#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=90 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (1, 80, '30.00', '0.00', '', 1, 'expense', '2021-06-08 19:15:58', 2, 0, 0, 13, NULL, 0, '2021-06-08', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (2, 13, '0.00', '30.00', '', 1, 'expense', '2021-06-08 19:15:58', 2, 0, 0, 80, NULL, 0, '2021-06-08', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (3, 51, '100.00', '100.00', 'ingres ocaja', 1, 'journal_entry', '2021-06-08 19:17:30', 2, NULL, 0, 0, NULL, 0, '2021-06-08', NULL);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (4, 1, '997.92', '0.00', '', 3, 'invoice', '2021-08-16 16:10:21', 1, 4, 0, 29, 0, 0, '2021-07-01', 1);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (5, 29, '0.00', '997.92', '', 3, 'invoice', '2021-08-16 16:10:21', 1, 4, 0, 1, 0, 0, '2021-07-01', 1);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (6, 1, '4752.00', '0.00', '', 3, 'invoice', '2021-08-16 16:10:21', 1, 4, 0, 66, 0, 0, '2021-07-01', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (7, 66, '0.00', '4752.00', '', 3, 'invoice', '2021-08-16 16:10:21', 1, 4, 0, 1, 0, 0, '2021-07-01', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (8, 1, '23.05', '0.00', '', 4, 'invoice', '2021-11-29 16:48:00', 1, 5, 0, 29, 0, 1, '2021-11-29', 2);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (9, 29, '0.00', '23.05', '', 4, 'invoice', '2021-11-29 16:48:00', 1, 5, 0, 1, 0, 1, '2021-11-29', 2);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (10, 1, '230.50', '0.00', '', 4, 'invoice', '2021-11-29 16:48:00', 1, 5, 0, 66, 0, 1, '2021-11-29', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (11, 66, '0.00', '230.50', '', 4, 'invoice', '2021-11-29 16:48:00', 1, 5, 0, 1, 0, 1, '2021-11-29', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (12, 1, '630.00', '0.00', '', 5, 'invoice', '2022-02-28 19:15:09', 1, 1, 0, 29, 0, 0, '2022-02-28', 1);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (13, 29, '0.00', '630.00', '', 5, 'invoice', '2022-02-28 19:15:09', 1, 1, 0, 1, 0, 0, '2022-02-28', 1);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (14, 1, '3000.00', '0.00', '', 5, 'invoice', '2022-02-28 19:15:09', 1, 1, 0, 66, 0, 0, '2022-02-28', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (15, 66, '0.00', '3000.00', '', 5, 'invoice', '2022-02-28 19:15:09', 1, 1, 0, 1, 0, 0, '2022-02-28', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (16, 1, '1436.53', '0.00', '', 6, 'invoice', '2022-03-09 16:19:18', 1, 4, 0, 29, 0, 0, '2022-01-01', 1);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (17, 29, '0.00', '1436.53', '', 6, 'invoice', '2022-03-09 16:19:18', 1, 4, 0, 1, 0, 0, '2022-01-01', 1);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (18, 1, '6840.60', '0.00', '', 6, 'invoice', '2022-03-09 16:19:18', 1, 4, 0, 66, 0, 0, '2022-01-01', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (19, 66, '0.00', '6840.60', '', 6, 'invoice', '2022-03-09 16:19:18', 1, 4, 0, 1, 0, 0, '2022-01-01', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (20, 1, '606.06', '0.00', '', 7, 'invoice', '2022-03-16 21:46:02', 1, 1, 0, 29, 0, 0, '2022-01-15', 1);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (21, 29, '0.00', '606.06', '', 7, 'invoice', '2022-03-16 21:46:02', 1, 1, 0, 1, 0, 0, '2022-01-15', 1);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (22, 1, '425.00', '0.00', '', 7, 'invoice', '2022-03-16 21:46:02', 1, 1, 0, 66, 0, 0, '2022-01-15', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (23, 66, '0.00', '425.00', '', 7, 'invoice', '2022-03-16 21:46:02', 1, 1, 0, 1, 0, 0, '2022-01-15', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (24, 1, '60.00', '0.00', '', 7, 'invoice', '2022-03-16 21:46:02', 1, 1, 0, 66, 0, 0, '2022-01-15', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (25, 66, '0.00', '60.00', '', 7, 'invoice', '2022-03-16 21:46:02', 1, 1, 0, 1, 0, 0, '2022-01-15', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (26, 1, '228.00', '0.00', '', 7, 'invoice', '2022-03-16 21:46:02', 1, 1, 0, 66, 0, 0, '2022-01-15', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (27, 66, '0.00', '228.00', '', 7, 'invoice', '2022-03-16 21:46:02', 1, 1, 0, 1, 0, 0, '2022-01-15', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (28, 1, '21.00', '0.00', '', 7, 'invoice', '2022-03-16 21:46:02', 1, 1, 0, 66, 0, 0, '2022-01-15', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (29, 66, '0.00', '21.00', '', 7, 'invoice', '2022-03-16 21:46:02', 1, 1, 0, 1, 0, 0, '2022-01-15', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (30, 1, '1278.00', '0.00', '', 7, 'invoice', '2022-03-16 21:46:02', 1, 1, 0, 66, 0, 0, '2022-01-15', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (31, 66, '0.00', '1278.00', '', 7, 'invoice', '2022-03-16 21:46:02', 1, 1, 0, 1, 0, 0, '2022-01-15', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (32, 1, '15.00', '0.00', '', 7, 'invoice', '2022-03-16 21:46:02', 1, 1, 0, 66, 0, 0, '2022-01-15', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (33, 66, '0.00', '15.00', '', 7, 'invoice', '2022-03-16 21:46:02', 1, 1, 0, 1, 0, 0, '2022-01-15', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (34, 1, '28.00', '0.00', '', 7, 'invoice', '2022-03-16 21:46:02', 1, 1, 0, 66, 0, 0, '2022-01-15', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (35, 66, '0.00', '28.00', '', 7, 'invoice', '2022-03-16 21:46:02', 1, 1, 0, 1, 0, 0, '2022-01-15', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (36, 1, '138.00', '0.00', '', 7, 'invoice', '2022-03-16 21:46:02', 1, 1, 0, 66, 0, 0, '2022-01-15', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (37, 66, '0.00', '138.00', '', 7, 'invoice', '2022-03-16 21:46:02', 1, 1, 0, 1, 0, 0, '2022-01-15', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (38, 1, '693.00', '0.00', '', 7, 'invoice', '2022-03-16 21:46:02', 1, 1, 0, 66, 0, 0, '2022-01-15', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (39, 66, '0.00', '693.00', '', 7, 'invoice', '2022-03-16 21:46:02', 1, 1, 0, 1, 0, 0, '2022-01-15', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (40, 1, '294.00', '0.00', '', 8, 'invoice', '2022-05-06 19:56:37', 1, 7, 0, 29, 0, 0, '2022-05-06', 1);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (41, 29, '0.00', '294.00', '', 8, 'invoice', '2022-05-06 19:56:37', 1, 7, 0, 1, 0, 0, '2022-05-06', 1);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (42, 1, '1400.00', '0.00', '', 8, 'invoice', '2022-05-06 19:56:37', 1, 7, 0, 66, 0, 0, '2022-05-06', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (43, 66, '0.00', '1400.00', '', 8, 'invoice', '2022-05-06 19:56:37', 1, 7, 0, 1, 0, 0, '2022-05-06', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (44, 1, '378.00', '0.00', '', 9, 'invoice', '2022-07-03 01:11:42', 1, 8, 0, 29, 0, 0, '2022-07-03', 1);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (45, 29, '0.00', '378.00', '', 9, 'invoice', '2022-07-03 01:11:42', 1, 8, 0, 1, 0, 0, '2022-07-03', 1);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (46, 1, '800.00', '0.00', '', 9, 'invoice', '2022-07-03 01:11:42', 1, 8, 0, 66, 0, 0, '2022-07-03', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (47, 66, '0.00', '800.00', '', 9, 'invoice', '2022-07-03 01:11:42', 1, 8, 0, 1, 0, 0, '2022-07-03', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (48, 1, '400.00', '0.00', '', 9, 'invoice', '2022-07-03 01:11:42', 1, 8, 0, 66, 0, 0, '2022-07-03', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (49, 66, '0.00', '400.00', '', 9, 'invoice', '2022-07-03 01:11:42', 1, 8, 0, 1, 0, 0, '2022-07-03', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (50, 1, '150.00', '0.00', '', 9, 'invoice', '2022-07-03 01:11:42', 1, 8, 0, 66, 0, 0, '2022-07-03', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (51, 66, '0.00', '150.00', '', 9, 'invoice', '2022-07-03 01:11:42', 1, 8, 0, 1, 0, 0, '2022-07-03', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (52, 1, '450.00', '0.00', '', 9, 'invoice', '2022-07-03 01:11:42', 1, 8, 0, 66, 0, 0, '2022-07-03', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (53, 66, '0.00', '450.00', '', 9, 'invoice', '2022-07-03 01:11:42', 1, 8, 0, 1, 0, 0, '2022-07-03', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (54, 1, '84.63', '0.00', '', 10, 'invoice', '2022-09-21 18:21:17', 1, 9, 0, 29, 0, 1, '2022-09-21', 2);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (55, 29, '0.00', '84.63', '', 10, 'invoice', '2022-09-21 18:21:17', 1, 9, 0, 1, 0, 1, '2022-09-21', 2);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (56, 1, '846.26', '0.00', '', 10, 'invoice', '2022-09-21 18:21:17', 1, 9, 0, 66, 0, 1, '2022-09-21', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (57, 66, '0.00', '846.26', '', 10, 'invoice', '2022-09-21 18:21:17', 1, 9, 0, 1, 0, 1, '2022-09-21', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (58, 1, '168.00', '0.00', '', 11, 'invoice', '2022-09-21 18:25:03', 1, 10, 0, 29, 0, 0, '2022-09-15', 1);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (59, 29, '0.00', '168.00', '', 11, 'invoice', '2022-09-21 18:25:03', 1, 10, 0, 1, 0, 0, '2022-09-15', 1);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (60, 1, '800.00', '0.00', '', 11, 'invoice', '2022-09-21 18:25:03', 1, 10, 0, 66, 0, 0, '2022-09-15', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (61, 66, '0.00', '800.00', '', 11, 'invoice', '2022-09-21 18:25:03', 1, 10, 0, 1, 0, 0, '2022-09-15', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (62, 1, '126.00', '0.00', '', 12, 'invoice', '2022-09-21 18:28:24', 1, 10, 0, 29, 0, 0, '2022-09-21', 1);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (63, 29, '0.00', '126.00', '', 12, 'invoice', '2022-09-21 18:28:24', 1, 10, 0, 1, 0, 0, '2022-09-21', 1);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (64, 1, '600.00', '0.00', '', 12, 'invoice', '2022-09-21 18:28:24', 1, 10, 0, 66, 0, 0, '2022-09-21', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (65, 66, '0.00', '600.00', '', 12, 'invoice', '2022-09-21 18:28:24', 1, 10, 0, 1, 0, 0, '2022-09-21', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (66, 1, '105.00', '0.00', '', 13, 'invoice', '2022-09-21 18:29:17', 1, 10, 0, 29, 0, 0, '2022-09-15', 1);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (67, 29, '0.00', '105.00', '', 13, 'invoice', '2022-09-21 18:29:17', 1, 10, 0, 1, 0, 0, '2022-09-15', 1);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (68, 1, '500.00', '0.00', '', 13, 'invoice', '2022-09-21 18:29:17', 1, 10, 0, 66, 0, 0, '2022-09-15', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (69, 66, '0.00', '500.00', '', 13, 'invoice', '2022-09-21 18:29:17', 1, 10, 0, 1, 0, 0, '2022-09-15', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (70, 1, '105.00', '0.00', '', 14, 'invoice', '2022-09-21 18:29:52', 1, 10, 0, 29, 0, 0, '2022-09-15', 1);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (71, 29, '0.00', '105.00', '', 14, 'invoice', '2022-09-21 18:29:52', 1, 10, 0, 1, 0, 0, '2022-09-15', 1);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (72, 1, '500.00', '0.00', '', 14, 'invoice', '2022-09-21 18:29:52', 1, 10, 0, 66, 0, 0, '2022-09-15', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (73, 66, '0.00', '500.00', '', 14, 'invoice', '2022-09-21 18:29:52', 1, 10, 0, 1, 0, 0, '2022-09-15', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (74, 1, '126.00', '0.00', '', 15, 'invoice', '2022-09-21 18:30:45', 1, 10, 0, 29, 0, 0, '2022-09-15', 1);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (75, 29, '0.00', '126.00', '', 15, 'invoice', '2022-09-21 18:30:45', 1, 10, 0, 1, 0, 0, '2022-09-15', 1);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (76, 1, '600.00', '0.00', '', 15, 'invoice', '2022-09-21 18:30:45', 1, 10, 0, 66, 0, 0, '2022-09-15', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (77, 66, '0.00', '600.00', '', 15, 'invoice', '2022-09-21 18:30:45', 1, 10, 0, 1, 0, 0, '2022-09-15', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (82, 1, '51.40', '0.00', '', 17, 'invoice', '2022-12-16 14:55:03', 1, 12, 0, 29, 0, 1, '2022-12-16', 2);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (83, 29, '0.00', '51.40', '', 17, 'invoice', '2022-12-16 14:55:03', 1, 12, 0, 1, 0, 1, '2022-12-16', 2);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (84, 1, '514.00', '0.00', '', 17, 'invoice', '2022-12-16 14:55:03', 1, 12, 0, 66, 0, 1, '2022-12-16', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (85, 66, '0.00', '514.00', '', 17, 'invoice', '2022-12-16 14:55:03', 1, 12, 0, 1, 0, 1, '2022-12-16', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (86, 1, '9.99', '0.00', '', 18, 'invoice', '2022-12-16 14:58:17', 1, 13, 0, 29, 0, 1, '2022-12-16', 2);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (87, 29, '0.00', '9.99', '', 18, 'invoice', '2022-12-16 14:58:17', 1, 13, 0, 1, 0, 1, '2022-12-16', 2);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (88, 1, '99.90', '0.00', '', 18, 'invoice', '2022-12-16 14:58:17', 1, 13, 0, 66, 0, 1, '2022-12-16', 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`) VALUES (89, 66, '0.00', '99.90', '', 18, 'invoice', '2022-12-16 14:58:17', 1, 13, 0, 1, 0, 1, '2022-12-16', 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=88 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_journal_entries` (`id`, `number`, `description`, `journal_date`, `amount`, `datecreated`, `addedfrom`) VALUES (1, '1', '', '2021-06-08', '100.00', '2021-06-08 19:17:30', 2);


#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` mediumtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=297 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280, 'User Successfully Logged In [User Id: 1, Is Staff Member: Yes, IP: 193.177.208.151]', '2024-09-10 19:37:55', 'Mario Puche');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281, 'Copied Invoice FA-000061', '2024-09-10 20:02:49', 'Mario Puche');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282, 'Invoice Status Updated [Invoice Number: FA-000062, From: Borrador To: Por pagar]', '2024-09-10 20:03:19', 'Mario Puche');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283, 'Copied Invoice FA-000062', '2024-09-10 20:03:23', 'Mario Puche');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284, 'Invoice Status Updated [Invoice Number: FA-000063, From: Borrador To: Por pagar]', '2024-09-10 20:03:38', 'Mario Puche');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (285, 'Invoice Status Updated [Invoice Number: FA-000060, From: Por pagar To: Retrasada]', '2024-09-16 21:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (286, 'User Successfully Logged In [User Id: 1, Is Staff Member: Yes, IP: 193.177.208.151]', '2024-09-17 10:03:24', 'Mario Puche');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (287, 'New Client Created [ID: 40, From Staff: 1]', '2024-09-17 11:42:15', 'Mario Puche');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (288, 'User Successfully Logged In [User Id: 1, Is Staff Member: Yes, IP: 193.177.208.151]', '2024-09-19 20:12:06', 'Mario Puche');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (289, 'New Client Created [ID: 41, From Staff: 1]', '2024-09-19 20:13:30', 'Mario Puche');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290, 'User Successfully Logged In [User Id: 1, Is Staff Member: Yes, IP: 192.145.39.249]', '2024-09-23 15:22:38', 'Mario Puche');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291, 'Non Existing User Tried to Login [Email: halil@panel.blitconcept.es, Is Staff Member: Yes, IP: 31.223.103.75]', '2024-09-25 21:38:16', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292, 'Non Existing User Tried to Login [Email: halil@panel.blitconcept.es, Is Staff Member: Yes, IP: 31.223.103.75]', '2024-09-25 22:00:27', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293, 'User Successfully Logged In [User Id: 1, Is Staff Member: Yes, IP: 2a02:26f7:ef0c:5905:0:bc3:6979:b6da]', '2024-09-25 22:04:26', 'Mario Puche');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294, 'New Staff Member Added [ID: 6, HALIL PERFEX]', '2024-09-25 22:05:16', 'Mario Puche');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (295, 'Staff Member Updated [ID: 6, HALIL PERFEX]', '2024-09-25 22:05:44', 'Mario Puche');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (296, 'User Successfully Logged In [User Id: 6, Is Staff Member: Yes, IP: 31.223.103.75]', '2024-09-25 22:06:18', 'HALIL PERFEX');


#
# TABLE STRUCTURE FOR: tblannouncements
#

DROP TABLE IF EXISTS `tblannouncements`;

CREATE TABLE `tblannouncements` (
  `announcementid` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `message` text DEFAULT NULL,
  `showtousers` int(11) NOT NULL,
  `showtostaff` int(11) NOT NULL,
  `showname` int(11) NOT NULL,
  `dateadded` datetime NOT NULL,
  `userid` varchar(100) NOT NULL,
  PRIMARY KEY (`announcementid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblbooking
#

DROP TABLE IF EXISTS `tblbooking`;

CREATE TABLE `tblbooking` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `purpose` varchar(255) NOT NULL,
  `orderer` int(11) NOT NULL,
  `resource_group` int(11) NOT NULL,
  `resource` int(11) NOT NULL,
  `start_time` datetime NOT NULL,
  `end_time` datetime NOT NULL,
  `status` int(11) NOT NULL DEFAULT 1,
  `description` text DEFAULT NULL,
  `amount` decimal(10,2) DEFAULT NULL,
  `person_number` varchar(50) DEFAULT NULL,
  `confirmed` tinyint(4) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tblbooking` (`id`, `purpose`, `orderer`, `resource_group`, `resource`, `start_time`, `end_time`, `status`, `description`, `amount`, `person_number`, `confirmed`) VALUES (1, 'Orlas dia 12', 1, 1, 1, '2024-09-24 15:27:00', '2024-09-25 15:27:00', 2, '', '500.00', '500', 1);
INSERT INTO `tblbooking` (`id`, `purpose`, `orderer`, `resource_group`, `resource`, `start_time`, `end_time`, `status`, `description`, `amount`, `person_number`, `confirmed`) VALUES (2, 'dsfsdf', 1, 1, 1, '2024-09-26 19:27:00', '2024-09-27 19:27:00', 2, '', '58.00', '950', 1);


#
# TABLE STRUCTURE FOR: tblbooking_checklist_templates
#

DROP TABLE IF EXISTS `tblbooking_checklist_templates`;

CREATE TABLE `tblbooking_checklist_templates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `checklist_text` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblbooking_checklists
#

DROP TABLE IF EXISTS `tblbooking_checklists`;

CREATE TABLE `tblbooking_checklists` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `booking_id` int(11) DEFAULT NULL,
  `checklist_text` varchar(255) DEFAULT NULL,
  `template_id` int(11) DEFAULT NULL,
  `complated_staff_id` int(11) DEFAULT NULL,
  `complated_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `booking_id` (`booking_id`),
  KEY `complated_staff_id` (`complated_staff_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblbooking_debt
#

DROP TABLE IF EXISTS `tblbooking_debt`;

CREATE TABLE `tblbooking_debt` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `booking_id` int(11) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) DEFAULT 0.00,
  `paid` decimal(15,2) DEFAULT 0.00,
  `added_date` datetime DEFAULT NULL,
  `added_staff` int(11) DEFAULT 0,
  `status` tinyint(4) DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `booking_id` (`booking_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblbooking_debt` (`id`, `booking_id`, `name`, `amount`, `paid`, `added_date`, `added_staff`, `status`) VALUES (3, 1, 'iyu', '55.00', '0.00', '2024-09-23 15:31:45', 1, 0);


#
# TABLE STRUCTURE FOR: tblbooking_debt_payments
#

DROP TABLE IF EXISTS `tblbooking_debt_payments`;

CREATE TABLE `tblbooking_debt_payments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `booking_id` int(11) DEFAULT NULL,
  `debt_id` int(11) DEFAULT NULL,
  `payment_amount` decimal(15,2) DEFAULT NULL,
  `status` tinyint(4) DEFAULT 0,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `booking_id` (`booking_id`),
  KEY `debt_id` (`debt_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblbooking_follower
#

DROP TABLE IF EXISTS `tblbooking_follower`;

CREATE TABLE `tblbooking_follower` (
  `follower_id` int(11) NOT NULL AUTO_INCREMENT,
  `booking` int(11) NOT NULL,
  `follower` int(11) NOT NULL,
  PRIMARY KEY (`follower_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

#
# TABLE STRUCTURE FOR: tblbooking_payments
#

DROP TABLE IF EXISTS `tblbooking_payments`;

CREATE TABLE `tblbooking_payments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `booking_id` int(11) DEFAULT NULL,
  `payment_id` varchar(100) DEFAULT NULL,
  `amount` decimal(10,2) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `status` tinyint(4) DEFAULT 0,
  `description` varchar(500) DEFAULT NULL,
  `added_staff_id` int(11) DEFAULT NULL,
  `reject_description` varchar(500) DEFAULT NULL,
  `bank_case_payment_record_id` int(11) DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `booking_id` (`booking_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblcheck_in_out
#

DROP TABLE IF EXISTS `tblcheck_in_out`;

CREATE TABLE `tblcheck_in_out` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `type_check` int(11) DEFAULT NULL,
  `type` varchar(5) NOT NULL DEFAULT 'W',
  `route_point_id` int(11) DEFAULT NULL,
  `workplace_id` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblcheck_in_out` (`id`, `staff_id`, `date`, `type_check`, `type`, `route_point_id`, `workplace_id`) VALUES (1, 1, '2024-03-13 17:26:30', 1, 'W', 0, 0);
INSERT INTO `tblcheck_in_out` (`id`, `staff_id`, `date`, `type_check`, `type`, `route_point_id`, `workplace_id`) VALUES (2, 1, '2024-03-13 17:26:49', 1, 'W', 0, 0);
INSERT INTO `tblcheck_in_out` (`id`, `staff_id`, `date`, `type_check`, `type`, `route_point_id`, `workplace_id`) VALUES (3, 1, '2024-03-13 17:26:57', 2, 'W', 0, 0);


#
# TABLE STRUCTURE FOR: tblclients
#

DROP TABLE IF EXISTS `tblclients`;

CREATE TABLE `tblclients` (
  `userid` int(11) NOT NULL AUTO_INCREMENT,
  `company` varchar(191) DEFAULT NULL,
  `vat` varchar(50) DEFAULT NULL,
  `phonenumber` varchar(30) DEFAULT NULL,
  `country` int(11) NOT NULL DEFAULT 0,
  `city` varchar(100) DEFAULT NULL,
  `zip` varchar(15) DEFAULT NULL,
  `state` varchar(50) DEFAULT NULL,
  `address` varchar(191) DEFAULT NULL,
  `website` varchar(150) DEFAULT NULL,
  `datecreated` datetime NOT NULL,
  `active` int(11) NOT NULL DEFAULT 1,
  `leadid` int(11) DEFAULT NULL,
  `billing_street` varchar(200) DEFAULT NULL,
  `billing_city` varchar(100) DEFAULT NULL,
  `billing_state` varchar(100) DEFAULT NULL,
  `billing_zip` varchar(100) DEFAULT NULL,
  `billing_country` int(11) DEFAULT 0,
  `shipping_street` varchar(200) DEFAULT NULL,
  `shipping_city` varchar(100) DEFAULT NULL,
  `shipping_state` varchar(100) DEFAULT NULL,
  `shipping_zip` varchar(100) DEFAULT NULL,
  `shipping_country` int(11) DEFAULT 0,
  `longitude` varchar(191) DEFAULT NULL,
  `latitude` varchar(191) DEFAULT NULL,
  `default_language` varchar(40) DEFAULT NULL,
  `default_currency` int(11) NOT NULL DEFAULT 0,
  `show_primary_contact` int(11) NOT NULL DEFAULT 0,
  `stripe_id` varchar(40) DEFAULT NULL,
  `registration_confirmed` int(11) NOT NULL DEFAULT 1,
  `addedfrom` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`userid`),
  KEY `country` (`country`),
  KEY `leadid` (`leadid`),
  KEY `company` (`company`),
  KEY `active` (`active`)
) ENGINE=InnoDB AUTO_INCREMENT=42 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblclients` (`userid`, `company`, `vat`, `phonenumber`, `country`, `city`, `zip`, `state`, `address`, `website`, `datecreated`, `active`, `leadid`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `longitude`, `latitude`, `default_language`, `default_currency`, `show_primary_contact`, `stripe_id`, `registration_confirmed`, `addedfrom`) VALUES (1, 'ICON SPIRITS  SL', 'CB67490417', '937 426 370', 209, 'BARCELONA', '08009', 'BARCELONA', 'CALLE VALENCIA 287', '', '2021-02-07 12:20:39', 1, NULL, '', '', '', '', 0, '', '', '', '', 0, NULL, NULL, '', 0, 0, NULL, 1, 1);
INSERT INTO `tblclients` (`userid`, `company`, `vat`, `phonenumber`, `country`, `city`, `zip`, `state`, `address`, `website`, `datecreated`, `active`, `leadid`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `longitude`, `latitude`, `default_language`, `default_currency`, `show_primary_contact`, `stripe_id`, `registration_confirmed`, `addedfrom`) VALUES (2, 'VODAFONE', '', '', 0, '', '', '', '', '', '2021-05-05 14:58:38', 1, NULL, '', '', '', '', 0, '', '', '', '', 0, NULL, NULL, '', 0, 0, NULL, 1, 1);
INSERT INTO `tblclients` (`userid`, `company`, `vat`, `phonenumber`, `country`, `city`, `zip`, `state`, `address`, `website`, `datecreated`, `active`, `leadid`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `longitude`, `latitude`, `default_language`, `default_currency`, `show_primary_contact`, `stripe_id`, `registration_confirmed`, `addedfrom`) VALUES (3, 'Tinoco', '', '', 0, '', '', '', '', '', '2021-05-05 20:47:38', 1, NULL, '', '', '', '', 0, '', '', '', '', 0, NULL, NULL, '', 0, 0, NULL, 1, 1);
INSERT INTO `tblclients` (`userid`, `company`, `vat`, `phonenumber`, `country`, `city`, `zip`, `state`, `address`, `website`, `datecreated`, `active`, `leadid`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `longitude`, `latitude`, `default_language`, `default_currency`, `show_primary_contact`, `stripe_id`, `registration_confirmed`, `addedfrom`) VALUES (4, 'DIAGEO ESPAÑA SA', 'A-28826691', '', 209, 'MADRID', '28023', 'MADRID', 'AVENIDA DE LA VICTORIA 32', '', '2021-08-16 16:07:24', 1, NULL, '', '', '', '', 0, '', '', '', '', 0, NULL, NULL, '', 0, 0, NULL, 1, 1);
INSERT INTO `tblclients` (`userid`, `company`, `vat`, `phonenumber`, `country`, `city`, `zip`, `state`, `address`, `website`, `datecreated`, `active`, `leadid`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `longitude`, `latitude`, `default_language`, `default_currency`, `show_primary_contact`, `stripe_id`, `registration_confirmed`, `addedfrom`) VALUES (5, 'PINKY LIDBERS SLP', 'B02739464', '', 0, 'ALICANTE', '03015', '', '', '', '2021-11-29 16:46:20', 1, NULL, '', '', '', '', 0, '', '', '', '', 0, NULL, NULL, '', 0, 0, NULL, 1, 1);
INSERT INTO `tblclients` (`userid`, `company`, `vat`, `phonenumber`, `country`, `city`, `zip`, `state`, `address`, `website`, `datecreated`, `active`, `leadid`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `longitude`, `latitude`, `default_language`, `default_currency`, `show_primary_contact`, `stripe_id`, `registration_confirmed`, `addedfrom`) VALUES (7, 'FRANCISCO MATEO PASTOR', '74178816K', '', 0, '', '', '', '', '', '2022-05-06 19:37:26', 1, NULL, '', '', '', '', 0, '', '', '', '', 0, NULL, NULL, '', 0, 0, NULL, 1, 1);
INSERT INTO `tblclients` (`userid`, `company`, `vat`, `phonenumber`, `country`, `city`, `zip`, `state`, `address`, `website`, `datecreated`, `active`, `leadid`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `longitude`, `latitude`, `default_language`, `default_currency`, `show_primary_contact`, `stripe_id`, `registration_confirmed`, `addedfrom`) VALUES (8, 'PRODUCEME SL', 'B54503586', '', 0, 'Madrid', '28009', 'Madrid', 'Avenida Felipe ii (wizink Center), S/N', '', '2022-07-03 01:08:01', 1, NULL, '', '', '', '', 0, '', '', '', '', 0, NULL, NULL, '', 0, 0, NULL, 1, 1);
INSERT INTO `tblclients` (`userid`, `company`, `vat`, `phonenumber`, `country`, `city`, `zip`, `state`, `address`, `website`, `datecreated`, `active`, `leadid`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `longitude`, `latitude`, `default_language`, `default_currency`, `show_primary_contact`, `stripe_id`, `registration_confirmed`, `addedfrom`) VALUES (9, 'GRUPO HOB NEGOCIOS SL', 'B54904552', '', 0, 'Alicante', '03003', 'Alicante', 'Av.Maisonnave,19', '', '2022-09-21 18:18:52', 1, NULL, '', '', '', '', 0, '', '', '', '', 0, NULL, NULL, '', 0, 0, NULL, 1, 1);
INSERT INTO `tblclients` (`userid`, `company`, `vat`, `phonenumber`, `country`, `city`, `zip`, `state`, `address`, `website`, `datecreated`, `active`, `leadid`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `longitude`, `latitude`, `default_language`, `default_currency`, `show_primary_contact`, `stripe_id`, `registration_confirmed`, `addedfrom`) VALUES (10, 'ZAMORA COMPANY ESPAÑA SLU', 'B30709729', '', 0, 'CARTAGENA', '30369', 'MURCIA', 'C/SICILIO 10 POL IND LOS CAMACHOS', '', '2022-09-21 18:24:24', 1, NULL, '', '', '', '', 0, '', '', '', '', 0, NULL, NULL, '', 0, 0, NULL, 1, 1);
INSERT INTO `tblclients` (`userid`, `company`, `vat`, `phonenumber`, `country`, `city`, `zip`, `state`, `address`, `website`, `datecreated`, `active`, `leadid`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `longitude`, `latitude`, `default_language`, `default_currency`, `show_primary_contact`, `stripe_id`, `registration_confirmed`, `addedfrom`) VALUES (11, 'Eulen Sa', 'A28517308', '', 0, 'Alicante', '03008', 'Alicante', 'C/ de los transportes 13', '', '2022-11-22 14:33:27', 1, NULL, '', '', '', '', 0, '', '', '', '', 0, NULL, NULL, '', 0, 0, NULL, 1, 1);
INSERT INTO `tblclients` (`userid`, `company`, `vat`, `phonenumber`, `country`, `city`, `zip`, `state`, `address`, `website`, `datecreated`, `active`, `leadid`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `longitude`, `latitude`, `default_language`, `default_currency`, `show_primary_contact`, `stripe_id`, `registration_confirmed`, `addedfrom`) VALUES (12, 'CENTRO DE ATENCIÓN INTEGRAL MONDALUA', 'B42578500', '', 0, 'Alicante', '03008', 'Alicante', 'C/ José de Cabo Palomares 37, local 3', '', '2022-12-16 14:53:35', 1, NULL, '', '', '', '', 0, '', '', '', '', 0, NULL, NULL, '', 0, 0, NULL, 1, 1);
INSERT INTO `tblclients` (`userid`, `company`, `vat`, `phonenumber`, `country`, `city`, `zip`, `state`, `address`, `website`, `datecreated`, `active`, `leadid`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `longitude`, `latitude`, `default_language`, `default_currency`, `show_primary_contact`, `stripe_id`, `registration_confirmed`, `addedfrom`) VALUES (13, 'Tabarca Selección SC', 'B54121744', '', 0, 'Alicante', '', 'Alicante ', 'AUSTOS N32', '', '2022-12-16 14:57:22', 1, NULL, '', '', '', '', 0, '', '', '', '', 0, NULL, NULL, '', 0, 0, NULL, 1, 1);
INSERT INTO `tblclients` (`userid`, `company`, `vat`, `phonenumber`, `country`, `city`, `zip`, `state`, `address`, `website`, `datecreated`, `active`, `leadid`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `longitude`, `latitude`, `default_language`, `default_currency`, `show_primary_contact`, `stripe_id`, `registration_confirmed`, `addedfrom`) VALUES (14, 'ALINUR CFPPDP SL', 'B54431226', '', 0, 'ALICANTE', '03005', 'ALICANTE', 'AVENIDA SANTO DOMINGO 46', '', '2022-12-16 17:23:54', 1, NULL, '', '', '', '', 0, '', '', '', '', 0, NULL, NULL, '', 0, 0, NULL, 1, 1);
INSERT INTO `tblclients` (`userid`, `company`, `vat`, `phonenumber`, `country`, `city`, `zip`, `state`, `address`, `website`, `datecreated`, `active`, `leadid`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `longitude`, `latitude`, `default_language`, `default_currency`, `show_primary_contact`, `stripe_id`, `registration_confirmed`, `addedfrom`) VALUES (15, 'UTE ALICANTE', 'U66060286', '', 0, 'ALICANTE', '03006', 'ALICANTE', 'POL IND PLA DE LA VALLONGA', '', '2022-12-16 17:26:08', 1, NULL, '', '', '', '', 0, '', '', '', '', 0, NULL, NULL, '', 0, 0, NULL, 1, 1);
INSERT INTO `tblclients` (`userid`, `company`, `vat`, `phonenumber`, `country`, `city`, `zip`, `state`, `address`, `website`, `datecreated`, `active`, `leadid`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `longitude`, `latitude`, `default_language`, `default_currency`, `show_primary_contact`, `stripe_id`, `registration_confirmed`, `addedfrom`) VALUES (16, 'IDIOMASFLOW', 'B54999677', '', 0, 'ALICANTE', '03015', 'ALICANTE', 'Avenida Pintor Xavier Soler, 13,', '', '2022-12-16 20:18:50', 1, NULL, '', '', '', '', 0, '', '', '', '', 0, NULL, NULL, '', 0, 0, NULL, 1, 1);
INSERT INTO `tblclients` (`userid`, `company`, `vat`, `phonenumber`, `country`, `city`, `zip`, `state`, `address`, `website`, `datecreated`, `active`, `leadid`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `longitude`, `latitude`, `default_language`, `default_currency`, `show_primary_contact`, `stripe_id`, `registration_confirmed`, `addedfrom`) VALUES (17, 'ODONTOALICANTE Diseño dental S.L', 'B54626270', '', 0, '', '', '', 'Avda.Periodista Rodolfo Salazar ,35C . Esc F . Local 5<br />\r\nAlicante 03015', '', '2022-12-22 22:37:35', 1, NULL, '', '', '', '', 0, '', '', '', '', 0, NULL, NULL, '', 0, 0, NULL, 1, 1);
INSERT INTO `tblclients` (`userid`, `company`, `vat`, `phonenumber`, `country`, `city`, `zip`, `state`, `address`, `website`, `datecreated`, `active`, `leadid`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `longitude`, `latitude`, `default_language`, `default_currency`, `show_primary_contact`, `stripe_id`, `registration_confirmed`, `addedfrom`) VALUES (18, 'Girabebe S.L', 'B92778026', '', 0, '', '', '', 'Calle marco nº88 poligono industrial las atalaya 03<br />\r\n03114 Alicante', '', '2022-12-22 22:38:55', 1, NULL, '', '', '', '', 0, '', '', '', '', 0, NULL, NULL, '', 0, 0, NULL, 1, 1);
INSERT INTO `tblclients` (`userid`, `company`, `vat`, `phonenumber`, `country`, `city`, `zip`, `state`, `address`, `website`, `datecreated`, `active`, `leadid`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `longitude`, `latitude`, `default_language`, `default_currency`, `show_primary_contact`, `stripe_id`, `registration_confirmed`, `addedfrom`) VALUES (19, 'SALA MAGMA SL', 'B54940382', '', 0, 'ALICANTE', '03007', 'ALICANTE', 'ARTURO 19 1 DERECHA', '', '2022-12-27 20:42:09', 1, NULL, '', '', '', '', 0, '', '', '', '', 0, NULL, NULL, '', 0, 0, NULL, 1, 1);
INSERT INTO `tblclients` (`userid`, `company`, `vat`, `phonenumber`, `country`, `city`, `zip`, `state`, `address`, `website`, `datecreated`, `active`, `leadid`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `longitude`, `latitude`, `default_language`, `default_currency`, `show_primary_contact`, `stripe_id`, `registration_confirmed`, `addedfrom`) VALUES (20, 'TEJEDA Y FRIGOLA ABOGADOS, S.L.P.', 'B06836662', '', 0, 'Alicante', '03001', 'Alicante', 'Calle Ángel Lozano nº 18, 3º Izda;', '', '2023-01-04 18:11:50', 1, NULL, '', '', '', '', 0, '', '', '', '', 0, NULL, NULL, '', 0, 0, NULL, 1, 1);
INSERT INTO `tblclients` (`userid`, `company`, `vat`, `phonenumber`, `country`, `city`, `zip`, `state`, `address`, `website`, `datecreated`, `active`, `leadid`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `longitude`, `latitude`, `default_language`, `default_currency`, `show_primary_contact`, `stripe_id`, `registration_confirmed`, `addedfrom`) VALUES (21, 'Producto propio incoming grupos Europa SL', 'B54532866', '', 0, 'Alicante', '03003', 'Alicante ', 'Pintor Lorenzo Casanova 62 3C', '', '2023-01-13 22:09:52', 1, NULL, '', '', '', '', 0, '', '', '', '', 0, NULL, NULL, '', 0, 0, NULL, 1, 1);
INSERT INTO `tblclients` (`userid`, `company`, `vat`, `phonenumber`, `country`, `city`, `zip`, `state`, `address`, `website`, `datecreated`, `active`, `leadid`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `longitude`, `latitude`, `default_language`, `default_currency`, `show_primary_contact`, `stripe_id`, `registration_confirmed`, `addedfrom`) VALUES (22, 'ASOCIACION DE ASENTADORES DE FRUTAS, VERDURAS Y HORTALIZAS DE MERCALICANTE', 'G53370615', '', 0, 'ALICANTE', '03006', 'ALICANTE', 'CARRETERA MADRID KM 4,5', '', '2023-02-03 15:16:40', 1, NULL, '', '', '', '', 0, '', '', '', '', 0, NULL, NULL, '', 0, 0, NULL, 1, 1);
INSERT INTO `tblclients` (`userid`, `company`, `vat`, `phonenumber`, `country`, `city`, `zip`, `state`, `address`, `website`, `datecreated`, `active`, `leadid`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `longitude`, `latitude`, `default_language`, `default_currency`, `show_primary_contact`, `stripe_id`, `registration_confirmed`, `addedfrom`) VALUES (23, 'WARM BALTIMORE AIE', 'V-42575910', '', 0, 'ALICANTE', '03004', 'ALICANTE', 'CALLE MANUEL ANTÓN 13, 2 D', '', '2023-02-03 15:21:20', 1, NULL, '', '', '', '', 0, '', '', '', '', 0, NULL, NULL, '', 0, 0, NULL, 1, 1);
INSERT INTO `tblclients` (`userid`, `company`, `vat`, `phonenumber`, `country`, `city`, `zip`, `state`, `address`, `website`, `datecreated`, `active`, `leadid`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `longitude`, `latitude`, `default_language`, `default_currency`, `show_primary_contact`, `stripe_id`, `registration_confirmed`, `addedfrom`) VALUES (24, 'DAMM SA', 'A08000820', '', 0, 'BARCELONA', '08025', 'BARCELONA', 'CALLE ROSELLO 515', '', '2023-02-03 15:30:38', 1, NULL, '', '', '', '', 0, '', '', '', '', 0, NULL, NULL, '', 0, 0, NULL, 1, 1);
INSERT INTO `tblclients` (`userid`, `company`, `vat`, `phonenumber`, `country`, `city`, `zip`, `state`, `address`, `website`, `datecreated`, `active`, `leadid`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `longitude`, `latitude`, `default_language`, `default_currency`, `show_primary_contact`, `stripe_id`, `registration_confirmed`, `addedfrom`) VALUES (25, 'DAMM, S.A.', 'A08000820', '', 0, '', '', '', 'CL ROSELLO 515<br />\r\n08025 - BARCELONA<br />\r\nBARCELONA', '', '2023-02-14 12:17:27', 1, NULL, '', '', '', '', 0, '', '', '', '', 0, NULL, NULL, '', 0, 0, NULL, 1, 1);
INSERT INTO `tblclients` (`userid`, `company`, `vat`, `phonenumber`, `country`, `city`, `zip`, `state`, `address`, `website`, `datecreated`, `active`, `leadid`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `longitude`, `latitude`, `default_language`, `default_currency`, `show_primary_contact`, `stripe_id`, `registration_confirmed`, `addedfrom`) VALUES (26, 'TEVA PHARMA, S.L.U.', 'B83959379', '', 0, '', '', '', 'CL ANABEL SEGURA 11, EDIF.<br />\r\nALBATROS B PLANTA 1<br />\r\n28100 - ALCOBENDAS<br />\r\nMADRID', '', '2023-02-14 12:19:49', 1, NULL, '', '', '', '', 0, '', '', '', '', 0, NULL, NULL, '', 0, 0, NULL, 1, 1);
INSERT INTO `tblclients` (`userid`, `company`, `vat`, `phonenumber`, `country`, `city`, `zip`, `state`, `address`, `website`, `datecreated`, `active`, `leadid`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `longitude`, `latitude`, `default_language`, `default_currency`, `show_primary_contact`, `stripe_id`, `registration_confirmed`, `addedfrom`) VALUES (27, 'CINEMATOGRAFICAS RAMOS SL', 'B03415551', '', 0, 'EL CAMPELLO', '03560', 'ALICANTE', 'AV. GENERALITAT, 71 BAJO', '', '2023-07-17 23:30:58', 1, NULL, '', '', '', '', 0, '', '', '', '', 0, NULL, NULL, '', 0, 0, NULL, 1, 1);
INSERT INTO `tblclients` (`userid`, `company`, `vat`, `phonenumber`, `country`, `city`, `zip`, `state`, `address`, `website`, `datecreated`, `active`, `leadid`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `longitude`, `latitude`, `default_language`, `default_currency`, `show_primary_contact`, `stripe_id`, `registration_confirmed`, `addedfrom`) VALUES (28, 'Spenly Partners Spirits Sl.', 'B98759327', '', 0, 'VALENCIA ', '46002', 'VALENCIA ', 'PLAZA AJUNTAMENT, 19 7', '', '2023-07-17 23:33:55', 1, NULL, '', '', '', '', 0, '', '', '', '', 0, NULL, NULL, '', 0, 0, NULL, 1, 1);
INSERT INTO `tblclients` (`userid`, `company`, `vat`, `phonenumber`, `country`, `city`, `zip`, `state`, `address`, `website`, `datecreated`, `active`, `leadid`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `longitude`, `latitude`, `default_language`, `default_currency`, `show_primary_contact`, `stripe_id`, `registration_confirmed`, `addedfrom`) VALUES (29, 'BOOMBENIDORM A.I.E', 'V09971599', '', 0, 'Gijón', '33202 ', 'Asturias', 'Celestino junquera 2 oficina 16', '', '2023-09-11 10:02:48', 1, NULL, '', '', '', '', 0, '', '', '', '', 0, NULL, NULL, '', 0, 0, NULL, 1, 1);
INSERT INTO `tblclients` (`userid`, `company`, `vat`, `phonenumber`, `country`, `city`, `zip`, `state`, `address`, `website`, `datecreated`, `active`, `leadid`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `longitude`, `latitude`, `default_language`, `default_currency`, `show_primary_contact`, `stripe_id`, `registration_confirmed`, `addedfrom`) VALUES (30, 'Producciones Baltimore S.L', 'B54749163', '', 0, 'ALICANTE', '03001', 'ALICANTE', 'ALVAREZ SEREIX 12 ENTRESUELO DERECHA', '', '2023-09-29 12:08:27', 1, NULL, '', '', '', '', 0, '', '', '', '', 0, NULL, NULL, '', 0, 0, NULL, 1, 1);
INSERT INTO `tblclients` (`userid`, `company`, `vat`, `phonenumber`, `country`, `city`, `zip`, `state`, `address`, `website`, `datecreated`, `active`, `leadid`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `longitude`, `latitude`, `default_language`, `default_currency`, `show_primary_contact`, `stripe_id`, `registration_confirmed`, `addedfrom`) VALUES (31, 'DAMM, S.A.', 'A08000820', '', 0, '', '', '', 'CL ROSELLO 515<br />\r\n08025 - BARCELONA<br />\r\nBARCELONA', '', '2023-11-28 12:00:39', 1, NULL, '', '', '', '', 0, '', '', '', '', 0, NULL, NULL, '', 0, 0, NULL, 1, 1);
INSERT INTO `tblclients` (`userid`, `company`, `vat`, `phonenumber`, `country`, `city`, `zip`, `state`, `address`, `website`, `datecreated`, `active`, `leadid`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `longitude`, `latitude`, `default_language`, `default_currency`, `show_primary_contact`, `stripe_id`, `registration_confirmed`, `addedfrom`) VALUES (32, 'HMY YUDIGAR EQUIPAMIENTO SLU', 'B96106794', '', 0, '', '', '', 'PZ LA VEGUILLA SN<br />\r\n50400 - CARIÑENA<br />\r\nZARAGOZA', '', '2023-11-28 12:02:43', 1, NULL, '', '', '', '', 0, '', '', '', '', 0, NULL, NULL, '', 0, 0, NULL, 1, 1);
INSERT INTO `tblclients` (`userid`, `company`, `vat`, `phonenumber`, `country`, `city`, `zip`, `state`, `address`, `website`, `datecreated`, `active`, `leadid`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `longitude`, `latitude`, `default_language`, `default_currency`, `show_primary_contact`, `stripe_id`, `registration_confirmed`, `addedfrom`) VALUES (33, 'STAFF CONSULTING BUREAU S.L.', 'B83854687', '', 0, '', '', '', 'CL AZALEA 194<br />\r\n28109 - ALCOBENDAS<br />\r\nMADRID', '', '2023-11-28 12:05:56', 1, NULL, '', '', '', '', 0, '', '', '', '', 0, NULL, NULL, '', 0, 0, NULL, 1, 1);
INSERT INTO `tblclients` (`userid`, `company`, `vat`, `phonenumber`, `country`, `city`, `zip`, `state`, `address`, `website`, `datecreated`, `active`, `leadid`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `longitude`, `latitude`, `default_language`, `default_currency`, `show_primary_contact`, `stripe_id`, `registration_confirmed`, `addedfrom`) VALUES (34, 'Esatur XXI', 'B53874145', '', 0, 'Alicante', '03003', 'Alicante', 'Arzobispo Loaces 3 Alicante', '', '2023-12-26 20:08:07', 1, NULL, '', '', '', '', 0, '', '', '', '', 0, NULL, NULL, '', 0, 0, NULL, 1, 1);
INSERT INTO `tblclients` (`userid`, `company`, `vat`, `phonenumber`, `country`, `city`, `zip`, `state`, `address`, `website`, `datecreated`, `active`, `leadid`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `longitude`, `latitude`, `default_language`, `default_currency`, `show_primary_contact`, `stripe_id`, `registration_confirmed`, `addedfrom`) VALUES (35, 'Eventos Mare Nostrum, S.L.', 'B42685891', '', 0, 'Alicante', '03001 ', 'Alicante', 'C/ San Fernando, 49 4 Puerta 3', '', '2024-01-09 19:21:32', 1, NULL, 'C/ San Fernando, 49 4 Puerta 3', 'Alicante', '', '03001', 0, '', '', '', '', 0, NULL, NULL, '', 0, 0, NULL, 1, 1);
INSERT INTO `tblclients` (`userid`, `company`, `vat`, `phonenumber`, `country`, `city`, `zip`, `state`, `address`, `website`, `datecreated`, `active`, `leadid`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `longitude`, `latitude`, `default_language`, `default_currency`, `show_primary_contact`, `stripe_id`, `registration_confirmed`, `addedfrom`) VALUES (36, 'KARMO SPIRIT S.L.U', 'B-90153057', '', 0, 'SEVILLA', '41410', 'SEVILLA', 'Mercurion nº5 Parque logístico Carmona', '', '2024-01-31 09:48:22', 1, NULL, '', '', '', '', 0, '', '', '', '', 0, NULL, NULL, '', 0, 0, NULL, 1, 1);
INSERT INTO `tblclients` (`userid`, `company`, `vat`, `phonenumber`, `country`, `city`, `zip`, `state`, `address`, `website`, `datecreated`, `active`, `leadid`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `longitude`, `latitude`, `default_language`, `default_currency`, `show_primary_contact`, `stripe_id`, `registration_confirmed`, `addedfrom`) VALUES (37, 'Jesus Navarro S.A.', 'A08941544', '', 0, 'NOVELDA', '03660 ', 'ALICANTE', 'Isaac Peral 46', '', '2024-01-31 11:46:15', 1, NULL, '', '', '', '', 0, '', '', '', '', 0, NULL, NULL, '', 0, 0, NULL, 1, 1);
INSERT INTO `tblclients` (`userid`, `company`, `vat`, `phonenumber`, `country`, `city`, `zip`, `state`, `address`, `website`, `datecreated`, `active`, `leadid`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `longitude`, `latitude`, `default_language`, `default_currency`, `show_primary_contact`, `stripe_id`, `registration_confirmed`, `addedfrom`) VALUES (38, 'LOW FESTIVAL AIE', 'V87534483', '', 0, 'ALICANTE', '03001', 'ALICANTE', 'ÁLVAREZ SEREIX 12 entlo derecha', '', '2024-02-12 17:26:03', 1, NULL, '', '', '', '', 0, '', '', '', '', 0, NULL, NULL, '', 0, 0, NULL, 1, 1);
INSERT INTO `tblclients` (`userid`, `company`, `vat`, `phonenumber`, `country`, `city`, `zip`, `state`, `address`, `website`, `datecreated`, `active`, `leadid`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `longitude`, `latitude`, `default_language`, `default_currency`, `show_primary_contact`, `stripe_id`, `registration_confirmed`, `addedfrom`) VALUES (39, 'BACARDI ESPAÑA', 'A-08005746', '', 0, '', '', '', 'PLAZA CATALUÑA, 1-4<br />\r\nTRIANGLE PLANTA 6<br />\r\n08002 BARCELONA', '', '2024-02-20 20:54:34', 1, NULL, '', '', '', '', 0, '', '', '', '', 0, NULL, NULL, '', 0, 0, NULL, 1, 1);
INSERT INTO `tblclients` (`userid`, `company`, `vat`, `phonenumber`, `country`, `city`, `zip`, `state`, `address`, `website`, `datecreated`, `active`, `leadid`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `longitude`, `latitude`, `default_language`, `default_currency`, `show_primary_contact`, `stripe_id`, `registration_confirmed`, `addedfrom`) VALUES (40, 'Distribuciones Alben 2009 SL', 'B17134818', '', 0, 'Alicante', '03006', 'Alicante', 'CL Camino de Borja, 29', '', '2024-09-17 11:42:15', 1, NULL, '', '', '', '', 0, '', '', '', '', 0, NULL, NULL, '', 0, 0, NULL, 1, 1);
INSERT INTO `tblclients` (`userid`, `company`, `vat`, `phonenumber`, `country`, `city`, `zip`, `state`, `address`, `website`, `datecreated`, `active`, `leadid`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `longitude`, `latitude`, `default_language`, `default_currency`, `show_primary_contact`, `stripe_id`, `registration_confirmed`, `addedfrom`) VALUES (41, 'DISCOMIX ORGANIZACION Y PRODUCCION DE EVENTOS SL', 'B54776281', '', 0, 'EL VERGER', '03063', 'ALICANTE', 'CAMI LA VIA , NUM 30', '', '2024-09-19 20:13:30', 1, NULL, '', '', '', '', 0, '', '', '', '', 0, NULL, NULL, '', 0, 0, NULL, 1, 1);


#
# TABLE STRUCTURE FOR: tblconsent_purposes
#

DROP TABLE IF EXISTS `tblconsent_purposes`;

CREATE TABLE `tblconsent_purposes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `description` text DEFAULT NULL,
  `date_created` datetime NOT NULL,
  `last_updated` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblconsents
#

DROP TABLE IF EXISTS `tblconsents`;

CREATE TABLE `tblconsents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `action` varchar(10) NOT NULL,
  `date` datetime NOT NULL,
  `ip` varchar(40) NOT NULL,
  `contact_id` int(11) NOT NULL DEFAULT 0,
  `lead_id` int(11) NOT NULL DEFAULT 0,
  `description` text DEFAULT NULL,
  `opt_in_purpose_description` text DEFAULT NULL,
  `purpose_id` int(11) NOT NULL,
  `staff_name` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `purpose_id` (`purpose_id`),
  KEY `contact_id` (`contact_id`),
  KEY `lead_id` (`lead_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblcontact_permissions
#

DROP TABLE IF EXISTS `tblcontact_permissions`;

CREATE TABLE `tblcontact_permissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `permission_id` int(11) NOT NULL,
  `userid` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblcontact_permissions` (`id`, `permission_id`, `userid`) VALUES (1, 1, 1);
INSERT INTO `tblcontact_permissions` (`id`, `permission_id`, `userid`) VALUES (2, 2, 1);
INSERT INTO `tblcontact_permissions` (`id`, `permission_id`, `userid`) VALUES (3, 3, 1);
INSERT INTO `tblcontact_permissions` (`id`, `permission_id`, `userid`) VALUES (4, 4, 1);
INSERT INTO `tblcontact_permissions` (`id`, `permission_id`, `userid`) VALUES (5, 5, 1);
INSERT INTO `tblcontact_permissions` (`id`, `permission_id`, `userid`) VALUES (6, 6, 1);
INSERT INTO `tblcontact_permissions` (`id`, `permission_id`, `userid`) VALUES (7, 1, 2);
INSERT INTO `tblcontact_permissions` (`id`, `permission_id`, `userid`) VALUES (8, 2, 2);
INSERT INTO `tblcontact_permissions` (`id`, `permission_id`, `userid`) VALUES (9, 3, 2);
INSERT INTO `tblcontact_permissions` (`id`, `permission_id`, `userid`) VALUES (10, 4, 2);
INSERT INTO `tblcontact_permissions` (`id`, `permission_id`, `userid`) VALUES (11, 5, 2);
INSERT INTO `tblcontact_permissions` (`id`, `permission_id`, `userid`) VALUES (12, 6, 2);


#
# TABLE STRUCTURE FOR: tblcontacts
#

DROP TABLE IF EXISTS `tblcontacts`;

CREATE TABLE `tblcontacts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` int(11) NOT NULL,
  `is_primary` int(11) NOT NULL DEFAULT 1,
  `firstname` varchar(191) NOT NULL,
  `lastname` varchar(191) NOT NULL,
  `email` varchar(100) NOT NULL,
  `phonenumber` varchar(100) NOT NULL,
  `title` varchar(100) DEFAULT NULL,
  `datecreated` datetime NOT NULL,
  `password` varchar(255) DEFAULT NULL,
  `new_pass_key` varchar(32) DEFAULT NULL,
  `new_pass_key_requested` datetime DEFAULT NULL,
  `email_verified_at` datetime DEFAULT NULL,
  `email_verification_key` varchar(32) DEFAULT NULL,
  `email_verification_sent_at` datetime DEFAULT NULL,
  `last_ip` varchar(40) DEFAULT NULL,
  `last_login` datetime DEFAULT NULL,
  `last_password_change` datetime DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `profile_image` varchar(191) DEFAULT NULL,
  `direction` varchar(3) DEFAULT NULL,
  `invoice_emails` tinyint(1) NOT NULL DEFAULT 1,
  `estimate_emails` tinyint(1) NOT NULL DEFAULT 1,
  `credit_note_emails` tinyint(1) NOT NULL DEFAULT 1,
  `contract_emails` tinyint(1) NOT NULL DEFAULT 1,
  `task_emails` tinyint(1) NOT NULL DEFAULT 1,
  `project_emails` tinyint(1) NOT NULL DEFAULT 1,
  `ticket_emails` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `userid` (`userid`),
  KEY `firstname` (`firstname`),
  KEY `lastname` (`lastname`),
  KEY `email` (`email`),
  KEY `is_primary` (`is_primary`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblcontacts` (`id`, `userid`, `is_primary`, `firstname`, `lastname`, `email`, `phonenumber`, `title`, `datecreated`, `password`, `new_pass_key`, `new_pass_key_requested`, `email_verified_at`, `email_verification_key`, `email_verification_sent_at`, `last_ip`, `last_login`, `last_password_change`, `active`, `profile_image`, `direction`, `invoice_emails`, `estimate_emails`, `credit_note_emails`, `contract_emails`, `task_emails`, `project_emails`, `ticket_emails`) VALUES (1, 1, 1, 'ANTONIO', 'ICON', 'MARIO96HS@GMAIL.COM', '621 27 17 03', '', '2021-02-07 12:22:22', '$2a$08$F7L06klOFaJPHFeBNNOPp.xtQ92SoFh.ZWmGsYWNqSVOZFS6Omwdu', NULL, NULL, '2021-02-07 12:22:21', NULL, NULL, NULL, NULL, NULL, 1, NULL, '', 1, 1, 1, 1, 1, 1, 1);
INSERT INTO `tblcontacts` (`id`, `userid`, `is_primary`, `firstname`, `lastname`, `email`, `phonenumber`, `title`, `datecreated`, `password`, `new_pass_key`, `new_pass_key_requested`, `email_verified_at`, `email_verification_key`, `email_verification_sent_at`, `last_ip`, `last_login`, `last_password_change`, `active`, `profile_image`, `direction`, `invoice_emails`, `estimate_emails`, `credit_note_emails`, `contract_emails`, `task_emails`, `project_emails`, `ticket_emails`) VALUES (2, 4, 1, 'MARIO', 'DIAGEO', 'Mario.Toledano@diageo.com', '', '', '2021-08-16 16:07:58', '$2a$08$JJA3y9f9F98KoibHtlC.AeagzVEbNoB9LDB7/hjxFZ4AOSL.IKQY6', '739b84b940e3a6f42cc54283fb193ae2', '2021-08-16 16:07:59', '2021-08-16 16:07:58', NULL, NULL, NULL, NULL, NULL, 1, NULL, '', 1, 1, 1, 1, 1, 1, 1);


#
# TABLE STRUCTURE FOR: tblcontract_comments
#

DROP TABLE IF EXISTS `tblcontract_comments`;

CREATE TABLE `tblcontract_comments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `content` mediumtext DEFAULT NULL,
  `contract_id` int(11) NOT NULL,
  `staffid` int(11) NOT NULL,
  `dateadded` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblcontract_renewals
#

DROP TABLE IF EXISTS `tblcontract_renewals`;

CREATE TABLE `tblcontract_renewals` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `contractid` int(11) NOT NULL,
  `old_start_date` date NOT NULL,
  `new_start_date` date NOT NULL,
  `old_end_date` date DEFAULT NULL,
  `new_end_date` date DEFAULT NULL,
  `old_value` decimal(15,2) DEFAULT NULL,
  `new_value` decimal(15,2) DEFAULT NULL,
  `date_renewed` datetime NOT NULL,
  `renewed_by` varchar(100) NOT NULL,
  `renewed_by_staff_id` int(11) NOT NULL DEFAULT 0,
  `is_on_old_expiry_notified` int(11) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblcontracts
#

DROP TABLE IF EXISTS `tblcontracts`;

CREATE TABLE `tblcontracts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `content` longtext DEFAULT NULL,
  `description` text DEFAULT NULL,
  `subject` varchar(191) DEFAULT NULL,
  `client` int(11) NOT NULL,
  `datestart` date DEFAULT NULL,
  `dateend` date DEFAULT NULL,
  `contract_type` int(11) DEFAULT NULL,
  `project_id` int(11) DEFAULT NULL,
  `addedfrom` int(11) NOT NULL,
  `dateadded` datetime NOT NULL,
  `isexpirynotified` int(11) NOT NULL DEFAULT 0,
  `contract_value` decimal(15,2) DEFAULT NULL,
  `trash` tinyint(1) DEFAULT 0,
  `not_visible_to_client` tinyint(1) NOT NULL DEFAULT 0,
  `hash` varchar(32) DEFAULT NULL,
  `signed` tinyint(1) NOT NULL DEFAULT 0,
  `signature` varchar(40) DEFAULT NULL,
  `marked_as_signed` tinyint(1) NOT NULL DEFAULT 0,
  `acceptance_firstname` varchar(50) DEFAULT NULL,
  `acceptance_lastname` varchar(50) DEFAULT NULL,
  `acceptance_email` varchar(100) DEFAULT NULL,
  `acceptance_date` datetime DEFAULT NULL,
  `acceptance_ip` varchar(40) DEFAULT NULL,
  `short_link` varchar(100) DEFAULT NULL,
  `last_sent_at` datetime DEFAULT NULL,
  `contacts_sent_to` text DEFAULT NULL,
  `last_sign_reminder_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `client` (`client`),
  KEY `contract_type` (`contract_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblcontracts_types
#

DROP TABLE IF EXISTS `tblcontracts_types`;

CREATE TABLE `tblcontracts_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` mediumtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblcontracts_types` (`id`, `name`) VALUES (1, 'ORLAS');


#
# TABLE STRUCTURE FOR: tblcountries
#

DROP TABLE IF EXISTS `tblcountries`;

CREATE TABLE `tblcountries` (
  `country_id` int(5) NOT NULL AUTO_INCREMENT,
  `iso2` char(2) DEFAULT NULL,
  `short_name` varchar(80) NOT NULL DEFAULT '',
  `long_name` varchar(80) NOT NULL DEFAULT '',
  `iso3` char(3) DEFAULT NULL,
  `numcode` varchar(6) DEFAULT NULL,
  `un_member` varchar(12) DEFAULT NULL,
  `calling_code` varchar(8) DEFAULT NULL,
  `cctld` varchar(5) DEFAULT NULL,
  PRIMARY KEY (`country_id`)
) ENGINE=InnoDB AUTO_INCREMENT=251 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (1, 'AF', 'Afghanistan', 'Islamic Republic of Afghanistan', 'AFG', '004', 'yes', '93', '.af');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (2, 'AX', 'Aland Islands', '&Aring;land Islands', 'ALA', '248', 'no', '358', '.ax');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (3, 'AL', 'Albania', 'Republic of Albania', 'ALB', '008', 'yes', '355', '.al');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (4, 'DZ', 'Algeria', 'People\'s Democratic Republic of Algeria', 'DZA', '012', 'yes', '213', '.dz');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (5, 'AS', 'American Samoa', 'American Samoa', 'ASM', '016', 'no', '1+684', '.as');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (6, 'AD', 'Andorra', 'Principality of Andorra', 'AND', '020', 'yes', '376', '.ad');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (7, 'AO', 'Angola', 'Republic of Angola', 'AGO', '024', 'yes', '244', '.ao');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (8, 'AI', 'Anguilla', 'Anguilla', 'AIA', '660', 'no', '1+264', '.ai');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (9, 'AQ', 'Antarctica', 'Antarctica', 'ATA', '010', 'no', '672', '.aq');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (10, 'AG', 'Antigua and Barbuda', 'Antigua and Barbuda', 'ATG', '028', 'yes', '1+268', '.ag');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (11, 'AR', 'Argentina', 'Argentine Republic', 'ARG', '032', 'yes', '54', '.ar');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (12, 'AM', 'Armenia', 'Republic of Armenia', 'ARM', '051', 'yes', '374', '.am');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (13, 'AW', 'Aruba', 'Aruba', 'ABW', '533', 'no', '297', '.aw');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (14, 'AU', 'Australia', 'Commonwealth of Australia', 'AUS', '036', 'yes', '61', '.au');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (15, 'AT', 'Austria', 'Republic of Austria', 'AUT', '040', 'yes', '43', '.at');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (16, 'AZ', 'Azerbaijan', 'Republic of Azerbaijan', 'AZE', '031', 'yes', '994', '.az');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (17, 'BS', 'Bahamas', 'Commonwealth of The Bahamas', 'BHS', '044', 'yes', '1+242', '.bs');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (18, 'BH', 'Bahrain', 'Kingdom of Bahrain', 'BHR', '048', 'yes', '973', '.bh');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (19, 'BD', 'Bangladesh', 'People\'s Republic of Bangladesh', 'BGD', '050', 'yes', '880', '.bd');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (20, 'BB', 'Barbados', 'Barbados', 'BRB', '052', 'yes', '1+246', '.bb');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (21, 'BY', 'Belarus', 'Republic of Belarus', 'BLR', '112', 'yes', '375', '.by');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (22, 'BE', 'Belgium', 'Kingdom of Belgium', 'BEL', '056', 'yes', '32', '.be');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (23, 'BZ', 'Belize', 'Belize', 'BLZ', '084', 'yes', '501', '.bz');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (24, 'BJ', 'Benin', 'Republic of Benin', 'BEN', '204', 'yes', '229', '.bj');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (25, 'BM', 'Bermuda', 'Bermuda Islands', 'BMU', '060', 'no', '1+441', '.bm');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (26, 'BT', 'Bhutan', 'Kingdom of Bhutan', 'BTN', '064', 'yes', '975', '.bt');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (27, 'BO', 'Bolivia', 'Plurinational State of Bolivia', 'BOL', '068', 'yes', '591', '.bo');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (28, 'BQ', 'Bonaire, Sint Eustatius and Saba', 'Bonaire, Sint Eustatius and Saba', 'BES', '535', 'no', '599', '.bq');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (29, 'BA', 'Bosnia and Herzegovina', 'Bosnia and Herzegovina', 'BIH', '070', 'yes', '387', '.ba');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (30, 'BW', 'Botswana', 'Republic of Botswana', 'BWA', '072', 'yes', '267', '.bw');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (31, 'BV', 'Bouvet Island', 'Bouvet Island', 'BVT', '074', 'no', 'NONE', '.bv');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (32, 'BR', 'Brazil', 'Federative Republic of Brazil', 'BRA', '076', 'yes', '55', '.br');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (33, 'IO', 'British Indian Ocean Territory', 'British Indian Ocean Territory', 'IOT', '086', 'no', '246', '.io');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (34, 'BN', 'Brunei', 'Brunei Darussalam', 'BRN', '096', 'yes', '673', '.bn');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (35, 'BG', 'Bulgaria', 'Republic of Bulgaria', 'BGR', '100', 'yes', '359', '.bg');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (36, 'BF', 'Burkina Faso', 'Burkina Faso', 'BFA', '854', 'yes', '226', '.bf');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (37, 'BI', 'Burundi', 'Republic of Burundi', 'BDI', '108', 'yes', '257', '.bi');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (38, 'KH', 'Cambodia', 'Kingdom of Cambodia', 'KHM', '116', 'yes', '855', '.kh');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (39, 'CM', 'Cameroon', 'Republic of Cameroon', 'CMR', '120', 'yes', '237', '.cm');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (40, 'CA', 'Canada', 'Canada', 'CAN', '124', 'yes', '1', '.ca');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (41, 'CV', 'Cape Verde', 'Republic of Cape Verde', 'CPV', '132', 'yes', '238', '.cv');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (42, 'KY', 'Cayman Islands', 'The Cayman Islands', 'CYM', '136', 'no', '1+345', '.ky');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (43, 'CF', 'Central African Republic', 'Central African Republic', 'CAF', '140', 'yes', '236', '.cf');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (44, 'TD', 'Chad', 'Republic of Chad', 'TCD', '148', 'yes', '235', '.td');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (45, 'CL', 'Chile', 'Republic of Chile', 'CHL', '152', 'yes', '56', '.cl');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (46, 'CN', 'China', 'People\'s Republic of China', 'CHN', '156', 'yes', '86', '.cn');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (47, 'CX', 'Christmas Island', 'Christmas Island', 'CXR', '162', 'no', '61', '.cx');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (48, 'CC', 'Cocos (Keeling) Islands', 'Cocos (Keeling) Islands', 'CCK', '166', 'no', '61', '.cc');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (49, 'CO', 'Colombia', 'Republic of Colombia', 'COL', '170', 'yes', '57', '.co');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (50, 'KM', 'Comoros', 'Union of the Comoros', 'COM', '174', 'yes', '269', '.km');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (51, 'CG', 'Congo', 'Republic of the Congo', 'COG', '178', 'yes', '242', '.cg');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (52, 'CK', 'Cook Islands', 'Cook Islands', 'COK', '184', 'some', '682', '.ck');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (53, 'CR', 'Costa Rica', 'Republic of Costa Rica', 'CRI', '188', 'yes', '506', '.cr');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (54, 'CI', 'Cote d\'ivoire (Ivory Coast)', 'Republic of C&ocirc;te D\'Ivoire (Ivory Coast)', 'CIV', '384', 'yes', '225', '.ci');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (55, 'HR', 'Croatia', 'Republic of Croatia', 'HRV', '191', 'yes', '385', '.hr');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (56, 'CU', 'Cuba', 'Republic of Cuba', 'CUB', '192', 'yes', '53', '.cu');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (57, 'CW', 'Curacao', 'Cura&ccedil;ao', 'CUW', '531', 'no', '599', '.cw');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (58, 'CY', 'Cyprus', 'Republic of Cyprus', 'CYP', '196', 'yes', '357', '.cy');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (59, 'CZ', 'Czech Republic', 'Czech Republic', 'CZE', '203', 'yes', '420', '.cz');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (60, 'CD', 'Democratic Republic of the Congo', 'Democratic Republic of the Congo', 'COD', '180', 'yes', '243', '.cd');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (61, 'DK', 'Denmark', 'Kingdom of Denmark', 'DNK', '208', 'yes', '45', '.dk');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (62, 'DJ', 'Djibouti', 'Republic of Djibouti', 'DJI', '262', 'yes', '253', '.dj');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (63, 'DM', 'Dominica', 'Commonwealth of Dominica', 'DMA', '212', 'yes', '1+767', '.dm');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (64, 'DO', 'Dominican Republic', 'Dominican Republic', 'DOM', '214', 'yes', '1+809, 8', '.do');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (65, 'EC', 'Ecuador', 'Republic of Ecuador', 'ECU', '218', 'yes', '593', '.ec');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (66, 'EG', 'Egypt', 'Arab Republic of Egypt', 'EGY', '818', 'yes', '20', '.eg');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (67, 'SV', 'El Salvador', 'Republic of El Salvador', 'SLV', '222', 'yes', '503', '.sv');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (68, 'GQ', 'Equatorial Guinea', 'Republic of Equatorial Guinea', 'GNQ', '226', 'yes', '240', '.gq');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (69, 'ER', 'Eritrea', 'State of Eritrea', 'ERI', '232', 'yes', '291', '.er');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (70, 'EE', 'Estonia', 'Republic of Estonia', 'EST', '233', 'yes', '372', '.ee');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (71, 'ET', 'Ethiopia', 'Federal Democratic Republic of Ethiopia', 'ETH', '231', 'yes', '251', '.et');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (72, 'FK', 'Falkland Islands (Malvinas)', 'The Falkland Islands (Malvinas)', 'FLK', '238', 'no', '500', '.fk');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (73, 'FO', 'Faroe Islands', 'The Faroe Islands', 'FRO', '234', 'no', '298', '.fo');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (74, 'FJ', 'Fiji', 'Republic of Fiji', 'FJI', '242', 'yes', '679', '.fj');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (75, 'FI', 'Finland', 'Republic of Finland', 'FIN', '246', 'yes', '358', '.fi');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (76, 'FR', 'France', 'French Republic', 'FRA', '250', 'yes', '33', '.fr');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (77, 'GF', 'French Guiana', 'French Guiana', 'GUF', '254', 'no', '594', '.gf');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (78, 'PF', 'French Polynesia', 'French Polynesia', 'PYF', '258', 'no', '689', '.pf');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (79, 'TF', 'French Southern Territories', 'French Southern Territories', 'ATF', '260', 'no', NULL, '.tf');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (80, 'GA', 'Gabon', 'Gabonese Republic', 'GAB', '266', 'yes', '241', '.ga');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (81, 'GM', 'Gambia', 'Republic of The Gambia', 'GMB', '270', 'yes', '220', '.gm');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (82, 'GE', 'Georgia', 'Georgia', 'GEO', '268', 'yes', '995', '.ge');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (83, 'DE', 'Germany', 'Federal Republic of Germany', 'DEU', '276', 'yes', '49', '.de');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (84, 'GH', 'Ghana', 'Republic of Ghana', 'GHA', '288', 'yes', '233', '.gh');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (85, 'GI', 'Gibraltar', 'Gibraltar', 'GIB', '292', 'no', '350', '.gi');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (86, 'GR', 'Greece', 'Hellenic Republic', 'GRC', '300', 'yes', '30', '.gr');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (87, 'GL', 'Greenland', 'Greenland', 'GRL', '304', 'no', '299', '.gl');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (88, 'GD', 'Grenada', 'Grenada', 'GRD', '308', 'yes', '1+473', '.gd');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (89, 'GP', 'Guadaloupe', 'Guadeloupe', 'GLP', '312', 'no', '590', '.gp');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (90, 'GU', 'Guam', 'Guam', 'GUM', '316', 'no', '1+671', '.gu');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (91, 'GT', 'Guatemala', 'Republic of Guatemala', 'GTM', '320', 'yes', '502', '.gt');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (92, 'GG', 'Guernsey', 'Guernsey', 'GGY', '831', 'no', '44', '.gg');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (93, 'GN', 'Guinea', 'Republic of Guinea', 'GIN', '324', 'yes', '224', '.gn');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (94, 'GW', 'Guinea-Bissau', 'Republic of Guinea-Bissau', 'GNB', '624', 'yes', '245', '.gw');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (95, 'GY', 'Guyana', 'Co-operative Republic of Guyana', 'GUY', '328', 'yes', '592', '.gy');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (96, 'HT', 'Haiti', 'Republic of Haiti', 'HTI', '332', 'yes', '509', '.ht');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (97, 'HM', 'Heard Island and McDonald Islands', 'Heard Island and McDonald Islands', 'HMD', '334', 'no', 'NONE', '.hm');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (98, 'HN', 'Honduras', 'Republic of Honduras', 'HND', '340', 'yes', '504', '.hn');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (99, 'HK', 'Hong Kong', 'Hong Kong', 'HKG', '344', 'no', '852', '.hk');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (100, 'HU', 'Hungary', 'Hungary', 'HUN', '348', 'yes', '36', '.hu');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (101, 'IS', 'Iceland', 'Republic of Iceland', 'ISL', '352', 'yes', '354', '.is');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (102, 'IN', 'India', 'Republic of India', 'IND', '356', 'yes', '91', '.in');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (103, 'ID', 'Indonesia', 'Republic of Indonesia', 'IDN', '360', 'yes', '62', '.id');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (104, 'IR', 'Iran', 'Islamic Republic of Iran', 'IRN', '364', 'yes', '98', '.ir');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (105, 'IQ', 'Iraq', 'Republic of Iraq', 'IRQ', '368', 'yes', '964', '.iq');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (106, 'IE', 'Ireland', 'Ireland', 'IRL', '372', 'yes', '353', '.ie');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (107, 'IM', 'Isle of Man', 'Isle of Man', 'IMN', '833', 'no', '44', '.im');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (108, 'IL', 'Israel', 'State of Israel', 'ISR', '376', 'yes', '972', '.il');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (109, 'IT', 'Italy', 'Italian Republic', 'ITA', '380', 'yes', '39', '.jm');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (110, 'JM', 'Jamaica', 'Jamaica', 'JAM', '388', 'yes', '1+876', '.jm');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (111, 'JP', 'Japan', 'Japan', 'JPN', '392', 'yes', '81', '.jp');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (112, 'JE', 'Jersey', 'The Bailiwick of Jersey', 'JEY', '832', 'no', '44', '.je');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (113, 'JO', 'Jordan', 'Hashemite Kingdom of Jordan', 'JOR', '400', 'yes', '962', '.jo');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (114, 'KZ', 'Kazakhstan', 'Republic of Kazakhstan', 'KAZ', '398', 'yes', '7', '.kz');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (115, 'KE', 'Kenya', 'Republic of Kenya', 'KEN', '404', 'yes', '254', '.ke');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (116, 'KI', 'Kiribati', 'Republic of Kiribati', 'KIR', '296', 'yes', '686', '.ki');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (117, 'XK', 'Kosovo', 'Republic of Kosovo', '---', '---', 'some', '381', '');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (118, 'KW', 'Kuwait', 'State of Kuwait', 'KWT', '414', 'yes', '965', '.kw');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (119, 'KG', 'Kyrgyzstan', 'Kyrgyz Republic', 'KGZ', '417', 'yes', '996', '.kg');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (120, 'LA', 'Laos', 'Lao People\'s Democratic Republic', 'LAO', '418', 'yes', '856', '.la');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (121, 'LV', 'Latvia', 'Republic of Latvia', 'LVA', '428', 'yes', '371', '.lv');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (122, 'LB', 'Lebanon', 'Republic of Lebanon', 'LBN', '422', 'yes', '961', '.lb');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (123, 'LS', 'Lesotho', 'Kingdom of Lesotho', 'LSO', '426', 'yes', '266', '.ls');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (124, 'LR', 'Liberia', 'Republic of Liberia', 'LBR', '430', 'yes', '231', '.lr');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (125, 'LY', 'Libya', 'Libya', 'LBY', '434', 'yes', '218', '.ly');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (126, 'LI', 'Liechtenstein', 'Principality of Liechtenstein', 'LIE', '438', 'yes', '423', '.li');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (127, 'LT', 'Lithuania', 'Republic of Lithuania', 'LTU', '440', 'yes', '370', '.lt');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (128, 'LU', 'Luxembourg', 'Grand Duchy of Luxembourg', 'LUX', '442', 'yes', '352', '.lu');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (129, 'MO', 'Macao', 'The Macao Special Administrative Region', 'MAC', '446', 'no', '853', '.mo');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (130, 'MK', 'North Macedonia', 'Republic of North Macedonia', 'MKD', '807', 'yes', '389', '.mk');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (131, 'MG', 'Madagascar', 'Republic of Madagascar', 'MDG', '450', 'yes', '261', '.mg');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (132, 'MW', 'Malawi', 'Republic of Malawi', 'MWI', '454', 'yes', '265', '.mw');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (133, 'MY', 'Malaysia', 'Malaysia', 'MYS', '458', 'yes', '60', '.my');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (134, 'MV', 'Maldives', 'Republic of Maldives', 'MDV', '462', 'yes', '960', '.mv');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (135, 'ML', 'Mali', 'Republic of Mali', 'MLI', '466', 'yes', '223', '.ml');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (136, 'MT', 'Malta', 'Republic of Malta', 'MLT', '470', 'yes', '356', '.mt');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (137, 'MH', 'Marshall Islands', 'Republic of the Marshall Islands', 'MHL', '584', 'yes', '692', '.mh');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (138, 'MQ', 'Martinique', 'Martinique', 'MTQ', '474', 'no', '596', '.mq');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (139, 'MR', 'Mauritania', 'Islamic Republic of Mauritania', 'MRT', '478', 'yes', '222', '.mr');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (140, 'MU', 'Mauritius', 'Republic of Mauritius', 'MUS', '480', 'yes', '230', '.mu');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (141, 'YT', 'Mayotte', 'Mayotte', 'MYT', '175', 'no', '262', '.yt');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (142, 'MX', 'Mexico', 'United Mexican States', 'MEX', '484', 'yes', '52', '.mx');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (143, 'FM', 'Micronesia', 'Federated States of Micronesia', 'FSM', '583', 'yes', '691', '.fm');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (144, 'MD', 'Moldava', 'Republic of Moldova', 'MDA', '498', 'yes', '373', '.md');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (145, 'MC', 'Monaco', 'Principality of Monaco', 'MCO', '492', 'yes', '377', '.mc');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (146, 'MN', 'Mongolia', 'Mongolia', 'MNG', '496', 'yes', '976', '.mn');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (147, 'ME', 'Montenegro', 'Montenegro', 'MNE', '499', 'yes', '382', '.me');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (148, 'MS', 'Montserrat', 'Montserrat', 'MSR', '500', 'no', '1+664', '.ms');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (149, 'MA', 'Morocco', 'Kingdom of Morocco', 'MAR', '504', 'yes', '212', '.ma');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (150, 'MZ', 'Mozambique', 'Republic of Mozambique', 'MOZ', '508', 'yes', '258', '.mz');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (151, 'MM', 'Myanmar (Burma)', 'Republic of the Union of Myanmar', 'MMR', '104', 'yes', '95', '.mm');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (152, 'NA', 'Namibia', 'Republic of Namibia', 'NAM', '516', 'yes', '264', '.na');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (153, 'NR', 'Nauru', 'Republic of Nauru', 'NRU', '520', 'yes', '674', '.nr');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (154, 'NP', 'Nepal', 'Federal Democratic Republic of Nepal', 'NPL', '524', 'yes', '977', '.np');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (155, 'NL', 'Netherlands', 'Kingdom of the Netherlands', 'NLD', '528', 'yes', '31', '.nl');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (156, 'NC', 'New Caledonia', 'New Caledonia', 'NCL', '540', 'no', '687', '.nc');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (157, 'NZ', 'New Zealand', 'New Zealand', 'NZL', '554', 'yes', '64', '.nz');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (158, 'NI', 'Nicaragua', 'Republic of Nicaragua', 'NIC', '558', 'yes', '505', '.ni');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (159, 'NE', 'Niger', 'Republic of Niger', 'NER', '562', 'yes', '227', '.ne');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (160, 'NG', 'Nigeria', 'Federal Republic of Nigeria', 'NGA', '566', 'yes', '234', '.ng');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (161, 'NU', 'Niue', 'Niue', 'NIU', '570', 'some', '683', '.nu');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (162, 'NF', 'Norfolk Island', 'Norfolk Island', 'NFK', '574', 'no', '672', '.nf');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (163, 'KP', 'North Korea', 'Democratic People\'s Republic of Korea', 'PRK', '408', 'yes', '850', '.kp');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (164, 'MP', 'Northern Mariana Islands', 'Northern Mariana Islands', 'MNP', '580', 'no', '1+670', '.mp');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (165, 'NO', 'Norway', 'Kingdom of Norway', 'NOR', '578', 'yes', '47', '.no');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (166, 'OM', 'Oman', 'Sultanate of Oman', 'OMN', '512', 'yes', '968', '.om');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (167, 'PK', 'Pakistan', 'Islamic Republic of Pakistan', 'PAK', '586', 'yes', '92', '.pk');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (168, 'PW', 'Palau', 'Republic of Palau', 'PLW', '585', 'yes', '680', '.pw');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (169, 'PS', 'Palestine', 'State of Palestine (or Occupied Palestinian Territory)', 'PSE', '275', 'some', '970', '.ps');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (170, 'PA', 'Panama', 'Republic of Panama', 'PAN', '591', 'yes', '507', '.pa');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (171, 'PG', 'Papua New Guinea', 'Independent State of Papua New Guinea', 'PNG', '598', 'yes', '675', '.pg');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (172, 'PY', 'Paraguay', 'Republic of Paraguay', 'PRY', '600', 'yes', '595', '.py');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (173, 'PE', 'Peru', 'Republic of Peru', 'PER', '604', 'yes', '51', '.pe');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (174, 'PH', 'Philippines', 'Republic of the Philippines', 'PHL', '608', 'yes', '63', '.ph');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (175, 'PN', 'Pitcairn', 'Pitcairn', 'PCN', '612', 'no', 'NONE', '.pn');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (176, 'PL', 'Poland', 'Republic of Poland', 'POL', '616', 'yes', '48', '.pl');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (177, 'PT', 'Portugal', 'Portuguese Republic', 'PRT', '620', 'yes', '351', '.pt');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (178, 'PR', 'Puerto Rico', 'Commonwealth of Puerto Rico', 'PRI', '630', 'no', '1+939', '.pr');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (179, 'QA', 'Qatar', 'State of Qatar', 'QAT', '634', 'yes', '974', '.qa');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (180, 'RE', 'Reunion', 'R&eacute;union', 'REU', '638', 'no', '262', '.re');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (181, 'RO', 'Romania', 'Romania', 'ROU', '642', 'yes', '40', '.ro');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (182, 'RU', 'Russia', 'Russian Federation', 'RUS', '643', 'yes', '7', '.ru');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (183, 'RW', 'Rwanda', 'Republic of Rwanda', 'RWA', '646', 'yes', '250', '.rw');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (184, 'BL', 'Saint Barthelemy', 'Saint Barth&eacute;lemy', 'BLM', '652', 'no', '590', '.bl');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (185, 'SH', 'Saint Helena', 'Saint Helena, Ascension and Tristan da Cunha', 'SHN', '654', 'no', '290', '.sh');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (186, 'KN', 'Saint Kitts and Nevis', 'Federation of Saint Christopher and Nevis', 'KNA', '659', 'yes', '1+869', '.kn');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (187, 'LC', 'Saint Lucia', 'Saint Lucia', 'LCA', '662', 'yes', '1+758', '.lc');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (188, 'MF', 'Saint Martin', 'Saint Martin', 'MAF', '663', 'no', '590', '.mf');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (189, 'PM', 'Saint Pierre and Miquelon', 'Saint Pierre and Miquelon', 'SPM', '666', 'no', '508', '.pm');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (190, 'VC', 'Saint Vincent and the Grenadines', 'Saint Vincent and the Grenadines', 'VCT', '670', 'yes', '1+784', '.vc');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (191, 'WS', 'Samoa', 'Independent State of Samoa', 'WSM', '882', 'yes', '685', '.ws');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (192, 'SM', 'San Marino', 'Republic of San Marino', 'SMR', '674', 'yes', '378', '.sm');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (193, 'ST', 'Sao Tome and Principe', 'Democratic Republic of S&atilde;o Tom&eacute; and Pr&iacute;ncipe', 'STP', '678', 'yes', '239', '.st');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (194, 'SA', 'Saudi Arabia', 'Kingdom of Saudi Arabia', 'SAU', '682', 'yes', '966', '.sa');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (195, 'SN', 'Senegal', 'Republic of Senegal', 'SEN', '686', 'yes', '221', '.sn');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (196, 'RS', 'Serbia', 'Republic of Serbia', 'SRB', '688', 'yes', '381', '.rs');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (197, 'SC', 'Seychelles', 'Republic of Seychelles', 'SYC', '690', 'yes', '248', '.sc');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (198, 'SL', 'Sierra Leone', 'Republic of Sierra Leone', 'SLE', '694', 'yes', '232', '.sl');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (199, 'SG', 'Singapore', 'Republic of Singapore', 'SGP', '702', 'yes', '65', '.sg');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (200, 'SX', 'Sint Maarten', 'Sint Maarten', 'SXM', '534', 'no', '1+721', '.sx');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (201, 'SK', 'Slovakia', 'Slovak Republic', 'SVK', '703', 'yes', '421', '.sk');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (202, 'SI', 'Slovenia', 'Republic of Slovenia', 'SVN', '705', 'yes', '386', '.si');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (203, 'SB', 'Solomon Islands', 'Solomon Islands', 'SLB', '090', 'yes', '677', '.sb');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (204, 'SO', 'Somalia', 'Somali Republic', 'SOM', '706', 'yes', '252', '.so');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (205, 'ZA', 'South Africa', 'Republic of South Africa', 'ZAF', '710', 'yes', '27', '.za');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (206, 'GS', 'South Georgia and the South Sandwich Islands', 'South Georgia and the South Sandwich Islands', 'SGS', '239', 'no', '500', '.gs');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (207, 'KR', 'South Korea', 'Republic of Korea', 'KOR', '410', 'yes', '82', '.kr');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (208, 'SS', 'South Sudan', 'Republic of South Sudan', 'SSD', '728', 'yes', '211', '.ss');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (209, 'ES', 'Spain', 'Kingdom of Spain', 'ESP', '724', 'yes', '34', '.es');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (210, 'LK', 'Sri Lanka', 'Democratic Socialist Republic of Sri Lanka', 'LKA', '144', 'yes', '94', '.lk');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (211, 'SD', 'Sudan', 'Republic of the Sudan', 'SDN', '729', 'yes', '249', '.sd');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (212, 'SR', 'Suriname', 'Republic of Suriname', 'SUR', '740', 'yes', '597', '.sr');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (213, 'SJ', 'Svalbard and Jan Mayen', 'Svalbard and Jan Mayen', 'SJM', '744', 'no', '47', '.sj');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (214, 'SZ', 'Swaziland', 'Kingdom of Swaziland', 'SWZ', '748', 'yes', '268', '.sz');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (215, 'SE', 'Sweden', 'Kingdom of Sweden', 'SWE', '752', 'yes', '46', '.se');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (216, 'CH', 'Switzerland', 'Swiss Confederation', 'CHE', '756', 'yes', '41', '.ch');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (217, 'SY', 'Syria', 'Syrian Arab Republic', 'SYR', '760', 'yes', '963', '.sy');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (218, 'TW', 'Taiwan', 'Republic of China (Taiwan)', 'TWN', '158', 'former', '886', '.tw');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (219, 'TJ', 'Tajikistan', 'Republic of Tajikistan', 'TJK', '762', 'yes', '992', '.tj');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (220, 'TZ', 'Tanzania', 'United Republic of Tanzania', 'TZA', '834', 'yes', '255', '.tz');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (221, 'TH', 'Thailand', 'Kingdom of Thailand', 'THA', '764', 'yes', '66', '.th');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (222, 'TL', 'Timor-Leste (East Timor)', 'Democratic Republic of Timor-Leste', 'TLS', '626', 'yes', '670', '.tl');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (223, 'TG', 'Togo', 'Togolese Republic', 'TGO', '768', 'yes', '228', '.tg');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (224, 'TK', 'Tokelau', 'Tokelau', 'TKL', '772', 'no', '690', '.tk');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (225, 'TO', 'Tonga', 'Kingdom of Tonga', 'TON', '776', 'yes', '676', '.to');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (226, 'TT', 'Trinidad and Tobago', 'Republic of Trinidad and Tobago', 'TTO', '780', 'yes', '1+868', '.tt');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (227, 'TN', 'Tunisia', 'Republic of Tunisia', 'TUN', '788', 'yes', '216', '.tn');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (228, 'TR', 'Turkey', 'Republic of Turkey', 'TUR', '792', 'yes', '90', '.tr');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (229, 'TM', 'Turkmenistan', 'Turkmenistan', 'TKM', '795', 'yes', '993', '.tm');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (230, 'TC', 'Turks and Caicos Islands', 'Turks and Caicos Islands', 'TCA', '796', 'no', '1+649', '.tc');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (231, 'TV', 'Tuvalu', 'Tuvalu', 'TUV', '798', 'yes', '688', '.tv');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (232, 'UG', 'Uganda', 'Republic of Uganda', 'UGA', '800', 'yes', '256', '.ug');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (233, 'UA', 'Ukraine', 'Ukraine', 'UKR', '804', 'yes', '380', '.ua');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (234, 'AE', 'United Arab Emirates', 'United Arab Emirates', 'ARE', '784', 'yes', '971', '.ae');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (235, 'GB', 'United Kingdom', 'United Kingdom of Great Britain and Nothern Ireland', 'GBR', '826', 'yes', '44', '.uk');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (236, 'US', 'United States', 'United States of America', 'USA', '840', 'yes', '1', '.us');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (237, 'UM', 'United States Minor Outlying Islands', 'United States Minor Outlying Islands', 'UMI', '581', 'no', 'NONE', 'NONE');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (238, 'UY', 'Uruguay', 'Eastern Republic of Uruguay', 'URY', '858', 'yes', '598', '.uy');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (239, 'UZ', 'Uzbekistan', 'Republic of Uzbekistan', 'UZB', '860', 'yes', '998', '.uz');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (240, 'VU', 'Vanuatu', 'Republic of Vanuatu', 'VUT', '548', 'yes', '678', '.vu');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (241, 'VA', 'Vatican City', 'State of the Vatican City', 'VAT', '336', 'no', '39', '.va');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (242, 'VE', 'Venezuela', 'Bolivarian Republic of Venezuela', 'VEN', '862', 'yes', '58', '.ve');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (243, 'VN', 'Vietnam', 'Socialist Republic of Vietnam', 'VNM', '704', 'yes', '84', '.vn');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (244, 'VG', 'Virgin Islands, British', 'British Virgin Islands', 'VGB', '092', 'no', '1+284', '.vg');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (245, 'VI', 'Virgin Islands, US', 'Virgin Islands of the United States', 'VIR', '850', 'no', '1+340', '.vi');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (246, 'WF', 'Wallis and Futuna', 'Wallis and Futuna', 'WLF', '876', 'no', '681', '.wf');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (247, 'EH', 'Western Sahara', 'Western Sahara', 'ESH', '732', 'no', '212', '.eh');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (248, 'YE', 'Yemen', 'Republic of Yemen', 'YEM', '887', 'yes', '967', '.ye');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (249, 'ZM', 'Zambia', 'Republic of Zambia', 'ZMB', '894', 'yes', '260', '.zm');
INSERT INTO `tblcountries` (`country_id`, `iso2`, `short_name`, `long_name`, `iso3`, `numcode`, `un_member`, `calling_code`, `cctld`) VALUES (250, 'ZW', 'Zimbabwe', 'Republic of Zimbabwe', 'ZWE', '716', 'yes', '263', '.zw');


#
# TABLE STRUCTURE FOR: tblcreditnote_refunds
#

DROP TABLE IF EXISTS `tblcreditnote_refunds`;

CREATE TABLE `tblcreditnote_refunds` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `credit_note_id` int(11) NOT NULL,
  `staff_id` int(11) NOT NULL,
  `refunded_on` date NOT NULL,
  `payment_mode` varchar(40) NOT NULL,
  `note` text DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblcreditnotes
#

DROP TABLE IF EXISTS `tblcreditnotes`;

CREATE TABLE `tblcreditnotes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `clientid` int(11) NOT NULL,
  `deleted_customer_name` varchar(100) DEFAULT NULL,
  `number` int(11) NOT NULL,
  `prefix` varchar(50) DEFAULT NULL,
  `number_format` int(11) NOT NULL DEFAULT 1,
  `datecreated` datetime NOT NULL,
  `date` date NOT NULL,
  `adminnote` text DEFAULT NULL,
  `terms` text DEFAULT NULL,
  `clientnote` text DEFAULT NULL,
  `currency` int(11) NOT NULL,
  `subtotal` decimal(15,2) NOT NULL,
  `total_tax` decimal(15,2) NOT NULL DEFAULT 0.00,
  `total` decimal(15,2) NOT NULL,
  `adjustment` decimal(15,2) DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT 1,
  `project_id` int(11) NOT NULL DEFAULT 0,
  `discount_percent` decimal(15,2) DEFAULT 0.00,
  `discount_total` decimal(15,2) DEFAULT 0.00,
  `discount_type` varchar(30) NOT NULL,
  `billing_street` varchar(200) DEFAULT NULL,
  `billing_city` varchar(100) DEFAULT NULL,
  `billing_state` varchar(100) DEFAULT NULL,
  `billing_zip` varchar(100) DEFAULT NULL,
  `billing_country` int(11) DEFAULT NULL,
  `shipping_street` varchar(200) DEFAULT NULL,
  `shipping_city` varchar(100) DEFAULT NULL,
  `shipping_state` varchar(100) DEFAULT NULL,
  `shipping_zip` varchar(100) DEFAULT NULL,
  `shipping_country` int(11) DEFAULT NULL,
  `include_shipping` tinyint(1) NOT NULL,
  `show_shipping_on_credit_note` tinyint(1) NOT NULL DEFAULT 1,
  `show_quantity_as` int(11) NOT NULL DEFAULT 1,
  `reference_no` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `currency` (`currency`),
  KEY `clientid` (`clientid`),
  KEY `project_id` (`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblcredits
#

DROP TABLE IF EXISTS `tblcredits`;

CREATE TABLE `tblcredits` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice_id` int(11) NOT NULL,
  `credit_id` int(11) NOT NULL,
  `staff_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `date_applied` datetime NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblcurrencies
#

DROP TABLE IF EXISTS `tblcurrencies`;

CREATE TABLE `tblcurrencies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `symbol` varchar(10) NOT NULL,
  `name` varchar(100) NOT NULL,
  `decimal_separator` varchar(5) DEFAULT NULL,
  `thousand_separator` varchar(5) DEFAULT NULL,
  `placement` varchar(10) DEFAULT NULL,
  `isdefault` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblcurrencies` (`id`, `symbol`, `name`, `decimal_separator`, `thousand_separator`, `placement`, `isdefault`) VALUES (1, '$', 'USD', '.', ',', 'before', 0);
INSERT INTO `tblcurrencies` (`id`, `symbol`, `name`, `decimal_separator`, `thousand_separator`, `placement`, `isdefault`) VALUES (2, '€', 'EUR', ',', '.', 'after', 1);


#
# TABLE STRUCTURE FOR: tblcustomer_admins
#

DROP TABLE IF EXISTS `tblcustomer_admins`;

CREATE TABLE `tblcustomer_admins` (
  `staff_id` int(11) NOT NULL,
  `customer_id` int(11) NOT NULL,
  `date_assigned` text NOT NULL,
  KEY `customer_id` (`customer_id`),
  KEY `staff_id` (`staff_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblcustomer_groups
#

DROP TABLE IF EXISTS `tblcustomer_groups`;

CREATE TABLE `tblcustomer_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `groupid` int(11) NOT NULL,
  `customer_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `groupid` (`groupid`),
  KEY `customer_id` (`customer_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblcustomer_groups` (`id`, `groupid`, `customer_id`) VALUES (1, 1, 1);
INSERT INTO `tblcustomer_groups` (`id`, `groupid`, `customer_id`) VALUES (2, 1, 4);


#
# TABLE STRUCTURE FOR: tblcustomers_groups
#

DROP TABLE IF EXISTS `tblcustomers_groups`;

CREATE TABLE `tblcustomers_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblcustomers_groups` (`id`, `name`) VALUES (1, 'COMERCIALES');


#
# TABLE STRUCTURE FOR: tblcustomfields
#

DROP TABLE IF EXISTS `tblcustomfields`;

CREATE TABLE `tblcustomfields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fieldto` varchar(30) DEFAULT NULL,
  `name` varchar(150) NOT NULL,
  `slug` varchar(150) NOT NULL,
  `required` tinyint(1) NOT NULL DEFAULT 0,
  `type` varchar(20) NOT NULL,
  `options` mediumtext DEFAULT NULL,
  `display_inline` tinyint(1) NOT NULL DEFAULT 0,
  `field_order` int(11) DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `show_on_pdf` int(11) NOT NULL DEFAULT 0,
  `show_on_ticket_form` tinyint(1) NOT NULL DEFAULT 0,
  `only_admin` tinyint(1) NOT NULL DEFAULT 0,
  `show_on_table` tinyint(1) NOT NULL DEFAULT 0,
  `show_on_client_portal` int(11) NOT NULL DEFAULT 0,
  `disalow_client_to_edit` int(11) NOT NULL DEFAULT 0,
  `bs_column` int(11) NOT NULL DEFAULT 12,
  `default_value` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblcustomfieldsvalues
#

DROP TABLE IF EXISTS `tblcustomfieldsvalues`;

CREATE TABLE `tblcustomfieldsvalues` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `relid` int(11) NOT NULL,
  `fieldid` int(11) NOT NULL,
  `fieldto` varchar(15) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `relid` (`relid`),
  KEY `fieldto` (`fieldto`),
  KEY `fieldid` (`fieldid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblday_off
#

DROP TABLE IF EXISTS `tblday_off`;

CREATE TABLE `tblday_off` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `off_reason` varchar(255) NOT NULL,
  `off_type` varchar(100) NOT NULL,
  `break_date` date NOT NULL,
  `timekeeping` varchar(45) DEFAULT NULL,
  `department` varchar(45) DEFAULT NULL,
  `position` varchar(45) DEFAULT NULL,
  `add_from` int(11) NOT NULL,
  `repeat_by_year` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tbldepartments
#

DROP TABLE IF EXISTS `tbldepartments`;

CREATE TABLE `tbldepartments` (
  `departmentid` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `imap_username` varchar(191) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `email_from_header` tinyint(1) NOT NULL DEFAULT 0,
  `host` varchar(150) DEFAULT NULL,
  `password` mediumtext DEFAULT NULL,
  `encryption` varchar(3) DEFAULT NULL,
  `folder` varchar(191) NOT NULL DEFAULT 'INBOX',
  `delete_after_import` int(11) NOT NULL DEFAULT 0,
  `calendar_id` mediumtext DEFAULT NULL,
  `hidefromclient` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`departmentid`),
  KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tbldismissed_announcements
#

DROP TABLE IF EXISTS `tbldismissed_announcements`;

CREATE TABLE `tbldismissed_announcements` (
  `dismissedannouncementid` int(11) NOT NULL AUTO_INCREMENT,
  `announcementid` int(11) NOT NULL,
  `staff` int(11) NOT NULL,
  `userid` int(11) NOT NULL,
  PRIMARY KEY (`dismissedannouncementid`),
  KEY `announcementid` (`announcementid`),
  KEY `staff` (`staff`),
  KEY `userid` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblemailtemplates
#

DROP TABLE IF EXISTS `tblemailtemplates`;

CREATE TABLE `tblemailtemplates` (
  `emailtemplateid` int(11) NOT NULL AUTO_INCREMENT,
  `type` mediumtext NOT NULL,
  `slug` varchar(100) NOT NULL,
  `language` varchar(40) DEFAULT NULL,
  `name` mediumtext NOT NULL,
  `subject` mediumtext NOT NULL,
  `message` mediumtext NOT NULL,
  `fromname` mediumtext NOT NULL,
  `fromemail` varchar(100) DEFAULT NULL,
  `plaintext` int(11) NOT NULL DEFAULT 0,
  `active` tinyint(4) NOT NULL DEFAULT 0,
  `order` int(11) NOT NULL,
  PRIMARY KEY (`emailtemplateid`)
) ENGINE=InnoDB AUTO_INCREMENT=88 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (1, 'client', 'new-client-created', 'english', 'New Contact Added/Registered (Welcome Email)', 'Welcome aboard', 'Dear {contact_firstname} {contact_lastname}<br /><br />Thank you for registering on the <strong>{companyname}</strong> CRM System.<br /><br />We just wanted to say welcome.<br /><br />Please contact us if you need any help.<br /><br />Click here to view your profile: <a href=\"{crm_url}\">{crm_url}</a><br /><br />Kind Regards, <br />{email_signature}<br /><br />(This is an automated email, so please don\'t reply to this email address)', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (2, 'invoice', 'invoice-send-to-client', 'english', 'Send Invoice to Customer', 'Invoice with number {invoice_number} created', '<span style=\"font-size: 12pt;\">Dear {contact_firstname} {contact_lastname}</span><br /><br /><span style=\"font-size: 12pt;\">We have prepared the following invoice for you: <strong># {invoice_number}</strong></span><br /><br /><span style=\"font-size: 12pt;\"><strong>Invoice status</strong>: {invoice_status}</span><br /><br /><span style=\"font-size: 12pt;\">You can view the invoice on the following link: <a href=\"{invoice_link}\">{invoice_number}</a></span><br /><br /><span style=\"font-size: 12pt;\">Please contact us for more information.</span><br /><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (3, 'ticket', 'new-ticket-opened-admin', 'english', 'New Ticket Opened (Opened by Staff, Sent to Customer)', 'New Support Ticket Opened', '<span style=\"font-size: 12pt;\">Hi {contact_firstname} {contact_lastname}</span><br /><br /><span style=\"font-size: 12pt;\">New support ticket has been opened.</span><br /><br /><span style=\"font-size: 12pt;\"><strong>Subject:</strong> {ticket_subject}</span><br /><span style=\"font-size: 12pt;\"><strong>Department:</strong> {ticket_department}</span><br /><span style=\"font-size: 12pt;\"><strong>Priority:</strong> {ticket_priority}<br /></span><br /><span style=\"font-size: 12pt;\"><strong>Ticket message:</strong></span><br /><span style=\"font-size: 12pt;\">{ticket_message}</span><br /><br /><span style=\"font-size: 12pt;\">You can view the ticket on the following link: <a href=\"{ticket_public_url}\">#{ticket_id}</a><br /><br />Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (4, 'ticket', 'ticket-reply', 'english', 'Ticket Reply (Sent to Customer)', 'New Ticket Reply', '<span style=\"font-size: 12pt;\">Hi {contact_firstname} {contact_lastname}</span><br /><br /><span style=\"font-size: 12pt;\">You have a new ticket reply to ticket <a href=\"{ticket_public_url}\">#{ticket_id}</a></span><br /><br /><span style=\"font-size: 12pt;\"><strong>Ticket Subject:</strong> {ticket_subject}<br /></span><br /><span style=\"font-size: 12pt;\"><strong>Ticket message:</strong></span><br /><span style=\"font-size: 12pt;\">{ticket_message}</span><br /><br /><span style=\"font-size: 12pt;\">You can view the ticket on the following link: <a href=\"{ticket_public_url}\">#{ticket_id}</a></span><br /><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (5, 'ticket', 'ticket-autoresponse', 'english', 'New Ticket Opened - Autoresponse', 'New Support Ticket Opened', '<span style=\"font-size: 12pt;\">Hi {contact_firstname} {contact_lastname}</span><br /><br /><span style=\"font-size: 12pt;\">Thank you for contacting our support team. A support ticket has now been opened for your request. You will be notified when a response is made by email.</span><br /><br /><span style=\"font-size: 12pt;\"><strong>Subject:</strong> {ticket_subject}</span><br /><span style=\"font-size: 12pt;\"><strong>Department</strong>: {ticket_department}</span><br /><span style=\"font-size: 12pt;\"><strong>Priority:</strong> {ticket_priority}</span><br /><br /><span style=\"font-size: 12pt;\"><strong>Ticket message:</strong></span><br /><span style=\"font-size: 12pt;\">{ticket_message}</span><br /><br /><span style=\"font-size: 12pt;\">You can view the ticket on the following link: <a href=\"{ticket_public_url}\">#{ticket_id}</a></span><br /><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (6, 'invoice', 'invoice-payment-recorded', 'english', 'Invoice Payment Recorded (Sent to Customer)', 'Invoice Payment Recorded', '<span style=\"font-size: 12pt;\">Hello {contact_firstname}&nbsp;{contact_lastname}<br /><br /></span>Thank you for the payment. Find the payment details below:<br /><br />-------------------------------------------------<br /><br />Amount:&nbsp;<strong>{payment_total}<br /></strong>Date:&nbsp;<strong>{payment_date}</strong><br />Invoice number:&nbsp;<span style=\"font-size: 12pt;\"><strong># {invoice_number}<br /><br /></strong></span>-------------------------------------------------<br /><br />You can always view the invoice for this payment at the following link:&nbsp;<a href=\"{invoice_link}\"><span style=\"font-size: 12pt;\">{invoice_number}</span></a><br /><br />We are looking forward working with you.<br /><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (7, 'invoice', 'invoice-overdue-notice', 'english', 'Invoice Overdue Notice', 'Invoice Overdue Notice - {invoice_number}', '<span style=\"font-size: 12pt;\">Hi {contact_firstname} {contact_lastname}</span><br /><br /><span style=\"font-size: 12pt;\">This is an overdue notice for invoice <strong># {invoice_number}</strong></span><br /><br /><span style=\"font-size: 12pt;\">This invoice was due: {invoice_duedate}</span><br /><br /><span style=\"font-size: 12pt;\">You can view the invoice on the following link: <a href=\"{invoice_link}\">{invoice_number}</a></span><br /><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (8, 'invoice', 'invoice-already-send', 'english', 'Invoice Already Sent to Customer', 'Invoice # {invoice_number} ', '<span style=\"font-size: 12pt;\">Hi {contact_firstname} {contact_lastname}</span><br /><br /><span style=\"font-size: 12pt;\">At your request, here is the invoice with number <strong># {invoice_number}</strong></span><br /><br /><span style=\"font-size: 12pt;\">You can view the invoice on the following link: <a href=\"{invoice_link}\">{invoice_number}</a></span><br /><br /><span style=\"font-size: 12pt;\">Please contact us for more information.</span><br /><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (9, 'ticket', 'new-ticket-created-staff', 'english', 'New Ticket Created (Opened by Customer, Sent to Staff Members)', 'New Ticket Created', '<span style=\"font-size: 12pt;\">A new support ticket has been opened.</span><br /><br /><span style=\"font-size: 12pt;\"><strong>Subject</strong>: {ticket_subject}</span><br /><span style=\"font-size: 12pt;\"><strong>Department</strong>: {ticket_department}</span><br /><span style=\"font-size: 12pt;\"><strong>Priority</strong>: {ticket_priority}<br /></span><br /><span style=\"font-size: 12pt;\"><strong>Ticket message:</strong></span><br /><span style=\"font-size: 12pt;\">{ticket_message}</span><br /><br /><span style=\"font-size: 12pt;\">You can view the ticket on the following link: <a href=\"{ticket_url}\">#{ticket_id}</a></span><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (10, 'estimate', 'estimate-send-to-client', 'english', 'Send Estimate to Customer', 'Estimate # {estimate_number} created', '<span style=\"font-size: 12pt;\">Dear {contact_firstname} {contact_lastname}</span><br /><br /><span style=\"font-size: 12pt;\">Please find the attached estimate <strong># {estimate_number}</strong></span><br /><br /><span style=\"font-size: 12pt;\"><strong>Estimate status:</strong> {estimate_status}</span><br /><br /><span style=\"font-size: 12pt;\">You can view the estimate on the following link: <a href=\"{estimate_link}\">{estimate_number}</a></span><br /><br /><span style=\"font-size: 12pt;\">We look forward to your communication.</span><br /><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}<br /></span>', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (11, 'ticket', 'ticket-reply-to-admin', 'english', 'Ticket Reply (Sent to Staff)', 'New Support Ticket Reply', '<span style=\"font-size: 12pt;\">A new support ticket reply from {contact_firstname} {contact_lastname}</span><br /><br /><span style=\"font-size: 12pt;\"><strong>Subject</strong>: {ticket_subject}</span><br /><span style=\"font-size: 12pt;\"><strong>Department</strong>: {ticket_department}</span><br /><span style=\"font-size: 12pt;\"><strong>Priority</strong>: {ticket_priority}</span><br /><br /><span style=\"font-size: 12pt;\"><strong>Ticket message:</strong></span><br /><span style=\"font-size: 12pt;\">{ticket_message}</span><br /><br /><span style=\"font-size: 12pt;\">You can view the ticket on the following link: <a href=\"{ticket_url}\">#{ticket_id}</a></span><br /><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (12, 'estimate', 'estimate-already-send', 'english', 'Estimate Already Sent to Customer', 'Estimate # {estimate_number} ', '<span style=\"font-size: 12pt;\">Dear {contact_firstname} {contact_lastname}</span><br /> <br /><span style=\"font-size: 12pt;\">Thank you for your estimate request.</span><br /> <br /><span style=\"font-size: 12pt;\">You can view the estimate on the following link: <a href=\"{estimate_link}\">{estimate_number}</a></span><br /> <br /><span style=\"font-size: 12pt;\">Please contact us for more information.</span><br /> <br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (13, 'contract', 'contract-expiration', 'english', 'Contract Expiration Reminder (Sent to Customer Contacts)', 'Contract Expiration Reminder', '<span style=\"font-size: 12pt;\">Dear {client_company}</span><br /><br /><span style=\"font-size: 12pt;\">This is a reminder that the following contract will expire soon:</span><br /><br /><span style=\"font-size: 12pt;\"><strong>Subject:</strong> {contract_subject}</span><br /><span style=\"font-size: 12pt;\"><strong>Description:</strong> {contract_description}</span><br /><span style=\"font-size: 12pt;\"><strong>Date Start:</strong> {contract_datestart}</span><br /><span style=\"font-size: 12pt;\"><strong>Date End:</strong> {contract_dateend}</span><br /><br /><span style=\"font-size: 12pt;\">Please contact us for more information.</span><br /><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (14, 'tasks', 'task-assigned', 'english', 'New Task Assigned (Sent to Staff)', 'New Task Assigned to You - {task_name}', '<span style=\"font-size: 12pt;\">Dear {staff_firstname}</span><br /><br /><span style=\"font-size: 12pt;\">You have been assigned to a new task:</span><br /><br /><span style=\"font-size: 12pt;\"><strong>Name:</strong> {task_name}<br /></span><strong>Start Date:</strong> {task_startdate}<br /><span style=\"font-size: 12pt;\"><strong>Due date:</strong> {task_duedate}</span><br /><span style=\"font-size: 12pt;\"><strong>Priority:</strong> {task_priority}<br /><br /></span><span style=\"font-size: 12pt;\"><span>You can view the task on the following link</span>: <a href=\"{task_link}\">{task_name}</a></span><br /><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (15, 'tasks', 'task-added-as-follower', 'english', 'Staff Member Added as Follower on Task (Sent to Staff)', 'You are added as follower on task - {task_name}', '<span style=\"font-size: 12pt;\">Hi {staff_firstname}<br /></span><br /><span style=\"font-size: 12pt;\">You have been added as follower on the following task:</span><br /><br /><span style=\"font-size: 12pt;\"><strong>Name:</strong> {task_name}</span><br /><span style=\"font-size: 12pt;\"><strong>Start date:</strong> {task_startdate}</span><br /><br /><span>You can view the task on the following link</span><span>: </span><a href=\"{task_link}\">{task_name}</a><br /><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (16, 'tasks', 'task-commented', 'english', 'New Comment on Task (Sent to Staff)', 'New Comment on Task - {task_name}', 'Dear {staff_firstname}<br /><br />A comment has been made on the following task:<br /><br /><strong>Name:</strong> {task_name}<br /><strong>Comment:</strong> {task_comment}<br /><br />You can view the task on the following link: <a href=\"{task_link}\">{task_name}</a><br /><br />Kind Regards,<br />{email_signature}', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (17, 'tasks', 'task-added-attachment', 'english', 'New Attachment(s) on Task (Sent to Staff)', 'New Attachment on Task - {task_name}', 'Hi {staff_firstname}<br /><br /><strong>{task_user_take_action}</strong> added an attachment on the following task:<br /><br /><strong>Name:</strong> {task_name}<br /><br />You can view the task on the following link: <a href=\"{task_link}\">{task_name}</a><br /><br />Kind Regards,<br />{email_signature}', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (18, 'estimate', 'estimate-declined-to-staff', 'english', 'Estimate Declined (Sent to Staff)', 'Customer Declined Estimate', '<span style=\"font-size: 12pt;\">Hi</span><br /> <br /><span style=\"font-size: 12pt;\">Customer ({client_company}) declined estimate with number <strong># {estimate_number}</strong></span><br /> <br /><span style=\"font-size: 12pt;\">You can view the estimate on the following link: <a href=\"{estimate_link}\">{estimate_number}</a></span><br /> <br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (19, 'estimate', 'estimate-accepted-to-staff', 'english', 'Estimate Accepted (Sent to Staff)', 'Customer Accepted Estimate', '<span style=\"font-size: 12pt;\">Hi</span><br /> <br /><span style=\"font-size: 12pt;\">Customer ({client_company}) accepted estimate with number <strong># {estimate_number}</strong></span><br /> <br /><span style=\"font-size: 12pt;\">You can view the estimate on the following link: <a href=\"{estimate_link}\">{estimate_number}</a></span><br /> <br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (20, 'proposals', 'proposal-client-accepted', 'english', 'Customer Action - Accepted (Sent to Staff)', 'Customer Accepted Proposal', '<div>Hi<br /> <br />Client <strong>{proposal_proposal_to}</strong> accepted the following proposal:<br /> <br /><strong>Number:</strong> {proposal_number}<br /><strong>Subject</strong>: {proposal_subject}<br /><strong>Total</strong>: {proposal_total}<br /> <br />View the proposal on the following link: <a href=\"{proposal_link}\">{proposal_number}</a><br /> <br />Kind Regards,<br />{email_signature}</div>\r\n<div>&nbsp;</div>\r\n<div>&nbsp;</div>\r\n<div>&nbsp;</div>', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (21, 'proposals', 'proposal-send-to-customer', 'english', 'Send Proposal to Customer', 'Proposal With Number {proposal_number} Created', 'Dear {proposal_proposal_to}<br /><br />Please find our attached proposal.<br /><br />This proposal is valid until: {proposal_open_till}<br />You can view the proposal on the following link: <a href=\"{proposal_link}\">{proposal_number}</a><br /><br />Please don\'t hesitate to comment online if you have any questions.<br /><br />We look forward to your communication.<br /><br />Kind Regards,<br />{email_signature}', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (22, 'proposals', 'proposal-client-declined', 'english', 'Customer Action - Declined (Sent to Staff)', 'Client Declined Proposal', 'Hi<br /> <br />Customer <strong>{proposal_proposal_to}</strong> declined the proposal <strong>{proposal_subject}</strong><br /> <br />View the proposal on the following link <a href=\"{proposal_link}\">{proposal_number}</a>&nbsp;or from the admin area.<br /> <br />Kind Regards,<br />{email_signature}', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (23, 'proposals', 'proposal-client-thank-you', 'english', 'Thank You Email (Sent to Customer After Accept)', 'Thank for you accepting proposal', 'Dear {proposal_proposal_to}<br /> <br />Thank for for accepting the proposal.<br /> <br />We look forward to doing business with you.<br /> <br />We will contact you as soon as possible<br /> <br />Kind Regards,<br />{email_signature}', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (24, 'proposals', 'proposal-comment-to-client', 'english', 'New Comment Â (Sent to Customer/Lead)', 'New Proposal Comment', 'Dear {proposal_proposal_to}<br /> <br />A new comment has been made on the following proposal: <strong>{proposal_number}</strong><br /> <br />You can view and reply to the comment on the following link: <a href=\"{proposal_link}\">{proposal_number}</a><br /> <br />Kind Regards,<br />{email_signature}', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (25, 'proposals', 'proposal-comment-to-admin', 'english', 'New Comment (Sent to Staff) ', 'New Proposal Comment', 'Hi<br /> <br />A new comment has been made to the proposal <strong>{proposal_subject}</strong><br /> <br />You can view and reply to the comment on the following link: <a href=\"{proposal_link}\">{proposal_number}</a>&nbsp;or from the admin area.<br /> <br />{email_signature}', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (26, 'estimate', 'estimate-thank-you-to-customer', 'english', 'Thank You Email (Sent to Customer After Accept)', 'Thank for you accepting estimate', '<span style=\"font-size: 12pt;\">Dear {contact_firstname} {contact_lastname}</span><br /> <br /><span style=\"font-size: 12pt;\">Thank for for accepting the estimate.</span><br /> <br /><span style=\"font-size: 12pt;\">We look forward to doing business with you.</span><br /> <br /><span style=\"font-size: 12pt;\">We will contact you as soon as possible.</span><br /> <br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (27, 'tasks', 'task-deadline-notification', 'english', 'Task Deadline Reminder - Sent to Assigned Members', 'Task Deadline Reminder', 'Hi {staff_firstname}&nbsp;{staff_lastname}<br /><br />This is an automated email from {companyname}.<br /><br />The task <strong>{task_name}</strong> deadline is on <strong>{task_duedate}</strong>. <br />This task is still not finished.<br /><br />You can view the task on the following link: <a href=\"{task_link}\">{task_name}</a><br /><br />Kind Regards,<br />{email_signature}', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (28, 'contract', 'send-contract', 'english', 'Send Contract to Customer', 'Contract - {contract_subject}', '<p><span style=\"font-size: 12pt;\">Hi&nbsp;{contact_firstname}&nbsp;{contact_lastname}</span><br /><br /><span style=\"font-size: 12pt;\">Please find the <a href=\"{contract_link}\">{contract_subject}</a> attached.<br /><br />Description: {contract_description}<br /><br /></span><span style=\"font-size: 12pt;\">Looking forward to hear from you.</span><br /><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span></p>', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (29, 'invoice', 'invoice-payment-recorded-to-staff', 'english', 'Invoice Payment Recorded (Sent to Staff)', 'New Invoice Payment', '<span style=\"font-size: 12pt;\">Hi</span><br /><br /><span style=\"font-size: 12pt;\">Customer recorded payment for invoice <strong># {invoice_number}</strong></span><br /> <br /><span style=\"font-size: 12pt;\">You can view the invoice on the following link: <a href=\"{invoice_link}\">{invoice_number}</a></span><br /> <br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (30, 'ticket', 'auto-close-ticket', 'english', 'Auto Close Ticket', 'Ticket Auto Closed', '<p><span style=\"font-size: 12pt;\">Hi {contact_firstname} {contact_lastname}</span><br /><br /><span style=\"font-size: 12pt;\">Ticket {ticket_subject} has been auto close due to inactivity.</span><br /><br /><span style=\"font-size: 12pt;\"><strong>Ticket #</strong>: <a href=\"{ticket_public_url}\">{ticket_id}</a></span><br /><span style=\"font-size: 12pt;\"><strong>Department</strong>: {ticket_department}</span><br /><span style=\"font-size: 12pt;\"><strong>Priority:</strong> {ticket_priority}</span><br /><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span></p>', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (31, 'project', 'new-project-discussion-created-to-staff', 'english', 'New Project Discussion (Sent to Project Members)', 'New Project Discussion Created - {project_name}', '<p>Hi {staff_firstname}<br /><br />New project discussion created from <strong>{discussion_creator}</strong><br /><br /><strong>Subject:</strong> {discussion_subject}<br /><strong>Description:</strong> {discussion_description}<br /><br />You can view the discussion on the following link: <a href=\"{discussion_link}\">{discussion_subject}</a><br /><br />Kind Regards,<br />{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (32, 'project', 'new-project-discussion-created-to-customer', 'english', 'New Project Discussion (Sent to Customer Contacts)', 'New Project Discussion Created - {project_name}', '<p>Hello {contact_firstname} {contact_lastname}<br /><br />New project discussion created from <strong>{discussion_creator}</strong><br /><br /><strong>Subject:</strong> {discussion_subject}<br /><strong>Description:</strong> {discussion_description}<br /><br />You can view the discussion on the following link: <a href=\"{discussion_link}\">{discussion_subject}</a><br /><br />Kind Regards,<br />{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (33, 'project', 'new-project-file-uploaded-to-customer', 'english', 'New Project File(s) Uploaded (Sent to Customer Contacts)', 'New Project File(s) Uploaded - {project_name}', '<p>Hello {contact_firstname} {contact_lastname}<br /><br />New project file is uploaded on <strong>{project_name}</strong> from <strong>{file_creator}</strong><br /><br />You can view the project on the following link: <a href=\"{project_link}\">{project_name}</a><br /><br />To view the file in our CRM you can click on the following link: <a href=\"{discussion_link}\">{discussion_subject}</a><br /><br />Kind Regards,<br />{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (34, 'project', 'new-project-file-uploaded-to-staff', 'english', 'New Project File(s) Uploaded (Sent to Project Members)', 'New Project File(s) Uploaded - {project_name}', '<p>Hello&nbsp;{staff_firstname}</p>\r\n<p>New project&nbsp;file is uploaded on&nbsp;<strong>{project_name}</strong> from&nbsp;<strong>{file_creator}</strong></p>\r\n<p>You can view the project on the following link: <a href=\"{project_link}\">{project_name}<br /></a><br />To view&nbsp;the file you can click on the following link: <a href=\"{discussion_link}\">{discussion_subject}</a></p>\r\n<p>Kind Regards,<br />{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (35, 'project', 'new-project-discussion-comment-to-customer', 'english', 'New Discussion Comment  (Sent to Customer Contacts)', 'New Discussion Comment', '<p><span style=\"font-size: 12pt;\">Hello {contact_firstname} {contact_lastname}</span><br /><br /><span style=\"font-size: 12pt;\">New discussion comment has been made on <strong>{discussion_subject}</strong> from <strong>{comment_creator}</strong></span><br /><br /><span style=\"font-size: 12pt;\"><strong>Discussion subject:</strong> {discussion_subject}</span><br /><span style=\"font-size: 12pt;\"><strong>Comment</strong>: {discussion_comment}</span><br /><br /><span style=\"font-size: 12pt;\">You can view the discussion on the following link: <a href=\"{discussion_link}\">{discussion_subject}</a></span><br /><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span></p>', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (36, 'project', 'new-project-discussion-comment-to-staff', 'english', 'New Discussion Comment (Sent to Project Members)', 'New Discussion Comment', '<p>Hi {staff_firstname}<br /><br />New discussion comment has been made on <strong>{discussion_subject}</strong> from <strong>{comment_creator}</strong><br /><br /><strong>Discussion subject:</strong> {discussion_subject}<br /><strong>Comment:</strong> {discussion_comment}<br /><br />You can view the discussion on the following link: <a href=\"{discussion_link}\">{discussion_subject}</a><br /><br />Kind Regards,<br />{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (37, 'project', 'staff-added-as-project-member', 'english', 'Staff Added as Project Member', 'New project assigned to you', '<p>Hi {staff_firstname}<br /><br />New project has been assigned to you.<br /><br />You can view the project on the following link <a href=\"{project_link}\">{project_name}</a><br /><br />{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (38, 'estimate', 'estimate-expiry-reminder', 'english', 'Estimate Expiration Reminder', 'Estimate Expiration Reminder', '<p><span style=\"font-size: 12pt;\">Hello {contact_firstname} {contact_lastname}</span><br /><br /><span style=\"font-size: 12pt;\">The estimate with <strong># {estimate_number}</strong> will expire on <strong>{estimate_expirydate}</strong></span><br /><br /><span style=\"font-size: 12pt;\">You can view the estimate on the following link: <a href=\"{estimate_link}\">{estimate_number}</a></span><br /><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span></p>', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (39, 'proposals', 'proposal-expiry-reminder', 'english', 'Proposal Expiration Reminder', 'Proposal Expiration Reminder', '<p>Hello {proposal_proposal_to}<br /><br />The proposal {proposal_number}&nbsp;will expire on <strong>{proposal_open_till}</strong><br /><br />You can view the proposal on the following link: <a href=\"{proposal_link}\">{proposal_number}</a><br /><br />Kind Regards,<br />{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (40, 'staff', 'new-staff-created', 'english', 'New Staff Created (Welcome Email)', 'You are added as staff member', 'Hi {staff_firstname}<br /><br />You are added as member on our CRM.<br /><br />Please use the following logic credentials:<br /><br /><strong>Email:</strong> {staff_email}<br /><strong>Password:</strong> {password}<br /><br />Click <a href=\"{admin_url}\">here </a>to login in the dashboard.<br /><br />Best Regards,<br />{email_signature}', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (41, 'client', 'contact-forgot-password', 'english', 'Forgot Password', 'Create New Password', '<h2>Create a new password</h2>\r\nForgot your password?<br /> To create a new password, just follow this link:<br /> <br /><a href=\"{reset_password_url}\">Reset Password</a><br /> <br /> You received this email, because it was requested by a {companyname}&nbsp;user. This is part of the procedure to create a new password on the system. If you DID NOT request a new password then please ignore this email and your password will remain the same. <br /><br /> {email_signature}', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (42, 'client', 'contact-password-reseted', 'english', 'Password Reset - Confirmation', 'Your password has been changed', '<strong><span style=\"font-size: 14pt;\">You have changed your password.</span><br /></strong><br /> Please, keep it in your records so you don\'t forget it.<br /> <br /> Your email address for login is: {contact_email}<br /><br />If this wasnt you, please contact us.<br /><br />{email_signature}', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (43, 'client', 'contact-set-password', 'english', 'Set New Password', 'Set new password on {companyname} ', '<h2><span style=\"font-size: 14pt;\">Setup your new password on {companyname}</span></h2>\r\nPlease use the following link to set up your new password:<br /><br /><a href=\"{set_password_url}\">Set new password</a><br /><br />Keep it in your records so you don\'t forget it.<br /><br />Please set your new password in <strong>48 hours</strong>. After that, you won\'t be able to set your password because this link will expire.<br /><br />You can login at: <a href=\"{crm_url}\">{crm_url}</a><br />Your email address for login: {contact_email}<br /><br />{email_signature}', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (44, 'staff', 'staff-forgot-password', 'english', 'Forgot Password', 'Create New Password', '<h2><span style=\"font-size: 14pt;\">Create a new password</span></h2>\r\nForgot your password?<br /> To create a new password, just follow this link:<br /> <br /><a href=\"{reset_password_url}\">Reset Password</a><br /> <br /> You received this email, because it was requested by a <strong>{companyname}</strong>&nbsp;user. This is part of the procedure to create a new password on the system. If you DID NOT request a new password then please ignore this email and your password will remain the same. <br /><br /> {email_signature}', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (45, 'staff', 'staff-password-reseted', 'english', 'Password Reset - Confirmation', 'Your password has been changed', '<span style=\"font-size: 14pt;\"><strong>You have changed your password.<br /></strong></span><br /> Please, keep it in your records so you don\'t forget it.<br /> <br /> Your email address for login is: {staff_email}<br /><br /> If this wasnt you, please contact us.<br /><br />{email_signature}', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (46, 'project', 'assigned-to-project', 'english', 'New Project Created (Sent to Customer Contacts)', 'New Project Created', '<p>Hello&nbsp;{contact_firstname}&nbsp;{contact_lastname}</p>\r\n<p>New project is assigned to your company.<br /><br /><strong>Project Name:</strong>&nbsp;{project_name}<br /><strong>Project Start Date:</strong>&nbsp;{project_start_date}</p>\r\n<p>You can view the project on the following link:&nbsp;<a href=\"{project_link}\">{project_name}</a></p>\r\n<p>We are looking forward hearing from you.<br /><br />Kind Regards,<br />{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (47, 'tasks', 'task-added-attachment-to-contacts', 'english', 'New Attachment(s) on Task (Sent to Customer Contacts)', 'New Attachment on Task - {task_name}', '<span>Hi {contact_firstname} {contact_lastname}</span><br /><br /><strong>{task_user_take_action}</strong><span> added an attachment on the following task:</span><br /><br /><strong>Name:</strong><span> {task_name}</span><br /><br /><span>You can view the task on the following link: </span><a href=\"{task_link}\">{task_name}</a><br /><br /><span>Kind Regards,</span><br /><span>{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (48, 'tasks', 'task-commented-to-contacts', 'english', 'New Comment on Task (Sent to Customer Contacts)', 'New Comment on Task - {task_name}', '<span>Dear {contact_firstname} {contact_lastname}</span><br /><br /><span>A comment has been made on the following task:</span><br /><br /><strong>Name:</strong><span> {task_name}</span><br /><strong>Comment:</strong><span> {task_comment}</span><br /><br /><span>You can view the task on the following link: </span><a href=\"{task_link}\">{task_name}</a><br /><br /><span>Kind Regards,</span><br /><span>{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (49, 'leads', 'new-lead-assigned', 'english', 'New Lead Assigned to Staff Member', 'New lead assigned to you', '<p>Hello {lead_assigned}<br /><br />New lead is assigned to you.<br /><br /><strong>Lead Name:</strong>&nbsp;{lead_name}<br /><strong>Lead Email:</strong>&nbsp;{lead_email}<br /><br />You can view the lead on the following link: <a href=\"{lead_link}\">{lead_name}</a><br /><br />Kind Regards,<br />{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (50, 'client', 'client-statement', 'english', 'Statement - Account Summary', 'Account Statement from {statement_from} to {statement_to}', 'Dear {contact_firstname} {contact_lastname}, <br /><br />Its been a great experience working with you.<br /><br />Attached with this email is a list of all transactions for the period between {statement_from} to {statement_to}<br /><br />For your information your account balance due is total:&nbsp;{statement_balance_due}<br /><br />Please contact us if you need more information.<br /> <br />Kind Regards,<br />{email_signature}', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (51, 'ticket', 'ticket-assigned-to-admin', 'english', 'New Ticket Assigned (Sent to Staff)', 'New support ticket has been assigned to you', '<p><span style=\"font-size: 12pt;\">Hi</span></p>\r\n<p><span style=\"font-size: 12pt;\">A new support ticket&nbsp;has been assigned to you.</span><br /><br /><span style=\"font-size: 12pt;\"><strong>Subject</strong>: {ticket_subject}</span><br /><span style=\"font-size: 12pt;\"><strong>Department</strong>: {ticket_department}</span><br /><span style=\"font-size: 12pt;\"><strong>Priority</strong>: {ticket_priority}</span><br /><br /><span style=\"font-size: 12pt;\"><strong>Ticket message:</strong></span><br /><span style=\"font-size: 12pt;\">{ticket_message}</span><br /><br /><span style=\"font-size: 12pt;\">You can view the ticket on the following link: <a href=\"{ticket_url}\">#{ticket_id}</a></span><br /><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span></p>', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (52, 'client', 'new-client-registered-to-admin', 'english', 'New Customer Registration (Sent to admins)', 'New Customer Registration', 'Hello.<br /><br />New customer registration on your customer portal:<br /><br /><strong>Firstname:</strong>&nbsp;{contact_firstname}<br /><strong>Lastname:</strong>&nbsp;{contact_lastname}<br /><strong>Company:</strong>&nbsp;{client_company}<br /><strong>Email:</strong>&nbsp;{contact_email}<br /><br />Best Regards', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (53, 'leads', 'new-web-to-lead-form-submitted', 'english', 'Web to lead form submitted - Sent to lead', '{lead_name} - We Received Your Request', 'Hello {lead_name}.<br /><br /><strong>Your request has been received.</strong><br /><br />This email is to let you know that we received your request and we will get back to you as soon as possible with more information.<br /><br />Best Regards,<br />{email_signature}', '{companyname} | CRM', '', 0, 0, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (54, 'staff', 'two-factor-authentication', 'english', 'Two Factor Authentication', 'Confirm Your Login', '<p>Hi {staff_firstname}</p>\r\n<p style=\"text-align: left;\">You received this email because you have enabled two factor authentication in your account.<br />Use the following code to confirm your login:</p>\r\n<p style=\"text-align: left;\"><span style=\"font-size: 18pt;\"><strong>{two_factor_auth_code}<br /><br /></strong><span style=\"font-size: 12pt;\">{email_signature}</span><strong><br /><br /><br /><br /></strong></span></p>', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (55, 'project', 'project-finished-to-customer', 'english', 'Project Marked as Finished (Sent to Customer Contacts)', 'Project Marked as Finished', '<p>Hello&nbsp;{contact_firstname}&nbsp;{contact_lastname}</p>\r\n<p>You are receiving this email because project&nbsp;<strong>{project_name}</strong> has been marked as finished. This project is assigned under your company and we just wanted to keep you up to date.<br /><br />You can view the project on the following link:&nbsp;<a href=\"{project_link}\">{project_name}</a></p>\r\n<p>If you have any questions don\'t hesitate to contact us.<br /><br />Kind Regards,<br />{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (56, 'credit_note', 'credit-note-send-to-client', 'english', 'Send Credit Note To Email', 'Credit Note With Number #{credit_note_number} Created', 'Dear&nbsp;{contact_firstname}&nbsp;{contact_lastname}<br /><br />We have attached the credit note with number <strong>#{credit_note_number} </strong>for your reference.<br /><br /><strong>Date:</strong>&nbsp;{credit_note_date}<br /><strong>Total Amount:</strong>&nbsp;{credit_note_total}<br /><br /><span style=\"font-size: 12pt;\">Please contact us for more information.</span><br /> <br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (57, 'tasks', 'task-status-change-to-staff', 'english', 'Task Status Changed (Sent to Staff)', 'Task Status Changed', '<span style=\"font-size: 12pt;\">Hi {staff_firstname}</span><br /><br /><span style=\"font-size: 12pt;\"><strong>{task_user_take_action}</strong> marked task as <strong>{task_status}</strong></span><br /><br /><span style=\"font-size: 12pt;\"><strong>Name:</strong> {task_name}</span><br /><span style=\"font-size: 12pt;\"><strong>Due date:</strong> {task_duedate}</span><br /><br /><span style=\"font-size: 12pt;\">You can view the task on the following link: <a href=\"{task_link}\">{task_name}</a></span><br /><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (58, 'tasks', 'task-status-change-to-contacts', 'english', 'Task Status Changed (Sent to Customer Contacts)', 'Task Status Changed', '<span style=\"font-size: 12pt;\">Hi {contact_firstname} {contact_lastname}</span><br /><br /><span style=\"font-size: 12pt;\"><strong>{task_user_take_action}</strong> marked task as <strong>{task_status}</strong></span><br /><br /><span style=\"font-size: 12pt;\"><strong>Name:</strong> {task_name}</span><br /><span style=\"font-size: 12pt;\"><strong>Due date:</strong> {task_duedate}</span><br /><br /><span style=\"font-size: 12pt;\">You can view the task on the following link: <a href=\"{task_link}\">{task_name}</a></span><br /><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (59, 'staff', 'reminder-email-staff', 'english', 'Staff Reminder Email', 'You Have a New Reminder!', '<p>Hello&nbsp;{staff_firstname}<br /><br /><strong>You have a new reminder&nbsp;linked to&nbsp;{staff_reminder_relation_name}!<br /><br />Reminder description:</strong><br />{staff_reminder_description}<br /><br />Click <a href=\"{staff_reminder_relation_link}\">here</a> to view&nbsp;<a href=\"{staff_reminder_relation_link}\">{staff_reminder_relation_name}</a><br /><br />Best Regards<br /><br /></p>', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (60, 'contract', 'contract-comment-to-client', 'english', 'New Comment Â (Sent to Customer Contacts)', 'New Contract Comment', 'Dear {contact_firstname} {contact_lastname}<br /> <br />A new comment has been made on the following contract: <strong>{contract_subject}</strong><br /> <br />You can view and reply to the comment on the following link: <a href=\"{contract_link}\">{contract_subject}</a><br /> <br />Kind Regards,<br />{email_signature}', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (61, 'contract', 'contract-comment-to-admin', 'english', 'New Comment (Sent to Staff) ', 'New Contract Comment', 'Hi {staff_firstname}<br /><br />A new comment has been made to the contract&nbsp;<strong>{contract_subject}</strong><br /><br />You can view and reply to the comment on the following link: <a href=\"{contract_link}\">{contract_subject}</a>&nbsp;or from the admin area.<br /><br />{email_signature}', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (62, 'subscriptions', 'send-subscription', 'english', 'Send Subscription to Customer', 'Subscription Created', 'Hello&nbsp;{contact_firstname}&nbsp;{contact_lastname}<br /><br />We have prepared the subscription&nbsp;<strong>{subscription_name}</strong> for your company.<br /><br />Click <a href=\"{subscription_link}\">here</a> to review the subscription and subscribe.<br /><br />Best Regards,<br />{email_signature}', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (63, 'subscriptions', 'subscription-payment-failed', 'english', 'Subscription Payment Failed', 'Your most recent invoice payment failed', 'Hello&nbsp;{contact_firstname}&nbsp;{contact_lastname}<br /><br br=\"\" />Unfortunately, your most recent invoice payment for&nbsp;<strong>{subscription_name}</strong> was declined.<br /><br />This could be due to a change in your card number, your card expiring,<br />cancellation of your credit card, or the card issuer not recognizing the<br />payment and therefore taking action to prevent it.<br /><br />Please update your payment information as soon as possible by logging in here:<br /><a href=\"{crm_url}/login\">{crm_url}/login</a><br /><br />Best Regards,<br />{email_signature}', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (64, 'subscriptions', 'subscription-canceled', 'english', 'Subscription Canceled (Sent to customer primary contact)', 'Your subscription has been canceled', 'Hello&nbsp;{contact_firstname}&nbsp;{contact_lastname}<br /><br />Your subscription&nbsp;<strong>{subscription_name} </strong>has been canceled, if you have any questions don\'t hesitate to contact us.<br /><br />It was a pleasure doing business with you.<br /><br />Best Regards,<br />{email_signature}', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (65, 'subscriptions', 'subscription-payment-succeeded', 'english', 'Subscription Payment Succeeded (Sent to customer primary contact)', 'Subscription  Payment Receipt - {subscription_name}', 'Hello&nbsp;{contact_firstname}&nbsp;{contact_lastname}<br /><br />This email is to let you know that we received your payment for subscription&nbsp;<strong>{subscription_name}&nbsp;</strong>of&nbsp;<strong><span>{payment_total}<br /><br /></span></strong>The invoice associated with it is now with status&nbsp;<strong>{invoice_status}<br /></strong><br />Thank you for your confidence.<br /><br />Best Regards,<br />{email_signature}', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (66, 'contract', 'contract-expiration-to-staff', 'english', 'Contract Expiration Reminder (Sent to Staff)', 'Contract Expiration Reminder', 'Hi {staff_firstname}<br /><br /><span style=\"font-size: 12pt;\">This is a reminder that the following contract will expire soon:</span><br /><br /><span style=\"font-size: 12pt;\"><strong>Subject:</strong> {contract_subject}</span><br /><span style=\"font-size: 12pt;\"><strong>Description:</strong> {contract_description}</span><br /><span style=\"font-size: 12pt;\"><strong>Date Start:</strong> {contract_datestart}</span><br /><span style=\"font-size: 12pt;\"><strong>Date End:</strong> {contract_dateend}</span><br /><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (67, 'gdpr', 'gdpr-removal-request', 'english', 'Removal Request From Contact (Sent to administrators)', 'Data Removal Request Received', 'Hello&nbsp;{staff_firstname}&nbsp;{staff_lastname}<br /><br />Data removal has been requested by&nbsp;{contact_firstname} {contact_lastname}<br /><br />You can review this request and take proper actions directly from the admin area.', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (68, 'gdpr', 'gdpr-removal-request-lead', 'english', 'Removal Request From Lead (Sent to administrators)', 'Data Removal Request Received', 'Hello&nbsp;{staff_firstname}&nbsp;{staff_lastname}<br /><br />Data removal has been requested by {lead_name}<br /><br />You can review this request and take proper actions directly from the admin area.<br /><br />To view the lead inside the admin area click here:&nbsp;<a href=\"{lead_link}\">{lead_link}</a>', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (69, 'client', 'client-registration-confirmed', 'english', 'Customer Registration Confirmed', 'Your registration is confirmed', '<p>Dear {contact_firstname} {contact_lastname}<br /><br />We just wanted to let you know that your registration at&nbsp;{companyname} is successfully confirmed and your account is now active.<br /><br />You can login at&nbsp;<a href=\"{crm_url}\">{crm_url}</a> with the email and password you provided during registration.<br /><br />Please contact us if you need any help.<br /><br />Kind Regards, <br />{email_signature}</p>\r\n<p><br />(This is an automated email, so please don\'t reply to this email address)</p>', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (70, 'contract', 'contract-signed-to-staff', 'english', 'Contract Signed (Sent to Staff)', 'Customer Signed a Contract', 'Hi {staff_firstname}<br /><br />A contract with subject&nbsp;<strong>{contract_subject} </strong>has been successfully signed by the customer.<br /><br />You can view the contract at the following link: <a href=\"{contract_link}\">{contract_subject}</a>&nbsp;or from the admin area.<br /><br />{email_signature}', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (71, 'subscriptions', 'customer-subscribed-to-staff', 'english', 'Customer Subscribed to a Subscription (Sent to administrators and subscription creator)', 'Customer Subscribed to a Subscription', 'The customer <strong>{client_company}</strong> subscribed to a subscription with name&nbsp;<strong>{subscription_name}</strong><br /><br /><strong>ID</strong>:&nbsp;{subscription_id}<br /><strong>Subscription name</strong>:&nbsp;{subscription_name}<br /><strong>Subscription description</strong>:&nbsp;{subscription_description}<br /><br />You can view the subscription by clicking <a href=\"{subscription_link}\">here</a><br />\r\n<div style=\"text-align: center;\"><span style=\"font-size: 10pt;\">&nbsp;</span></div>\r\nBest Regards,<br />{email_signature}<br /><br /><span style=\"font-size: 10pt;\"><span style=\"color: #999999;\">You are receiving this email because you are either administrator or you are creator of the subscription.</span></span>', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (72, 'client', 'contact-verification-email', 'english', 'Email Verification (Sent to Contact After Registration)', 'Verify Email Address', '<p>Hello&nbsp;{contact_firstname}<br /><br />Please click the button below to verify your email address.<br /><br /><a href=\"{email_verification_url}\">Verify Email Address</a><br /><br />If you did not create an account, no further action is required</p>\r\n<p><br />{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (73, 'client', 'new-customer-profile-file-uploaded-to-staff', 'english', 'New Customer Profile File(s) Uploaded (Sent to Staff)', 'Customer Uploaded New File(s) in Profile', 'Hi!<br /><br />New file(s) is uploaded into the customer ({client_company}) profile by&nbsp;{contact_firstname}<br /><br />You can check the uploaded files into the admin area by clicking <a href=\"{customer_profile_files_admin_link}\">here</a> or at the following link:&nbsp;{customer_profile_files_admin_link}<br /><br />{email_signature}', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (74, 'staff', 'event-notification-to-staff', 'english', 'Event Notification (Calendar)', 'Upcoming Event - {event_title}', 'Hi {staff_firstname}! <br /><br />This is a reminder for event <a href=\\\"{event_link}\\\">{event_title}</a> scheduled at {event_start_date}. <br /><br />Regards.', '', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (75, 'subscriptions', 'subscription-payment-requires-action', 'english', 'Credit Card Authorization Required - SCA', 'Important: Confirm your subscription {subscription_name} payment', '<p>Hello {contact_firstname}</p>\r\n<p><strong>Your bank sometimes requires an additional step to make sure an online transaction was authorized.</strong><br /><br />Because of European regulation to protect consumers, many online payments now require two-factor authentication. Your bank ultimately decides when authentication is required to confirm a payment, but you may notice this step when you start paying for a service or when the cost changes.<br /><br />In order to pay the subscription <strong>{subscription_name}</strong>, you will need to&nbsp;confirm your payment by clicking on the follow link: <strong><a href=\"{subscription_authorize_payment_link}\">{subscription_authorize_payment_link}</a></strong><br /><br />To view the subscription, please click at the following link: <a href=\"{subscription_link}\"><span>{subscription_link}</span></a><br />or you can login in our dedicated area here: <a href=\"{crm_url}/login\">{crm_url}/login</a> in case you want to update your credit card or view the subscriptions you are subscribed.<br /><br />Best Regards,<br />{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (76, 'invoice', 'invoice-due-notice', 'english', 'Invoice Due Notice', 'Your {invoice_number} will be due soon', '<span style=\"font-size: 12pt;\">Hi {contact_firstname} {contact_lastname}<br /><br /></span>You invoice <span style=\"font-size: 12pt;\"><strong># {invoice_number} </strong>will be due on <strong>{invoice_duedate}</strong></span><br /><br /><span style=\"font-size: 12pt;\">You can view the invoice on the following link: <a href=\"{invoice_link}\">{invoice_number}</a></span><br /><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} | CRM', NULL, 0, 0, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (77, 'estimate_request', 'estimate-request-submitted-to-staff', 'english', 'Estimate Request Submitted (Sent to Staff)', 'New Estimate Request Submitted', '<span> Hello,&nbsp;</span><br /><br />{estimate_request_email} submitted an estimate request via the {estimate_request_form_name} form.<br /><br />You can view the request at the following link: <a href=\"{estimate_request_link}\">{estimate_request_link}</a><br /><br />==<br /><br />{estimate_request_submitted_data}<br /><br />Kind Regards,<br /><span>{email_signature}</span>', '{companyname} | CRM', NULL, 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (78, 'estimate_request', 'estimate-request-assigned', 'english', 'Estimate Request Assigned (Sent to Staff)', 'New Estimate Request Assigned', '<span> Hello {estimate_request_assigned},&nbsp;</span><br /><br />Estimate request #{estimate_request_id} has been assigned to you.<br /><br />You can view the request at the following link: <a href=\"{estimate_request_link}\">{estimate_request_link}</a><br /><br />Kind Regards,<br /><span>{email_signature}</span>', '{companyname} | CRM', NULL, 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (79, 'estimate_request', 'estimate-request-received-to-user', 'english', 'Estimate Request Received (Sent to User)', 'Estimate Request Received', 'Hello,<br /><br /><strong>Your request has been received.</strong><br /><br />This email is to let you know that we received your request and we will get back to you as soon as possible with more information.<br /><br />Best Regards,<br />{email_signature}', '{companyname} | CRM', NULL, 0, 0, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (80, 'inventory_warning', 'inventory-warning-to-staff', 'english', 'Inventory warning (Sent to staff)', 'Inventory warning', 'Hi {staff_name}! <br /><br />This is a inventory warning<br />{<span 12pt=\"\">notification_content</span>}. <br /><br />Regards.', '{companyname} | CRM', NULL, 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (81, 'notifications', 'non-billed-tasks-reminder', 'english', 'Non-billed tasks reminder (sent to selected staff members)', 'Action required: Completed tasks are not billed', 'Hello {staff_firstname}<br><br>The following tasks are marked as complete but not yet billed:<br><br>{unbilled_tasks_list}<br><br>Kind Regards,<br><br>{email_signature}', '{companyname} | CRM', NULL, 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (82, 'invoice', 'invoices-batch-payments', 'english', 'Invoices Payments Recorded in Batch (Sent to Customer)', 'We have received your payments', 'Hello {contact_firstname} {contact_lastname}<br><br>Thank you for the payments. Please find the payments details below:<br><br>{batch_payments_list}<br><br>We are looking forward working with you.<br><br>Kind Regards,<br><br>{email_signature}', '{companyname} | CRM', NULL, 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (83, 'contract', 'contract-sign-reminder', 'english', 'Contract Sign Reminder (Sent to Customer)', 'Contract Sign Reminder', '<p>Hello {contact_firstname} {contact_lastname}<br /><br />This is a reminder to review and sign the contract:<a href=\"{contract_link}\">{contract_subject}</a></p><p>You can view and sign by visiting: <a href=\"{contract_link}\">{contract_subject}</a></p><p><br />We are looking forward working with you.<br /><br />Kind Regards,<br /><br />{email_signature}</p>', '{companyname} | CRM', NULL, 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (84, 'timesheets_attendance_mgt', 'attendance_notice', 'english', 'Attendance notice', 'Timesheets - Attendance notice', '{staff_name} {type_check} at {date_time}', '{companyname} | CRM', NULL, 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (85, 'timesheets_attendance_mgt', 'send_request_approval', 'english', 'Send request approval', 'Timesheets - Send request approval to approver', 'Hi {approver}! <br>-{staff_name} has created an apply for leave and requires your approval. Please go to this link for details and approval: {link}', '{companyname} | CRM', NULL, 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (86, 'timesheets_attendance_mgt', 'remind_user_check_in', 'english', 'Remind user check in', 'Timesheets - Remind user check in', 'Remind you to check in today to record the start time of the shift {date_time}', '{companyname} | CRM', NULL, 0, 1, 0);
INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES (87, 'timesheets_attendance_mgt', 'new_leave_application_send_to_notification_recipient', 'english', 'New application (Send to notification recipient)', 'Timesheets - New application - Send to notification recipient', '{staff_name} created a new application {link} at {date_time}', '{companyname} | CRM', NULL, 0, 1, 0);


#
# TABLE STRUCTURE FOR: tblestimate_request_forms
#

DROP TABLE IF EXISTS `tblestimate_request_forms`;

CREATE TABLE `tblestimate_request_forms` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_key` varchar(32) NOT NULL,
  `type` varchar(100) NOT NULL,
  `name` varchar(191) NOT NULL,
  `form_data` mediumtext DEFAULT NULL,
  `recaptcha` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL,
  `submit_btn_name` varchar(100) DEFAULT NULL,
  `submit_btn_text_color` varchar(10) DEFAULT '#ffffff',
  `submit_btn_bg_color` varchar(10) DEFAULT '#84c529',
  `success_submit_msg` text DEFAULT NULL,
  `submit_action` int(2) DEFAULT 0,
  `submit_redirect_url` mediumtext DEFAULT NULL,
  `language` varchar(100) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `notify_type` varchar(100) DEFAULT NULL,
  `notify_ids` mediumtext DEFAULT NULL,
  `responsible` int(11) DEFAULT NULL,
  `notify_request_submitted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblestimate_request_status
#

DROP TABLE IF EXISTS `tblestimate_request_status`;

CREATE TABLE `tblestimate_request_status` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `statusorder` int(11) DEFAULT NULL,
  `color` varchar(10) DEFAULT NULL,
  `flag` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblestimate_request_status` (`id`, `name`, `statusorder`, `color`, `flag`) VALUES (1, 'Cancelled', 1, '#808080', 'cancelled');
INSERT INTO `tblestimate_request_status` (`id`, `name`, `statusorder`, `color`, `flag`) VALUES (2, 'Processing', 2, '#007bff', 'processing');
INSERT INTO `tblestimate_request_status` (`id`, `name`, `statusorder`, `color`, `flag`) VALUES (3, 'Completed', 3, '#28a745', 'completed');


#
# TABLE STRUCTURE FOR: tblestimate_requests
#

DROP TABLE IF EXISTS `tblestimate_requests`;

CREATE TABLE `tblestimate_requests` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(100) NOT NULL,
  `submission` longtext NOT NULL,
  `last_status_change` datetime DEFAULT NULL,
  `date_estimated` datetime DEFAULT NULL,
  `from_form_id` int(11) DEFAULT NULL,
  `assigned` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `default_language` int(11) NOT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblestimates
#

DROP TABLE IF EXISTS `tblestimates`;

CREATE TABLE `tblestimates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sent` tinyint(1) NOT NULL DEFAULT 0,
  `datesend` datetime DEFAULT NULL,
  `clientid` int(11) NOT NULL,
  `deleted_customer_name` varchar(100) DEFAULT NULL,
  `project_id` int(11) NOT NULL DEFAULT 0,
  `number` int(11) NOT NULL,
  `prefix` varchar(50) DEFAULT NULL,
  `number_format` int(11) NOT NULL DEFAULT 0,
  `hash` varchar(32) DEFAULT NULL,
  `datecreated` datetime NOT NULL,
  `date` date NOT NULL,
  `expirydate` date DEFAULT NULL,
  `currency` int(11) NOT NULL,
  `subtotal` decimal(15,2) NOT NULL,
  `total_tax` decimal(15,2) NOT NULL DEFAULT 0.00,
  `total` decimal(15,2) NOT NULL,
  `adjustment` decimal(15,2) DEFAULT NULL,
  `addedfrom` int(11) NOT NULL,
  `status` int(11) NOT NULL DEFAULT 1,
  `clientnote` text DEFAULT NULL,
  `adminnote` text DEFAULT NULL,
  `discount_percent` decimal(15,2) DEFAULT 0.00,
  `discount_total` decimal(15,2) DEFAULT 0.00,
  `discount_type` varchar(30) DEFAULT NULL,
  `invoiceid` int(11) DEFAULT NULL,
  `invoiced_date` datetime DEFAULT NULL,
  `terms` text DEFAULT NULL,
  `reference_no` varchar(100) DEFAULT NULL,
  `sale_agent` int(11) NOT NULL DEFAULT 0,
  `billing_street` varchar(200) DEFAULT NULL,
  `billing_city` varchar(100) DEFAULT NULL,
  `billing_state` varchar(100) DEFAULT NULL,
  `billing_zip` varchar(100) DEFAULT NULL,
  `billing_country` int(11) DEFAULT NULL,
  `shipping_street` varchar(200) DEFAULT NULL,
  `shipping_city` varchar(100) DEFAULT NULL,
  `shipping_state` varchar(100) DEFAULT NULL,
  `shipping_zip` varchar(100) DEFAULT NULL,
  `shipping_country` int(11) DEFAULT NULL,
  `include_shipping` tinyint(1) NOT NULL,
  `show_shipping_on_estimate` tinyint(1) NOT NULL DEFAULT 1,
  `show_quantity_as` int(11) NOT NULL DEFAULT 1,
  `pipeline_order` int(11) DEFAULT 1,
  `is_expiry_notified` int(11) NOT NULL DEFAULT 0,
  `acceptance_firstname` varchar(50) DEFAULT NULL,
  `acceptance_lastname` varchar(50) DEFAULT NULL,
  `acceptance_email` varchar(100) DEFAULT NULL,
  `acceptance_date` datetime DEFAULT NULL,
  `acceptance_ip` varchar(40) DEFAULT NULL,
  `signature` varchar(40) DEFAULT NULL,
  `short_link` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `clientid` (`clientid`),
  KEY `currency` (`currency`),
  KEY `project_id` (`project_id`),
  KEY `sale_agent` (`sale_agent`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblestimates` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `project_id`, `number`, `prefix`, `number_format`, `hash`, `datecreated`, `date`, `expirydate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `status`, `clientnote`, `adminnote`, `discount_percent`, `discount_total`, `discount_type`, `invoiceid`, `invoiced_date`, `terms`, `reference_no`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_estimate`, `show_quantity_as`, `pipeline_order`, `is_expiry_notified`, `acceptance_firstname`, `acceptance_lastname`, `acceptance_email`, `acceptance_date`, `acceptance_ip`, `signature`, `short_link`) VALUES (1, 0, NULL, 30, NULL, 0, 1, 'EST-', 1, '4a5de610f75d04844d1ae10c12dfbcec', '2023-11-15 10:46:49', '2023-11-15', '2023-11-22', 2, '1000.00', '210.00', '1210.00', '0.00', 1, 1, '', '', '0.00', '0.00', '', NULL, NULL, '', '', 0, '', '', '', '', 0, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL);


#
# TABLE STRUCTURE FOR: tblevents
#

DROP TABLE IF EXISTS `tblevents`;

CREATE TABLE `tblevents` (
  `eventid` int(11) NOT NULL AUTO_INCREMENT,
  `title` mediumtext NOT NULL,
  `description` text DEFAULT NULL,
  `userid` int(11) NOT NULL,
  `start` datetime NOT NULL,
  `end` datetime DEFAULT NULL,
  `public` int(11) NOT NULL DEFAULT 0,
  `color` varchar(10) DEFAULT NULL,
  `isstartnotified` tinyint(1) NOT NULL DEFAULT 0,
  `reminder_before` int(11) NOT NULL DEFAULT 0,
  `reminder_before_type` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`eventid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblexpenses
#

DROP TABLE IF EXISTS `tblexpenses`;

CREATE TABLE `tblexpenses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category` int(11) NOT NULL,
  `currency` int(11) NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `tax` int(11) DEFAULT NULL,
  `tax2` int(11) NOT NULL DEFAULT 0,
  `reference_no` varchar(100) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `expense_name` varchar(191) DEFAULT NULL,
  `clientid` int(11) NOT NULL,
  `project_id` int(11) NOT NULL DEFAULT 0,
  `billable` int(11) DEFAULT 0,
  `invoiceid` int(11) DEFAULT NULL,
  `paymentmode` varchar(50) DEFAULT NULL,
  `date` date NOT NULL,
  `recurring_type` varchar(10) DEFAULT NULL,
  `repeat_every` int(11) DEFAULT NULL,
  `recurring` int(11) NOT NULL DEFAULT 0,
  `cycles` int(11) NOT NULL DEFAULT 0,
  `total_cycles` int(11) NOT NULL DEFAULT 0,
  `custom_recurring` int(11) NOT NULL DEFAULT 0,
  `last_recurring_date` date DEFAULT NULL,
  `create_invoice_billable` tinyint(1) DEFAULT NULL,
  `send_invoice_to_customer` tinyint(1) NOT NULL,
  `recurring_from` int(11) DEFAULT NULL,
  `dateadded` datetime NOT NULL,
  `addedfrom` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `clientid` (`clientid`),
  KEY `project_id` (`project_id`),
  KEY `category` (`category`),
  KEY `currency` (`currency`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblexpenses` (`id`, `category`, `currency`, `amount`, `tax`, `tax2`, `reference_no`, `note`, `expense_name`, `clientid`, `project_id`, `billable`, `invoiceid`, `paymentmode`, `date`, `recurring_type`, `repeat_every`, `recurring`, `cycles`, `total_cycles`, `custom_recurring`, `last_recurring_date`, `create_invoice_billable`, `send_invoice_to_customer`, `recurring_from`, `dateadded`, `addedfrom`) VALUES (1, 1, 2, '30.00', 0, 0, '', '', 'gasto prueba', 0, 0, 0, NULL, '1', '2021-06-08', NULL, 0, 0, 0, 0, 0, NULL, 0, 0, NULL, '2021-06-08 19:14:53', 2);


#
# TABLE STRUCTURE FOR: tblexpenses_categories
#

DROP TABLE IF EXISTS `tblexpenses_categories`;

CREATE TABLE `tblexpenses_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblexpenses_categories` (`id`, `name`, `description`) VALUES (1, 'orueba', '');


#
# TABLE STRUCTURE FOR: tblfiles
#

DROP TABLE IF EXISTS `tblfiles`;

CREATE TABLE `tblfiles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rel_id` int(11) NOT NULL,
  `rel_type` varchar(20) NOT NULL,
  `file_name` varchar(191) NOT NULL,
  `filetype` varchar(40) DEFAULT NULL,
  `visible_to_customer` int(11) NOT NULL DEFAULT 0,
  `attachment_key` varchar(32) DEFAULT NULL,
  `external` varchar(40) DEFAULT NULL,
  `external_link` text DEFAULT NULL,
  `thumbnail_link` text DEFAULT NULL COMMENT 'For external usage',
  `staffid` int(11) NOT NULL,
  `contact_id` int(11) DEFAULT 0,
  `task_comment_id` int(11) NOT NULL DEFAULT 0,
  `dateadded` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `rel_id` (`rel_id`),
  KEY `rel_type` (`rel_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblfilter_defaults
#

DROP TABLE IF EXISTS `tblfilter_defaults`;

CREATE TABLE `tblfilter_defaults` (
  `filter_id` int(10) unsigned NOT NULL,
  `staff_id` int(11) NOT NULL,
  `identifier` varchar(191) NOT NULL,
  `view` varchar(191) NOT NULL,
  KEY `filter_id` (`filter_id`),
  KEY `staff_id` (`staff_id`),
  CONSTRAINT `tblfilter_defaults_ibfk_1` FOREIGN KEY (`filter_id`) REFERENCES `tblfilters` (`id`) ON DELETE CASCADE,
  CONSTRAINT `tblfilter_defaults_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `tblstaff` (`staffid`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblfilters
#

DROP TABLE IF EXISTS `tblfilters`;

CREATE TABLE `tblfilters` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `builder` mediumtext NOT NULL,
  `staff_id` int(10) unsigned NOT NULL,
  `identifier` varchar(191) NOT NULL,
  `is_shared` tinyint(3) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `tblfilters` (`id`, `name`, `builder`, `staff_id`, `identifier`, `is_shared`) VALUES (1, '2024', '{\"match_type\":\"or\",\"rules\":[{\"id\":\"date\",\"value\":\"01\\/01\\/2024\",\"has_dynamic_value\":\"false\",\"operator\":\"greater_or_equal\",\"type\":\"DateRule\"}]}', 1, 'invoices', 0);


#
# TABLE STRUCTURE FOR: tblform_question_box
#

DROP TABLE IF EXISTS `tblform_question_box`;

CREATE TABLE `tblform_question_box` (
  `boxid` int(11) NOT NULL AUTO_INCREMENT,
  `boxtype` varchar(10) NOT NULL,
  `questionid` int(11) NOT NULL,
  PRIMARY KEY (`boxid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblform_question_box_description
#

DROP TABLE IF EXISTS `tblform_question_box_description`;

CREATE TABLE `tblform_question_box_description` (
  `questionboxdescriptionid` int(11) NOT NULL AUTO_INCREMENT,
  `description` mediumtext NOT NULL,
  `boxid` mediumtext NOT NULL,
  `questionid` int(11) NOT NULL,
  PRIMARY KEY (`questionboxdescriptionid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblform_questions
#

DROP TABLE IF EXISTS `tblform_questions`;

CREATE TABLE `tblform_questions` (
  `questionid` int(11) NOT NULL AUTO_INCREMENT,
  `rel_id` int(11) NOT NULL,
  `rel_type` varchar(20) DEFAULT NULL,
  `question` mediumtext NOT NULL,
  `required` tinyint(1) NOT NULL DEFAULT 0,
  `question_order` int(11) NOT NULL,
  PRIMARY KEY (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblform_results
#

DROP TABLE IF EXISTS `tblform_results`;

CREATE TABLE `tblform_results` (
  `resultid` int(11) NOT NULL AUTO_INCREMENT,
  `boxid` int(11) NOT NULL,
  `boxdescriptionid` int(11) DEFAULT NULL,
  `rel_id` int(11) NOT NULL,
  `rel_type` varchar(20) DEFAULT NULL,
  `questionid` int(11) NOT NULL,
  `answer` text DEFAULT NULL,
  `resultsetid` int(11) NOT NULL,
  PRIMARY KEY (`resultid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblgdpr_requests
#

DROP TABLE IF EXISTS `tblgdpr_requests`;

CREATE TABLE `tblgdpr_requests` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `clientid` int(11) NOT NULL DEFAULT 0,
  `contact_id` int(11) NOT NULL DEFAULT 0,
  `lead_id` int(11) NOT NULL DEFAULT 0,
  `request_type` varchar(191) DEFAULT NULL,
  `status` varchar(40) DEFAULT NULL,
  `request_date` datetime NOT NULL,
  `request_from` varchar(150) DEFAULT NULL,
  `description` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblgoods_delivery
#

DROP TABLE IF EXISTS `tblgoods_delivery`;

CREATE TABLE `tblgoods_delivery` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `rel_type` int(11) DEFAULT NULL COMMENT 'type goods delivery',
  `rel_document` int(11) DEFAULT NULL COMMENT 'document id of goods delivery',
  `customer_code` text DEFAULT NULL,
  `customer_name` varchar(100) DEFAULT NULL,
  `to_` varchar(100) DEFAULT NULL,
  `address` varchar(100) DEFAULT NULL,
  `description` text DEFAULT NULL COMMENT 'the reason delivery',
  `staff_id` int(11) DEFAULT NULL COMMENT 'salesman',
  `date_c` date DEFAULT NULL,
  `date_add` date DEFAULT NULL,
  `goods_delivery_code` varchar(100) DEFAULT NULL COMMENT 'số chứng từ xuất kho',
  `warehouse_id` int(11) DEFAULT NULL,
  `total_money` varchar(200) DEFAULT NULL,
  `approval` int(11) DEFAULT 0 COMMENT 'status approval ',
  `addedfrom` int(11) DEFAULT NULL,
  `total_discount` varchar(100) DEFAULT NULL,
  `after_discount` varchar(100) DEFAULT NULL,
  `invoice_id` varchar(100) DEFAULT NULL,
  `project` text DEFAULT NULL,
  `type` text DEFAULT NULL,
  `department` int(11) DEFAULT NULL,
  `requester` int(11) DEFAULT NULL,
  `invoice_no` text DEFAULT NULL,
  `pr_order_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblgoods_delivery_detail
#

DROP TABLE IF EXISTS `tblgoods_delivery_detail`;

CREATE TABLE `tblgoods_delivery_detail` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `goods_delivery_id` int(11) NOT NULL,
  `commodity_code` varchar(100) DEFAULT NULL,
  `commodity_name` text DEFAULT NULL,
  `warehouse_id` text DEFAULT NULL,
  `unit_id` text DEFAULT NULL,
  `quantities` text DEFAULT NULL,
  `unit_price` varchar(100) DEFAULT NULL,
  `total_money` varchar(200) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `discount` varchar(100) DEFAULT NULL,
  `discount_money` varchar(100) DEFAULT NULL,
  `available_quantity` varchar(100) DEFAULT NULL,
  `tax_id` varchar(100) DEFAULT NULL,
  `total_after_discount` varchar(100) DEFAULT NULL,
  `expiry_date` text DEFAULT NULL,
  `lot_number` text DEFAULT NULL,
  `guarantee_period` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblgoods_delivery_invoices_pr_orders
#

DROP TABLE IF EXISTS `tblgoods_delivery_invoices_pr_orders`;

CREATE TABLE `tblgoods_delivery_invoices_pr_orders` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `rel_id` int(11) DEFAULT NULL COMMENT 'goods_delivery_id',
  `rel_type` int(11) DEFAULT NULL COMMENT 'invoice_id or purchase order id',
  `type` varchar(100) DEFAULT NULL COMMENT 'invoice,  purchase_orders',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblgoods_receipt
#

DROP TABLE IF EXISTS `tblgoods_receipt`;

CREATE TABLE `tblgoods_receipt` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `supplier_code` varchar(100) DEFAULT NULL,
  `supplier_name` text DEFAULT NULL,
  `deliver_name` text DEFAULT NULL,
  `buyer_id` int(11) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `pr_order_id` int(11) DEFAULT NULL COMMENT 'code puchase request agree',
  `date_c` date DEFAULT NULL,
  `date_add` date DEFAULT NULL,
  `goods_receipt_code` varchar(100) DEFAULT NULL,
  `warehouse_id` int(11) DEFAULT NULL,
  `total_tax_money` varchar(100) DEFAULT NULL,
  `total_goods_money` varchar(100) DEFAULT NULL,
  `value_of_inventory` varchar(100) DEFAULT NULL,
  `total_money` varchar(100) DEFAULT NULL COMMENT 'total_money = total_tax_money +total_goods_money ',
  `addedfrom` int(11) DEFAULT NULL,
  `approval` int(11) DEFAULT 0,
  `project` text DEFAULT NULL,
  `type` text DEFAULT NULL,
  `department` int(11) DEFAULT NULL,
  `requester` int(11) DEFAULT NULL,
  `expiry_date` date DEFAULT NULL,
  `invoice_no` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblgoods_receipt_detail
#

DROP TABLE IF EXISTS `tblgoods_receipt_detail`;

CREATE TABLE `tblgoods_receipt_detail` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `goods_receipt_id` int(11) NOT NULL,
  `commodity_code` varchar(100) DEFAULT NULL,
  `commodity_name` text DEFAULT NULL,
  `warehouse_id` text DEFAULT NULL,
  `unit_id` text DEFAULT NULL,
  `quantities` text DEFAULT NULL,
  `unit_price` varchar(100) DEFAULT NULL,
  `tax` varchar(100) DEFAULT NULL,
  `tax_money` varchar(100) DEFAULT NULL,
  `goods_money` varchar(100) DEFAULT NULL,
  `date_manufacture` date DEFAULT NULL,
  `expiry_date` date DEFAULT NULL,
  `note` text DEFAULT NULL,
  `discount` varchar(100) DEFAULT NULL,
  `discount_money` varchar(100) DEFAULT NULL,
  `lot_number` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblgoods_transaction_detail
#

DROP TABLE IF EXISTS `tblgoods_transaction_detail`;

CREATE TABLE `tblgoods_transaction_detail` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `goods_receipt_id` int(11) DEFAULT NULL COMMENT 'id_goods_receipt_id or goods_delivery_id',
  `goods_id` int(11) NOT NULL COMMENT ' is id commodity',
  `old_quantity` varchar(100) DEFAULT NULL,
  `quantity` varchar(100) DEFAULT NULL,
  `date_add` datetime DEFAULT NULL,
  `commodity_id` int(11) NOT NULL,
  `warehouse_id` text NOT NULL,
  `note` text DEFAULT NULL,
  `status` int(2) DEFAULT NULL COMMENT '1:Goods receipt note 2:Goods delivery note',
  `purchase_price` varchar(100) DEFAULT NULL,
  `price` varchar(100) DEFAULT NULL,
  `expiry_date` text DEFAULT NULL,
  `lot_number` text DEFAULT NULL,
  `from_stock_name` int(11) DEFAULT NULL,
  `to_stock_name` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`,`commodity_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblinternal_delivery_note
#

DROP TABLE IF EXISTS `tblinternal_delivery_note`;

CREATE TABLE `tblinternal_delivery_note` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `internal_delivery_name` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `date_c` date DEFAULT NULL,
  `date_add` date DEFAULT NULL,
  `internal_delivery_code` varchar(100) DEFAULT NULL,
  `approval` int(11) DEFAULT 0 COMMENT 'status approval ',
  `addedfrom` int(11) DEFAULT NULL,
  `total_amount` decimal(15,2) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblinternal_delivery_note_detail
#

DROP TABLE IF EXISTS `tblinternal_delivery_note_detail`;

CREATE TABLE `tblinternal_delivery_note_detail` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `internal_delivery_id` int(11) NOT NULL,
  `commodity_code` varchar(100) DEFAULT NULL,
  `from_stock_name` text DEFAULT NULL,
  `to_stock_name` text DEFAULT NULL,
  `unit_id` text DEFAULT NULL,
  `available_quantity` text DEFAULT NULL,
  `quantities` text DEFAULT NULL,
  `unit_price` varchar(100) DEFAULT NULL,
  `into_money` varchar(100) DEFAULT NULL,
  `note` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblinventory_commodity_min
#

DROP TABLE IF EXISTS `tblinventory_commodity_min`;

CREATE TABLE `tblinventory_commodity_min` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `commodity_id` int(11) NOT NULL,
  `commodity_code` varchar(100) DEFAULT NULL,
  `commodity_name` varchar(100) DEFAULT NULL,
  `inventory_number_min` varchar(100) DEFAULT NULL,
  `inventory_number_max` varchar(100) DEFAULT '0',
  PRIMARY KEY (`id`,`commodity_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblinventory_manage
#

DROP TABLE IF EXISTS `tblinventory_manage`;

CREATE TABLE `tblinventory_manage` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `warehouse_id` int(11) NOT NULL,
  `commodity_id` int(11) NOT NULL,
  `inventory_number` varchar(100) DEFAULT NULL,
  `date_manufacture` date DEFAULT NULL,
  `expiry_date` date DEFAULT NULL,
  `lot_number` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`,`commodity_id`,`warehouse_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblinvoicepaymentrecords
#

DROP TABLE IF EXISTS `tblinvoicepaymentrecords`;

CREATE TABLE `tblinvoicepaymentrecords` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invoiceid` int(11) NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `paymentmode` varchar(40) DEFAULT NULL,
  `paymentmethod` varchar(191) DEFAULT NULL,
  `date` date NOT NULL,
  `daterecorded` datetime NOT NULL,
  `note` text NOT NULL,
  `transactionid` mediumtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoiceid` (`invoiceid`),
  KEY `paymentmethod` (`paymentmethod`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblinvoicepaymentrecords` (`id`, `invoiceid`, `amount`, `paymentmode`, `paymentmethod`, `date`, `daterecorded`, `note`, `transactionid`) VALUES (1, 4, '250.00', '1', NULL, '2021-11-29', '2021-11-29 19:25:07', '', '');
INSERT INTO `tblinvoicepaymentrecords` (`id`, `invoiceid`, `amount`, `paymentmode`, `paymentmethod`, `date`, `daterecorded`, `note`, `transactionid`) VALUES (2, 10, '931.00', '3', '', '2022-08-17', '2022-09-21 19:19:17', '', '');
INSERT INTO `tblinvoicepaymentrecords` (`id`, `invoiceid`, `amount`, `paymentmode`, `paymentmethod`, `date`, `daterecorded`, `note`, `transactionid`) VALUES (5, 20, '109.90', '2', NULL, '2022-12-16', '2022-12-16 17:09:24', '', '');
INSERT INTO `tblinvoicepaymentrecords` (`id`, `invoiceid`, `amount`, `paymentmode`, `paymentmethod`, `date`, `daterecorded`, `note`, `transactionid`) VALUES (6, 19, '565.40', '2', NULL, '2022-12-16', '2022-12-16 17:09:34', '', '');
INSERT INTO `tblinvoicepaymentrecords` (`id`, `invoiceid`, `amount`, `paymentmode`, `paymentmethod`, `date`, `daterecorded`, `note`, `transactionid`) VALUES (7, 21, '370.70', '2', NULL, '2022-12-16', '2022-12-16 17:24:47', '', '');
INSERT INTO `tblinvoicepaymentrecords` (`id`, `invoiceid`, `amount`, `paymentmode`, `paymentmethod`, `date`, `daterecorded`, `note`, `transactionid`) VALUES (9, 22, '102.50', '2', NULL, '2022-12-16', '2022-12-16 17:27:34', '', '');
INSERT INTO `tblinvoicepaymentrecords` (`id`, `invoiceid`, `amount`, `paymentmode`, `paymentmethod`, `date`, `daterecorded`, `note`, `transactionid`) VALUES (10, 23, '52.00', '2', NULL, '2022-12-16', '2022-12-16 20:19:52', '', '');
INSERT INTO `tblinvoicepaymentrecords` (`id`, `invoiceid`, `amount`, `paymentmode`, `paymentmethod`, `date`, `daterecorded`, `note`, `transactionid`) VALUES (11, 24, '62.50', '2', NULL, '2022-12-22', '2022-12-22 22:43:08', '', '');
INSERT INTO `tblinvoicepaymentrecords` (`id`, `invoiceid`, `amount`, `paymentmode`, `paymentmethod`, `date`, `daterecorded`, `note`, `transactionid`) VALUES (12, 25, '1075.80', '2', NULL, '2022-12-22', '2022-12-22 22:43:22', '', '');
INSERT INTO `tblinvoicepaymentrecords` (`id`, `invoiceid`, `amount`, `paymentmode`, `paymentmethod`, `date`, `daterecorded`, `note`, `transactionid`) VALUES (13, 26, '34606.00', '1', NULL, '2022-12-27', '2022-12-27 20:44:32', 'A CTA DEUDA PRÉSTAMOS', '');
INSERT INTO `tblinvoicepaymentrecords` (`id`, `invoiceid`, `amount`, `paymentmode`, `paymentmethod`, `date`, `daterecorded`, `note`, `transactionid`) VALUES (14, 27, '9885.70', '1', NULL, '2022-12-27', '2022-12-27 20:46:27', 'A CTA DEUDA PRESTAMOS', '');
INSERT INTO `tblinvoicepaymentrecords` (`id`, `invoiceid`, `amount`, `paymentmode`, `paymentmethod`, `date`, `daterecorded`, `note`, `transactionid`) VALUES (15, 28, '477.50', '2', NULL, '2023-01-04', '2023-01-04 18:13:41', '', '');
INSERT INTO `tblinvoicepaymentrecords` (`id`, `invoiceid`, `amount`, `paymentmode`, `paymentmethod`, `date`, `daterecorded`, `note`, `transactionid`) VALUES (16, 29, '1148.50', '2', '', '2023-01-13', '2023-01-13 22:11:58', '', '');
INSERT INTO `tblinvoicepaymentrecords` (`id`, `invoiceid`, `amount`, `paymentmode`, `paymentmethod`, `date`, `daterecorded`, `note`, `transactionid`) VALUES (17, 30, '1011.10', '2', NULL, '2023-02-03', '2023-02-03 15:19:34', '', '');
INSERT INTO `tblinvoicepaymentrecords` (`id`, `invoiceid`, `amount`, `paymentmode`, `paymentmethod`, `date`, `daterecorded`, `note`, `transactionid`) VALUES (18, 34, '18.50', '2', NULL, '2023-02-14', '2023-02-14 12:20:32', '', '');
INSERT INTO `tblinvoicepaymentrecords` (`id`, `invoiceid`, `amount`, `paymentmode`, `paymentmethod`, `date`, `daterecorded`, `note`, `transactionid`) VALUES (19, 33, '22.49', '2', NULL, '2023-02-14', '2023-02-14 12:20:42', '', '');
INSERT INTO `tblinvoicepaymentrecords` (`id`, `invoiceid`, `amount`, `paymentmode`, `paymentmethod`, `date`, `daterecorded`, `note`, `transactionid`) VALUES (20, 40, '2569.77', '1', NULL, '2023-09-15', '2023-09-15 19:15:00', '', '');
INSERT INTO `tblinvoicepaymentrecords` (`id`, `invoiceid`, `amount`, `paymentmode`, `paymentmethod`, `date`, `daterecorded`, `note`, `transactionid`) VALUES (21, 48, '319.10', '2', NULL, '2023-11-28', '2023-11-28 12:04:07', '', '');
INSERT INTO `tblinvoicepaymentrecords` (`id`, `invoiceid`, `amount`, `paymentmode`, `paymentmethod`, `date`, `daterecorded`, `note`, `transactionid`) VALUES (22, 47, '20.45', '2', NULL, '2023-11-28', '2023-11-28 12:04:15', '', '');
INSERT INTO `tblinvoicepaymentrecords` (`id`, `invoiceid`, `amount`, `paymentmode`, `paymentmethod`, `date`, `daterecorded`, `note`, `transactionid`) VALUES (23, 49, '63.00', '2', NULL, '2023-11-28', '2023-11-28 12:06:23', '', '');


#
# TABLE STRUCTURE FOR: tblinvoices
#

DROP TABLE IF EXISTS `tblinvoices`;

CREATE TABLE `tblinvoices` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sent` tinyint(1) NOT NULL DEFAULT 0,
  `datesend` datetime DEFAULT NULL,
  `clientid` int(11) NOT NULL,
  `deleted_customer_name` varchar(100) DEFAULT NULL,
  `number` int(11) NOT NULL,
  `prefix` varchar(50) DEFAULT NULL,
  `number_format` int(11) NOT NULL DEFAULT 0,
  `datecreated` datetime NOT NULL,
  `date` date NOT NULL,
  `duedate` date DEFAULT NULL,
  `currency` int(11) NOT NULL,
  `subtotal` decimal(15,2) NOT NULL,
  `total_tax` decimal(15,2) NOT NULL DEFAULT 0.00,
  `total` decimal(15,2) NOT NULL,
  `adjustment` decimal(15,2) DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `hash` varchar(32) NOT NULL,
  `status` int(11) DEFAULT 1,
  `clientnote` text DEFAULT NULL,
  `adminnote` text DEFAULT NULL,
  `last_overdue_reminder` date DEFAULT NULL,
  `last_due_reminder` date DEFAULT NULL,
  `cancel_overdue_reminders` int(11) NOT NULL DEFAULT 0,
  `allowed_payment_modes` mediumtext DEFAULT NULL,
  `token` mediumtext DEFAULT NULL,
  `discount_percent` decimal(15,2) DEFAULT 0.00,
  `discount_total` decimal(15,2) DEFAULT 0.00,
  `discount_type` varchar(30) NOT NULL,
  `recurring` int(11) NOT NULL DEFAULT 0,
  `recurring_type` varchar(10) DEFAULT NULL,
  `custom_recurring` tinyint(1) NOT NULL DEFAULT 0,
  `cycles` int(11) NOT NULL DEFAULT 0,
  `total_cycles` int(11) NOT NULL DEFAULT 0,
  `is_recurring_from` int(11) DEFAULT NULL,
  `last_recurring_date` date DEFAULT NULL,
  `terms` text DEFAULT NULL,
  `sale_agent` int(11) NOT NULL DEFAULT 0,
  `billing_street` varchar(200) DEFAULT NULL,
  `billing_city` varchar(100) DEFAULT NULL,
  `billing_state` varchar(100) DEFAULT NULL,
  `billing_zip` varchar(100) DEFAULT NULL,
  `billing_country` int(11) DEFAULT NULL,
  `shipping_street` varchar(200) DEFAULT NULL,
  `shipping_city` varchar(100) DEFAULT NULL,
  `shipping_state` varchar(100) DEFAULT NULL,
  `shipping_zip` varchar(100) DEFAULT NULL,
  `shipping_country` int(11) DEFAULT NULL,
  `include_shipping` tinyint(1) NOT NULL,
  `show_shipping_on_invoice` tinyint(1) NOT NULL DEFAULT 1,
  `show_quantity_as` int(11) NOT NULL DEFAULT 1,
  `project_id` int(11) DEFAULT 0,
  `subscription_id` int(11) NOT NULL DEFAULT 0,
  `short_link` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `currency` (`currency`),
  KEY `clientid` (`clientid`),
  KEY `project_id` (`project_id`),
  KEY `sale_agent` (`sale_agent`),
  KEY `total` (`total`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=69 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (1, 0, NULL, 1, NULL, 1, 'INV-', 1, '2021-02-07 12:25:29', '2021-02-07', '2021-03-09', 2, '3000.00', '630.00', '3630.00', '0.00', 1, '8ff6e6947ada9e48ed1afc9e03968251', 4, '', '', '2024-09-24', NULL, 0, 'a:1:{i:0;s:1:\"1\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, 'ESTA FACTURA ES DE CARÁCTER TOTALMENTE CONFIDENCIAL', 1, '', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (2, 0, NULL, 1, NULL, 2, 'INV-', 1, '2021-02-07 12:29:25', '2021-02-07', '2021-03-09', 2, '1500.00', '315.00', '1815.00', '0.00', 1, 'acb15176f7307eda40475c9462fd2e47', 4, '', '', '2024-09-24', NULL, 0, 'a:1:{i:0;s:1:\"1\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, 'ESTA FACTURA ES DE CARÁCTER TOTALMENTE CONFIDENCIAL ', 1, '', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (3, 0, NULL, 4, NULL, 3, 'INV-', 1, '2021-08-16 16:10:20', '2021-07-01', '2021-09-01', 2, '4752.00', '997.92', '5749.92', '0.00', 1, 'd18a660aa62c7e5541da763bca125afb', 4, '', '', '2024-09-24', NULL, 0, 'a:1:{i:0;s:1:\"1\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, 'PAGO A 60 DÍAS ', 0, '', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (4, 0, NULL, 5, NULL, 4, 'INV-', 1, '2021-11-29 16:48:00', '2021-11-29', '2021-12-29', 2, '227.27', '22.73', '250.00', '0.00', 1, '7a04953e3b9f8ce81695ee5442621987', 2, '', '', NULL, NULL, 0, 'a:1:{i:0;s:1:\"1\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, '', '', '', '', 0, '', NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (5, 0, NULL, 1, NULL, 5, 'INV-', 1, '2022-02-28 19:15:09', '2022-01-01', '2022-03-30', 2, '3000.00', '630.00', '3630.00', '0.00', 1, '161867d8015253dc5da64f4abebf4683', 4, '', '', '2024-09-24', NULL, 0, 'a:1:{i:0;s:1:\"1\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, '', '', '', '', 0, '', NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (6, 0, NULL, 4, NULL, 6, 'INV-', 1, '2022-03-09 16:19:18', '2022-01-01', '2022-03-01', 2, '6840.60', '1436.53', '8277.13', '0.00', 1, 'c6c07e8ace295fd868236d579c816ea3', 4, '', '', '2024-09-24', NULL, 0, 'a:1:{i:0;s:1:\"1\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, 'PAGO A 60 DÍAS', 1, '', '', '', '', 0, '', NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (7, 0, NULL, 1, NULL, 7, 'INV-', 1, '2022-03-16 21:46:02', '2022-01-15', '2022-03-15', 2, '2886.00', '606.06', '3492.06', '0.00', 1, 'd7d30c218c1494b0f95c3a8a24ce8bef', 4, '', '', '2024-09-24', NULL, 0, 'a:1:{i:0;s:1:\"1\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, '', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (8, 0, NULL, 7, NULL, 8, 'INV-', 1, '2022-05-06 19:56:37', '2022-05-06', '2022-06-05', 2, '1400.00', '294.00', '1694.00', '0.00', 1, '5d25218b7a9aa82eac230a0f19c80a40', 4, '', '', '2024-09-24', NULL, 0, 'a:1:{i:0;s:1:\"1\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, 'CAMINO DE LA SIERRA NAVE 3', 'COX', '', '03359', 209, '', NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (9, 0, NULL, 8, NULL, 9, 'INV-', 1, '2022-07-03 01:11:42', '2022-07-03', '2022-07-03', 2, '1650.00', '346.50', '1996.50', '0.00', 1, '3c3d7f3ef96940c0e30100f20d97b3aa', 4, '', '', '2024-09-24', NULL, 0, 'a:1:{i:0;s:1:\"1\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, '', '', '', '', 0, '', NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (10, 0, NULL, 9, NULL, 10, 'INV-', 1, '2022-09-21 18:21:17', '2022-09-21', '2022-10-21', 2, '846.26', '84.63', '931.00', '0.11', 1, '2cd58f6a0136e77b619fa2cfd0835abc', 2, 'Realizado pago con tarjeta en el establecimiento.', '', NULL, NULL, 0, 'a:1:{i:0;s:1:\"3\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, '', '', '', '', 0, '', NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (11, 0, NULL, 10, NULL, 11, 'INV-', 1, '2022-09-21 18:25:03', '2022-09-15', '2022-10-15', 2, '800.00', '168.00', '968.00', '0.00', 1, '6f6c941db6aaff1d13906f36a3444830', 4, '', '', '2024-09-24', NULL, 0, 'a:1:{i:0;s:1:\"1\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, '', '', '', '', 0, '', NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (12, 0, NULL, 10, NULL, 12, 'INV-', 2, '2022-09-21 18:28:24', '2022-09-21', '2022-10-21', 2, '600.00', '126.00', '726.00', '0.00', 1, '389fa4338ec1a1f344dd259a42490578', 4, '', '', '2024-09-24', NULL, 0, 'a:1:{i:0;s:1:\"1\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, '', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (13, 0, NULL, 10, NULL, 13, 'INV-', 2, '2022-09-21 18:29:17', '2022-09-15', '2022-10-15', 2, '500.00', '105.00', '605.00', '0.00', 1, '9e5f6fc432ec54b7c872c7ec835dfe21', 4, '', '', '2024-09-24', NULL, 0, 'a:1:{i:0;s:1:\"1\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, '', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (14, 0, NULL, 10, NULL, 14, 'INV-', 2, '2022-09-21 18:29:52', '2022-09-15', '2022-10-15', 2, '500.00', '105.00', '605.00', '0.00', 1, 'c529b87085e7b5228eea63a0b21dfc93', 4, '', '', '2024-09-24', NULL, 0, 'a:1:{i:0;s:1:\"1\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, '', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (15, 0, NULL, 10, NULL, 15, 'INV-', 2, '2022-09-21 18:30:44', '2022-09-15', '2022-10-15', 2, '600.00', '126.00', '726.00', '0.00', 1, '36ed4492f64153e92d0d0f2898c34007', 4, '', '', '2024-09-24', NULL, 0, 'a:1:{i:0;s:1:\"1\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, '', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (19, 0, NULL, 12, NULL, 16, 'FA-', 1, '2022-12-16 17:08:16', '2022-12-16', '2023-01-15', 2, '514.00', '51.40', '565.40', '0.00', 1, '0e66c425e398ab360678aff0a7dda9c9', 2, '', '', NULL, NULL, 0, 'a:1:{i:0;s:1:\"2\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, '', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (20, 0, NULL, 13, NULL, 17, 'FA-', 1, '2022-12-16 17:09:14', '2022-12-16', '2023-01-15', 2, '99.90', '9.99', '109.90', '0.01', 1, '60be68c82be0a05ad91051c5ab1a3b48', 2, '', '', NULL, NULL, 0, 'a:1:{i:0;s:1:\"2\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, '', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (21, 0, NULL, 14, NULL, 18, 'FA-', 1, '2022-12-16 17:24:41', '2022-12-16', '2023-01-15', 2, '337.00', '33.70', '370.70', '0.00', 1, 'e2e3eb590a200bca127963e73e62ee3d', 2, '', '', NULL, NULL, 0, 'a:1:{i:0;s:1:\"2\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, '', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (22, 0, NULL, 15, NULL, 19, 'FA-', 1, '2022-12-16 17:26:47', '2022-12-16', '2023-01-15', 2, '93.18', '9.32', '102.50', '0.00', 1, '8c0685b8df652bf81c1ef6f1b68f3bae', 2, '', '', NULL, NULL, 0, 'a:1:{i:0;s:1:\"2\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, '', '', '', '', 0, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (23, 0, NULL, 16, NULL, 20, 'FA-', 1, '2022-12-16 20:19:38', '2022-12-16', '2023-01-15', 2, '47.27', '4.73', '52.00', '0.00', 1, '27d1ae782a82c55d44a5885863d85121', 2, '', '', NULL, NULL, 0, 'a:1:{i:0;s:1:\"2\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, '', '', '', '', 0, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (24, 0, NULL, 17, NULL, 21, 'FA-', 1, '2022-12-22 22:41:05', '2022-12-22', '2023-01-21', 2, '56.82', '5.68', '62.50', '0.00', 1, '9ecc6a31603847a6b2e2cf20d6021474', 2, '', '', NULL, NULL, 0, 'a:1:{i:0;s:1:\"2\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, '', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (25, 0, NULL, 18, NULL, 22, 'FA-', 1, '2022-12-22 22:42:21', '2022-12-22', '2023-01-21', 2, '978.00', '97.80', '1075.80', '0.00', 1, '24ede5004fc7ebe1b503ddcf0b229a06', 2, '', '', NULL, NULL, 0, 'a:1:{i:0;s:1:\"2\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, '', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (26, 0, NULL, 19, NULL, 23, 'FA-', 1, '2022-12-27 20:44:13', '2022-12-27', '2023-01-26', 2, '28600.00', '6006.00', '34606.00', '0.00', 1, 'fd2558e030328192395c47fba4b18c65', 2, '', '', NULL, NULL, 0, 'a:1:{i:0;s:1:\"1\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, '', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (27, 0, NULL, 19, NULL, 24, 'FA-', 1, '2022-12-27 20:46:17', '2022-12-27', '2023-01-26', 2, '8170.00', '1715.70', '9885.70', '0.00', 1, '81098196215c76ef73e12b1962215ed8', 2, '', '', NULL, NULL, 0, 'a:1:{i:0;s:1:\"1\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, '', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (28, 0, NULL, 20, NULL, 25, 'FA-', 1, '2023-01-04 18:13:34', '2022-12-30', '2023-01-29', 2, '434.09', '43.41', '477.50', '0.00', 1, '3e3191e7ccf9ce71cadfaf57ad0db876', 2, '', '', NULL, NULL, 0, 'a:1:{i:0;s:1:\"2\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, '', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (29, 0, NULL, 21, NULL, 26, 'FA-', 1, '2023-01-13 22:11:47', '2023-01-13', '2023-02-12', 2, '1044.10', '104.41', '1148.50', '-0.01', 1, '986f914844b978b38f7966077025dbee', 2, '', '', NULL, NULL, 0, 'a:1:{i:0;s:1:\"2\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, '', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (30, 0, NULL, 22, NULL, 27, 'FA-', 1, '2023-02-03 15:19:04', '2023-01-11', '2023-02-10', 2, '919.18', '91.92', '1011.10', '0.00', 1, '4dc49a109a37d88c5b06dbdc80a803e0', 2, '', '', NULL, NULL, 0, 'a:1:{i:0;s:1:\"2\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, '', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (31, 0, NULL, 23, NULL, 28, 'FA-', 1, '2023-02-03 15:21:58', '2023-02-03', '2023-02-17', 2, '1800.00', '378.00', '2178.00', '0.00', 1, '64d558ff070ae9947c712cc5b04a341a', 4, '', '', '2024-09-25', '2023-02-15', 0, 'a:1:{i:0;s:1:\"1\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, '', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (32, 0, NULL, 24, NULL, 29, 'FA-', 1, '2023-02-03 15:31:17', '2023-02-03', '2023-03-05', 2, '2716.00', '570.36', '3286.36', '0.00', 1, 'a536f6e9ea9a686890eb8edeb5b259ad', 4, '', '', '2024-09-23', '2023-03-03', 0, 'a:1:{i:0;s:1:\"1\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, '', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (33, 0, NULL, 25, NULL, 30, 'FA-', 1, '2023-02-14 12:18:59', '2023-02-14', '2023-03-16', 2, '20.45', '2.05', '22.49', '0.00', 1, '52a4a85c425152ffd1469d8161488f48', 2, '', '', NULL, NULL, 0, 'a:1:{i:0;s:1:\"2\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, '', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (34, 0, NULL, 26, NULL, 31, 'FA-', 1, '2023-02-14 12:20:22', '2023-02-14', '2023-03-16', 2, '16.82', '1.68', '18.50', '0.00', 1, '385f7c2057d75b6cc3ee531f3efc03b7', 2, '', '', NULL, NULL, 0, 'a:1:{i:0;s:1:\"2\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, 'Calle ANABEL SEGURA 11, <br />\r\nEDIF. ALBATROS B PLANTA 1 <br />\r\n28100 ALCOBENDAS <br />\r\nMADRID', '', '', '', 0, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (35, 0, NULL, 1, NULL, 32, 'FA-', 1, '2023-02-24 12:36:22', '2023-02-24', '2023-03-26', 2, '3591.00', '754.11', '4345.11', '0.00', 1, 'dc120857d07d6af2bc826a6f6513b71f', 4, '', '', '2024-09-23', '2023-03-24', 0, 'a:1:{i:0;s:1:\"1\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, '', '', '', '', 0, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (36, 0, NULL, 1, NULL, 33, 'FA-', 1, '2023-02-27 14:46:23', '2023-02-27', '2023-03-29', 2, '186.00', '39.06', '225.06', '0.00', 1, '81ab52f75edc8a2157d22bc88708938f', 4, '', '', '2024-09-23', '2023-03-27', 0, 'a:1:{i:0;s:1:\"1\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, '', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (37, 0, NULL, 4, NULL, 34, 'FA-', 1, '2023-04-17 19:57:15', '2023-02-28', '2023-04-30', 2, '5850.00', '1228.50', '7078.50', '0.00', 1, '28b1e9f5b26713a66478af7edc289503', 4, '', '', '2024-09-25', '2023-04-28', 0, 'a:1:{i:0;s:1:\"1\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, '', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (38, 0, NULL, 4, NULL, 35, 'FA-', 1, '2023-04-17 19:58:52', '2023-02-28', '2023-04-30', 2, '650.00', '136.50', '786.50', '0.00', 1, 'a9126538e7f58155e522f9bc952694b3', 4, '', '', '2024-09-25', '2023-04-28', 0, 'a:1:{i:0;s:1:\"1\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, '', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (39, 1, '2023-04-17 20:00:47', 4, NULL, 36, 'FA-', 1, '2023-04-17 19:59:11', '2023-02-28', '2023-04-30', 2, '11436.25', '2401.61', '13837.86', '0.00', 1, '2bb479113c8f1175c267f4b00eb081a5', 4, '', '', '2024-09-25', '2023-04-28', 0, 'a:1:{i:0;s:1:\"1\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, '', '', '', '', 0, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (40, 0, NULL, 27, NULL, 37, 'FA-', 1, '2023-07-17 23:31:47', '2023-07-17', '2023-08-16', 2, '2336.15', '233.62', '2569.77', '0.00', 1, '6e153d0857535b1393b641f553755e7b', 2, '', '', '2023-09-13', '2023-08-14', 0, 'a:1:{i:0;s:1:\"1\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, '', '', '', '', 0, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (41, 0, NULL, 28, NULL, 38, 'FA-', 1, '2023-07-17 23:34:27', '2023-07-17', '2023-08-16', 2, '600.00', '126.00', '726.00', '0.00', 1, '703e7d2947768511a7b02b9f4317f167', 4, '', '', '2024-09-25', '2023-08-14', 0, 'a:1:{i:0;s:1:\"1\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, '', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (42, 0, NULL, 29, NULL, 39, 'FA-', 1, '2023-09-11 10:03:45', '2023-09-11', '2023-10-11', 2, '1340.30', '281.46', '1621.76', '0.00', 1, '5fdcd933455f61020325ccd586bb2385', 4, '', '', '2024-09-24', '2023-10-09', 0, 'a:1:{i:0;s:1:\"1\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, '', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (43, 0, NULL, 30, NULL, 40, 'FA-', 1, '2023-09-29 12:09:34', '2023-09-29', '2023-10-29', 2, '8168.00', '816.80', '8984.80', '0.00', 1, 'ff274772059dd8574ed4109335580f01', 4, '', '', '2024-09-24', '2023-10-27', 0, 'a:1:{i:0;s:1:\"1\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, '', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (44, 0, NULL, 30, NULL, 41, 'FA-', 1, '2023-10-13 10:56:32', '2023-10-13', '2023-11-12', 2, '7428.00', '742.80', '8170.80', '0.00', 1, '13d2b5183450a28c2fc4b345c66fe853', 4, '', '', '2024-09-23', '2023-11-10', 0, 'a:1:{i:0;s:1:\"1\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, '', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (45, 0, NULL, 4, NULL, 42, 'FA-', 1, '2023-10-30 17:36:11', '2023-10-01', '2023-12-01', 2, '2380.90', '499.99', '2880.89', '0.00', 1, '5c6f2f47f3dc0092a61eb89f44c8ef6f', 4, '', '', '2024-09-24', '2023-11-29', 0, 'a:1:{i:0;s:1:\"1\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, '', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (46, 0, NULL, 30, NULL, 43, 'FA-', 1, '2023-11-22 12:34:42', '2023-11-22', '2023-12-22', 2, '4127.40', '412.74', '4540.14', '0.00', 1, '60e4f5115f60e2b637ef3f1e968146d5', 4, '', '', '2024-09-24', '2023-12-20', 0, 'a:1:{i:0;s:1:\"1\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, '', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (47, 0, NULL, 31, NULL, 44, 'FA-', 1, '2023-11-28 12:01:45', '2023-11-28', '2023-12-28', 2, '20.45', '0.00', '20.45', '0.00', 1, 'eb4d8b6e32d08cd2c3dcbcb2dbb18711', 2, '', '', NULL, NULL, 0, 'a:1:{i:0;s:1:\"2\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, 'Calle ROSELLO 515<br />\r\n08025 BARCELONA', '', '', '', 0, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (48, 0, NULL, 32, NULL, 45, 'FA-', 1, '2023-11-28 12:03:19', '2023-11-28', '2023-12-28', 2, '290.09', '29.01', '319.10', '0.00', 1, '6b2dc30cdcf67efb369c8326e4ab942e', 2, '', '', NULL, NULL, 0, 'a:1:{i:0;s:1:\"2\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, 'Plaza LA VEGUILLA S/N <br />\r\n50400 CARIÑENA- ZARAGOZA', '', '', '', 0, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (49, 0, NULL, 33, NULL, 46, 'FA-', 1, '2023-11-28 12:06:19', '2023-11-28', '2023-12-28', 2, '57.27', '5.73', '63.00', '0.00', 1, '82559078da21f5bea203097d0e691830', 2, '', '', NULL, NULL, 0, 'a:1:{i:0;s:1:\"2\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, 'Calle AZALEA 194 <br />\r\n28109 ALCOBENDAS – MADRID', '', '', '', 0, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (50, 0, NULL, 34, NULL, 47, 'FA-', 1, '2023-12-26 20:09:03', '2023-12-26', '2024-01-25', 2, '4500.00', '450.00', '4950.00', '0.00', 1, '62b942eae6adac56b33d191a1bc4bef7', 4, '', '', '2024-09-25', '2024-01-23', 0, 'a:1:{i:0;s:1:\"1\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, '', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (51, 0, NULL, 35, NULL, 48, 'FA-', 1, '2024-01-09 19:22:39', '2023-12-31', '2024-01-30', 2, '1250.00', '125.00', '1375.00', '0.00', 1, 'bd3a0b6fc7c039f76ad42402793822c5', 4, '', '', '2024-09-24', '2024-01-28', 0, 'a:1:{i:0;s:1:\"1\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, 'C/ San Fernando, 49 4 Puerta 3', 'Alicante', '', '03001', 0, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (52, 0, NULL, 36, NULL, 49, 'FA-', 1, '2024-01-31 09:50:01', '2024-01-01', '2024-01-31', 2, '8868.00', '1862.28', '10730.28', '0.00', 1, '73cfe6f5691fa6b7f780351916798f5f', 4, '', '', '2024-09-25', NULL, 0, 'a:1:{i:0;s:1:\"1\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, '', '', '', '', 0, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (53, 0, NULL, 1, NULL, 50, 'FA-', 1, '2024-01-31 11:42:41', '2024-01-01', '2024-01-31', 2, '3753.00', '788.13', '4541.13', '0.00', 1, 'ae85ccfe24a33491cdcdf6d98d9033dd', 4, '', 'ACUERDO PRÓXIMO 2023', '2024-09-25', NULL, 0, 'a:1:{i:0;s:1:\"1\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, '', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (54, 0, NULL, 1, NULL, 51, 'FA-', 1, '2024-01-31 11:43:48', '2024-01-01', '2024-01-31', 2, '500.00', '105.00', '605.00', '0.00', 1, 'd63d3b94bbf2ff41f85f0e8f5a1db287', 4, '', '', '2024-09-25', NULL, 0, 'a:1:{i:0;s:1:\"1\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, 'CALLE VALENCIA 287', 'BARCELONA', '', '08009', 209, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (55, 0, NULL, 37, NULL, 52, 'FA-', 1, '2024-01-31 11:49:58', '2024-01-01', '2024-01-31', 2, '12000.00', '2520.00', '14520.00', '0.00', 1, '801b117c6d0c7897baca02140f7a05e5', 4, '', '', '2024-09-25', NULL, 0, 'a:1:{i:0;s:1:\"1\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, '', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (56, 0, NULL, 36, NULL, 53, 'FA-', 1, '2024-02-01 23:08:12', '2024-01-01', '2024-01-31', 2, '2956.00', '620.76', '3576.76', '0.00', 1, 'ddc7dcaa56003023a20aecfd7e599cbc', 4, '', '', '2024-09-23', NULL, 0, 'a:1:{i:0;s:1:\"1\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, '', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (57, 0, NULL, 38, NULL, 54, 'FA-', 1, '2024-02-12 17:29:56', '2024-02-15', '2024-03-13', 2, '2900.00', '609.00', '3509.00', '0.00', 1, 'bdb41dceb71fa6cdd75c06a0b8fddb45', 4, '', '', '2024-09-25', '2024-03-11', 0, 'a:1:{i:0;s:1:\"1\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, 'ÁLVAREZ SEREIX 12 entlo derecha<br />\r\n03001- ALICANTE', '', '', '', 0, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (58, 0, NULL, 38, NULL, 55, 'FA-', 1, '2024-02-12 17:32:12', '2024-02-15', '2024-03-13', 2, '3399.00', '339.90', '3738.90', '0.00', 1, '64dc2c20ac673a35f72652a96480be78', 4, '', '', '2024-09-25', '2024-03-11', 0, 'a:1:{i:0;s:1:\"1\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, 'ÁLVAREZ SEREIX 12 entlo derecha<br />\r\n03001- ALICANTE', '', '', '', 0, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (59, 0, NULL, 38, NULL, 56, 'FA-', 1, '2024-02-12 17:34:22', '2024-02-16', '2024-03-13', 2, '700.00', '147.00', '847.00', '0.00', 1, 'c930f0f4ef8b311e82c103e3ddb956dd', 4, '', '', '2024-09-25', '2024-03-11', 0, 'a:1:{i:0;s:1:\"1\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, 'ÁLVAREZ SEREIX 12 entlo derecha<br />\r\n03001- ALICANTE', '', '', '', 0, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (60, 0, NULL, 28, NULL, 57, 'FA-', 1, '2024-02-20 19:35:29', '2024-02-20', '2024-03-21', 2, '2430.00', '510.30', '2940.30', '0.00', 1, 'f5912cec79a0918628ea89849a476677', 4, '', '', '2024-09-24', '2024-03-19', 0, 'a:1:{i:0;s:1:\"1\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, 'Plaza Ajuntament, 19 - 7 C<br />\r\n<br />\r\nValencia<br />\r\n<br />\r\n46002', '', '', '', 0, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (61, 0, NULL, 25, NULL, 58, 'FA-', 1, '2024-02-20 19:37:19', '2024-02-20', '2024-03-21', 2, '2182.00', '458.22', '2640.22', '0.00', 1, '4a2a3e4c2a12fe91251b78270142328f', 4, '', '', '2024-09-24', '2024-03-19', 0, 'a:1:{i:0;s:1:\"1\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, 'Calle Rossello, 515<br />\r\n<br />\r\nBarcelona<br />\r\n<br />\r\n08025', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (62, 0, NULL, 39, NULL, 59, 'FA-', 1, '2024-02-20 20:55:21', '2024-02-20', '2024-03-21', 2, '21136.00', '4438.56', '25574.56', '0.00', 1, '97b04935b44e7228d4faceeb29c84874', 4, '', '', '2024-09-24', '2024-03-19', 0, 'a:1:{i:0;s:1:\"1\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 0, 'PLAZA CATALUÑA, 1-4<br />\r\n<br />\r\nTRIANGLE PLANTA 6<br />\r\n<br />\r\n08002 BARCELONA', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (63, 0, NULL, 4, NULL, 60, 'FA-', 1, '2024-09-10 19:40:00', '2024-07-15', '2024-09-15', 2, '16315.70', '3426.30', '19742.00', '0.00', 1, '600522d59d3019cc76ace0a5706f57e0', 4, '', '', '2024-09-25', '2024-09-13', 0, 'a:1:{i:0;s:1:\"2\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 1, '', '', '', '', 0, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (64, 0, NULL, 4, NULL, 61, 'FA-', 1, '2024-09-10 20:00:46', '2024-09-10', '2024-11-10', 2, '1950.00', '409.50', '2359.50', '0.00', 1, 'ae4c067f9b0409bf79a481cab1f0d354', 1, '', '', NULL, NULL, 0, 'a:1:{i:0;s:1:\"2\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 1, '', '', '', '', 0, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (65, 1, '2024-09-10 20:03:19', 4, NULL, 62, 'FA-', 1, '2024-09-10 20:02:49', '2024-09-10', '2024-10-10', 2, '100.00', '21.00', '121.00', '0.00', 1, '38654a07c27f102e593e73a33595b54c', 1, '', '', NULL, NULL, 0, 'a:1:{i:0;s:1:\"2\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 1, '', '', '', '', 0, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (66, 1, '2024-09-10 20:03:38', 4, NULL, 63, 'FA-', 1, '2024-09-10 20:03:23', '2024-09-10', '2024-10-10', 2, '950.00', '199.50', '1149.50', '0.00', 1, '19d49406fcaacbcc3457082168ee98b4', 1, '', '', NULL, NULL, 0, 'a:1:{i:0;s:1:\"2\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 1, '', '', '', '', 0, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (67, 0, NULL, 40, NULL, 64, 'FA-', 1, '2024-09-17 11:43:13', '2024-09-17', '2024-10-17', 2, '650.00', '136.50', '786.50', '0.00', 1, 'dac048ed2e7b8faf351880266e31cf11', 1, '', '', NULL, NULL, 0, 'a:1:{i:0;s:1:\"1\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 1, 'CL Camino de Borja, 29<br />\r\nAlicante<br />\r\n03006', '', '', '', 0, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);
INSERT INTO `tblinvoices` (`id`, `sent`, `datesend`, `clientid`, `deleted_customer_name`, `number`, `prefix`, `number_format`, `datecreated`, `date`, `duedate`, `currency`, `subtotal`, `total_tax`, `total`, `adjustment`, `addedfrom`, `hash`, `status`, `clientnote`, `adminnote`, `last_overdue_reminder`, `last_due_reminder`, `cancel_overdue_reminders`, `allowed_payment_modes`, `token`, `discount_percent`, `discount_total`, `discount_type`, `recurring`, `recurring_type`, `custom_recurring`, `cycles`, `total_cycles`, `is_recurring_from`, `last_recurring_date`, `terms`, `sale_agent`, `billing_street`, `billing_city`, `billing_state`, `billing_zip`, `billing_country`, `shipping_street`, `shipping_city`, `shipping_state`, `shipping_zip`, `shipping_country`, `include_shipping`, `show_shipping_on_invoice`, `show_quantity_as`, `project_id`, `subscription_id`, `short_link`) VALUES (68, 0, NULL, 41, NULL, 65, 'FA-', 1, '2024-09-19 20:14:27', '2024-09-19', '2024-10-19', 2, '1680.00', '352.80', '2032.80', '0.00', 1, '4833522682c414a3c17b17902e2061fe', 1, '', '', NULL, NULL, 0, 'a:1:{i:0;s:1:\"1\";}', NULL, '0.00', '0.00', '', 0, NULL, 0, 0, 0, NULL, NULL, '', 1, 'CAMI LA VIA, NUM 30', 'EL VERGER', 'ALICANTE', '03063', NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0, 0, NULL);


#
# TABLE STRUCTURE FOR: tblitem_tax
#

DROP TABLE IF EXISTS `tblitem_tax`;

CREATE TABLE `tblitem_tax` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `itemid` int(11) NOT NULL,
  `rel_id` int(11) NOT NULL,
  `rel_type` varchar(20) NOT NULL,
  `taxrate` decimal(15,2) NOT NULL,
  `taxname` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `itemid` (`itemid`),
  KEY `rel_id` (`rel_id`)
) ENGINE=InnoDB AUTO_INCREMENT=95 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (1, 1, 1, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (2, 2, 2, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (3, 3, 1, 'proposal', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (4, 4, 2, 'proposal', '10.00', 'VENTAS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (5, 5, 2, 'proposal', '10.00', 'VENTAS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (6, 6, 3, 'proposal', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (7, 7, 3, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (8, 8, 4, 'invoice', '10.00', 'VENTAS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (9, 9, 5, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (10, 10, 6, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (11, 11, 7, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (12, 12, 7, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (13, 13, 7, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (14, 14, 7, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (15, 15, 7, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (16, 16, 7, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (17, 17, 7, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (18, 18, 7, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (19, 19, 7, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (20, 20, 8, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (21, 21, 9, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (22, 22, 9, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (23, 23, 9, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (24, 24, 9, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (25, 25, 10, 'invoice', '10.00', 'VENTAS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (26, 26, 11, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (27, 27, 12, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (28, 28, 13, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (29, 29, 14, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (30, 30, 15, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (32, 32, 4, 'proposal', '10.00', 'VENTAS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (35, 35, 19, 'invoice', '10.00', 'VENTAS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (36, 36, 20, 'invoice', '10.00', 'VENTAS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (37, 37, 21, 'invoice', '10.00', 'VENTAS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (38, 38, 22, 'invoice', '10.00', 'VENTAS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (39, 39, 23, 'invoice', '10.00', 'VENTAS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (40, 40, 24, 'invoice', '10.00', 'VENTAS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (41, 41, 25, 'invoice', '10.00', 'VENTAS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (42, 42, 26, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (43, 43, 26, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (44, 44, 27, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (45, 45, 27, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (46, 46, 28, 'invoice', '10.00', 'VENTAS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (47, 47, 29, 'invoice', '10.00', 'VENTAS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (48, 48, 30, 'invoice', '10.00', 'VENTAS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (49, 49, 31, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (50, 50, 32, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (51, 51, 33, 'invoice', '10.00', 'VENTAS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (52, 52, 34, 'invoice', '10.00', 'VENTAS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (53, 53, 35, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (54, 54, 35, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (56, 56, 36, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (57, 57, 37, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (58, 58, 38, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (60, 60, 39, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (61, 61, 40, 'invoice', '10.00', 'VENTAS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (62, 62, 41, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (63, 63, 42, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (64, 64, 43, 'invoice', '10.00', 'VENTAS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (65, 65, 44, 'invoice', '10.00', 'VENTAS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (66, 66, 45, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (67, 67, 1, 'estimate', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (68, 68, 1, 'estimate', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (69, 69, 46, 'invoice', '10.00', 'VENTAS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (70, 71, 48, 'invoice', '10.00', 'VENTAS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (71, 72, 49, 'invoice', '10.00', 'VENTAS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (72, 73, 50, 'invoice', '10.00', 'VENTAS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (74, 74, 51, 'invoice', '10.00', 'VENTAS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (76, 76, 52, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (77, 77, 53, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (78, 78, 53, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (79, 79, 53, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (80, 80, 54, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (81, 81, 55, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (82, 84, 56, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (83, 85, 57, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (84, 86, 58, 'invoice', '10.00', 'VENTAS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (85, 87, 59, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (86, 88, 60, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (87, 89, 61, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (88, 90, 62, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (89, 91, 63, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (90, 92, 64, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (91, 93, 65, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (92, 94, 66, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (93, 95, 67, 'invoice', '21.00', 'SERVICIOS');
INSERT INTO `tblitem_tax` (`id`, `itemid`, `rel_id`, `rel_type`, `taxrate`, `taxname`) VALUES (94, 96, 68, 'invoice', '21.00', 'SERVICIOS');


#
# TABLE STRUCTURE FOR: tblitemable
#

DROP TABLE IF EXISTS `tblitemable`;

CREATE TABLE `tblitemable` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rel_id` int(11) NOT NULL,
  `rel_type` varchar(15) NOT NULL,
  `description` mediumtext NOT NULL,
  `long_description` mediumtext DEFAULT NULL,
  `qty` decimal(15,2) NOT NULL,
  `rate` decimal(15,2) NOT NULL,
  `unit` varchar(40) DEFAULT NULL,
  `item_order` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `rel_id` (`rel_id`),
  KEY `rel_type` (`rel_type`),
  KEY `qty` (`qty`),
  KEY `rate` (`rate`)
) ENGINE=InnoDB AUTO_INCREMENT=97 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (1, 1, 'invoice', 'G\'VINE', 'SPONSORIZACIÓN BARRA BLIT CONCEPT', '1.00', '3000.00', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (2, 2, 'invoice', 'JOSÉ CUERVO', 'COLABORACIÓN GRUPO MAGMA', '1.00', '1500.00', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (3, 1, 'proposal', 'BOTELLA JUNE BY GVINE', 'A Elegir entre Wild Peach o Royal Pear', '1.00', '100.00', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (4, 2, 'proposal', 'MACALLAN 12 años', 'Copa en vaso de piedra ', '1.00', '10.00', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (5, 2, 'proposal', 'RON BUMBU', 'Ron con sabor a vainilla', '1.00', '7.50', '', 2);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (6, 3, 'proposal', 'ENTRADA MAGMA', 'Día 14 de Mayo', '2.00', '20.00', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (7, 3, 'invoice', 'Visibilidad Marcas DIAGEO', '', '1.00', '4752.00', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (8, 4, 'invoice', 'RESERVA COMIDA', '26 DE DICIEMBRE', '1.00', '227.27', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (9, 5, 'invoice', 'VISIBILIDAD G’VINE', 'GRUPO MAGMA', '1.00', '3000.00', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (10, 6, 'invoice', 'Colaboracion marcas Diageo', '', '1.00', '6840.60', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (11, 7, 'invoice', 'G\'Vine', '', '85.00', '5.00', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (12, 7, 'invoice', 'Nº3', '', '12.00', '5.00', '', 2);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (13, 7, 'invoice', 'June', '', '57.00', '4.00', '', 3);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (14, 7, 'invoice', 'La Quintinye', '', '7.00', '3.00', '', 4);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (15, 7, 'invoice', 'JOSÉ CUERVO', '', '426.00', '3.00', '', 5);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (16, 7, 'invoice', '1800', '', '3.00', '5.00', '', 6);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (17, 7, 'invoice', 'KRAKEN', '', '7.00', '4.00', '', 7);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (18, 7, 'invoice', 'BUMBU', '', '69.00', '2.00', '', 8);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (19, 7, 'invoice', 'BELAIRE', 'DESCONTANDO PEDIDO INICIAL ADELANTADO', '1.00', '693.00', '', 9);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (20, 8, 'invoice', 'COLABORACIÓN', 'COCA COLA', '1.00', '1400.00', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (21, 9, 'invoice', 'ALQUILER CDJ 2000 NEXUS', '', '4.00', '200.00', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (22, 9, 'invoice', 'ALQUILER DJM 900', '', '1.00', '400.00', '', 2);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (23, 9, 'invoice', 'TÉCNICO SONIDO', '', '1.00', '150.00', '', 3);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (24, 9, 'invoice', 'HOTEL + TRANSPORTE + DIETAS', '', '1.00', '300.00', '', 4);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (25, 10, 'invoice', 'Evento empresarial Grupo Hob', '38 MENUS', '38.00', '22.27', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (26, 11, 'invoice', 'ACUERDO COMERCIAL.', '', '1.00', '800.00', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (27, 12, 'invoice', 'ACUERDO COMERCIAL', '', '1.00', '600.00', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (28, 13, 'invoice', 'ACUERDO COMERCIAL', '', '1.00', '500.00', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (29, 14, 'invoice', 'ACUERDO COMERCIAL', '', '1.00', '500.00', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (30, 15, 'invoice', 'ACUERDO COMERCIAL', '', '1.00', '600.00', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (32, 4, 'proposal', 'ANTICIPO', 'Comida Viernes 16 de Diciembre', '1.00', '251.00', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (35, 19, 'invoice', 'Servicios de Restauración', 'Blit Concept', '1.00', '514.00', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (36, 20, 'invoice', 'Servicios de Restauración', 'Blit Concept', '1.00', '99.90', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (37, 21, 'invoice', 'Servicios de Restauración', 'Blit Concept', '1.00', '337.00', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (38, 22, 'invoice', 'Servicios de Restauración', 'Blit Concept', '1.00', '93.18', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (39, 23, 'invoice', 'Servicios de Restauración', 'Blit Concept', '1.00', '47.27', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (40, 24, 'invoice', 'Servicios de Restauración', 'Blit Concept', '1.00', '56.82', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (41, 25, 'invoice', 'Servicios de Restauración', 'Blit Concept', '1.00', '978.00', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (42, 26, 'invoice', 'CONTRATACION FEID 07-08-2022', 'Concierto en Magma Club', '1.00', '26000.00', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (43, 26, 'invoice', 'Gestión contratación y ROE', '', '1.00', '2600.00', '', 2);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (44, 27, 'invoice', 'VENTA VASOS METACRILATO', 'COMPRA A EMPRESA NIPCO ITALIA', '1.00', '7650.00', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (45, 27, 'invoice', 'Gestión logística', 'Desde Roma', '1.00', '520.00', '', 2);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (46, 28, 'invoice', 'Servicios de Restauración', 'En Blit Concept', '1.00', '434.09', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (47, 29, 'invoice', 'Comida 8 de Enero 26 Comensales', '', '1.00', '1044.10', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (48, 30, 'invoice', 'SERVICIOS DE RESTAURACIÓN', 'BLIT CONCEPT', '1.00', '919.18', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (49, 31, 'invoice', 'SERVICIOS PRODUCCIÓN OCEAN RACE 2023', '', '1.00', '1800.00', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (50, 32, 'invoice', 'Colaboración imagen fever tree. ', '', '1.00', '2716.00', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (51, 33, 'invoice', 'SERVICIO DE RESTAURACIÓN', '', '1.00', '20.45', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (52, 34, 'invoice', 'SERVICIOS DE RESTAURACIÓN', '', '1.00', '16.82', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (53, 35, 'invoice', 'ACUERDO JOSÉ CUERVO', '', '1.00', '3389.00', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (54, 35, 'invoice', 'RAPEL BELAIRE', '', '1.00', '202.00', '', 2);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (56, 36, 'invoice', 'RAPEL BUMBU', '', '1.00', '186.00', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (57, 37, 'invoice', 'VISIBILIDAD MARCAS DIAGEO', '', '1.00', '5850.00', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (58, 38, 'invoice', 'COLABORACIÓN MARCAS DIAGEO', '', '1.00', '650.00', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (60, 39, 'invoice', 'Colaboración Marcas Diageo', '', '1.00', '11436.25', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (61, 40, 'invoice', 'SERVICIOS RESTAURACIÓN', '', '1.00', '2336.15', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (62, 41, 'invoice', 'COLABORACIÓN HOGUERAS', '', '1.00', '600.00', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (63, 42, 'invoice', 'SERVICIOS PUBLICITARIOS', 'Gestión y envío SMS nacionales', '1.00', '1340.30', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (64, 43, 'invoice', 'SERVICIOS DE RESTAURACIÓN', 'FIESTA TRABAJADORES', '1.00', '8168.00', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (65, 44, 'invoice', 'SERVICIOS DE RESTAURACIÓN', 'DURANTE EL MES DE SEPTIEMBRE', '1.00', '7428.00', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (66, 45, 'invoice', 'COLABORACIÓN MARCAS DIAGEO', '', '1.00', '2380.90', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (67, 1, 'estimate', 'Prueba', 'Prueba', '1.00', '500.00', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (68, 1, 'estimate', 'Prueba 2', 'Prueba final', '1.00', '500.00', '', 2);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (69, 46, 'invoice', 'PRESTACION SERVICIOS', 'Durante el mes de Octubre y Noviembre', '1.00', '4127.40', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (70, 47, 'invoice', 'SERVICIOS RESTAURACIÓN', '', '1.00', '20.45', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (71, 48, 'invoice', 'SERVICIOS DE RESTAURACIÓN', '', '1.00', '290.09', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (72, 49, 'invoice', 'SERVICIOS DE RESTAURACIÓN', '', '1.00', '57.27', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (73, 50, 'invoice', 'Cena de empresa ESATUR 2023', 'Servicios de restauración y bebidas', '300.00', '15.00', 'Personas', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (74, 51, 'invoice', 'CENA EMPRESA', 'Servicios en restauración', '1.00', '1250.00', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (76, 52, 'invoice', 'ACUERDO DE CONSUMO', '', '1.00', '8868.00', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (77, 53, 'invoice', 'Aportación Comercial', 'José Cuervo', '1.00', '2908.00', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (78, 53, 'invoice', 'Aportación Comercial', 'Gvine', '1.00', '645.00', '', 2);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (79, 53, 'invoice', 'Aportación Comercial', 'June', '1.00', '200.00', '', 3);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (80, 54, 'invoice', 'Acuerdo visibilidad', 'Gvine PO: 2000293982', '1.00', '500.00', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (81, 55, 'invoice', 'DESARROLLO ACCIÓN PUBLICITARIA PARA TEMPORADA 2024-2025 GRUPO MAGMA', 'Creación y confección visibilidad Ad-hoc en taquilla entrada principal y zona Garden. Mano de Santo en Magma Club (sito C/Vial Flora de España 29). ', '2.00', '6000.00', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (82, 55, 'invoice', 'ACCIONES COMERCIALES', 'Venta de producto y referenciación en neveras', '1.00', '0.00', '', 2);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (83, 55, 'invoice', 'ACCIONES DE MARKETING', 'Acciones puntuales azafatas y en redes sociales de todos los locales del grupo empresarial', '1.00', '0.00', '', 3);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (84, 56, 'invoice', 'ACUERDO DE IMAGEN', '', '1.00', '2956.00', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (85, 57, 'invoice', 'Envío de Newsletter y SMS', 'LINK MOBILITY BBDD GRUPO MAGMA', '1.00', '2900.00', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (86, 58, 'invoice', 'SERVICIO CATERING ARTISTAS', '', '1.00', '3399.00', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (87, 59, 'invoice', 'SERVICIOS RESTAURACIÓN', 'Establecimiento KAO LOUNGE', '1.00', '700.00', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (88, 60, 'invoice', 'Acuerdo marketing y visibilidad Gin Zeeland 2023', '', '1.00', '2430.00', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (89, 61, 'invoice', 'Colaboración imagen Fever Tree 2023', '', '1.00', '2182.00', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (90, 62, 'invoice', 'Acuerdo hostelería número de rebate 7000031888', '', '1.00', '21136.00', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (91, 63, 'invoice', 'COLABORACION MARCAS DIAGEO', '', '1.00', '16315.70', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (92, 64, 'invoice', 'VISIBILIDAD MARCAS DIAGEO', '', '1.00', '1950.00', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (93, 65, 'invoice', 'VISIBILIDAD MARCAS DIAGEO', '', '1.00', '100.00', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (94, 66, 'invoice', 'VISIBILIDAD MARCAS DIAGEO', '', '1.00', '950.00', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (95, 67, 'invoice', 'Colaboración Raco Explanada 2024', '', '1.00', '650.00', '', 1);
INSERT INTO `tblitemable` (`id`, `rel_id`, `rel_type`, `description`, `long_description`, `qty`, `rate`, `unit`, `item_order`) VALUES (96, 68, 'invoice', 'ALQUILER CDJ 3000', '', '1.00', '1680.00', '', 1);


#
# TABLE STRUCTURE FOR: tblitems
#

DROP TABLE IF EXISTS `tblitems`;

CREATE TABLE `tblitems` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` mediumtext NOT NULL,
  `long_description` text DEFAULT NULL,
  `rate` decimal(15,2) NOT NULL,
  `tax` int(11) DEFAULT NULL,
  `tax2` int(11) DEFAULT NULL,
  `unit` varchar(40) DEFAULT NULL,
  `group_id` int(11) NOT NULL DEFAULT 0,
  `commodity_code` varchar(100) NOT NULL,
  `commodity_barcode` text DEFAULT NULL,
  `commodity_type` int(11) DEFAULT NULL,
  `warehouse_id` int(11) DEFAULT NULL,
  `origin` varchar(100) DEFAULT NULL,
  `color_id` int(11) DEFAULT NULL,
  `style_id` int(11) DEFAULT NULL,
  `model_id` int(11) DEFAULT NULL,
  `size_id` int(11) DEFAULT NULL,
  `unit_id` int(11) DEFAULT NULL,
  `sku_code` varchar(200) DEFAULT NULL,
  `sku_name` varchar(200) DEFAULT NULL,
  `purchase_price` decimal(15,2) DEFAULT NULL,
  `sub_group` varchar(200) DEFAULT NULL,
  `commodity_name` varchar(200) NOT NULL,
  `color` text DEFAULT NULL,
  `guarantee` text DEFAULT NULL,
  `profif_ratio` text DEFAULT NULL,
  `active` int(11) DEFAULT 1,
  `long_descriptions` longtext DEFAULT NULL,
  `without_checking_warehouse` int(11) DEFAULT 1,
  `series_id` text DEFAULT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `attributes` longtext DEFAULT NULL,
  `parent_attributes` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tax` (`tax`),
  KEY `tax2` (`tax2`),
  KEY `group_id` (`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblitems_groups
#

DROP TABLE IF EXISTS `tblitems_groups`;

CREATE TABLE `tblitems_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `commodity_group_code` varchar(100) DEFAULT NULL,
  `order` int(10) DEFAULT NULL,
  `display` int(1) DEFAULT NULL,
  `note` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblknowedge_base_article_feedback
#

DROP TABLE IF EXISTS `tblknowedge_base_article_feedback`;

CREATE TABLE `tblknowedge_base_article_feedback` (
  `articleanswerid` int(11) NOT NULL AUTO_INCREMENT,
  `articleid` int(11) NOT NULL,
  `answer` int(11) NOT NULL,
  `ip` varchar(40) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`articleanswerid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblknowledge_base
#

DROP TABLE IF EXISTS `tblknowledge_base`;

CREATE TABLE `tblknowledge_base` (
  `articleid` int(11) NOT NULL AUTO_INCREMENT,
  `articlegroup` int(11) NOT NULL,
  `subject` mediumtext NOT NULL,
  `description` text NOT NULL,
  `slug` mediumtext NOT NULL,
  `active` tinyint(4) NOT NULL,
  `datecreated` datetime NOT NULL,
  `article_order` int(11) NOT NULL DEFAULT 0,
  `staff_article` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`articleid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblknowledge_base_groups
#

DROP TABLE IF EXISTS `tblknowledge_base_groups`;

CREATE TABLE `tblknowledge_base_groups` (
  `groupid` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `group_slug` text DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `active` tinyint(4) NOT NULL,
  `color` varchar(10) DEFAULT '#28B8DA',
  `group_order` int(11) DEFAULT 0,
  PRIMARY KEY (`groupid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tbllead_activity_log
#

DROP TABLE IF EXISTS `tbllead_activity_log`;

CREATE TABLE `tbllead_activity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `leadid` int(11) NOT NULL,
  `description` mediumtext NOT NULL,
  `additional_data` text DEFAULT NULL,
  `date` datetime NOT NULL,
  `staffid` int(11) NOT NULL,
  `full_name` varchar(100) DEFAULT NULL,
  `custom_activity` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tbllead_integration_emails
#

DROP TABLE IF EXISTS `tbllead_integration_emails`;

CREATE TABLE `tbllead_integration_emails` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `subject` mediumtext DEFAULT NULL,
  `body` mediumtext DEFAULT NULL,
  `dateadded` datetime NOT NULL,
  `leadid` int(11) NOT NULL,
  `emailid` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblleads
#

DROP TABLE IF EXISTS `tblleads`;

CREATE TABLE `tblleads` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `hash` varchar(65) DEFAULT NULL,
  `name` varchar(191) NOT NULL,
  `title` varchar(100) DEFAULT NULL,
  `company` varchar(191) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `country` int(11) NOT NULL DEFAULT 0,
  `zip` varchar(15) DEFAULT NULL,
  `city` varchar(100) DEFAULT NULL,
  `state` varchar(50) DEFAULT NULL,
  `address` varchar(100) DEFAULT NULL,
  `assigned` int(11) NOT NULL DEFAULT 0,
  `dateadded` datetime NOT NULL,
  `from_form_id` int(11) NOT NULL DEFAULT 0,
  `status` int(11) NOT NULL,
  `source` int(11) NOT NULL,
  `lastcontact` datetime DEFAULT NULL,
  `dateassigned` date DEFAULT NULL,
  `last_status_change` datetime DEFAULT NULL,
  `addedfrom` int(11) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `website` varchar(150) DEFAULT NULL,
  `leadorder` int(11) DEFAULT 1,
  `phonenumber` varchar(50) DEFAULT NULL,
  `date_converted` datetime DEFAULT NULL,
  `lost` tinyint(1) NOT NULL DEFAULT 0,
  `junk` int(11) NOT NULL DEFAULT 0,
  `last_lead_status` int(11) NOT NULL DEFAULT 0,
  `is_imported_from_email_integration` tinyint(1) NOT NULL DEFAULT 0,
  `email_integration_uid` varchar(30) DEFAULT NULL,
  `is_public` tinyint(1) NOT NULL DEFAULT 0,
  `default_language` varchar(40) DEFAULT NULL,
  `client_id` int(11) NOT NULL DEFAULT 0,
  `lead_value` decimal(15,2) DEFAULT NULL,
  `vat` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `name` (`name`),
  KEY `company` (`company`),
  KEY `email` (`email`),
  KEY `assigned` (`assigned`),
  KEY `status` (`status`),
  KEY `source` (`source`),
  KEY `lastcontact` (`lastcontact`),
  KEY `dateadded` (`dateadded`),
  KEY `leadorder` (`leadorder`),
  KEY `from_form_id` (`from_form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblleads_email_integration
#

DROP TABLE IF EXISTS `tblleads_email_integration`;

CREATE TABLE `tblleads_email_integration` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'the ID always must be 1',
  `active` int(11) NOT NULL,
  `email` varchar(100) NOT NULL,
  `imap_server` varchar(100) NOT NULL,
  `password` mediumtext NOT NULL,
  `check_every` int(11) NOT NULL DEFAULT 5,
  `responsible` int(11) NOT NULL,
  `lead_source` int(11) NOT NULL,
  `lead_status` int(11) NOT NULL,
  `encryption` varchar(3) DEFAULT NULL,
  `folder` varchar(100) NOT NULL,
  `last_run` varchar(50) DEFAULT NULL,
  `notify_lead_imported` tinyint(1) NOT NULL DEFAULT 1,
  `notify_lead_contact_more_times` tinyint(1) NOT NULL DEFAULT 1,
  `notify_type` varchar(20) DEFAULT NULL,
  `notify_ids` mediumtext DEFAULT NULL,
  `mark_public` int(11) NOT NULL DEFAULT 0,
  `only_loop_on_unseen_emails` tinyint(1) NOT NULL DEFAULT 1,
  `delete_after_import` int(11) NOT NULL DEFAULT 0,
  `create_task_if_customer` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblleads_email_integration` (`id`, `active`, `email`, `imap_server`, `password`, `check_every`, `responsible`, `lead_source`, `lead_status`, `encryption`, `folder`, `last_run`, `notify_lead_imported`, `notify_lead_contact_more_times`, `notify_type`, `notify_ids`, `mark_public`, `only_loop_on_unseen_emails`, `delete_after_import`, `create_task_if_customer`) VALUES (1, 0, '', '', '', 10, 0, 0, 0, 'tls', 'INBOX', '', 1, 1, 'assigned', '', 0, 1, 0, 1);


#
# TABLE STRUCTURE FOR: tblleads_sources
#

DROP TABLE IF EXISTS `tblleads_sources`;

CREATE TABLE `tblleads_sources` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblleads_sources` (`id`, `name`) VALUES (2, 'Facebook');
INSERT INTO `tblleads_sources` (`id`, `name`) VALUES (1, 'Google');


#
# TABLE STRUCTURE FOR: tblleads_status
#

DROP TABLE IF EXISTS `tblleads_status`;

CREATE TABLE `tblleads_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `statusorder` int(11) DEFAULT NULL,
  `color` varchar(10) DEFAULT '#28B8DA',
  `isdefault` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblleads_status` (`id`, `name`, `statusorder`, `color`, `isdefault`) VALUES (1, 'Customer', 1000, '#7cb342', 1);


#
# TABLE STRUCTURE FOR: tblleave_of_the_year
#

DROP TABLE IF EXISTS `tblleave_of_the_year`;

CREATE TABLE `tblleave_of_the_year` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) NOT NULL,
  `value` double DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `add_from` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblmail_queue
#

DROP TABLE IF EXISTS `tblmail_queue`;

CREATE TABLE `tblmail_queue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `engine` varchar(40) DEFAULT NULL,
  `email` varchar(191) NOT NULL,
  `cc` text DEFAULT NULL,
  `bcc` text DEFAULT NULL,
  `message` mediumtext NOT NULL,
  `alt_message` mediumtext DEFAULT NULL,
  `status` enum('pending','sending','sent','failed') DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `headers` text DEFAULT NULL,
  `attachments` mediumtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblmanage_leave
#

DROP TABLE IF EXISTS `tblmanage_leave`;

CREATE TABLE `tblmanage_leave` (
  `leave_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `id_staff` int(11) NOT NULL,
  `leave_date` int(11) DEFAULT NULL,
  `leave_year` int(11) DEFAULT NULL,
  `accumulated_leave` int(11) DEFAULT NULL,
  `seniority_leave` int(11) DEFAULT NULL,
  `borrow_leave` int(11) DEFAULT NULL,
  `actual_leave` int(11) DEFAULT NULL,
  `expected_leave` int(11) DEFAULT NULL,
  PRIMARY KEY (`leave_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblmigrations
#

DROP TABLE IF EXISTS `tblmigrations`;

CREATE TABLE `tblmigrations` (
  `version` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblmigrations` (`version`) VALUES ('314');


#
# TABLE STRUCTURE FOR: tblmilestones
#

DROP TABLE IF EXISTS `tblmilestones`;

CREATE TABLE `tblmilestones` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `description_visible_to_customer` tinyint(1) DEFAULT 0,
  `start_date` date DEFAULT NULL,
  `due_date` date NOT NULL,
  `project_id` int(11) NOT NULL,
  `color` varchar(10) DEFAULT NULL,
  `milestone_order` int(11) NOT NULL DEFAULT 0,
  `datecreated` date NOT NULL,
  `hide_from_customer` int(11) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblmodules
#

DROP TABLE IF EXISTS `tblmodules`;

CREATE TABLE `tblmodules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `module_name` varchar(55) NOT NULL,
  `installed_version` varchar(11) NOT NULL,
  `active` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblmodules` (`id`, `module_name`, `installed_version`, `active`) VALUES (1, 'flat_admin_theme', '1.0', 0);
INSERT INTO `tblmodules` (`id`, `module_name`, `installed_version`, `active`) VALUES (2, 'theme_style', '2.3.0', 1);
INSERT INTO `tblmodules` (`id`, `module_name`, `installed_version`, `active`) VALUES (3, 'accounting', '1.0.5', 0);
INSERT INTO `tblmodules` (`id`, `module_name`, `installed_version`, `active`) VALUES (4, 'warehouse', '1.1.7', 0);
INSERT INTO `tblmodules` (`id`, `module_name`, `installed_version`, `active`) VALUES (5, 'timesheets', '1.1.8', 0);
INSERT INTO `tblmodules` (`id`, `module_name`, `installed_version`, `active`) VALUES (6, 'resourcebooking', '1.0.0', 1);
INSERT INTO `tblmodules` (`id`, `module_name`, `installed_version`, `active`) VALUES (7, 'account_balances', '1.0.3', 1);
INSERT INTO `tblmodules` (`id`, `module_name`, `installed_version`, `active`) VALUES (8, 'backup', '2.3.0', 1);


#
# TABLE STRUCTURE FOR: tblnewsfeed_comment_likes
#

DROP TABLE IF EXISTS `tblnewsfeed_comment_likes`;

CREATE TABLE `tblnewsfeed_comment_likes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `postid` int(11) NOT NULL,
  `commentid` int(11) NOT NULL,
  `userid` int(11) NOT NULL,
  `dateliked` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblnewsfeed_post_comments
#

DROP TABLE IF EXISTS `tblnewsfeed_post_comments`;

CREATE TABLE `tblnewsfeed_post_comments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `content` text DEFAULT NULL,
  `userid` int(11) NOT NULL,
  `postid` int(11) NOT NULL,
  `dateadded` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblnewsfeed_post_likes
#

DROP TABLE IF EXISTS `tblnewsfeed_post_likes`;

CREATE TABLE `tblnewsfeed_post_likes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `postid` int(11) NOT NULL,
  `userid` int(11) NOT NULL,
  `dateliked` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblnewsfeed_posts
#

DROP TABLE IF EXISTS `tblnewsfeed_posts`;

CREATE TABLE `tblnewsfeed_posts` (
  `postid` int(11) NOT NULL AUTO_INCREMENT,
  `creator` int(11) NOT NULL,
  `datecreated` datetime NOT NULL,
  `visibility` varchar(100) NOT NULL,
  `content` text NOT NULL,
  `pinned` int(11) NOT NULL,
  `datepinned` datetime DEFAULT NULL,
  PRIMARY KEY (`postid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblnotes
#

DROP TABLE IF EXISTS `tblnotes`;

CREATE TABLE `tblnotes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rel_id` int(11) NOT NULL,
  `rel_type` varchar(20) NOT NULL,
  `description` text DEFAULT NULL,
  `date_contacted` datetime DEFAULT NULL,
  `addedfrom` int(11) NOT NULL,
  `dateadded` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `rel_id` (`rel_id`),
  KEY `rel_type` (`rel_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblnotifications
#

DROP TABLE IF EXISTS `tblnotifications`;

CREATE TABLE `tblnotifications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `isread` int(11) NOT NULL DEFAULT 0,
  `isread_inline` tinyint(1) NOT NULL DEFAULT 0,
  `date` datetime NOT NULL,
  `description` text NOT NULL,
  `fromuserid` int(11) NOT NULL,
  `fromclientid` int(11) NOT NULL DEFAULT 0,
  `from_fullname` varchar(100) NOT NULL,
  `touserid` int(11) NOT NULL,
  `fromcompany` int(11) DEFAULT NULL,
  `link` mediumtext DEFAULT NULL,
  `additional_data` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblnotifications` (`id`, `isread`, `isread_inline`, `date`, `description`, `fromuserid`, `fromclientid`, `from_fullname`, `touserid`, `fromcompany`, `link`, `additional_data`) VALUES (1, 1, 0, '2022-12-16 17:42:51', 'not_customer_viewed_invoice', 0, 0, '', 1, 1, 'invoices/list_invoices/22', 'a:1:{i:0;s:9:\"FA-000019\";}');
INSERT INTO `tblnotifications` (`id`, `isread`, `isread_inline`, `date`, `description`, `fromuserid`, `fromclientid`, `from_fullname`, `touserid`, `fromcompany`, `link`, `additional_data`) VALUES (2, 1, 0, '2024-02-23 14:14:23', 'not_customer_viewed_invoice', 0, 0, '', 1, 1, 'invoices/list_invoices/58', 'a:1:{i:0;s:9:\"FA-000055\";}');
INSERT INTO `tblnotifications` (`id`, `isread`, `isread_inline`, `date`, `description`, `fromuserid`, `fromclientid`, `from_fullname`, `touserid`, `fromcompany`, `link`, `additional_data`) VALUES (3, 0, 0, '2024-03-13 17:34:01', 'not_task_assigned_to_you', 1, 0, 'Mario Puche', 5, NULL, '#taskid=2', 'a:1:{i:0;s:5:\"Magma\";}');
INSERT INTO `tblnotifications` (`id`, `isread`, `isread_inline`, `date`, `description`, `fromuserid`, `fromclientid`, `from_fullname`, `touserid`, `fromcompany`, `link`, `additional_data`) VALUES (4, 0, 0, '2024-09-23 15:27:36', 'Ubicacaciones que controlas Orlas dia 12', 1, 0, 'Mario Puche', 2, NULL, 'resourcebooking/booking/1', 'a:1:{i:0;s:12:\"Orlas dia 12\";}');
INSERT INTO `tblnotifications` (`id`, `isread`, `isread_inline`, `date`, `description`, `fromuserid`, `fromclientid`, `from_fullname`, `touserid`, `fromcompany`, `link`, `additional_data`) VALUES (5, 0, 0, '2024-09-23 19:27:56', 'Ubicacaciones que controlas dsfsdf', 1, 0, 'Mario Puche', 2, NULL, 'resourcebooking/booking/2', 'a:1:{i:0;s:6:\"dsfsdf\";}');


#
# TABLE STRUCTURE FOR: tbloptions
#

DROP TABLE IF EXISTS `tbloptions`;

CREATE TABLE `tbloptions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `value` longtext NOT NULL,
  `autoload` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=506 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (1, 'dateformat', 'd/m/Y|%d/%m/%Y', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (2, 'companyname', 'RACO EXPLANADA SL', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (3, 'services', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (4, 'maximum_allowed_ticket_attachments', '4', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (5, 'ticket_attachments_file_extensions', '.jpg,.png,.pdf,.doc,.zip,.rar', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (6, 'staff_access_only_assigned_departments', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (7, 'use_knowledge_base', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (8, 'smtp_email', 'info@blitconcept.es', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (9, 'smtp_password', '0ea3b4b995debaf4a760787027a6f710b7a791a72df8014b63977463024bf9e8ce9ed15f32e75af7ca93620e6643f40ee43bf638436979e2149e25a97f0efa70BmkO0EkU0nYsaQST6Yq5MokbewfO209sz2TQy+bGZsg=', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (10, 'company_info_format', '{company_name}<br />\r\n<br />\r\n{address}<br />\r\n<br />\r\n{city} {state}<br />\r\n<br />\r\n{country_code} {zip_code}<br />\r\n<br />\r\n{vat_number_with_label}', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (11, 'smtp_port', '465', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (12, 'smtp_host', 'mail.blitconcept.es', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (13, 'smtp_email_charset', 'utf-8', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (14, 'default_timezone', 'Europe/Madrid', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (15, 'clients_default_theme', 'perfex', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (16, 'company_logo', 'd9914fc67ec72c7dc91b4a7c23f2f5d2.png', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (17, 'tables_pagination_limit', '25', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (18, 'main_domain', 'blitconcept.es', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (19, 'allow_registration', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (20, 'knowledge_base_without_registration', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (21, 'email_signature', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (22, 'default_staff_role', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (23, 'newsfeed_maximum_files_upload', '10', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (24, 'contract_expiration_before', '4', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (25, 'invoice_prefix', 'FA-', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (26, 'decimal_separator', '.', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (27, 'thousand_separator', ',', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (28, 'invoice_company_name', 'RACO EXPLANADA SL', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (29, 'invoice_company_address', 'Calle Arturo 19 1derecha', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (30, 'invoice_company_city', 'Alicante', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (31, 'invoice_company_country_code', 'España', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (32, 'invoice_company_postal_code', '03007', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (33, 'invoice_company_phonenumber', '678587693', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (34, 'view_invoice_only_logged_in', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (35, 'invoice_number_format', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (36, 'next_invoice_number', '66', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (37, 'active_language', 'spanish', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (38, 'invoice_number_decrement_on_delete', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (39, 'automatically_send_invoice_overdue_reminder_after', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (40, 'automatically_resend_invoice_overdue_reminder_after', '3', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (41, 'expenses_auto_operations_hour', '21', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (42, 'delete_only_on_last_invoice', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (43, 'delete_only_on_last_estimate', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (44, 'create_invoice_from_recurring_only_on_paid_invoices', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (45, 'allow_payment_amount_to_be_modified', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (46, 'rtl_support_client', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (47, 'limit_top_search_bar_results_to', '10', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (48, 'estimate_prefix', 'EST-', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (49, 'next_estimate_number', '2', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (50, 'estimate_number_decrement_on_delete', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (51, 'estimate_number_format', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (52, 'estimate_auto_convert_to_invoice_on_client_accept', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (53, 'exclude_estimate_from_client_area_with_draft_status', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (54, 'rtl_support_admin', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (55, 'last_cron_run', '1727296202', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (56, 'show_sale_agent_on_estimates', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (57, 'show_sale_agent_on_invoices', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (58, 'predefined_terms_invoice', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (59, 'predefined_terms_estimate', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (60, 'default_task_priority', '2', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (61, 'dropbox_app_key', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (62, 'show_expense_reminders_on_calendar', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (63, 'only_show_contact_tickets', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (64, 'predefined_clientnote_invoice', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (65, 'predefined_clientnote_estimate', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (66, 'custom_pdf_logo_image_url', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (67, 'favicon', 'favicon.png', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (68, 'invoice_due_after', '30', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (69, 'google_api_key', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (70, 'google_calendar_main_calendar', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (71, 'default_tax', 'a:0:{}', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (72, 'show_invoices_on_calendar', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (73, 'show_estimates_on_calendar', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (74, 'show_contracts_on_calendar', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (75, 'show_tasks_on_calendar', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (76, 'show_customer_reminders_on_calendar', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (77, 'output_client_pdfs_from_admin_area_in_client_language', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (78, 'show_lead_reminders_on_calendar', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (79, 'send_estimate_expiry_reminder_before', '4', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (80, 'leads_default_source', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (81, 'leads_default_status', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (82, 'proposal_expiry_reminder_enabled', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (83, 'send_proposal_expiry_reminder_before', '4', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (84, 'default_contact_permissions', 'a:6:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";i:4;s:1:\"5\";i:5;s:1:\"6\";}', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (85, 'pdf_logo_width', '150', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (86, 'access_tickets_to_none_staff_members', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (87, 'customer_default_country', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (88, 'view_estimate_only_logged_in', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (89, 'show_status_on_pdf_ei', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (90, 'email_piping_only_replies', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (91, 'email_piping_only_registered', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (92, 'default_view_calendar', 'dayGridMonth', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (93, 'email_piping_default_priority', '2', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (94, 'total_to_words_lowercase', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (95, 'show_tax_per_item', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (96, 'total_to_words_enabled', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (97, 'receive_notification_on_new_ticket', '1', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (98, 'autoclose_tickets_after', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (99, 'media_max_file_size_upload', '10', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (100, 'client_staff_add_edit_delete_task_comments_first_hour', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (101, 'show_projects_on_calendar', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (102, 'leads_kanban_limit', '50', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (103, 'tasks_reminder_notification_before', '2', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (104, 'pdf_font', 'freesans', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (105, 'pdf_table_heading_color', '#323a45', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (106, 'pdf_table_heading_text_color', '#ffffff', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (107, 'pdf_font_size', '10', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (108, 'default_leads_kanban_sort', 'leadorder', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (109, 'default_leads_kanban_sort_type', 'asc', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (110, 'allowed_files', '.png,.jpg,.pdf,.doc,.docx,.xls,.xlsx,.zip,.rar,.txt', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (111, 'show_all_tasks_for_project_member', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (112, 'email_protocol', 'smtp', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (113, 'calendar_first_day', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (114, 'recaptcha_secret_key', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (115, 'show_help_on_setup_menu', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (116, 'show_proposals_on_calendar', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (117, 'smtp_encryption', 'ssl', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (118, 'recaptcha_site_key', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (119, 'smtp_username', 'info@blitconcept.es', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (120, 'auto_stop_tasks_timers_on_new_timer', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (121, 'notification_when_customer_pay_invoice', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (122, 'calendar_invoice_color', '#ff6f00', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (123, 'calendar_estimate_color', '#ff6f00', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (124, 'calendar_proposal_color', '#84c529', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (125, 'new_task_auto_assign_current_member', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (126, 'calendar_reminder_color', '#03a9f4', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (127, 'calendar_contract_color', '#b72974', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (128, 'calendar_project_color', '#b72974', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (129, 'update_info_message', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (130, 'show_estimate_reminders_on_calendar', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (131, 'show_invoice_reminders_on_calendar', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (132, 'show_proposal_reminders_on_calendar', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (133, 'proposal_due_after', '7', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (134, 'allow_customer_to_change_ticket_status', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (135, 'lead_lock_after_convert_to_customer', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (136, 'default_proposals_pipeline_sort', 'pipeline_order', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (137, 'default_proposals_pipeline_sort_type', 'asc', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (138, 'default_estimates_pipeline_sort', 'pipeline_order', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (139, 'default_estimates_pipeline_sort_type', 'asc', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (140, 'use_recaptcha_customers_area', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (141, 'remove_decimals_on_zero', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (142, 'remove_tax_name_from_item_table', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (143, 'pdf_format_invoice', 'A4-PORTRAIT', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (144, 'pdf_format_estimate', 'A4-PORTRAIT', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (145, 'pdf_format_proposal', 'A4-PORTRAIT', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (146, 'pdf_format_payment', 'A4-PORTRAIT', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (147, 'pdf_format_contract', 'A4-PORTRAIT', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (148, 'swap_pdf_info', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (149, 'exclude_invoice_from_client_area_with_draft_status', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (150, 'cron_has_run_from_cli', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (151, 'hide_cron_is_required_message', '0', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (152, 'auto_assign_customer_admin_after_lead_convert', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (153, 'show_transactions_on_invoice_pdf', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (154, 'show_pay_link_to_invoice_pdf', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (155, 'tasks_kanban_limit', '50', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (156, 'purchase_key', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (157, 'estimates_pipeline_limit', '50', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (158, 'proposals_pipeline_limit', '50', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (159, 'proposal_number_prefix', 'PROFORMA-', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (160, 'number_padding_prefixes', '6', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (161, 'show_page_number_on_pdf', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (162, 'calendar_events_limit', '4', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (163, 'show_setup_menu_item_only_on_hover', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (164, 'company_requires_vat_number_field', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (165, 'company_is_required', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (166, 'allow_contact_to_delete_files', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (167, 'company_vat', 'B42509554', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (168, 'di', '1612693215', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (169, 'invoice_auto_operations_hour', '21', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (170, 'use_minified_files', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (171, 'only_own_files_contacts', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (172, 'allow_primary_contact_to_view_edit_billing_and_shipping', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (173, 'estimate_due_after', '7', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (174, 'staff_members_open_tickets_to_all_contacts', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (175, 'time_format', '24', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (176, 'delete_activity_log_older_then', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (177, 'disable_language', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (178, 'company_state', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (179, 'email_header', '<!doctype html>\r\n                            <html>\r\n                            <head>\r\n                              <meta name=\"viewport\" content=\"width=device-width\" />\r\n                              <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />\r\n                              <style>\r\n                                body {\r\n                                 background-color: #f6f6f6;\r\n                                 font-family: sans-serif;\r\n                                 -webkit-font-smoothing: antialiased;\r\n                                 font-size: 14px;\r\n                                 line-height: 1.4;\r\n                                 margin: 0;\r\n                                 padding: 0;\r\n                                 -ms-text-size-adjust: 100%;\r\n                                 -webkit-text-size-adjust: 100%;\r\n                               }\r\n                               table {\r\n                                 border-collapse: separate;\r\n                                 mso-table-lspace: 0pt;\r\n                                 mso-table-rspace: 0pt;\r\n                                 width: 100%;\r\n                               }\r\n                               table td {\r\n                                 font-family: sans-serif;\r\n                                 font-size: 14px;\r\n                                 vertical-align: top;\r\n                               }\r\n                                   /* -------------------------------------\r\n                                     BODY & CONTAINER\r\n                                     ------------------------------------- */\r\n                                     .body {\r\n                                       background-color: #f6f6f6;\r\n                                       width: 100%;\r\n                                     }\r\n                                     /* Set a max-width, and make it display as block so it will automatically stretch to that width, but will also shrink down on a phone or something */\r\n\r\n                                     .container {\r\n                                       display: block;\r\n                                       margin: 0 auto !important;\r\n                                       /* makes it centered */\r\n                                       max-width: 680px;\r\n                                       padding: 10px;\r\n                                       width: 680px;\r\n                                     }\r\n                                     /* This should also be a block element, so that it will fill 100% of the .container */\r\n\r\n                                     .content {\r\n                                       box-sizing: border-box;\r\n                                       display: block;\r\n                                       margin: 0 auto;\r\n                                       max-width: 680px;\r\n                                       padding: 10px;\r\n                                     }\r\n                                   /* -------------------------------------\r\n                                     HEADER, FOOTER, MAIN\r\n                                     ------------------------------------- */\r\n\r\n                                     .main {\r\n                                       background: #fff;\r\n                                       border-radius: 3px;\r\n                                       width: 100%;\r\n                                     }\r\n                                     .wrapper {\r\n                                       box-sizing: border-box;\r\n                                       padding: 20px;\r\n                                     }\r\n                                     .footer {\r\n                                       clear: both;\r\n                                       padding-top: 10px;\r\n                                       text-align: center;\r\n                                       width: 100%;\r\n                                     }\r\n                                     .footer td,\r\n                                     .footer p,\r\n                                     .footer span,\r\n                                     .footer a {\r\n                                       color: #999999;\r\n                                       font-size: 12px;\r\n                                       text-align: center;\r\n                                     }\r\n                                     hr {\r\n                                       border: 0;\r\n                                       border-bottom: 1px solid #f6f6f6;\r\n                                       margin: 20px 0;\r\n                                     }\r\n                                   /* -------------------------------------\r\n                                     RESPONSIVE AND MOBILE FRIENDLY STYLES\r\n                                     ------------------------------------- */\r\n\r\n                                     @media only screen and (max-width: 620px) {\r\n                                       table[class=body] .content {\r\n                                         padding: 0 !important;\r\n                                       }\r\n                                       table[class=body] .container {\r\n                                         padding: 0 !important;\r\n                                         width: 100% !important;\r\n                                       }\r\n                                       table[class=body] .main {\r\n                                         border-left-width: 0 !important;\r\n                                         border-radius: 0 !important;\r\n                                         border-right-width: 0 !important;\r\n                                       }\r\n                                     }\r\n                                   </style>\r\n                                 </head>\r\n                                 <body class=\"\">\r\n                                  <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"body\">\r\n                                    <tr>\r\n                                     <td>&nbsp;</td>\r\n                                     <td class=\"container\">\r\n                                      <div class=\"content\">\r\n                                        <!-- START CENTERED WHITE CONTAINER -->\r\n                                        <table class=\"main\">\r\n                                          <!-- START MAIN CONTENT AREA -->\r\n                                          <tr>\r\n                                           <td class=\"wrapper\">\r\n                                            <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\r\n                                              <tr>\r\n                                               <td>', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (180, 'show_pdf_signature_invoice', '1', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (181, 'show_pdf_signature_estimate', '1', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (182, 'signature_image', '', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (184, 'email_footer', '</td>\r\n                             </tr>\r\n                           </table>\r\n                         </td>\r\n                       </tr>\r\n                       <!-- END MAIN CONTENT AREA -->\r\n                     </table>\r\n                     <!-- START FOOTER -->\r\n                     <div class=\"footer\">\r\n                      <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\r\n                        <tr>\r\n                          <td class=\"content-block\">\r\n                            <span>{companyname}</span>\r\n                          </td>\r\n                        </tr>\r\n                      </table>\r\n                    </div>\r\n                    <!-- END FOOTER -->\r\n                    <!-- END CENTERED WHITE CONTAINER -->\r\n                  </div>\r\n                </td>\r\n                <td>&nbsp;</td>\r\n              </tr>\r\n            </table>\r\n            </body>\r\n            </html>', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (185, 'exclude_proposal_from_client_area_with_draft_status', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (186, 'pusher_app_key', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (187, 'pusher_app_secret', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (188, 'pusher_app_id', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (189, 'pusher_realtime_notifications', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (190, 'pdf_format_statement', 'A4-PORTRAIT', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (191, 'pusher_cluster', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (192, 'show_table_export_button', 'to_all', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (193, 'allow_staff_view_proposals_assigned', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (194, 'show_cloudflare_notice', '0', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (195, 'task_modal_class', 'modal-lg', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (196, 'lead_modal_class', 'modal-lg', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (197, 'show_timesheets_overview_all_members_notice_admins', '1', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (198, 'desktop_notifications', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (199, 'hide_notified_reminders_from_calendar', '1', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (200, 'customer_info_format', '{company_name}<br />\r\n<br />\r\n{street}<br />\r\n<br />\r\n{city} {state}<br />\r\n<br />\r\n{country_code} {zip_code}<br />\r\n<br />\r\n{vat_number_with_label}', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (201, 'timer_started_change_status_in_progress', '1', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (202, 'default_ticket_reply_status', '3', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (203, 'default_task_status', 'auto', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (204, 'email_queue_skip_with_attachments', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (205, 'email_queue_enabled', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (206, 'last_email_queue_retry', '1727296202', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (207, 'auto_dismiss_desktop_notifications_after', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (208, 'proposal_info_format', '{proposal_to}<br />\r\n<br />\r\n{address}<br />\r\n<br />\r\n{city} {state}<br />\r\n<br />\r\n{country_code} {zip_code}<br />\r\n<br />\r\n{phone}<br />\r\n<br />\r\n{email}', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (209, 'ticket_replies_order', 'asc', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (210, 'new_recurring_invoice_action', 'generate_and_send', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (211, 'bcc_emails', '', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (212, 'email_templates_language_checks', '', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (213, 'proposal_accept_identity_confirmation', '1', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (214, 'estimate_accept_identity_confirmation', '1', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (215, 'new_task_auto_follower_current_member', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (216, 'task_biillable_checked_on_creation', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (217, 'predefined_clientnote_credit_note', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (218, 'predefined_terms_credit_note', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (219, 'next_credit_note_number', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (220, 'credit_note_prefix', 'CN-', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (221, 'credit_note_number_decrement_on_delete', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (222, 'pdf_format_credit_note', 'A4-PORTRAIT', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (223, 'show_pdf_signature_credit_note', '1', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (224, 'show_credit_note_reminders_on_calendar', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (225, 'show_amount_due_on_invoice', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (226, 'show_total_paid_on_invoice', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (227, 'show_credits_applied_on_invoice', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (228, 'staff_members_create_inline_lead_status', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (229, 'staff_members_create_inline_customer_groups', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (230, 'staff_members_create_inline_ticket_services', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (231, 'staff_members_save_tickets_predefined_replies', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (232, 'staff_members_create_inline_contract_types', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (233, 'staff_members_create_inline_expense_categories', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (234, 'show_project_on_credit_note', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (235, 'proposals_auto_operations_hour', '21', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (236, 'estimates_auto_operations_hour', '21', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (237, 'contracts_auto_operations_hour', '21', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (238, 'credit_note_number_format', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (239, 'allow_non_admin_members_to_import_leads', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (240, 'e_sign_legal_text', 'By clicking on \"Sign\", I consent to be legally bound by this electronic representation of my signature.', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (241, 'show_pdf_signature_contract', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (242, 'view_contract_only_logged_in', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (243, 'show_subscriptions_in_customers_area', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (244, 'calendar_only_assigned_tasks', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (245, 'after_subscription_payment_captured', 'send_invoice_and_receipt', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (246, 'mail_engine', 'phpmailer', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (247, 'gdpr_enable_terms_and_conditions', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (248, 'privacy_policy', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (249, 'terms_and_conditions', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (250, 'gdpr_enable_terms_and_conditions_lead_form', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (251, 'gdpr_enable_terms_and_conditions_ticket_form', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (252, 'gdpr_contact_enable_right_to_be_forgotten', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (253, 'show_gdpr_in_customers_menu', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (254, 'show_gdpr_link_in_footer', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (255, 'enable_gdpr', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (256, 'gdpr_on_forgotten_remove_invoices_credit_notes', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (257, 'gdpr_on_forgotten_remove_estimates', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (258, 'gdpr_enable_consent_for_contacts', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (259, 'gdpr_consent_public_page_top_block', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (260, 'gdpr_page_top_information_block', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (261, 'gdpr_enable_lead_public_form', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (262, 'gdpr_show_lead_custom_fields_on_public_form', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (263, 'gdpr_lead_attachments_on_public_form', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (264, 'gdpr_enable_consent_for_leads', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (265, 'gdpr_lead_enable_right_to_be_forgotten', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (266, 'allow_staff_view_invoices_assigned', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (267, 'gdpr_data_portability_leads', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (268, 'gdpr_lead_data_portability_allowed', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (269, 'gdpr_contact_data_portability_allowed', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (270, 'gdpr_data_portability_contacts', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (271, 'allow_staff_view_estimates_assigned', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (272, 'gdpr_after_lead_converted_delete', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (273, 'gdpr_show_terms_and_conditions_in_footer', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (274, 'save_last_order_for_tables', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (275, 'company_logo_dark', '33e32d2e42a2ae1514e6e5c56304347c.png', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (276, 'customers_register_require_confirmation', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (277, 'allow_non_admin_staff_to_delete_ticket_attachments', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (278, 'receive_notification_on_new_ticket_replies', '1', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (279, 'google_client_id', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (280, 'enable_google_picker', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (281, 'show_ticket_reminders_on_calendar', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (282, 'ticket_import_reply_only', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (283, 'visible_customer_profile_tabs', 'all', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (284, 'show_project_on_invoice', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (285, 'show_project_on_estimate', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (286, 'staff_members_create_inline_lead_source', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (287, 'lead_unique_validation', '[\"email\"]', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (288, 'last_upgrade_copy_data', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (289, 'custom_js_admin_scripts', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (290, 'custom_js_customer_scripts', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (291, 'stripe_webhook_id', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (292, 'stripe_webhook_signing_secret', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (293, 'stripe_ideal_webhook_id', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (294, 'stripe_ideal_webhook_signing_secret', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (295, 'show_php_version_notice', '1', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (296, 'recaptcha_ignore_ips', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (297, 'show_task_reminders_on_calendar', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (298, 'customer_settings', 'true', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (299, 'tasks_reminder_notification_hour', '21', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (300, 'allow_primary_contact_to_manage_other_contacts', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (301, 'items_table_amounts_exclude_currency_symbol', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (302, 'round_off_task_timer_option', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (303, 'round_off_task_timer_time', '5', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (304, 'bitly_access_token', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (306, 'sms_clickatell_api_key', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (307, 'sms_clickatell_active', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (308, 'sms_clickatell_initialized', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (309, 'sms_msg91_sender_id', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (310, 'sms_msg91_api_type', 'api', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (311, 'sms_msg91_auth_key', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (312, 'sms_msg91_active', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (313, 'sms_msg91_initialized', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (314, 'sms_twilio_account_sid', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (315, 'sms_twilio_auth_token', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (316, 'sms_twilio_phone_number', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (317, 'sms_twilio_active', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (318, 'sms_twilio_initialized', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (319, 'paymentmethod_authorize_acceptjs_active', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (320, 'paymentmethod_authorize_acceptjs_label', 'Authorize.net Accept.js', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (321, 'paymentmethod_authorize_acceptjs_public_key', '', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (322, 'paymentmethod_authorize_acceptjs_api_login_id', '', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (323, 'paymentmethod_authorize_acceptjs_api_transaction_key', '', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (324, 'paymentmethod_authorize_acceptjs_description_dashboard', 'Payment for Invoice {invoice_number}', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (325, 'paymentmethod_authorize_acceptjs_currencies', 'USD', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (326, 'paymentmethod_authorize_acceptjs_test_mode_enabled', '0', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (327, 'paymentmethod_authorize_acceptjs_default_selected', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (328, 'paymentmethod_authorize_acceptjs_initialized', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (329, 'paymentmethod_instamojo_active', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (330, 'paymentmethod_instamojo_label', 'Instamojo', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (331, 'paymentmethod_instamojo_api_key', '', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (332, 'paymentmethod_instamojo_auth_token', '', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (333, 'paymentmethod_instamojo_description_dashboard', 'Payment for Invoice {invoice_number}', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (334, 'paymentmethod_instamojo_currencies', 'INR', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (335, 'paymentmethod_instamojo_test_mode_enabled', '1', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (336, 'paymentmethod_instamojo_default_selected', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (337, 'paymentmethod_instamojo_initialized', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (338, 'paymentmethod_mollie_active', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (339, 'paymentmethod_mollie_label', 'Mollie', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (340, 'paymentmethod_mollie_api_key', '', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (341, 'paymentmethod_mollie_description_dashboard', 'Payment for Invoice {invoice_number}', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (342, 'paymentmethod_mollie_currencies', 'EUR', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (343, 'paymentmethod_mollie_test_mode_enabled', '1', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (344, 'paymentmethod_mollie_default_selected', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (345, 'paymentmethod_mollie_initialized', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (346, 'paymentmethod_paypal_braintree_active', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (347, 'paymentmethod_paypal_braintree_label', 'Braintree', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (348, 'paymentmethod_paypal_braintree_merchant_id', '', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (349, 'paymentmethod_paypal_braintree_api_public_key', '', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (350, 'paymentmethod_paypal_braintree_api_private_key', '', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (351, 'paymentmethod_paypal_braintree_currencies', 'USD', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (352, 'paymentmethod_paypal_braintree_paypal_enabled', '1', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (353, 'paymentmethod_paypal_braintree_test_mode_enabled', '1', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (354, 'paymentmethod_paypal_braintree_default_selected', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (355, 'paymentmethod_paypal_braintree_initialized', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (356, 'paymentmethod_paypal_checkout_active', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (357, 'paymentmethod_paypal_checkout_label', 'Paypal Smart Checkout', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (358, 'paymentmethod_paypal_checkout_client_id', '', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (359, 'paymentmethod_paypal_checkout_secret', '', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (360, 'paymentmethod_paypal_checkout_payment_description', 'Payment for Invoice {invoice_number}', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (361, 'paymentmethod_paypal_checkout_currencies', 'USD,CAD,EUR', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (362, 'paymentmethod_paypal_checkout_test_mode_enabled', '1', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (363, 'paymentmethod_paypal_checkout_default_selected', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (364, 'paymentmethod_paypal_checkout_initialized', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (365, 'paymentmethod_paypal_active', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (366, 'paymentmethod_paypal_label', 'Paypal', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (367, 'paymentmethod_paypal_username', '', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (368, 'paymentmethod_paypal_password', '', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (369, 'paymentmethod_paypal_signature', '', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (370, 'paymentmethod_paypal_description_dashboard', 'Payment for Invoice {invoice_number}', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (371, 'paymentmethod_paypal_currencies', 'EUR,USD', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (372, 'paymentmethod_paypal_test_mode_enabled', '1', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (373, 'paymentmethod_paypal_default_selected', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (374, 'paymentmethod_paypal_initialized', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (375, 'paymentmethod_payu_money_active', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (376, 'paymentmethod_payu_money_label', 'PayU Money', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (377, 'paymentmethod_payu_money_key', '', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (378, 'paymentmethod_payu_money_salt', '', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (379, 'paymentmethod_payu_money_description_dashboard', 'Payment for Invoice {invoice_number}', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (380, 'paymentmethod_payu_money_currencies', 'INR', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (381, 'paymentmethod_payu_money_test_mode_enabled', '1', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (382, 'paymentmethod_payu_money_default_selected', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (383, 'paymentmethod_payu_money_initialized', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (384, 'paymentmethod_stripe_active', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (385, 'paymentmethod_stripe_label', 'Stripe Checkout', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (386, 'paymentmethod_stripe_api_secret_key', '', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (387, 'paymentmethod_stripe_api_publishable_key', '', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (388, 'paymentmethod_stripe_description_dashboard', 'Payment for Invoice {invoice_number}', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (389, 'paymentmethod_stripe_currencies', 'USD,CAD', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (390, 'paymentmethod_stripe_allow_primary_contact_to_update_credit_card', '1', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (391, 'paymentmethod_stripe_default_selected', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (392, 'paymentmethod_stripe_initialized', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (393, 'paymentmethod_stripe_ideal_active', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (394, 'paymentmethod_stripe_ideal_label', 'Stripe iDEAL', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (395, 'paymentmethod_stripe_ideal_api_secret_key', '', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (396, 'paymentmethod_stripe_ideal_api_publishable_key', '', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (397, 'paymentmethod_stripe_ideal_description_dashboard', 'Payment for Invoice {invoice_number}', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (398, 'paymentmethod_stripe_ideal_statement_descriptor', 'Payment for Invoice {invoice_number}', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (399, 'paymentmethod_stripe_ideal_currencies', 'EUR', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (400, 'paymentmethod_stripe_ideal_default_selected', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (401, 'paymentmethod_stripe_ideal_initialized', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (402, 'paymentmethod_two_checkout_active', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (403, 'paymentmethod_two_checkout_label', '2Checkout', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (404, 'paymentmethod_two_checkout_merchant_code', '', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (405, 'paymentmethod_two_checkout_secret_key', '', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (406, 'paymentmethod_two_checkout_description', 'Payment for Invoice {invoice_number}', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (407, 'paymentmethod_two_checkout_currencies', 'USD, EUR, GBP', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (408, 'paymentmethod_two_checkout_test_mode_enabled', '1', 0);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (409, 'paymentmethod_two_checkout_default_selected', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (410, 'paymentmethod_two_checkout_initialized', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (411, 'flat_admin_theme_customers', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (412, 'theme_style', '[]', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (413, 'theme_style_custom_admin_area', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (414, 'theme_style_custom_clients_area', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (415, 'theme_style_custom_clients_and_admin_area', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (416, 'enable_support_menu_badges', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (417, 'attach_invoice_to_payment_receipt_email', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (418, 'gdpr_enable_terms_and_conditions_estimate_request_form', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (419, 'invoice_due_notice_before', '2', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (420, 'invoice_due_notice_resend_after', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (421, 'show_estimate_request_in_customers_area', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (422, 'auto_backup_hour', '6', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (423, '_v283_update_clients_theme', 'perfex', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (425, 'acc_first_month_of_financial_year', 'January', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (426, 'acc_first_month_of_tax_year', 'same_as_financial_year', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (427, 'acc_accounting_method', 'cash', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (428, 'acc_close_the_books', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (429, 'acc_allow_changes_after_viewing', 'allow_changes_after_viewing_a_warning', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (430, 'acc_close_book_password', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (431, 'acc_close_book_passwordr', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (432, 'acc_enable_account_numbers', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (433, 'acc_show_account_numbers', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (434, 'acc_closing_date', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (435, 'acc_add_default_account', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (436, 'acc_add_default_account_new', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (437, 'acc_invoice_automatic_conversion', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (438, 'acc_payment_automatic_conversion', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (439, 'acc_expense_automatic_conversion', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (440, 'acc_tax_automatic_conversion', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (441, 'acc_invoice_payment_account', '66', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (442, 'acc_invoice_deposit_to', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (443, 'acc_payment_payment_account', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (444, 'acc_payment_deposit_to', '13', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (445, 'acc_expense_payment_account', '13', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (446, 'acc_expense_deposit_to', '80', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (447, 'acc_tax_payment_account', '29', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (448, 'acc_tax_deposit_to', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (449, 'acc_expense_tax_payment_account', '13', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (450, 'acc_expense_tax_deposit_to', '29', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (451, 'acc_active_payment_mode_mapping', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (452, 'acc_active_expense_category_mapping', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (453, 'acc_payment_expense_automatic_conversion', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (454, 'acc_payment_sale_automatic_conversion', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (455, 'acc_expense_payment_payment_account', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (456, 'acc_expense_payment_deposit_to', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (457, 'warehouse_selling_price_rule_profif_ratio', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (458, 'profit_rate_by_purchase_price_sale', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (459, 'warehouse_the_fractional_part', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (460, 'warehouse_integer_part', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (461, 'auto_create_goods_received', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (462, 'auto_create_goods_delivery', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (463, 'goods_receipt_warehouse', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (464, 'barcode_with_sku_code', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (465, 'revert_goods_receipt_goods_delivery', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (466, 'cancelled_invoice_reverse_inventory_delivery_voucher', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (467, 'uncancelled_invoice_create_inventory_delivery_voucher', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (468, 'inventory_auto_operations_hour', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (469, 'automatically_send_items_expired_before', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (470, 'inventorys_cronjob_active', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (471, 'inventory_cronjob_notification_recipients', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (472, 'inventory_received_number_prefix', 'NK', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (473, 'next_inventory_received_mumber', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (474, 'inventory_delivery_number_prefix', 'XK', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (475, 'next_inventory_delivery_mumber', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (476, 'internal_delivery_number_prefix', 'ID', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (477, 'next_internal_delivery_mumber', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (478, 'item_sku_prefix', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (479, 'goods_receipt_required_po', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (480, 'goods_delivery_required_po', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (481, 'goods_delivery_pdf_display', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (482, 'automatically_stop_task_timer_after_hours', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (483, 'automatically_assign_ticket_to_first_staff_responding', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (484, 'reminder_for_completed_but_not_billed_tasks', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (485, 'staff_notify_completed_but_not_billed_tasks', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (486, 'reminder_for_completed_but_not_billed_tasks_days', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (487, 'tasks_reminder_notification_last_notified_day', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (488, 'show_project_on_proposal', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (489, 'show_pdf_signature_proposal', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (490, 'enable_honeypot_spam_validation', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (491, 'staff_related_ticket_notification_to_assignee_only', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (493, 'last_updated_date', '1708514210', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (494, 'identification_key', '2077002161166783328063691dc001de7', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (496, 'automatically_set_logged_in_staff_sales_agent', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (497, 'contract_sign_reminder_every_days', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (498, 'v310_incompatible_tables', '[]', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (499, 'allow_non_admin_members_to_delete_tickets_and_replies', '1', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (500, 'required_register_fields', '[]', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (501, 'upgraded_from_version', '304', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (502, 'auto_backup_enabled', '0', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (503, 'auto_backup_every', '7', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (504, 'last_auto_backup', '', 1);
INSERT INTO `tbloptions` (`id`, `name`, `value`, `autoload`) VALUES (505, 'delete_backups_older_then', '0', 1);


#
# TABLE STRUCTURE FOR: tblpayment_attempts
#

DROP TABLE IF EXISTS `tblpayment_attempts`;

CREATE TABLE `tblpayment_attempts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reference` varchar(100) NOT NULL,
  `invoice_id` int(11) NOT NULL,
  `amount` double NOT NULL,
  `fee` double NOT NULL,
  `payment_gateway` varchar(100) NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblpayment_modes
#

DROP TABLE IF EXISTS `tblpayment_modes`;

CREATE TABLE `tblpayment_modes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `description` text DEFAULT NULL,
  `show_on_pdf` int(11) NOT NULL DEFAULT 0,
  `invoices_only` int(11) NOT NULL DEFAULT 0,
  `expenses_only` int(11) NOT NULL DEFAULT 0,
  `selected_by_default` int(11) NOT NULL DEFAULT 1,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `opening_balance` decimal(15,2) DEFAULT NULL,
  `payment_currency` varchar(10) DEFAULT 'USD',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblpayment_modes` (`id`, `name`, `description`, `show_on_pdf`, `invoices_only`, `expenses_only`, `selected_by_default`, `active`, `opening_balance`, `payment_currency`) VALUES (1, 'TRANSFERENCIA BANCARIA', 'SABADELL ES8500811248110001336836', 1, 0, 0, 1, 1, NULL, 'USD');
INSERT INTO `tblpayment_modes` (`id`, `name`, `description`, `show_on_pdf`, `invoices_only`, `expenses_only`, `selected_by_default`, `active`, `opening_balance`, `payment_currency`) VALUES (2, 'CONTADO', 'Realizado pago al contado en el establecimiento.', 0, 0, 0, 0, 1, NULL, 'USD');
INSERT INTO `tblpayment_modes` (`id`, `name`, `description`, `show_on_pdf`, `invoices_only`, `expenses_only`, `selected_by_default`, `active`, `opening_balance`, `payment_currency`) VALUES (3, 'TARJETA', 'Realizado pago con tarjeta en el establecimiento.', 0, 0, 0, 0, 1, NULL, 'USD');


#
# TABLE STRUCTURE FOR: tblpayment_modes_accounts
#

DROP TABLE IF EXISTS `tblpayment_modes_accounts`;

CREATE TABLE `tblpayment_modes_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_id` varchar(100) DEFAULT NULL,
  `payment_currency` varchar(10) DEFAULT NULL,
  `opening_balance` decimal(15,2) DEFAULT 0.00,
  `is_public` tinyint(4) DEFAULT 1,
  `active_staff` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `payment_id` (`payment_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblpayment_modes_accounts` (`id`, `payment_id`, `payment_currency`, `opening_balance`, `is_public`, `active_staff`) VALUES (1, '1', 'USD', NULL, 1, NULL);
INSERT INTO `tblpayment_modes_accounts` (`id`, `payment_id`, `payment_currency`, `opening_balance`, `is_public`, `active_staff`) VALUES (2, '2', 'USD', NULL, 1, NULL);
INSERT INTO `tblpayment_modes_accounts` (`id`, `payment_id`, `payment_currency`, `opening_balance`, `is_public`, `active_staff`) VALUES (3, '3', 'USD', NULL, 1, NULL);


#
# TABLE STRUCTURE FOR: tblpayment_modes_income
#

DROP TABLE IF EXISTS `tblpayment_modes_income`;

CREATE TABLE `tblpayment_modes_income` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `source_mode` varchar(100) DEFAULT NULL,
  `client_id` int(11) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `amount` decimal(15,2) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `description` varchar(500) DEFAULT NULL,
  `added_from` int(11) DEFAULT NULL,
  `added_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `client_id` (`client_id`) USING BTREE,
  KEY `staff_id` (`staff_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=DYNAMIC;

#
# TABLE STRUCTURE FOR: tblpayment_modes_transfer
#

DROP TABLE IF EXISTS `tblpayment_modes_transfer`;

CREATE TABLE `tblpayment_modes_transfer` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `source_mode` varchar(100) DEFAULT NULL,
  `target_mode` varchar(100) DEFAULT NULL,
  `source_amount` decimal(15,2) DEFAULT NULL,
  `target_amount` decimal(15,2) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `staffid` int(11) DEFAULT NULL,
  `description` varchar(500) DEFAULT NULL,
  `transfer_date` date DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `id` (`id`) USING BTREE,
  KEY `source_mode` (`source_mode`) USING BTREE,
  KEY `target_mode` (`target_mode`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=DYNAMIC;

#
# TABLE STRUCTURE FOR: tblpayment_modes_withdraw
#

DROP TABLE IF EXISTS `tblpayment_modes_withdraw`;

CREATE TABLE `tblpayment_modes_withdraw` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `source_mode` varchar(100) DEFAULT NULL,
  `client_id` int(11) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `amount` decimal(15,2) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `description` varchar(500) DEFAULT NULL,
  `added_from` int(11) DEFAULT NULL,
  `added_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `client_id` (`client_id`),
  KEY `staff_id` (`staff_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblpinned_projects
#

DROP TABLE IF EXISTS `tblpinned_projects`;

CREATE TABLE `tblpinned_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` int(11) NOT NULL,
  `staff_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `project_id` (`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblproject_activity
#

DROP TABLE IF EXISTS `tblproject_activity`;

CREATE TABLE `tblproject_activity` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` int(11) NOT NULL,
  `staff_id` int(11) NOT NULL DEFAULT 0,
  `contact_id` int(11) NOT NULL DEFAULT 0,
  `fullname` varchar(100) DEFAULT NULL,
  `visible_to_customer` int(11) NOT NULL DEFAULT 0,
  `description_key` varchar(191) NOT NULL COMMENT 'Language file key',
  `additional_data` text DEFAULT NULL,
  `dateadded` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblproject_files
#

DROP TABLE IF EXISTS `tblproject_files`;

CREATE TABLE `tblproject_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `file_name` varchar(191) NOT NULL,
  `original_file_name` mediumtext DEFAULT NULL,
  `subject` varchar(191) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `filetype` varchar(50) DEFAULT NULL,
  `dateadded` datetime NOT NULL,
  `last_activity` datetime DEFAULT NULL,
  `project_id` int(11) NOT NULL,
  `visible_to_customer` tinyint(1) DEFAULT 0,
  `staffid` int(11) NOT NULL,
  `contact_id` int(11) NOT NULL DEFAULT 0,
  `external` varchar(40) DEFAULT NULL,
  `external_link` text DEFAULT NULL,
  `thumbnail_link` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblproject_members
#

DROP TABLE IF EXISTS `tblproject_members`;

CREATE TABLE `tblproject_members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` int(11) NOT NULL,
  `staff_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `project_id` (`project_id`),
  KEY `staff_id` (`staff_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblproject_notes
#

DROP TABLE IF EXISTS `tblproject_notes`;

CREATE TABLE `tblproject_notes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` int(11) NOT NULL,
  `content` text NOT NULL,
  `staff_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblproject_settings
#

DROP TABLE IF EXISTS `tblproject_settings`;

CREATE TABLE `tblproject_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_id` (`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblprojectdiscussioncomments
#

DROP TABLE IF EXISTS `tblprojectdiscussioncomments`;

CREATE TABLE `tblprojectdiscussioncomments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `discussion_id` int(11) NOT NULL,
  `discussion_type` varchar(10) NOT NULL,
  `parent` int(11) DEFAULT NULL,
  `created` datetime NOT NULL,
  `modified` datetime DEFAULT NULL,
  `content` text NOT NULL,
  `staff_id` int(11) NOT NULL,
  `contact_id` int(11) DEFAULT 0,
  `fullname` varchar(191) DEFAULT NULL,
  `file_name` varchar(191) DEFAULT NULL,
  `file_mime_type` varchar(70) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblprojectdiscussions
#

DROP TABLE IF EXISTS `tblprojectdiscussions`;

CREATE TABLE `tblprojectdiscussions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` int(11) NOT NULL,
  `subject` varchar(191) NOT NULL,
  `description` text NOT NULL,
  `show_to_customer` tinyint(1) NOT NULL DEFAULT 0,
  `datecreated` datetime NOT NULL,
  `last_activity` datetime DEFAULT NULL,
  `staff_id` int(11) NOT NULL DEFAULT 0,
  `contact_id` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblprojects
#

DROP TABLE IF EXISTS `tblprojects`;

CREATE TABLE `tblprojects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  `clientid` int(11) NOT NULL,
  `billing_type` int(11) NOT NULL,
  `start_date` date NOT NULL,
  `deadline` date DEFAULT NULL,
  `project_created` date NOT NULL,
  `date_finished` datetime DEFAULT NULL,
  `progress` int(11) DEFAULT 0,
  `progress_from_tasks` int(11) NOT NULL DEFAULT 1,
  `project_cost` decimal(15,2) DEFAULT NULL,
  `project_rate_per_hour` decimal(15,2) DEFAULT NULL,
  `estimated_hours` decimal(15,2) DEFAULT NULL,
  `addedfrom` int(11) NOT NULL,
  `contact_notification` int(11) DEFAULT 1,
  `notify_contacts` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `clientid` (`clientid`),
  KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblproposal_comments
#

DROP TABLE IF EXISTS `tblproposal_comments`;

CREATE TABLE `tblproposal_comments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `content` mediumtext DEFAULT NULL,
  `proposalid` int(11) NOT NULL,
  `staffid` int(11) NOT NULL,
  `dateadded` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblproposals
#

DROP TABLE IF EXISTS `tblproposals`;

CREATE TABLE `tblproposals` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `subject` varchar(191) DEFAULT NULL,
  `content` longtext DEFAULT NULL,
  `addedfrom` int(11) NOT NULL,
  `datecreated` datetime NOT NULL,
  `total` decimal(15,2) DEFAULT NULL,
  `subtotal` decimal(15,2) NOT NULL,
  `total_tax` decimal(15,2) NOT NULL DEFAULT 0.00,
  `adjustment` decimal(15,2) DEFAULT NULL,
  `discount_percent` decimal(15,2) NOT NULL,
  `discount_total` decimal(15,2) NOT NULL,
  `discount_type` varchar(30) DEFAULT NULL,
  `show_quantity_as` int(11) NOT NULL DEFAULT 1,
  `currency` int(11) NOT NULL,
  `open_till` date DEFAULT NULL,
  `date` date NOT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(40) DEFAULT NULL,
  `assigned` int(11) DEFAULT NULL,
  `hash` varchar(32) NOT NULL,
  `proposal_to` varchar(191) DEFAULT NULL,
  `project_id` int(11) DEFAULT NULL,
  `country` int(11) NOT NULL DEFAULT 0,
  `zip` varchar(50) DEFAULT NULL,
  `state` varchar(100) DEFAULT NULL,
  `city` varchar(100) DEFAULT NULL,
  `address` varchar(200) DEFAULT NULL,
  `email` varchar(150) DEFAULT NULL,
  `phone` varchar(50) DEFAULT NULL,
  `allow_comments` tinyint(1) NOT NULL DEFAULT 1,
  `status` int(11) NOT NULL,
  `estimate_id` int(11) DEFAULT NULL,
  `invoice_id` int(11) DEFAULT NULL,
  `date_converted` datetime DEFAULT NULL,
  `pipeline_order` int(11) DEFAULT 1,
  `is_expiry_notified` int(11) NOT NULL DEFAULT 0,
  `acceptance_firstname` varchar(50) DEFAULT NULL,
  `acceptance_lastname` varchar(50) DEFAULT NULL,
  `acceptance_email` varchar(100) DEFAULT NULL,
  `acceptance_date` datetime DEFAULT NULL,
  `acceptance_ip` varchar(40) DEFAULT NULL,
  `signature` varchar(40) DEFAULT NULL,
  `short_link` varchar(100) DEFAULT NULL,
  `processing` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblproposals` (`id`, `subject`, `content`, `addedfrom`, `datecreated`, `total`, `subtotal`, `total_tax`, `adjustment`, `discount_percent`, `discount_total`, `discount_type`, `show_quantity_as`, `currency`, `open_till`, `date`, `rel_id`, `rel_type`, `assigned`, `hash`, `proposal_to`, `project_id`, `country`, `zip`, `state`, `city`, `address`, `email`, `phone`, `allow_comments`, `status`, `estimate_id`, `invoice_id`, `date_converted`, `pipeline_order`, `is_expiry_notified`, `acceptance_firstname`, `acceptance_lastname`, `acceptance_email`, `acceptance_date`, `acceptance_ip`, `signature`, `short_link`, `processing`) VALUES (1, 'Invitación Botella June by JVINE', '{proposal_items}', 1, '2021-05-05 15:03:41', '0.00', '100.00', '0.00', '0.00', '100.00', '100.00', 'before_tax', 1, 2, '2021-05-12', '2021-05-05', 2, 'customer', 0, 'b9d8dfcc897d5d32acd2cf5c83377114', 'VODAFONE', NULL, 0, '', '', '', '', 'Esther.silvestre@grupomovil.com', '', 1, 4, NULL, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `tblproposals` (`id`, `subject`, `content`, `addedfrom`, `datecreated`, `total`, `subtotal`, `total_tax`, `adjustment`, `discount_percent`, `discount_total`, `discount_type`, `show_quantity_as`, `currency`, `open_till`, `date`, `rel_id`, `rel_type`, `assigned`, `hash`, `proposal_to`, `project_id`, `country`, `zip`, `state`, `city`, `address`, `email`, `phone`, `allow_comments`, `status`, `estimate_id`, `invoice_id`, `date_converted`, `pipeline_order`, `is_expiry_notified`, `acceptance_firstname`, `acceptance_lastname`, `acceptance_email`, `acceptance_date`, `acceptance_ip`, `signature`, `short_link`, `processing`) VALUES (2, 'INVITACIÓN TINOCO', '{proposal_items}', 1, '2021-05-05 20:49:11', '0.00', '17.50', '0.00', '0.00', '100.00', '17.50', 'before_tax', 1, 2, '2021-05-05', '2021-05-05', 3, 'customer', 0, '4952ee2d9ed8ba6ead4caaff9339d5ad', 'Tinoco', NULL, 0, '', '', '', '', 'mario96hs@gmail.com', '', 1, 6, NULL, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `tblproposals` (`id`, `subject`, `content`, `addedfrom`, `datecreated`, `total`, `subtotal`, `total_tax`, `adjustment`, `discount_percent`, `discount_total`, `discount_type`, `show_quantity_as`, `currency`, `open_till`, `date`, `rel_id`, `rel_type`, `assigned`, `hash`, `proposal_to`, `project_id`, `country`, `zip`, `state`, `city`, `address`, `email`, `phone`, `allow_comments`, `status`, `estimate_id`, `invoice_id`, `date_converted`, `pipeline_order`, `is_expiry_notified`, `acceptance_firstname`, `acceptance_lastname`, `acceptance_email`, `acceptance_date`, `acceptance_ip`, `signature`, `short_link`, `processing`) VALUES (3, 'INVITACIÓN MAGMA TINOCO', '{proposal_items}', 1, '2021-05-13 14:06:34', '0.00', '40.00', '0.00', '0.00', '100.00', '40.00', 'before_tax', 1, 2, '2021-05-20', '2021-05-13', 3, 'customer', 0, 'b0de44633177dc922414251a3bb8c069', 'Tinoco', NULL, 0, '', '', '', '', 'luis.marco@icali.es', '', 1, 6, NULL, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `tblproposals` (`id`, `subject`, `content`, `addedfrom`, `datecreated`, `total`, `subtotal`, `total_tax`, `adjustment`, `discount_percent`, `discount_total`, `discount_type`, `show_quantity_as`, `currency`, `open_till`, `date`, `rel_id`, `rel_type`, `assigned`, `hash`, `proposal_to`, `project_id`, `country`, `zip`, `state`, `city`, `address`, `email`, `phone`, `allow_comments`, `status`, `estimate_id`, `invoice_id`, `date_converted`, `pipeline_order`, `is_expiry_notified`, `acceptance_firstname`, `acceptance_lastname`, `acceptance_email`, `acceptance_date`, `acceptance_ip`, `signature`, `short_link`, `processing`) VALUES (4, 'EVENTO EULEN', '{proposal_items}', 1, '2022-11-24 19:59:04', '276.10', '251.00', '25.10', '0.00', '0.00', '0.00', '', 1, 2, '2022-12-01', '2022-11-24', 11, 'customer', 0, 'b5d967a01b9aa3cad7023ce72825658f', 'Eulen Sa', 0, 0, '03008', 'Alicante', 'Alicante', 'Eulen Sa<br />\r\nC/ de los transportes 13<br />\r\n03008 Alicante<br />\r\nA28517308<br />\r\nCUENTA SABADELL ES85 0081 1248 1100 0133 6836', 'pool_eu_alicante@eulen.com', '', 1, 4, NULL, NULL, NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);


#
# TABLE STRUCTURE FOR: tblrelated_items
#

DROP TABLE IF EXISTS `tblrelated_items`;

CREATE TABLE `tblrelated_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rel_id` int(11) NOT NULL,
  `rel_type` varchar(30) NOT NULL,
  `item_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblreminders
#

DROP TABLE IF EXISTS `tblreminders`;

CREATE TABLE `tblreminders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` text DEFAULT NULL,
  `date` datetime NOT NULL,
  `isnotified` int(11) NOT NULL DEFAULT 0,
  `rel_id` int(11) NOT NULL,
  `staff` int(11) NOT NULL,
  `rel_type` varchar(40) NOT NULL,
  `notify_by_email` int(11) NOT NULL DEFAULT 1,
  `creator` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `rel_id` (`rel_id`),
  KEY `rel_type` (`rel_type`),
  KEY `staff` (`staff`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblresource
#

DROP TABLE IF EXISTS `tblresource`;

CREATE TABLE `tblresource` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `resource_name` varchar(100) NOT NULL,
  `resource_group` int(11) NOT NULL,
  `approved` int(11) NOT NULL,
  `manager` int(11) DEFAULT NULL,
  `color` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `status` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tblresource` (`id`, `resource_name`, `resource_group`, `approved`, `manager`, `color`, `description`, `status`) VALUES (1, 'Magma', 1, 0, 2, '#fb8c00', '', 'active');


#
# TABLE STRUCTURE FOR: tblresource_group
#

DROP TABLE IF EXISTS `tblresource_group`;

CREATE TABLE `tblresource_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `group_name` varchar(100) NOT NULL,
  `icon` varchar(100) NOT NULL,
  `description` text DEFAULT NULL,
  `creator` int(11) NOT NULL,
  `date_create` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tblresource_group` (`id`, `group_name`, `icon`, `description`, `creator`, `date_create`) VALUES (1, 'Orlas', '', '', 1, '2024-09-23');


#
# TABLE STRUCTURE FOR: tblroles
#

DROP TABLE IF EXISTS `tblroles`;

CREATE TABLE `tblroles` (
  `roleid` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  `permissions` longtext DEFAULT NULL,
  PRIMARY KEY (`roleid`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblroles` (`roleid`, `name`, `permissions`) VALUES (1, 'Employee', NULL);


#
# TABLE STRUCTURE FOR: tblsales_activity
#

DROP TABLE IF EXISTS `tblsales_activity`;

CREATE TABLE `tblsales_activity` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rel_type` varchar(20) DEFAULT NULL,
  `rel_id` int(11) NOT NULL,
  `description` text NOT NULL,
  `additional_data` text DEFAULT NULL,
  `staffid` varchar(11) DEFAULT NULL,
  `full_name` varchar(100) DEFAULT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=190 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (1, 'invoice', 1, 'invoice_activity_created', '', '1', 'Mario Puche', '2021-02-07 12:25:29');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (2, 'invoice', 2, 'invoice_activity_created', '', '1', 'Mario Puche', '2021-02-07 12:29:25');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (3, 'invoice', 3, 'invoice_activity_created', '', '1', 'Mario Puche', '2021-08-16 16:10:20');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (4, 'invoice', 4, 'invoice_activity_created', '', '1', 'Mario Puche', '2021-11-29 16:48:00');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (5, 'invoice', 4, 'invoice_estimate_activity_updated_item_rate', 'a:2:{i:0;s:6:\"230.50\";i:1;s:6:\"227.27\";}', '1', 'Mario Puche', '2021-11-29 16:48:24');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (6, 'invoice', 4, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>6</original_status>\";i:1;s:26:\"<new_status>2</new_status>\";}', '1', 'Mario Puche', '2021-11-29 19:25:07');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (7, 'invoice', 4, 'invoice_activity_payment_made_by_staff', 'a:2:{i:0;s:9:\"250,00€\";i:1;s:85:\"<a href=\"http://panel.blitconcept.es/admin/payments/payment/1\" target=\"_blank\">#1</a>\";}', '1', 'Mario Puche', '2021-11-29 19:25:07');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (8, 'invoice', 5, 'invoice_activity_created', '', '1', 'Mario Puche', '2022-02-28 19:15:09');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (9, 'invoice', 6, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>4</new_status>\";}', '1', 'Mario Puche', '2022-03-09 16:19:18');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (10, 'invoice', 6, 'invoice_activity_created', '', '1', 'Mario Puche', '2022-03-09 16:19:18');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (11, 'invoice', 7, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>4</new_status>\";}', '1', 'Mario Puche', '2022-03-16 21:46:02');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (12, 'invoice', 7, 'invoice_activity_created', '', '1', 'Mario Puche', '2022-03-16 21:46:02');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (13, 'invoice', 8, 'invoice_activity_created', '', '1', 'Mario Puche', '2022-05-06 19:56:37');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (14, 'invoice', 9, 'invoice_activity_created', '', '1', 'Mario Puche', '2022-07-03 01:11:42');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (15, 'invoice', 9, 'invoice_estimate_activity_updated_item_short_description', 'a:2:{i:0;s:16:\"TÉCNICO SONIDO \";i:1;s:15:\"TÉCNICO SONIDO\";}', '1', 'Mario Puche', '2022-07-03 02:29:02');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (16, 'invoice', 9, 'invoice_estimate_activity_updated_item_rate', 'a:2:{i:0;s:6:\"450.00\";i:1;s:3:\"350\";}', '1', 'Mario Puche', '2022-07-03 02:29:02');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (17, 'invoice', 9, 'invoice_estimate_activity_updated_item_rate', 'a:2:{i:0;s:6:\"350.00\";i:1;s:3:\"300\";}', '1', 'Mario Puche', '2022-07-03 09:38:06');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (18, 'invoice', 10, 'invoice_activity_created', '', '1', 'Mario Puche', '2022-09-21 18:21:17');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (19, 'invoice', 11, 'invoice_activity_created', '', '1', 'Mario Puche', '2022-09-21 18:25:03');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (20, 'invoice', 12, 'invoice_activity_created', '', '1', 'Mario Puche', '2022-09-21 18:28:24');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (21, 'invoice', 13, 'invoice_activity_created', '', '1', 'Mario Puche', '2022-09-21 18:29:17');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (22, 'invoice', 14, 'invoice_activity_created', '', '1', 'Mario Puche', '2022-09-21 18:29:52');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (23, 'invoice', 15, 'invoice_activity_created', '', '1', 'Mario Puche', '2022-09-21 18:30:45');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (24, 'invoice', 10, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>2</new_status>\";}', '1', 'Mario Puche', '2022-09-21 19:19:17');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (25, 'invoice', 10, 'invoice_activity_payment_made_by_staff', 'a:2:{i:0;s:9:\"931,00€\";i:1;s:86:\"<a href=\"https://panel.blitconcept.es/admin/payments/payment/2\" target=\"_blank\">#2</a>\";}', '1', 'Mario Puche', '2022-09-21 19:19:18');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (26, 'invoice', 1, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>4</new_status>\";}', '[CRON]', '[CRON]', '2022-11-07 21:04:02');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (27, 'invoice', 2, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>4</new_status>\";}', '[CRON]', '[CRON]', '2022-11-07 21:04:10');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (28, 'invoice', 3, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>4</new_status>\";}', '[CRON]', '[CRON]', '2022-11-07 21:04:18');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (29, 'invoice', 5, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>4</new_status>\";}', '[CRON]', '[CRON]', '2022-11-07 21:04:27');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (30, 'invoice', 8, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>4</new_status>\";}', '[CRON]', '[CRON]', '2022-11-07 21:04:46');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (31, 'invoice', 9, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>4</new_status>\";}', '[CRON]', '[CRON]', '2022-11-07 21:04:53');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (32, 'invoice', 11, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>4</new_status>\";}', '[CRON]', '[CRON]', '2022-11-07 21:05:01');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (33, 'invoice', 12, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>4</new_status>\";}', '[CRON]', '[CRON]', '2022-11-07 21:05:10');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (34, 'invoice', 13, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>4</new_status>\";}', '[CRON]', '[CRON]', '2022-11-07 21:05:18');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (35, 'invoice', 14, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>4</new_status>\";}', '[CRON]', '[CRON]', '2022-11-07 21:05:24');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (36, 'invoice', 15, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>4</new_status>\";}', '[CRON]', '[CRON]', '2022-11-07 21:05:32');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (46, 'invoice', 19, 'invoice_activity_created', '', '1', 'Mario Puche', '2022-12-16 17:08:16');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (47, 'invoice', 20, 'invoice_activity_created', '', '1', 'Mario Puche', '2022-12-16 17:09:14');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (48, 'invoice', 20, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>2</new_status>\";}', '1', 'Mario Puche', '2022-12-16 17:09:24');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (49, 'invoice', 20, 'invoice_activity_payment_made_by_staff', 'a:2:{i:0;s:9:\"109,90€\";i:1;s:86:\"<a href=\"https://panel.blitconcept.es/admin/payments/payment/5\" target=\"_blank\">#5</a>\";}', '1', 'Mario Puche', '2022-12-16 17:09:24');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (50, 'invoice', 19, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>2</new_status>\";}', '1', 'Mario Puche', '2022-12-16 17:09:34');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (51, 'invoice', 19, 'invoice_activity_payment_made_by_staff', 'a:2:{i:0;s:9:\"565,40€\";i:1;s:86:\"<a href=\"https://panel.blitconcept.es/admin/payments/payment/6\" target=\"_blank\">#6</a>\";}', '1', 'Mario Puche', '2022-12-16 17:09:34');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (52, 'invoice', 21, 'invoice_activity_created', '', '1', 'Mario Puche', '2022-12-16 17:24:41');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (53, 'invoice', 21, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>2</new_status>\";}', '1', 'Mario Puche', '2022-12-16 17:24:47');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (54, 'invoice', 21, 'invoice_activity_payment_made_by_staff', 'a:2:{i:0;s:9:\"370,70€\";i:1;s:86:\"<a href=\"https://panel.blitconcept.es/admin/payments/payment/7\" target=\"_blank\">#7</a>\";}', '1', 'Mario Puche', '2022-12-16 17:24:47');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (55, 'invoice', 22, 'invoice_activity_created', '', '1', 'Mario Puche', '2022-12-16 17:26:47');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (56, 'invoice', 22, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>2</new_status>\";}', '1', 'Mario Puche', '2022-12-16 17:26:54');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (57, 'invoice', 22, 'invoice_activity_payment_made_by_staff', 'a:2:{i:0;s:9:\"102,50€\";i:1;s:86:\"<a href=\"https://panel.blitconcept.es/admin/payments/payment/8\" target=\"_blank\">#8</a>\";}', '1', 'Mario Puche', '2022-12-16 17:26:54');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (58, 'invoice', 22, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>2</original_status>\";i:1;s:26:\"<new_status>1</new_status>\";}', '1', 'Mario Puche', '2022-12-16 17:27:03');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (59, 'invoice', 22, 'invoice_activity_payment_deleted', 'a:2:{i:0;s:1:\"8\";i:1;s:9:\"102,50€\";}', '1', 'Mario Puche', '2022-12-16 17:27:03');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (60, 'invoice', 22, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>2</new_status>\";}', '1', 'Mario Puche', '2022-12-16 17:27:34');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (61, 'invoice', 22, 'invoice_activity_payment_made_by_staff', 'a:2:{i:0;s:9:\"102,50€\";i:1;s:86:\"<a href=\"https://panel.blitconcept.es/admin/payments/payment/9\" target=\"_blank\">#9</a>\";}', '1', 'Mario Puche', '2022-12-16 17:27:34');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (62, 'invoice', 23, 'invoice_activity_created', '', '1', 'Mario Puche', '2022-12-16 20:19:38');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (63, 'invoice', 23, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>2</new_status>\";}', '1', 'Mario Puche', '2022-12-16 20:19:52');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (64, 'invoice', 23, 'invoice_activity_payment_made_by_staff', 'a:2:{i:0;s:8:\"52,00€\";i:1;s:88:\"<a href=\"https://panel.blitconcept.es/admin/payments/payment/10\" target=\"_blank\">#10</a>\";}', '1', 'Mario Puche', '2022-12-16 20:19:52');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (65, 'invoice', 24, 'invoice_activity_created', '', '1', 'Mario Puche', '2022-12-22 22:41:05');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (66, 'invoice', 25, 'invoice_activity_created', '', '1', 'Mario Puche', '2022-12-22 22:42:21');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (67, 'invoice', 24, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>2</new_status>\";}', '1', 'Mario Puche', '2022-12-22 22:43:08');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (68, 'invoice', 24, 'invoice_activity_payment_made_by_staff', 'a:2:{i:0;s:8:\"62,50€\";i:1;s:88:\"<a href=\"https://panel.blitconcept.es/admin/payments/payment/11\" target=\"_blank\">#11</a>\";}', '1', 'Mario Puche', '2022-12-22 22:43:08');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (69, 'invoice', 25, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>2</new_status>\";}', '1', 'Mario Puche', '2022-12-22 22:43:22');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (70, 'invoice', 25, 'invoice_activity_payment_made_by_staff', 'a:2:{i:0;s:11:\"1.075,80€\";i:1;s:88:\"<a href=\"https://panel.blitconcept.es/admin/payments/payment/12\" target=\"_blank\">#12</a>\";}', '1', 'Mario Puche', '2022-12-22 22:43:22');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (71, 'invoice', 26, 'invoice_activity_created', '', '1', 'Mario Puche', '2022-12-27 20:44:13');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (72, 'invoice', 26, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>2</new_status>\";}', '1', 'Mario Puche', '2022-12-27 20:44:32');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (73, 'invoice', 26, 'invoice_activity_payment_made_by_staff', 'a:2:{i:0;s:12:\"34.606,00€\";i:1;s:88:\"<a href=\"https://panel.blitconcept.es/admin/payments/payment/13\" target=\"_blank\">#13</a>\";}', '1', 'Mario Puche', '2022-12-27 20:44:32');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (74, 'invoice', 27, 'invoice_activity_created', '', '1', 'Mario Puche', '2022-12-27 20:46:17');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (75, 'invoice', 27, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>2</new_status>\";}', '1', 'Mario Puche', '2022-12-27 20:46:27');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (76, 'invoice', 27, 'invoice_activity_payment_made_by_staff', 'a:2:{i:0;s:11:\"9.885,70€\";i:1;s:88:\"<a href=\"https://panel.blitconcept.es/admin/payments/payment/14\" target=\"_blank\">#14</a>\";}', '1', 'Mario Puche', '2022-12-27 20:46:27');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (77, 'invoice', 28, 'invoice_activity_created', '', '1', 'Mario Puche', '2023-01-04 18:13:34');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (78, 'invoice', 28, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>2</new_status>\";}', '1', 'Mario Puche', '2023-01-04 18:13:41');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (79, 'invoice', 28, 'invoice_activity_payment_made_by_staff', 'a:2:{i:0;s:9:\"477,50€\";i:1;s:88:\"<a href=\"https://panel.blitconcept.es/admin/payments/payment/15\" target=\"_blank\">#15</a>\";}', '1', 'Mario Puche', '2023-01-04 18:13:41');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (80, 'invoice', 29, 'invoice_activity_created', '', '1', 'Mario Puche', '2023-01-13 22:11:47');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (81, 'invoice', 29, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>2</new_status>\";}', '1', 'Mario Puche', '2023-01-13 22:11:58');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (82, 'invoice', 29, 'invoice_activity_payment_made_by_staff', 'a:2:{i:0;s:11:\"1.148,50€\";i:1;s:88:\"<a href=\"https://panel.blitconcept.es/admin/payments/payment/16\" target=\"_blank\">#16</a>\";}', '1', 'Mario Puche', '2023-01-13 22:11:58');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (83, 'invoice', 30, 'invoice_activity_created', '', '1', 'Mario Puche', '2023-02-03 15:19:04');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (84, 'invoice', 30, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>2</new_status>\";}', '1', 'Mario Puche', '2023-02-03 15:19:34');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (85, 'invoice', 30, 'invoice_activity_payment_made_by_staff', 'a:2:{i:0;s:11:\"1.011,10€\";i:1;s:88:\"<a href=\"https://panel.blitconcept.es/admin/payments/payment/17\" target=\"_blank\">#17</a>\";}', '1', 'Mario Puche', '2023-02-03 15:19:34');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (86, 'invoice', 31, 'invoice_activity_created', '', '1', 'Mario Puche', '2023-02-03 15:21:58');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (87, 'invoice', 32, 'invoice_activity_created', '', '1', 'Mario Puche', '2023-02-03 15:31:17');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (88, 'invoice', 33, 'invoice_activity_created', '', '1', 'Mario Puche', '2023-02-14 12:18:59');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (89, 'invoice', 34, 'invoice_activity_created', '', '1', 'Mario Puche', '2023-02-14 12:20:22');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (90, 'invoice', 34, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>2</new_status>\";}', '1', 'Mario Puche', '2023-02-14 12:20:32');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (91, 'invoice', 34, 'invoice_activity_payment_made_by_staff', 'a:2:{i:0;s:8:\"18,50€\";i:1;s:88:\"<a href=\"https://panel.blitconcept.es/admin/payments/payment/18\" target=\"_blank\">#18</a>\";}', '1', 'Mario Puche', '2023-02-14 12:20:32');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (92, 'invoice', 33, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>2</new_status>\";}', '1', 'Mario Puche', '2023-02-14 12:20:42');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (93, 'invoice', 33, 'invoice_activity_payment_made_by_staff', 'a:2:{i:0;s:8:\"22,49€\";i:1;s:88:\"<a href=\"https://panel.blitconcept.es/admin/payments/payment/19\" target=\"_blank\">#19</a>\";}', '1', 'Mario Puche', '2023-02-14 12:20:42');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (94, 'invoice', 31, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>4</new_status>\";}', '[CRON]', '[CRON]', '2023-02-18 21:04:02');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (95, 'invoice', 35, 'invoice_activity_created', '', '1', 'Mario Puche', '2023-02-24 12:36:22');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (96, 'invoice', 35, 'invoice_estimate_activity_removed_item', 'a:1:{i:0;s:11:\"RAPEL BUMBU\";}', '1', 'Mario Puche', '2023-02-27 14:45:49');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (97, 'invoice', 35, 'invoice_estimate_activity_updated_item_short_description', 'a:2:{i:0;s:19:\"CUERDO JOSÉ CUERVO\";i:1;s:20:\"ACUERDO JOSÉ CUERVO\";}', '1', 'Mario Puche', '2023-02-27 14:45:49');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (98, 'invoice', 36, 'invoice_activity_created', '', '1', 'Mario Puche', '2023-02-27 14:46:23');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (99, 'invoice', 32, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>4</new_status>\";}', '[CRON]', '[CRON]', '2023-03-06 21:00:02');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (100, 'invoice', 35, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>4</new_status>\";}', '[CRON]', '[CRON]', '2023-03-27 21:03:09');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (101, 'invoice', 36, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>4</new_status>\";}', '[CRON]', '[CRON]', '2023-03-30 21:03:16');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (102, 'invoice', 37, 'invoice_activity_created', '', '1', 'Mario Puche', '2023-04-17 19:57:15');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (103, 'invoice', 38, 'invoice_activity_created', '', '1', 'Mario Puche', '2023-04-17 19:58:52');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (104, 'invoice', 39, 'invoice_activity_created', '', '1', 'Mario Puche', '2023-04-17 19:59:11');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (105, 'invoice', 39, 'invoice_estimate_activity_removed_item', 'a:1:{i:0;s:27:\"COLABORACIÓN MARCAS DIAGEO\";}', '1', 'Mario Puche', '2023-04-17 20:00:40');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (106, 'invoice', 39, 'invoice_estimate_activity_added_item', 'a:1:{i:0;s:27:\"Colaboración Marcas Diageo\";}', '1', 'Mario Puche', '2023-04-17 20:00:40');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (107, 'invoice', 39, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>6</original_status>\";i:1;s:26:\"<new_status>1</new_status>\";}', '1', 'Mario Puche', '2023-04-17 20:00:47');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (108, 'invoice', 39, 'invoice_activity_marked_as_sent', 'a:0:{}', '1', 'Mario Puche', '2023-04-17 20:00:47');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (109, 'invoice', 37, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>4</new_status>\";}', '[CRON]', '[CRON]', '2023-05-01 21:03:09');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (110, 'invoice', 38, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>4</new_status>\";}', '[CRON]', '[CRON]', '2023-05-01 21:03:16');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (111, 'invoice', 39, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>4</new_status>\";}', '[CRON]', '[CRON]', '2023-05-01 21:03:24');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (112, 'invoice', 40, 'invoice_activity_created', '', '1', 'Mario Puche', '2023-07-17 23:31:47');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (113, 'invoice', 41, 'invoice_activity_created', '', '1', 'Mario Puche', '2023-07-17 23:34:27');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (114, 'invoice', 40, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>4</new_status>\";}', '[CRON]', '[CRON]', '2023-08-17 21:03:31');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (115, 'invoice', 41, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>4</new_status>\";}', '[CRON]', '[CRON]', '2023-08-17 21:03:38');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (116, 'invoice', 42, 'invoice_activity_created', '', '1', 'Mario Puche', '2023-09-11 10:03:45');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (117, 'invoice', 40, 'invoice_estimate_activity_updated_item_rate', 'a:2:{i:0;s:7:\"2569.77\";i:1;s:7:\"2336.15\";}', '1', 'Mario Puche', '2023-09-15 19:14:52');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (118, 'invoice', 40, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>4</original_status>\";i:1;s:26:\"<new_status>2</new_status>\";}', '1', 'Mario Puche', '2023-09-15 19:15:00');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (119, 'invoice', 40, 'invoice_activity_payment_made_by_staff', 'a:2:{i:0;s:11:\"2.569,77€\";i:1;s:88:\"<a href=\"https://panel.blitconcept.es/admin/payments/payment/20\" target=\"_blank\">#20</a>\";}', '1', 'Mario Puche', '2023-09-15 19:15:00');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (120, 'invoice', 43, 'invoice_activity_created', '', '1', 'Mario Puche', '2023-09-29 12:09:34');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (121, 'invoice', 42, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>4</new_status>\";}', '[CRON]', '[CRON]', '2023-10-12 21:04:35');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (122, 'invoice', 44, 'invoice_activity_created', '', '1', 'Mario Puche', '2023-10-13 10:56:32');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (123, 'invoice', 45, 'invoice_activity_created', '', '1', 'Mario Puche', '2023-10-30 17:36:11');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (124, 'invoice', 43, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>4</new_status>\";}', '[CRON]', '[CRON]', '2023-10-30 21:04:42');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (125, 'invoice', 44, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>4</new_status>\";}', '[CRON]', '[CRON]', '2023-11-13 21:04:24');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (126, 'estimate', 1, 'estimate_activity_created', '', '1', 'Mario Puche', '2023-11-15 10:46:49');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (127, 'estimate', 1, 'invoice_estimate_activity_added_item', 'a:1:{i:0;s:8:\"Prueba 2\";}', '1', 'Mario Puche', '2023-11-15 10:47:27');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (128, 'invoice', 46, 'invoice_activity_created', '', '1', 'Mario Puche', '2023-11-22 12:34:42');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (129, 'invoice', 47, 'invoice_activity_created', '', '1', 'Mario Puche', '2023-11-28 12:01:45');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (130, 'invoice', 48, 'invoice_activity_created', '', '1', 'Mario Puche', '2023-11-28 12:03:19');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (131, 'invoice', 48, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>2</new_status>\";}', '1', 'Mario Puche', '2023-11-28 12:04:07');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (132, 'invoice', 48, 'invoice_activity_payment_made_by_staff', 'a:2:{i:0;s:9:\"319,10€\";i:1;s:88:\"<a href=\"https://panel.blitconcept.es/admin/payments/payment/21\" target=\"_blank\">#21</a>\";}', '1', 'Mario Puche', '2023-11-28 12:04:07');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (133, 'invoice', 47, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>2</new_status>\";}', '1', 'Mario Puche', '2023-11-28 12:04:15');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (134, 'invoice', 47, 'invoice_activity_payment_made_by_staff', 'a:2:{i:0;s:8:\"20,45€\";i:1;s:88:\"<a href=\"https://panel.blitconcept.es/admin/payments/payment/22\" target=\"_blank\">#22</a>\";}', '1', 'Mario Puche', '2023-11-28 12:04:15');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (135, 'invoice', 49, 'invoice_activity_created', '', '1', 'Mario Puche', '2023-11-28 12:06:19');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (136, 'invoice', 49, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>2</new_status>\";}', '1', 'Mario Puche', '2023-11-28 12:06:23');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (137, 'invoice', 49, 'invoice_activity_payment_made_by_staff', 'a:2:{i:0;s:8:\"63,00€\";i:1;s:88:\"<a href=\"https://panel.blitconcept.es/admin/payments/payment/23\" target=\"_blank\">#23</a>\";}', '1', 'Mario Puche', '2023-11-28 12:06:23');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (138, 'invoice', 45, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>4</new_status>\";}', '[CRON]', '[CRON]', '2023-12-02 21:01:51');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (139, 'invoice', 46, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>4</new_status>\";}', '[CRON]', '[CRON]', '2023-12-23 21:06:56');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (140, 'invoice', 50, 'invoice_activity_created', '', '1', 'Mario Puche', '2023-12-26 20:09:03');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (141, 'invoice', 51, 'invoice_activity_created', '', '1', 'Mario Puche', '2024-01-09 19:22:39');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (142, 'invoice', 51, 'invoice_estimate_activity_updated_item_short_description', 'a:2:{i:0;s:24:\"CANON EVENTO PLAZA TOROS\";i:1;s:12:\"CENA EMPRESA\";}', '1', 'Mario Puche', '2024-01-10 12:37:42');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (143, 'invoice', 51, 'invoice_estimate_activity_updated_item_long_description', 'a:2:{i:0;s:28:\"Devolución importe restante\";i:1;s:26:\"Servicios en restauración\";}', '1', 'Mario Puche', '2024-01-10 12:37:42');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (144, 'invoice', 50, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>4</new_status>\";}', '[CRON]', '[CRON]', '2024-01-26 21:02:38');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (145, 'invoice', 52, 'invoice_activity_created', '', '1', 'Mario Puche', '2024-01-31 09:50:01');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (146, 'invoice', 53, 'invoice_activity_created', '', '1', 'Mario Puche', '2024-01-31 11:42:41');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (147, 'invoice', 54, 'invoice_activity_created', '', '1', 'Mario Puche', '2024-01-31 11:43:48');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (148, 'invoice', 55, 'invoice_activity_created', '', '1', 'Mario Puche', '2024-01-31 11:49:58');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (149, 'invoice', 51, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>4</new_status>\";}', '[CRON]', '[CRON]', '2024-01-31 21:07:06');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (150, 'invoice', 52, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>4</new_status>\";}', '[CRON]', '[CRON]', '2024-02-01 21:03:45');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (151, 'invoice', 53, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>4</new_status>\";}', '[CRON]', '[CRON]', '2024-02-01 21:03:52');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (152, 'invoice', 54, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>4</new_status>\";}', '[CRON]', '[CRON]', '2024-02-01 21:04:00');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (153, 'invoice', 55, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>4</new_status>\";}', '[CRON]', '[CRON]', '2024-02-01 21:04:07');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (154, 'invoice', 52, 'invoice_estimate_activity_removed_item', 'a:1:{i:0;s:17:\"ACUERDO DE IMAGEN\";}', '1', 'Mario Puche', '2024-02-01 23:07:25');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (155, 'invoice', 56, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>4</new_status>\";}', '1', 'Mario Puche', '2024-02-01 23:08:12');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (156, 'invoice', 56, 'invoice_activity_created', '', '1', 'Mario Puche', '2024-02-01 23:08:12');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (157, 'invoice', 54, 'invoice_estimate_activity_updated_item_short_description', 'a:2:{i:0;s:20:\"Acuerdo visibilidad \";i:1;s:19:\"Acuerdo visibilidad\";}', '1', 'Mario Puche', '2024-02-06 12:51:48');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (158, 'invoice', 54, 'invoice_estimate_activity_updated_item_long_description', 'a:2:{i:0;s:5:\"Gvine\";i:1;s:20:\"Gvine PO: 2000293982\";}', '1', 'Mario Puche', '2024-02-06 12:51:48');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (159, 'invoice', 57, 'invoice_activity_created', '', '1', 'Mario Puche', '2024-02-12 17:29:56');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (160, 'invoice', 58, 'invoice_activity_created', '', '1', 'Mario Puche', '2024-02-12 17:32:12');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (161, 'invoice', 59, 'invoice_activity_created', '', '1', 'Mario Puche', '2024-02-12 17:34:22');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (162, 'invoice', 59, 'invoice_estimate_activity_updated_item_short_description', 'a:2:{i:0;s:20:\"ALOJAMIENTO PERSONAL\";i:1;s:23:\"SERVICIOS RESTAURACIÓN\";}', '1', 'Mario Puche', '2024-02-12 17:35:11');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (163, 'invoice', 59, 'invoice_estimate_activity_updated_item_long_description', 'a:2:{i:0;s:0:\"\";i:1;s:26:\"Establecimiento KAO LOUNGE\";}', '1', 'Mario Puche', '2024-02-12 17:35:11');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (164, 'invoice', 58, 'invoice_estimate_activity_updated_item_short_description', 'a:2:{i:0;s:35:\"SERVICIO CATERING ARTISTAS VALENCIA\";i:1;s:26:\"SERVICIO CATERING ARTISTAS\";}', '1', 'Mario Puche', '2024-02-12 17:35:30');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (165, 'invoice', 58, 'invoice_estimate_activity_updated_item_long_description', 'a:2:{i:0;s:42:\"Prestado en el evento Valencia VIBRA MAHOU\";i:1;s:0:\"\";}', '1', 'Mario Puche', '2024-02-12 17:35:30');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (166, 'invoice', 60, 'invoice_activity_created', '', '1', 'Mario Puche', '2024-02-20 19:35:29');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (167, 'invoice', 60, 'invoice_estimate_activity_updated_item_short_description', 'a:2:{i:0;s:45:\"Acuerdo marketing y visibilidad Gin Zeeland\r\n\";i:1;s:48:\"Acuerdo marketing y visibilidad Gin Zeeland 2023\";}', '1', 'Mario Puche', '2024-02-20 19:35:41');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (168, 'invoice', 61, 'invoice_activity_created', '', '1', 'Mario Puche', '2024-02-20 19:37:19');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (169, 'invoice', 62, 'invoice_activity_created', '', '1', 'Mario Puche', '2024-02-20 20:55:21');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (170, 'invoice', 57, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>4</new_status>\";}', '[CRON]', '[CRON]', '2024-03-14 21:01:05');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (171, 'invoice', 58, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>4</new_status>\";}', '[CRON]', '[CRON]', '2024-03-14 21:01:05');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (172, 'invoice', 59, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>4</new_status>\";}', '[CRON]', '[CRON]', '2024-03-14 21:01:05');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (173, 'invoice', 60, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>4</new_status>\";}', '[CRON]', '[CRON]', '2024-03-22 21:05:07');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (174, 'invoice', 61, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>4</new_status>\";}', '[CRON]', '[CRON]', '2024-03-22 21:05:07');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (175, 'invoice', 62, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>4</new_status>\";}', '[CRON]', '[CRON]', '2024-03-22 21:05:08');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (176, 'invoice', 63, 'invoice_activity_created', '', '1', 'Mario Puche', '2024-09-10 19:40:00');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (177, 'invoice', 64, 'invoice_activity_created', '', '1', 'Mario Puche', '2024-09-10 20:00:46');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (178, 'invoice', 64, 'invoice_estimate_activity_updated_item_rate', 'a:2:{i:0;s:7:\"3000.00\";i:1;s:7:\"1950.00\";}', '1', 'Mario Puche', '2024-09-10 20:02:41');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (179, 'invoice', 65, 'invoice_activity_created', '', '1', 'Mario Puche', '2024-09-10 20:02:49');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (180, 'invoice', 65, 'invoice_estimate_activity_updated_item_rate', 'a:2:{i:0;s:7:\"1950.00\";i:1;s:3:\"100\";}', '1', 'Mario Puche', '2024-09-10 20:03:07');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (181, 'invoice', 65, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>6</original_status>\";i:1;s:26:\"<new_status>1</new_status>\";}', '1', 'Mario Puche', '2024-09-10 20:03:19');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (182, 'invoice', 65, 'invoice_activity_marked_as_sent', 'a:0:{}', '1', 'Mario Puche', '2024-09-10 20:03:19');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (183, 'invoice', 66, 'invoice_activity_created', '', '1', 'Mario Puche', '2024-09-10 20:03:23');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (184, 'invoice', 66, 'invoice_estimate_activity_updated_item_rate', 'a:2:{i:0;s:6:\"100.00\";i:1;s:6:\"950.00\";}', '1', 'Mario Puche', '2024-09-10 20:03:33');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (185, 'invoice', 66, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>6</original_status>\";i:1;s:26:\"<new_status>1</new_status>\";}', '1', 'Mario Puche', '2024-09-10 20:03:38');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (186, 'invoice', 66, 'invoice_activity_marked_as_sent', 'a:0:{}', '1', 'Mario Puche', '2024-09-10 20:03:38');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (187, 'invoice', 63, 'invoice_activity_status_updated', 'a:2:{i:0;s:36:\"<original_status>1</original_status>\";i:1;s:26:\"<new_status>4</new_status>\";}', '[CRON]', '[CRON]', '2024-09-16 21:05:06');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (188, 'invoice', 67, 'invoice_activity_created', '', '1', 'Mario Puche', '2024-09-17 11:43:13');
INSERT INTO `tblsales_activity` (`id`, `rel_type`, `rel_id`, `description`, `additional_data`, `staffid`, `full_name`, `date`) VALUES (189, 'invoice', 68, 'invoice_activity_created', '', '1', 'Mario Puche', '2024-09-19 20:14:27');


#
# TABLE STRUCTURE FOR: tblscheduled_emails
#

DROP TABLE IF EXISTS `tblscheduled_emails`;

CREATE TABLE `tblscheduled_emails` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rel_id` int(11) NOT NULL,
  `rel_type` varchar(15) NOT NULL,
  `scheduled_at` datetime NOT NULL,
  `contacts` varchar(197) NOT NULL,
  `cc` text DEFAULT NULL,
  `attach_pdf` tinyint(1) NOT NULL DEFAULT 1,
  `template` varchar(197) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblservices
#

DROP TABLE IF EXISTS `tblservices`;

CREATE TABLE `tblservices` (
  `serviceid` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  PRIMARY KEY (`serviceid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblsessions
#

DROP TABLE IF EXISTS `tblsessions`;

CREATE TABLE `tblsessions` (
  `id` varchar(128) NOT NULL,
  `ip_address` varchar(45) NOT NULL,
  `timestamp` int(10) unsigned NOT NULL DEFAULT 0,
  `data` blob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ci_sessions_timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('003j8gubhj8bpde0pvu668iahrrcjqiv', '2a12:d280:100:51::', 1727112302, '__ci_last_regenerate|i:1727112302;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0063mha8clk3jt1f1i36vvjvsjtburr8', '2a12:d280:100:51::', 1727270642, '__ci_last_regenerate|i:1727270642;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('00cuf9cj57l7t6rfiokrf1jshkthd07v', '2a12:d280:100:51::', 1727123522, '__ci_last_regenerate|i:1727123521;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('00d575hq7tkhkp8ebrn5picevng51cpq', '2a12:d280:100:51::', 1727076061, '__ci_last_regenerate|i:1727076061;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('00ir289at6rt2h3vlt3fb8vs38s1g4bm', '2a12:d280:100:51::', 1727190121, '__ci_last_regenerate|i:1727190121;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('013s5qmgt0878si5nt9rcjhpt7ukmc9p', '2a12:d280:100:51::', 1727055841, '__ci_last_regenerate|i:1727055841;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('01fvvt4dh461gh20ufq8m2clj4oo47q8', '2a12:d280:100:51::', 1727098982, '__ci_last_regenerate|i:1727098982;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('02ed9frrectqbpureps45ivvtpu2et1f', '2a12:d280:100:51::', 1727085781, '__ci_last_regenerate|i:1727085781;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('02k1a187hgqjvdjf71v2agf61nf8hsju', '2a12:d280:100:51::', 1727227502, '__ci_last_regenerate|i:1727227502;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('03b3di34jode8928numm4pnnpq5llqp5', '2a12:d280:100:51::', 1727210222, '__ci_last_regenerate|i:1727210222;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('03hg604l47bdpggro2buidahd98groo2', '2a12:d280:100:51::', 1727105281, '__ci_last_regenerate|i:1727105281;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('042rti877t6vj7cdktkm8kqen5iah66r', '2a12:d280:100:51::', 1727177641, '__ci_last_regenerate|i:1727177641;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('044a07qqgqlottdp0fo53228q2pdr2c9', '2a12:d280:100:51::', 1727051282, '__ci_last_regenerate|i:1727051282;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('04e98h56g5pcihq5q5lt9kl7tepfd77u', '2a12:d280:100:51::', 1727162102, '__ci_last_regenerate|i:1727162101;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('04mvfddu3mitmtih22644tnnlfm3c7i0', '2a12:d280:100:51::', 1727102641, '__ci_last_regenerate|i:1727102641;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('04oun1ec0dgjkm276eviueq64fhs30kc', '2a12:d280:100:51::', 1727165941, '__ci_last_regenerate|i:1727165941;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('04t6jkn5rohh8b2e50h8qslnd4ibj5j7', '2a12:d280:100:51::', 1727064781, '__ci_last_regenerate|i:1727064781;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('051acc47uilj333feuiva4vie9cg4kq3', '2a12:d280:100:51::', 1727212322, '__ci_last_regenerate|i:1727212321;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('05b65ga13cl5q54lkqp9m3sauve76me7', '2a12:d280:100:51::', 1727187061, '__ci_last_regenerate|i:1727187061;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('05k8e4156spkpsutl6pooe9b5gdc8o6h', '2a12:d280:100:51::', 1727135641, '__ci_last_regenerate|i:1727135641;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('05ksdpelpc4ph23c6uqpmfgbmvqchvj8', '2a12:d280:100:51::', 1727099282, '__ci_last_regenerate|i:1727099282;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0671q0r3mk2cd74h6l3mc9dk39sl48l3', '2a12:d280:100:51::', 1727081042, '__ci_last_regenerate|i:1727081042;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('06alufat054tnr9dim4s2cn1lfrfr5a9', '2a12:d280:100:51::', 1727190901, '__ci_last_regenerate|i:1727190901;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('06fnvgsto9bnmtlov4jshtkv1o7se41b', '2a12:d280:100:51::', 1727201702, '__ci_last_regenerate|i:1727201702;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('06k9ctjlf4fob9un7dvbr5olfd3kg38m', '2a12:d280:100:51::', 1727183522, '__ci_last_regenerate|i:1727183522;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('071e16h3ehdo0d7anp7ftuivtup4fvig', '2a12:d280:100:51::', 1727109422, '__ci_last_regenerate|i:1727109422;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('07as95nvebj12t8ed3bvtisuftaj1hn9', '2a12:d280:100:51::', 1727228462, '__ci_last_regenerate|i:1727228462;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('07bmuvlm51egj7ecfmir81tq2mpot225', '2a12:d280:100:51::', 1727190722, '__ci_last_regenerate|i:1727190722;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('07g4m6u6o6fnkps0vn23p16b6nimfvju', '2a12:d280:100:51::', 1727068202, '__ci_last_regenerate|i:1727068202;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0824p1prm02on4i7msj59rl6rtffjm9v', '2a12:d280:100:51::', 1727122322, '__ci_last_regenerate|i:1727122322;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('083opm2me6pthsgoog52nvs6bolk8ufj', '2a12:d280:100:51::', 1727211662, '__ci_last_regenerate|i:1727211662;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0858pq96mke8rhu6i1pt7pr7p3hr2gv2', '184.72.121.156', 1727272467, '__ci_last_regenerate|i:1727272466;red_url|s:62:\"https://panel.blitconcept.es/admin/resourcebooking/statistical\";_prev_url|s:49:\"https://panel.blitconcept.es/admin/authentication\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('08d8imjqe68elpqomfib0klpb59rd6ha', '2a12:d280:100:51::', 1727093882, '__ci_last_regenerate|i:1727093882;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('08f5apjabc68hs9gi7pqli8jj7kpqbhi', '2a12:d280:100:51::', 1727066641, '__ci_last_regenerate|i:1727066641;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('08josrin8io07b9oe8gqg8sjaisavl9g', '2a12:d280:100:51::', 1727262241, '__ci_last_regenerate|i:1727262241;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('08u1ttoc0bkrr5lm181tru7eco4vk26e', '2a12:d280:100:51::', 1727201641, '__ci_last_regenerate|i:1727201641;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('08uc3c493167j4ivjk9enpj6tmjgt1or', '2a12:d280:100:51::', 1727115961, '__ci_last_regenerate|i:1727115961;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('08vferrjksri80t630seao494hui2554', '2a12:d280:100:51::', 1727286121, '__ci_last_regenerate|i:1727286121;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('094gecepcg6hpdobi0e3tbca3n9gp8lk', '2a12:d280:100:51::', 1727215682, '__ci_last_regenerate|i:1727215682;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('09guc868tbv9gqh1i8j2g3icrv9npju3', '2a12:d280:100:51::', 1727271962, '__ci_last_regenerate|i:1727271962;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0a6n9h09e60p6m08c26o1o4r6877vg3h', '2a12:d280:100:51::', 1727222461, '__ci_last_regenerate|i:1727222461;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0abmbo130dr6sbr5cnk0smnpqssaon94', '2a12:d280:100:51::', 1727151121, '__ci_last_regenerate|i:1727151121;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0ao99j2c9hh5j8rjdrcbe43873uc5vi0', '2a12:d280:100:51::', 1727125922, '__ci_last_regenerate|i:1727125922;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0aob5m09laksgpkt78gjsc2cernpvri1', '2a12:d280:100:51::', 1727263502, '__ci_last_regenerate|i:1727263502;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0ap7u9vg95poaib7rqgvm8oo34e3hr5h', '2a12:d280:100:51::', 1727164982, '__ci_last_regenerate|i:1727164982;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0atp7e2v658079jtrjuoagmoe957i5bn', '2a12:d280:100:51::', 1727118061, '__ci_last_regenerate|i:1727118061;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0b9j7tojhv5mdmg2hvaorjc5qu2u6qok', '2a12:d280:100:51::', 1727068802, '__ci_last_regenerate|i:1727068802;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0bd4hldr6mn5t4atjobcieahr51nrpfv', '2a12:d280:100:51::', 1727076842, '__ci_last_regenerate|i:1727076842;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0bevmv7mmfjki716tiilfa2t1v8faqoa', '2a12:d280:100:51::', 1727046841, '__ci_last_regenerate|i:1727046841;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0bhg88gopiqdoubn3kjktd16h5eaiteq', '2a12:d280:100:51::', 1727145481, '__ci_last_regenerate|i:1727145481;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0c4uvvcqr3gdrhcs39v93jgv7pl6qqrf', '2a12:d280:100:51::', 1727099881, '__ci_last_regenerate|i:1727099881;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0c53hk1km0v9ce3dnsf5ejhh7rn25o4e', '2a12:d280:100:51::', 1727146681, '__ci_last_regenerate|i:1727146681;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0ck2rekas24mi3q9p4ttttemkjqr375o', '2a12:d280:100:51::', 1727194562, '__ci_last_regenerate|i:1727194562;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0cs63qrgfv0746tsj4pldeia3vs0plrl', '2a12:d280:100:51::', 1727122982, '__ci_last_regenerate|i:1727122982;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0dhipb41h261hrqoue97oajj6tcjrm3o', '2a12:d280:100:51::', 1727115002, '__ci_last_regenerate|i:1727115002;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0dhrocq87ggof21r1k4sbkiegn74enjq', '2a12:d280:100:51::', 1727063701, '__ci_last_regenerate|i:1727063701;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0du4cb8vium37vpano0ngtg0bh0ipqr3', '2a12:d280:100:51::', 1727266082, '__ci_last_regenerate|i:1727266082;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0echns4vohgm8qbvkr60btv4hk2eqjd9', '2a12:d280:100:51::', 1727073302, '__ci_last_regenerate|i:1727073301;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0f95tpqli01vcnncopkeadstc82ut46c', '2a12:d280:100:51::', 1727295662, '__ci_last_regenerate|i:1727295662;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0fi1bik6midqesph3jt7oj3l2aicl97s', '2a12:d280:100:51::', 1727237342, '__ci_last_regenerate|i:1727237342;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0fvqfi78pujs20pa4gn9balo05p2mrm0', '2a12:d280:100:51::', 1727272561, '__ci_last_regenerate|i:1727272561;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0g54sos5lebhoa79gc7pp75n1dcn8hec', '2a12:d280:100:51::', 1727052242, '__ci_last_regenerate|i:1727052242;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0g5vpufnho0245mrearq6uk8gvi4ff94', '2a12:d280:100:51::', 1727156822, '__ci_last_regenerate|i:1727156822;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0gaqimb72g8b1761e0t5je59d1gmmad9', '2a12:d280:100:51::', 1727075402, '__ci_last_regenerate|i:1727075402;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0gcghdkrst4dn0jpbeg9s8acs9mvc3r6', '2a12:d280:100:51::', 1727171521, '__ci_last_regenerate|i:1727171521;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0gv28q19nj6d6h7r8b5jr5u000beeok4', '2a12:d280:100:51::', 1727195762, '__ci_last_regenerate|i:1727195762;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0h1gco976g2cab553me5l7l6f0k2mdai', '2a12:d280:100:51::', 1727234161, '__ci_last_regenerate|i:1727234161;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0h3ndu6h62u55mr55k54d84g0v5damhb', '2a12:d280:100:51::', 1727222701, '__ci_last_regenerate|i:1727222701;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0h5lqb5ca76jfsj0pkt45vgabravc5aa', '2a12:d280:100:51::', 1727219462, '__ci_last_regenerate|i:1727219462;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0hepn3ivpnd8b5sf307249km34t3n35s', '2a12:d280:100:51::', 1727238361, '__ci_last_regenerate|i:1727238361;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0hh1ht4c6inup6ekiodsdtvan54r66jp', '2a12:d280:100:51::', 1727057221, '__ci_last_regenerate|i:1727057221;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0hr3gc1ngt9c15sei9kkmv0vu3u6nlgp', '2a12:d280:100:51::', 1727080562, '__ci_last_regenerate|i:1727080562;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0huf30a8gb7mmrfh9jskr0jfspm24gjm', '2a12:d280:100:51::', 1727148781, '__ci_last_regenerate|i:1727148781;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0i576sscmmumvkpjaa0s4ebevo4vu1mn', '2a12:d280:100:51::', 1727177941, '__ci_last_regenerate|i:1727177941;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0i66evm1kcsndtuur3j1vgeficrj7t21', '2a12:d280:100:51::', 1727179202, '__ci_last_regenerate|i:1727179202;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0ik4hei6tf1k142fi6aovt1uvekf9chu', '2a12:d280:100:51::', 1727139781, '__ci_last_regenerate|i:1727139781;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0in4ds4q8uhe518o6rav7hira7cm7q0b', '2a12:d280:100:51::', 1727166421, '__ci_last_regenerate|i:1727166421;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0iovtjdnnjd2toc9l9gsoap1229gai5s', '2a12:d280:100:51::', 1727089262, '__ci_last_regenerate|i:1727089262;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0ise93f88jgfcvvqrc1haqp9645tg0m9', '2a12:d280:100:51::', 1727166362, '__ci_last_regenerate|i:1727166362;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0jbdpjtif8u4sfu3thberoiue77gavsk', '2a12:d280:100:51::', 1727235421, '__ci_last_regenerate|i:1727235421;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0jl0m0unjnv8n5fi9c4hng9bvjqcoobi', '2a12:d280:100:51::', 1727252581, '__ci_last_regenerate|i:1727252581;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0jo9i25449ojoon8a1ei55gqkseu7no7', '2a12:d280:100:51::', 1727223121, '__ci_last_regenerate|i:1727223121;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0jq87a68kui8vj3b4rr0c93p5u8cfah3', '2a12:d280:100:51::', 1727293201, '__ci_last_regenerate|i:1727293201;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0k8j11h713ms6bqdg2kvjre4u5but3uk', '2a12:d280:100:51::', 1727267882, '__ci_last_regenerate|i:1727267882;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0ktgqm3eq18kflllnicq6ucbb6b8dega', '2a12:d280:100:51::', 1727140142, '__ci_last_regenerate|i:1727140142;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0l6ifpmoonfj4c7mm9bf6emifhahcj8l', '2a12:d280:100:51::', 1727146022, '__ci_last_regenerate|i:1727146022;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0l82b1i1km4mkk4cvfo4rt2bh9964pu1', '2a12:d280:100:51::', 1727100422, '__ci_last_regenerate|i:1727100422;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0lb5spcf9rn1b49i7i39ps2q89rlvqns', '2a12:d280:100:51::', 1727158381, '__ci_last_regenerate|i:1727158381;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0m02csqicfemsravtngi2jumu2soafrv', '2a12:d280:100:51::', 1727235481, '__ci_last_regenerate|i:1727235481;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0m1rnc83k6j8t14l3faj6tr17dsa6tr2', '2a12:d280:100:51::', 1727051582, '__ci_last_regenerate|i:1727051582;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0mcv7dj8vrp9bcdaakbkt3556odm2lha', '2a12:d280:100:51::', 1727245081, '__ci_last_regenerate|i:1727245081;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0mfiedm9gsggv94vi2jv4ikdq5kugcjq', '2a12:d280:100:51::', 1727102402, '__ci_last_regenerate|i:1727102402;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0mh4erc1joa5c5supg38fdspvr43s0bg', '2a12:d280:100:51::', 1727254261, '__ci_last_regenerate|i:1727254261;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0mhnjs6tttrtvphsavlgs5jeffbj3nb3', '2a12:d280:100:51::', 1727281681, '__ci_last_regenerate|i:1727281681;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0mk0soamn0uirf595tjq3hmhn0n7t39m', '2a12:d280:100:51::', 1727222162, '__ci_last_regenerate|i:1727222162;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0mmfliksb6lml19r3mhu5ckuse1dgjfe', '2a12:d280:100:51::', 1727193661, '__ci_last_regenerate|i:1727193661;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0mq3tq5if18lk59bvs5bo5polsh0msm1', '2a12:d280:100:51::', 1727107561, '__ci_last_regenerate|i:1727107561;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0mrbboqdab03g1qdaaqqhhur67lrglup', '2a12:d280:100:51::', 1727155681, '__ci_last_regenerate|i:1727155681;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0nc7bavugl761h08u2ab0sim4kfkfs5q', '2a12:d280:100:51::', 1727104742, '__ci_last_regenerate|i:1727104742;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0o8kg0qmrmpvr0ensgj5qketud7cbi51', '2a12:d280:100:51::', 1727199181, '__ci_last_regenerate|i:1727199181;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0ogkp0c6ou92g5djhdp9ep7eq1ca54f8', '2a12:d280:100:51::', 1727189042, '__ci_last_regenerate|i:1727189042;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0p0od5r0fmv2jqugirj8l38nigc4ih5d', '2a12:d280:100:51::', 1727059801, '__ci_last_regenerate|i:1727059801;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0p6t698clddrvc2dl1h58mus60858ci7', '2a12:d280:100:51::', 1727224202, '__ci_last_regenerate|i:1727224202;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0p7j6n6ebdl486i0kefre958h8j3pm5s', '2a12:d280:100:51::', 1727143502, '__ci_last_regenerate|i:1727143502;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0pgoep08sqmchknqr4qor3f8n1qjv869', '2a12:d280:100:51::', 1727127542, '__ci_last_regenerate|i:1727127541;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0ph77j787dkks293so9soqtinr6f7p43', '2a12:d280:100:51::', 1727242441, '__ci_last_regenerate|i:1727242441;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0pjvtd944q8m9bgnrlahp407dqd8cj5l', '2a12:d280:100:51::', 1727230322, '__ci_last_regenerate|i:1727230322;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0pmf1l68qdbnblb9gcd7g2uojhjmms8f', '2a12:d280:100:51::', 1727085181, '__ci_last_regenerate|i:1727085181;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0q04i38ceir6q2ii8cu6k0or5dcc9kjd', '2a12:d280:100:51::', 1727101382, '__ci_last_regenerate|i:1727101382;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0q6immsghoukas42hhus1dnkmbo6jppq', '2a12:d280:100:51::', 1727243582, '__ci_last_regenerate|i:1727243582;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0qc7u2931g2h8rc51tasvcciqogm4grl', '2a12:d280:100:51::', 1727283422, '__ci_last_regenerate|i:1727283422;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0qdu8c29nid3oupbdks479g0mrnm2fqq', '2a12:d280:100:51::', 1727155442, '__ci_last_regenerate|i:1727155442;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0qmn8mgelfok4cq6qc7dio5vh13ld0uf', '2a12:d280:100:51::', 1727142302, '__ci_last_regenerate|i:1727142302;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0r56q99mrk1q03alob51b1dganso7gcm', '2a12:d280:100:51::', 1727243401, '__ci_last_regenerate|i:1727243401;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0r6jjoqh3qii6njr5rfd3jnuphm124p6', '2a12:d280:100:51::', 1727284082, '__ci_last_regenerate|i:1727284082;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0r98f0n8ognjgr6ahd4i3v78cd7ntfqm', '2a12:d280:100:51::', 1727128621, '__ci_last_regenerate|i:1727128621;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0rqp20gm5sgbg3v2m5egbqh3s7hta893', '2a12:d280:100:51::', 1727296261, '__ci_last_regenerate|i:1727296261;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0rskkgm0f8ndc1ssmt1uu0n9ms4asrtg', '2a12:d280:100:51::', 1727183882, '__ci_last_regenerate|i:1727183882;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0rueselvbcnb8k2n55lus92anmnca1b7', '2a12:d280:100:51::', 1727198282, '__ci_last_regenerate|i:1727198282;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0ruu639j4j4vjeukghvk8gb8dbi4jdhh', '2a12:d280:100:51::', 1727149322, '__ci_last_regenerate|i:1727149322;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0s6mivpmagev35otri4mh0bmc8aj9am5', '2a12:d280:100:51::', 1727183221, '__ci_last_regenerate|i:1727183221;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0st7859misj85r7540561pd9j6on5r9q', '2a12:d280:100:51::', 1727239562, '__ci_last_regenerate|i:1727239561;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0tae8hiunk5dlm5r90h4t59jb163vbed', '2a12:d280:100:51::', 1727286902, '__ci_last_regenerate|i:1727286902;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0tgcthmm4jl0343up2p6f4pcn3aad39t', '2a12:d280:100:51::', 1727133061, '__ci_last_regenerate|i:1727133061;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0tleftb1e6guk5q03vsrtoq69avhab2h', '2a12:d280:100:51::', 1727162822, '__ci_last_regenerate|i:1727162822;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0tvlf1lmhnkdjbj3mgs8c03cora050f8', '2a12:d280:100:51::', 1727084162, '__ci_last_regenerate|i:1727084162;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0u1937dv46pj1budscnj5nu63sgvm4b4', '2a12:d280:100:51::', 1727058121, '__ci_last_regenerate|i:1727058121;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0u707pfhsmq4sh10r5oe2cvpkn0mrjks', '2a12:d280:100:51::', 1727154001, '__ci_last_regenerate|i:1727154001;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0ucmsgmok75pr48oi7n5u5d9982uck55', '2a12:d280:100:51::', 1727161621, '__ci_last_regenerate|i:1727161621;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0ue2pkrvul6rs8ubcjfv43mmbhsk12jr', '2a12:d280:100:51::', 1727218142, '__ci_last_regenerate|i:1727218142;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0upvnlij5jn0o0qb4hkrodu39k1at47e', '2a12:d280:100:51::', 1727214362, '__ci_last_regenerate|i:1727214362;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0ut822dsthjcka6h3phdlbmhskkfr637', '2a12:d280:100:51::', 1727088962, '__ci_last_regenerate|i:1727088962;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0uvgbphd8vavc6vm4t0p9mo2u4bqhsdd', '2a12:d280:100:51::', 1727215981, '__ci_last_regenerate|i:1727215981;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0varbldfc0qljjh5cm55stjevl7aooq7', '2a12:d280:100:51::', 1727292302, '__ci_last_regenerate|i:1727292302;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0vkp69suft2s0d031ln8qpd98m3687id', '2a12:d280:100:51::', 1727273521, '__ci_last_regenerate|i:1727273521;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1071gcpds73tlv8b97743mnc67qaqa24', '2a12:d280:100:51::', 1727074202, '__ci_last_regenerate|i:1727074202;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('108u87rndr0te3njrrbp0f1p82i1ev4s', '2a12:d280:100:51::', 1727239082, '__ci_last_regenerate|i:1727239082;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('109qs37pmn06v6htbm7ae5jlia2a36v8', '2a12:d280:100:51::', 1727276581, '__ci_last_regenerate|i:1727276581;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('10krvbqhr5uututtdgp16hapt1jdo029', '2a12:d280:100:51::', 1727058541, '__ci_last_regenerate|i:1727058541;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('115k9vsubthrul324hpue29t2f6n58bb', '2a12:d280:100:51::', 1727157241, '__ci_last_regenerate|i:1727157241;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('11hjkgpt35fdec6u8hfndtff7khiu57i', '2a12:d280:100:51::', 1727118182, '__ci_last_regenerate|i:1727118182;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('11ok84eb8qt0rdiuqv850pqak28c5nhb', '2a12:d280:100:51::', 1727255641, '__ci_last_regenerate|i:1727255641;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('11tdk02kkp14bhbv34n5cftkrlcm4lsb', '2a12:d280:100:51::', 1727045642, '__ci_last_regenerate|i:1727045642;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1209jhcktevrcdmluqqjp3n4l63e16rc', '2a12:d280:100:51::', 1727200622, '__ci_last_regenerate|i:1727200622;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1251auahr9rdbifdc9p0jjfd4cunjvhi', '2a12:d280:100:51::', 1727164741, '__ci_last_regenerate|i:1727164741;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('12c355ebb4jctk05co7c93k88p7ahlf3', '2a12:d280:100:51::', 1727184002, '__ci_last_regenerate|i:1727184002;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('12ekp7i9fuon01punt35h10l9aacoc81', '2a12:d280:100:51::', 1727120761, '__ci_last_regenerate|i:1727120761;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('12stb62bgnlq2n8iuo9qg0v61dcr4uqs', '2a12:d280:100:51::', 1727256241, '__ci_last_regenerate|i:1727256241;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('12ulmvqn39ubcct0aqitbsi9uek1un4k', '2a12:d280:100:51::', 1727231821, '__ci_last_regenerate|i:1727231821;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('13025oh7g9tg68cl3csv74mmp121tesk', '2a12:d280:100:51::', 1727279882, '__ci_last_regenerate|i:1727279882;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('13b49e67bkga6pvr7utjeignadm8r23b', '2a12:d280:100:51::', 1727127961, '__ci_last_regenerate|i:1727127961;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('13btgj6a4lgjlctnefpi2bbck5v8qrtd', '2a12:d280:100:51::', 1727144701, '__ci_last_regenerate|i:1727144701;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('13d9rgardph9a7mf1ddhmrr0l27u9le7', '2a12:d280:100:51::', 1727108702, '__ci_last_regenerate|i:1727108702;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('13kd71i4v14oe24ghb5sjcpg3471ap0l', '2a12:d280:100:51::', 1727073422, '__ci_last_regenerate|i:1727073422;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('13kdj4tg0qv2jll4pu1142jd10iclgg5', '2a12:d280:100:51::', 1727116381, '__ci_last_regenerate|i:1727116381;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('13rauaevf03ehhrt4annlpjv8uc1tge2', '2a12:d280:100:51::', 1727238541, '__ci_last_regenerate|i:1727238541;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('13se2kbuc7p81jn3vem9ev5o5jekbrka', '2a12:d280:100:51::', 1727194982, '__ci_last_regenerate|i:1727194982;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('13t2llrnksmm9taib6b374ui2cr5nl2d', '2a12:d280:100:51::', 1727141461, '__ci_last_regenerate|i:1727141461;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1455qo9mkumv5lie22cqqu7tnfd2rhfu', '2a12:d280:100:51::', 1727244841, '__ci_last_regenerate|i:1727244841;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1466144a0tb74dm0n03tl8up14poc6kp', '2a12:d280:100:51::', 1727262361, '__ci_last_regenerate|i:1727262361;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('14a83h7gip4mld8mlcr1nd6rd1nleorh', '2a12:d280:100:51::', 1727122501, '__ci_last_regenerate|i:1727122501;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('14dg7242u1ljog7kb3h9tvr7329026l8', '2a12:d280:100:51::', 1727249581, '__ci_last_regenerate|i:1727249581;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('14lc0i63tbs5ttuia3dvfc397378avnp', '2a12:d280:100:51::', 1727256421, '__ci_last_regenerate|i:1727256421;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('14nmfi4bgi5s37rvsf1ajpp6taqp9kqh', '2a12:d280:100:51::', 1727167441, '__ci_last_regenerate|i:1727167441;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1553gu286shgrgq97i7j4aud6j3a3ia7', '2a12:d280:100:51::', 1727162522, '__ci_last_regenerate|i:1727162522;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('15bdevqsj5a6c1forvonc6h3tn3nl02t', '2a12:d280:100:51::', 1727222881, '__ci_last_regenerate|i:1727222881;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('16dllmue72i01ltr0itsqm1hucrq9eqr', '2a12:d280:100:51::', 1727170322, '__ci_last_regenerate|i:1727170321;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('16h6mpv6taj5ns4uvsdvbmnlg4qbitn6', '2a12:d280:100:51::', 1727172002, '__ci_last_regenerate|i:1727172001;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('16i7uv2lndlel4iensh7b25s01q2b0p4', '2a12:d280:100:51::', 1727268361, '__ci_last_regenerate|i:1727268361;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('16inkrnnc66ir6fg1moptqhv9qp1oapk', '2a12:d280:100:51::', 1727071561, '__ci_last_regenerate|i:1727071561;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1724682p7a2d8o8td6lpnvsj48a5lu8d', '2a12:d280:100:51::', 1727193061, '__ci_last_regenerate|i:1727193061;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('17enu8ol3a5ir3rg434qklf94mmu0cs0', '2a12:d280:100:51::', 1727141402, '__ci_last_regenerate|i:1727141402;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('17gi7938dvdiovfg0vkiujrp9s1q72p8', '2a12:d280:100:51::', 1727109481, '__ci_last_regenerate|i:1727109481;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('17h0mqauf3pmqkunulft1j64cruq4pp2', '2a12:d280:100:51::', 1727086261, '__ci_last_regenerate|i:1727086261;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('183uhsj473ma7ocapcsji45j6f9ak8pm', '2a12:d280:100:51::', 1727143922, '__ci_last_regenerate|i:1727143922;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('18m2k2mlajfgpcqdqga9m2u4jbes7l2u', '2a12:d280:100:51::', 1727160181, '__ci_last_regenerate|i:1727160181;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('191ore3avabh5o7pl7bpn4cvsjopgvci', '2a12:d280:100:51::', 1727121002, '__ci_last_regenerate|i:1727121002;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('19bo5po8u0q2b7un22so3mfo5p4uen9s', '2a12:d280:100:51::', 1727260802, '__ci_last_regenerate|i:1727260801;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1a107t7og3l0h6tol74i3tmesb1807ac', '2a12:d280:100:51::', 1727248682, '__ci_last_regenerate|i:1727248682;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1a9d5v26udd4op3kp2lbieregg18b5h0', '2a12:d280:100:51::', 1727245981, '__ci_last_regenerate|i:1727245981;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1aci9j9sguqekos04rlnk73ud5fc5j22', '2a12:d280:100:51::', 1727181962, '__ci_last_regenerate|i:1727181962;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1adm7pc0k14dsut1tuc3f360fout814r', '2a12:d280:100:51::', 1727111822, '__ci_last_regenerate|i:1727111822;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1ag0cd524vmnrfuscnv3u2ddbcfhoccp', '2a12:d280:100:51::', 1727239021, '__ci_last_regenerate|i:1727239021;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1ai75d4q9onc4bu14ctipk15g7414f2k', '2a12:d280:100:51::', 1727103841, '__ci_last_regenerate|i:1727103841;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1alsi6ovflqilnk4gctjmj6skk2jvv8p', '2a12:d280:100:51::', 1727149742, '__ci_last_regenerate|i:1727149742;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1b4kl57e2rlemsio0qeeahsloq2nhi51', '2a12:d280:100:51::', 1727130902, '__ci_last_regenerate|i:1727130902;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1bem7nfnpcj9k9md38mqnmtekddmjskn', '2a12:d280:100:51::', 1727242321, '__ci_last_regenerate|i:1727242321;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1bm814rjj8rladd996iqe1dja4n820t5', '2a12:d280:100:51::', 1727282342, '__ci_last_regenerate|i:1727282341;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1bn8e8ovh940hmf9a321bru74hhkp596', '2a12:d280:100:51::', 1727170202, '__ci_last_regenerate|i:1727170202;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1brsipr1n7ka5o88eqm8ftqjifgi6kfi', '2a12:d280:100:51::', 1727202542, '__ci_last_regenerate|i:1727202541;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1c2071uqf888n4v40n1dm747m54q4qk2', '2a12:d280:100:51::', 1727085962, '__ci_last_regenerate|i:1727085962;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1c2vmcdl91iufi77vvnso6d80frbba64', '2a12:d280:100:51::', 1727255342, '__ci_last_regenerate|i:1727255342;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1c5rkqbbtojh8tsip6ric8tifktgtlvs', '2a12:d280:100:51::', 1727173381, '__ci_last_regenerate|i:1727173381;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1c794uabagbqcnst3k0bun2rrm2e19f4', '2a12:d280:100:51::', 1727273341, '__ci_last_regenerate|i:1727273341;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1cdn08m3mnt99hl93b8ag8i0g6d6i40s', '2a12:d280:100:51::', 1727176561, '__ci_last_regenerate|i:1727176561;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1cgo12h6qptejfgm0b6qp1c7aepc24hq', '2a12:d280:100:51::', 1727273042, '__ci_last_regenerate|i:1727273042;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1dm2evvi146hau8p66lg4db6ldikd705', '2a12:d280:100:51::', 1727241541, '__ci_last_regenerate|i:1727241541;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1dsbe27d3hh618no7g258efrlk6iuuv6', '2a12:d280:100:51::', 1727190781, '__ci_last_regenerate|i:1727190781;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1eh04jjdk3e4oj9nan40grt2itf0hrh3', '2a12:d280:100:51::', 1727154722, '__ci_last_regenerate|i:1727154722;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1el2k9l5qtplb4d3upa36v7471en1af8', '2a12:d280:100:51::', 1727056141, '__ci_last_regenerate|i:1727056141;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1eu9cp8v5fro08hpo4g33m6pq112e0jj', '2a12:d280:100:51::', 1727278021, '__ci_last_regenerate|i:1727278021;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1f7mbh4bpqqq5om94t2avu1sbm3j32vo', '2a12:d280:100:51::', 1727086081, '__ci_last_regenerate|i:1727086081;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1fgtskg1o9fmhq1ptiuf0c71jb3cn6hh', '2a12:d280:100:51::', 1727134262, '__ci_last_regenerate|i:1727134262;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1fhiatsi6mvj1sosk4h4atlru41nsjrj', '2a12:d280:100:51::', 1727048941, '__ci_last_regenerate|i:1727048941;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1frto2d26mio7cnm0qgr0f3vcqd57km6', '2a12:d280:100:51::', 1727277182, '__ci_last_regenerate|i:1727277181;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1gbmi0n1c33rk22rilsoh4m7acp4uubu', '2a12:d280:100:51::', 1727081522, '__ci_last_regenerate|i:1727081522;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1ghdqlb5d4m8f114qjs3tq2hqvq4h3ig', '2a12:d280:100:51::', 1727225761, '__ci_last_regenerate|i:1727225761;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1giqac652gmt0e7iclbf852un0s1ll5c', '2a12:d280:100:51::', 1727235361, '__ci_last_regenerate|i:1727235361;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1gj44t731utv62nfurihck2oi89nf8fo', '2a12:d280:100:51::', 1727184421, '__ci_last_regenerate|i:1727184421;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1h7imh26dnrlrvpqjh6361n3ebedr31c', '2a12:d280:100:51::', 1727142601, '__ci_last_regenerate|i:1727142601;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1hdon8jn79led7j6h4km2reepubjlqqm', '2a12:d280:100:51::', 1727184602, '__ci_last_regenerate|i:1727184602;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1hfl280dj5tgekhne4soa04tp2teuo7d', '2a12:d280:100:51::', 1727136541, '__ci_last_regenerate|i:1727136541;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1hkjr5v8cjt9gb1f7gd802n6fhdfvt01', '2a12:d280:100:51::', 1727214602, '__ci_last_regenerate|i:1727214602;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1i2fgvc2bo0u7iplc6kadqtm30n01ae2', '2a12:d280:100:51::', 1727081461, '__ci_last_regenerate|i:1727081461;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1i4s254evv4aque2ievjipnv0iej7iqo', '2a12:d280:100:51::', 1727110381, '__ci_last_regenerate|i:1727110381;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1ibmhe0g5mgkkbn1gde29la2rmmlg3u9', '2a12:d280:100:51::', 1727167681, '__ci_last_regenerate|i:1727167681;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1inhd70ci26qd4951bgj09rfkmv5r51h', '2a12:d280:100:51::', 1727066581, '__ci_last_regenerate|i:1727066581;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1ioho4iv11q5s6kin96fe0vn1esj62kt', '2a12:d280:100:51::', 1727212081, '__ci_last_regenerate|i:1727212081;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1itk553p4n2f4vkvcnduvhagqee7ehjh', '2a12:d280:100:51::', 1727268302, '__ci_last_regenerate|i:1727268302;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1iunsqjgpgo5nkhko7h124lkilflcp1k', '2a12:d280:100:51::', 1727250181, '__ci_last_regenerate|i:1727250181;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1j4olbdje1qoqih69d1r4l08qoh5pd64', '2a12:d280:100:51::', 1727126941, '__ci_last_regenerate|i:1727126941;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1jhbn2hcthmu78n8i791hkbec5kq01ks', '2a12:d280:100:51::', 1727083081, '__ci_last_regenerate|i:1727083081;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1jja3o1o6dk6u4pk89jbasjkju699m13', '2a12:d280:100:51::', 1727277962, '__ci_last_regenerate|i:1727277962;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1jk4mm8f1qibutt1ikasjm11cubst1v3', '2a12:d280:100:51::', 1727057701, '__ci_last_regenerate|i:1727057701;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1jtcav835dt1ivsk314s2s8k9iodvsjt', '2a12:d280:100:51::', 1727047921, '__ci_last_regenerate|i:1727047921;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1jtmjrsnir2fg65qv2khsbmk3k306sp0', '2a12:d280:100:51::', 1727060341, '__ci_last_regenerate|i:1727060341;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1k0qnm4lkrb3toh74s2fvcod0u7p71gc', '2a12:d280:100:51::', 1727173862, '__ci_last_regenerate|i:1727173861;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1kdasni3rgqao8bk2ro2aru45tb657kb', '2a12:d280:100:51::', 1727102041, '__ci_last_regenerate|i:1727102041;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1keoepb70o44f1nqrlfb423pv4241gpt', '2a12:d280:100:51::', 1727129101, '__ci_last_regenerate|i:1727129101;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1kl3pse2c6anagigmadheiqo7b9k64ao', '2a12:d280:100:51::', 1727116742, '__ci_last_regenerate|i:1727116742;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1l2s4ngvcpj1m4m0b2oaekqo5k3e6nvc', '2a12:d280:100:51::', 1727158981, '__ci_last_regenerate|i:1727158981;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1lok4luuidprrvckuf4tfvsb05m8nv09', '2a12:d280:100:51::', 1727266921, '__ci_last_regenerate|i:1727266921;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1m13vptckipebg57j5016ru5lh8sjq50', '2a12:d280:100:51::', 1727246162, '__ci_last_regenerate|i:1727246162;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1m1fledib25udp6pganb2irfruumla6d', '2a12:d280:100:51::', 1727066702, '__ci_last_regenerate|i:1727066702;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1m68odinor0qmt1t71mjfnkt9r6afrc1', '2a12:d280:100:51::', 1727129582, '__ci_last_regenerate|i:1727129582;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1mdc6osi5s1ntkiqsdshidtuu3hca159', '2a12:d280:100:51::', 1727047382, '__ci_last_regenerate|i:1727047382;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1meku78i8gdtvfm0oss2iflo7bltcgl6', '2a12:d280:100:51::', 1727293982, '__ci_last_regenerate|i:1727293982;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1midk85akvgnp3ftqlpm37h4j478n5fm', '31.223.103.75', 1727295443, '__ci_last_regenerate|i:1727295443;_prev_url|s:42:\"https://panel.blitconcept.es/admin/modules\";staff_user_id|s:1:\"6\";staff_logged_in|b:1;setup-menu-open|s:0:\"\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1mlp3nsnqcm2aphtdr4v7ic5id67keu2', '2a12:d280:100:51::', 1727136841, '__ci_last_regenerate|i:1727136841;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1mmpkf7v7hdjsjh2a9tb1i6142kj49o8', '2a12:d280:100:51::', 1727149202, '__ci_last_regenerate|i:1727149202;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1mnfbho17s3g7bmah4uldvao3snjkj4r', '2a12:d280:100:51::', 1727107082, '__ci_last_regenerate|i:1727107082;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1mttb3pp4b4l2atfvqbkn5ojev7bo7oq', '2a12:d280:100:51::', 1727198041, '__ci_last_regenerate|i:1727198041;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1n41q6qalhekpnuqekf5l947bjo7u5ss', '2a12:d280:100:51::', 1727069761, '__ci_last_regenerate|i:1727069761;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1niqqfahpmbbsa8pdam92emqhc6sgmlj', '2a12:d280:100:51::', 1727159701, '__ci_last_regenerate|i:1727159701;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1nnh9valopuktk99qi18mcpvfjv48vqp', '2a12:d280:100:51::', 1727126401, '__ci_last_regenerate|i:1727126401;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1o0t6f3uehi8rncqhjkvrhe6s33lcs6l', '2a12:d280:100:51::', 1727230981, '__ci_last_regenerate|i:1727230981;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1o8chhtouic5c93r6uvu03o5v8fa8pvj', '2a12:d280:100:51::', 1727228102, '__ci_last_regenerate|i:1727228102;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1okggfe4u7hq95c1akqg3l49q4kaicp7', '2a12:d280:100:51::', 1727242802, '__ci_last_regenerate|i:1727242802;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1onbnvhf95uocv79hd9ctg5r4p4s8ef4', '2a12:d280:100:51::', 1727095081, '__ci_last_regenerate|i:1727095081;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1op77bss3ir204pj19936d48pclve25h', '2a12:d280:100:51::', 1727072402, '__ci_last_regenerate|i:1727072402;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1p78ej8330d0ulpvvso6b4i7kjocivna', '2a12:d280:100:51::', 1727101561, '__ci_last_regenerate|i:1727101561;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1p7tkbgehj2ru0g2mu1a0ub3dcon9dip', '2a12:d280:100:51::', 1727213761, '__ci_last_regenerate|i:1727213761;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1p9heeo0pf769948ludqfa2vkpajvarm', '2a12:d280:100:51::', 1727096882, '__ci_last_regenerate|i:1727096882;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1pfli8jdli6a6vupf6t5okp45r6tm3c4', '2a12:d280:100:51::', 1727061301, '__ci_last_regenerate|i:1727061301;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1pmpgvsg1t3tjsf5nadp25701eqg2v7t', '2a12:d280:100:51::', 1727048701, '__ci_last_regenerate|i:1727048701;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1qhamm2238bf9k4vklfdko4jgec27s7e', '2a12:d280:100:51::', 1727270282, '__ci_last_regenerate|i:1727270282;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1qvc458232887nfbe83pjugf5ticrb0s', '2a12:d280:100:51::', 1727088002, '__ci_last_regenerate|i:1727088002;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1r9kp6tc8tjeflp1bmm1npjjg9ick48a', '2a12:d280:100:51::', 1727047081, '__ci_last_regenerate|i:1727047081;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1rcmqg0g92bm5hlg8qja1diiu0cbraou', '2a12:d280:100:51::', 1727238961, '__ci_last_regenerate|i:1727238961;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1rhq5a8956kgvfkaualau8pkq8bfa5p4', '2a12:d280:100:51::', 1727203321, '__ci_last_regenerate|i:1727203321;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1s6oafbul01napkjnmu6ukodbinmb0pl', '2a12:d280:100:51::', 1727104562, '__ci_last_regenerate|i:1727104561;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1t3r8d2oee4p6bkggi8r2fliegdikhcj', '2a12:d280:100:51::', 1727051821, '__ci_last_regenerate|i:1727051821;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1t7hm9tufvshf0bm883rb8p1cc811udh', '2a12:d280:100:51::', 1727132701, '__ci_last_regenerate|i:1727132701;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1t9dq44cat4pu5o6e0jqkit9eut3kdiq', '2a12:d280:100:51::', 1727135582, '__ci_last_regenerate|i:1727135582;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1tafvbl3p9e8ohn9931j0ffteecig4ke', '2a12:d280:100:51::', 1727294642, '__ci_last_regenerate|i:1727294642;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1tor1gg3hd2n9oargt09ucp72blc94fd', '2a12:d280:100:51::', 1727144641, '__ci_last_regenerate|i:1727144641;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1u2knuk7m8gj5f3spdbdb7od9m9v3jn9', '2a12:d280:100:51::', 1727086682, '__ci_last_regenerate|i:1727086681;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1uceluvntll5g9rb322brdaes6ibqm0u', '2a12:d280:100:51::', 1727256181, '__ci_last_regenerate|i:1727256181;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1vbqeu3gv2ko4c26udku4iep91h9h5e1', '2a12:d280:100:51::', 1727082421, '__ci_last_regenerate|i:1727082421;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1vfd3i9cldfmc5fqfadv7j67ocqbqsnm', '2a12:d280:100:51::', 1727067602, '__ci_last_regenerate|i:1727067602;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1vm7dbntdeddd4qu60ndjj5sptopg339', '2a12:d280:100:51::', 1727279162, '__ci_last_regenerate|i:1727279162;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1vtqar22ivi4nrh9f3dp6bdmh1nvmpch', '2a12:d280:100:51::', 1727213221, '__ci_last_regenerate|i:1727213221;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1vujicpnv1vhsn6blk9mu65efpd0q739', '2a12:d280:100:51::', 1727194322, '__ci_last_regenerate|i:1727194322;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('20448vrodd6dc6f25ono9788udl0765u', '2a12:d280:100:51::', 1727231342, '__ci_last_regenerate|i:1727231342;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('21avb3ijjicn8ejeqtskivtgp90pr951', '2a12:d280:100:51::', 1727091962, '__ci_last_regenerate|i:1727091961;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('21i7lhrvf6gie6e59gl4ovopjg4o1q9u', '2a12:d280:100:51::', 1727257442, '__ci_last_regenerate|i:1727257442;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('21q6kgtu644btv5aguk2s2lm8o7b8u8r', '2a12:d280:100:51::', 1727289421, '__ci_last_regenerate|i:1727289421;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('22kf69pjrts6a3tn540ap3u1q5v6fir9', '2a12:d280:100:51::', 1727227922, '__ci_last_regenerate|i:1727227922;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('22nsfp9apist62a7lq7o4okkqscu5iji', '2a12:d280:100:51::', 1727148482, '__ci_last_regenerate|i:1727148481;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('22rqomsl38bgcj0hjafqbse1eqhd0p2v', '2a12:d280:100:51::', 1727169481, '__ci_last_regenerate|i:1727169481;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('22td7tpv9o9be4ah3n0ephjstvdj4238', '2a12:d280:100:51::', 1727085541, '__ci_last_regenerate|i:1727085541;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('22uevmbdgv81c305guj3ac5l37it2f7t', '2a12:d280:100:51::', 1727239382, '__ci_last_regenerate|i:1727239382;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('236h52sh66nl51u7c1eo1h0gekvpf7ck', '2a12:d280:100:51::', 1727186641, '__ci_last_regenerate|i:1727186641;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('23fm3bckt5kjolp7rgup1msqlepd2e98', '2a12:d280:100:51::', 1727106721, '__ci_last_regenerate|i:1727106721;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('23n0rkc1dfoa0mf37p49n6ggs88depk3', '2a12:d280:100:51::', 1727174101, '__ci_last_regenerate|i:1727174101;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('242gaiogneu8hjbojibrphurqq3u4u82', '2a12:d280:100:51::', 1727094421, '__ci_last_regenerate|i:1727094421;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('246amrh2gcj018bfrptq44odd19ftt2b', '2a12:d280:100:51::', 1727113322, '__ci_last_regenerate|i:1727113322;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('24dg460k83od5hp5uhocc0lrhmvlq63m', '2a12:d280:100:51::', 1727095321, '__ci_last_regenerate|i:1727095321;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('24lavuk8168ah45792gq1vrar8u3du3a', '2a12:d280:100:51::', 1727213582, '__ci_last_regenerate|i:1727213582;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('24vl9e1efaoscgpfudo5oi4our0ftivf', '2a12:d280:100:51::', 1727171821, '__ci_last_regenerate|i:1727171821;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('253ehpesolonqkpdu9ilkhlbouogl1dn', '2a12:d280:100:51::', 1727221021, '__ci_last_regenerate|i:1727221021;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('253magllsh395rk3agkfhe7npevmcgtb', '2a12:d280:100:51::', 1727155862, '__ci_last_regenerate|i:1727155862;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('25l7dih2e7r1q5uggjm81cssjb2f9n0u', '2a12:d280:100:51::', 1727098322, '__ci_last_regenerate|i:1727098322;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('25oc8h0qdn37nl2pqm4njiqa2l6oa5dk', '2a12:d280:100:51::', 1727138401, '__ci_last_regenerate|i:1727138401;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('25r7u52e1hbiennqr10aip68jpvm5rm9', '2a12:d280:100:51::', 1727111281, '__ci_last_regenerate|i:1727111281;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('262cks3vl0g1fsmo2ke0fnauhqm4d4pt', '2a12:d280:100:51::', 1727265301, '__ci_last_regenerate|i:1727265301;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('263tpcdctct28jeq0ldojerdshi2ckak', '2a12:d280:100:51::', 1727180281, '__ci_last_regenerate|i:1727180281;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('26fag76r42tkt1r87bpm47mnbqavhm61', '2a12:d280:100:51::', 1727283842, '__ci_last_regenerate|i:1727283842;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('26gq456ts8kpruq6dfur2ub02kagbkdo', '2a12:d280:100:51::', 1727157421, '__ci_last_regenerate|i:1727157421;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('27515lm09pv6qp4p025ah0hep454255k', '2a12:d280:100:51::', 1727172602, '__ci_last_regenerate|i:1727172602;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('27coo6kcj2i1u0gmt84p26uk9v5jqm4m', '2a12:d280:100:51::', 1727295182, '__ci_last_regenerate|i:1727295182;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('27f1edhpmvblumh8ekmrep756uukkeuf', '2a12:d280:100:51::', 1727151241, '__ci_last_regenerate|i:1727151241;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('27gph002n5bkaep6ki947ja4idl5jbph', '2a12:d280:100:51::', 1727260441, '__ci_last_regenerate|i:1727260441;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('28b2bb1mjdufb9mpisibvm4mc3a2i2nf', '2a12:d280:100:51::', 1727081402, '__ci_last_regenerate|i:1727081402;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('28g85g8atvir9ho0ise4v0acjjmkoslu', '2a12:d280:100:51::', 1727151961, '__ci_last_regenerate|i:1727151961;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('28gt24lld6k97savpnc7tclda5nfr256', '2a12:d280:100:51::', 1727179802, '__ci_last_regenerate|i:1727179802;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('28qo4di2n3re28ef216adjku14s87pe4', '2a12:d280:100:51::', 1727239261, '__ci_last_regenerate|i:1727239261;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('290g7ni1ki7e2rkvm5hi2onub6ferm7c', '2a12:d280:100:51::', 1727283361, '__ci_last_regenerate|i:1727283361;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2a4ikqkgp3inmfpjq69edbia2na3fovq', '2a12:d280:100:51::', 1727273881, '__ci_last_regenerate|i:1727273881;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2a9eevpmtir7k99qr5pam1e5dof4cneg', '2a12:d280:100:51::', 1727130182, '__ci_last_regenerate|i:1727130182;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2adadv3pvps94lf0rc1sq94hdpanglfh', '2a12:d280:100:51::', 1727250722, '__ci_last_regenerate|i:1727250722;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2adhq1p1iamsvd39pmb19c2a2jde2c2e', '2a12:d280:100:51::', 1727063762, '__ci_last_regenerate|i:1727063762;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2an0th5jkd4bjgaibogl23p8hoamg4fm', '2a12:d280:100:51::', 1727208902, '__ci_last_regenerate|i:1727208902;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2b3q6inu23pfco8a562mlkp0g9ph9op2', '2a12:d280:100:51::', 1727049722, '__ci_last_regenerate|i:1727049722;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2b5bh00ptctihbked0ol1uq6qiia7j47', '2a12:d280:100:51::', 1727229482, '__ci_last_regenerate|i:1727229481;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2bbqdrm4cip465vk50mgt78i10jnes2a', '2a12:d280:100:51::', 1727143141, '__ci_last_regenerate|i:1727143141;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2bnbc64rrddt05eeiiug8uit3kjiq1ma', '2a12:d280:100:51::', 1727267162, '__ci_last_regenerate|i:1727267162;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2bpgjfrl36orqd0bl4sc9e71o27l69ma', '2a12:d280:100:51::', 1727096641, '__ci_last_regenerate|i:1727096641;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2c27e1ju1b37oslt8v07pdaq81nkoq6g', '2a12:d280:100:51::', 1727141821, '__ci_last_regenerate|i:1727141821;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2cae1rjhrr2ckvajcu2artkrqf0v9k61', '2a12:d280:100:51::', 1727107202, '__ci_last_regenerate|i:1727107202;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2cbm9q625p7hmvv5sld7p3puema1jegd', '2a12:d280:100:51::', 1727148421, '__ci_last_regenerate|i:1727148421;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2ce5i4tbqs8veg2rrnc04t9h8n37q2tl', '2a12:d280:100:51::', 1727107321, '__ci_last_regenerate|i:1727107321;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2cglnbah9gebq4ir56tmssgcvk45pv5m', '2a12:d280:100:51::', 1727064961, '__ci_last_regenerate|i:1727064961;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2cls53mgisudhs3edv3j38usovqcl38q', '2a12:d280:100:51::', 1727156101, '__ci_last_regenerate|i:1727156101;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2cp08675edtd25m16im6ffehtefkkcd4', '2a12:d280:100:51::', 1727170982, '__ci_last_regenerate|i:1727170982;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2d6p69ieqrrtfkhr520qusqashkis422', '2a12:d280:100:51::', 1727052421, '__ci_last_regenerate|i:1727052421;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2ddus2lojut12m30msg54565sb41r2vb', '2a12:d280:100:51::', 1727157301, '__ci_last_regenerate|i:1727157301;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2dursupjnjod7uo4dvpmrspt4mdtk3bq', '2a12:d280:100:51::', 1727117822, '__ci_last_regenerate|i:1727117822;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2e14oc45nev7ml59k3atd1dj2stvqqhq', '2a12:d280:100:51::', 1727295122, '__ci_last_regenerate|i:1727295122;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2e21g7nif39c1k3ud0s434s4eli02565', '2a12:d280:100:51::', 1727143321, '__ci_last_regenerate|i:1727143321;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2eaatgvua4s9mj3ae0vr4i67pvlmrnnd', '2a12:d280:100:51::', 1727225102, '__ci_last_regenerate|i:1727225102;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2edmbsm9scimsjddo9inafa5ji2fnjsg', '2a12:d280:100:51::', 1727147941, '__ci_last_regenerate|i:1727147941;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2ek5rol6f9bv6cd9c9as6p70oc9j8qjo', '2a12:d280:100:51::', 1727179742, '__ci_last_regenerate|i:1727179742;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2ekgp17ead1qe43gdebde4tijab303si', '2a12:d280:100:51::', 1727051461, '__ci_last_regenerate|i:1727051461;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2ep6qbu2gs3qn3c1kivkbcqaide1e85i', '2a12:d280:100:51::', 1727110081, '__ci_last_regenerate|i:1727110081;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2eqj6chai1vsb8sovpj4advq1e88kjeb', '2a12:d280:100:51::', 1727080981, '__ci_last_regenerate|i:1727080981;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2f0f7a8u19f7e4f2tjnqd9fs41c7fm90', '2a12:d280:100:51::', 1727186461, '__ci_last_regenerate|i:1727186461;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2f2le60o9vftf759somscn8s1mpar76b', '2a12:d280:100:51::', 1727093161, '__ci_last_regenerate|i:1727093161;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2f9rtodtbmfmghnndlhq9lcvtroj7gud', '2a12:d280:100:51::', 1727198582, '__ci_last_regenerate|i:1727198582;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2fecmglfc2f58tbnobp7juio9at0db9o', '2a12:d280:100:51::', 1727287442, '__ci_last_regenerate|i:1727287442;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2fm1qg1haiuvdh2p8v5fthjrrbsjmjf9', '2a12:d280:100:51::', 1727134442, '__ci_last_regenerate|i:1727134442;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2g8flvg4aulni1gt18fbq00f20d7nrv3', '2a12:d280:100:51::', 1727058242, '__ci_last_regenerate|i:1727058242;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2g9p0ast8j1cvffdipvnc275sg8ef5q0', '2a12:d280:100:51::', 1727221981, '__ci_last_regenerate|i:1727221981;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2ggd4plvk1tigoqo9pqfj9hgcftkgjnt', '2a12:d280:100:51::', 1727046482, '__ci_last_regenerate|i:1727046482;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2glp6h6cb7ur031s361csi48npojapq1', '2a12:d280:100:51::', 1727247181, '__ci_last_regenerate|i:1727247181;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2h6cdptgk74m296eoo59ke1fcn2odg21', '2a12:d280:100:51::', 1727050441, '__ci_last_regenerate|i:1727050441;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2hduvthhr8rl6codeqdkd8un9lkjptdo', '2a12:d280:100:51::', 1727171161, '__ci_last_regenerate|i:1727171161;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2hedmdj8sdg3u1hbt0jtuevk2ujpbm2f', '2a12:d280:100:51::', 1727053981, '__ci_last_regenerate|i:1727053981;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2heie8v5p5n63bqk5og2d33v3hpkm9o7', '2a12:d280:100:51::', 1727079302, '__ci_last_regenerate|i:1727079302;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2ht13q6ki8tn5u4bnh6sa2jie6pqj10k', '2a12:d280:100:51::', 1727286602, '__ci_last_regenerate|i:1727286602;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2i3eimgae692uj9pp2vauvfgh1vbu63q', '2a12:d280:100:51::', 1727164142, '__ci_last_regenerate|i:1727164141;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2ih96c2pttkohrvvob2ct0q74j0nq56p', '2a12:d280:100:51::', 1727251201, '__ci_last_regenerate|i:1727251201;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2im80441pe4kpk5m328lbcc5aj0uu274', '2a12:d280:100:51::', 1727274182, '__ci_last_regenerate|i:1727274182;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2j6p9gecj0r5odbnt3teb92o2t746952', '2a12:d280:100:51::', 1727187902, '__ci_last_regenerate|i:1727187902;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2j9qpacqsqfbi11m33kvopl56snoobm6', '2a12:d280:100:51::', 1727140261, '__ci_last_regenerate|i:1727140261;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2jgj6pd35b5tesifi41a9jkatcfm4ppu', '2a12:d280:100:51::', 1727104862, '__ci_last_regenerate|i:1727104862;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2jl67frdoc202lqh0h460juk4g7iqljs', '2a12:d280:100:51::', 1727119022, '__ci_last_regenerate|i:1727119022;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2joibt8apv1t6fhjd5e7ghksio05h9i0', '2a12:d280:100:51::', 1727273581, '__ci_last_regenerate|i:1727273581;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2jopn7m2c5v26jud5cnn7c085iol26ui', '2a12:d280:100:51::', 1727295962, '__ci_last_regenerate|i:1727295962;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2jqtifdpjolpoiknufq77q6qf0iuscoo', '2a12:d280:100:51::', 1727199841, '__ci_last_regenerate|i:1727199841;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2k3ctbvrks54d0b85inaudqv2ob59do0', '2a12:d280:100:51::', 1727116141, '__ci_last_regenerate|i:1727116141;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2k4at2msvp8i161o4ict9eqbqliso5pq', '2a12:d280:100:51::', 1727252941, '__ci_last_regenerate|i:1727252941;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2k68njf3d9oqbgomsvi5ap4atpka03k5', '2a12:d280:100:51::', 1727084402, '__ci_last_regenerate|i:1727084402;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2kb0bkfinjrkc4dgrrc3mf5h3nk11cds', '2a12:d280:100:51::', 1727189581, '__ci_last_regenerate|i:1727189581;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2kcg0idm3rm004sii5irft4k2qp8c2vl', '2a12:d280:100:51::', 1727228161, '__ci_last_regenerate|i:1727228161;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2klm2tdlsgb6e8onhuuks4thdkesi1gq', '2a12:d280:100:51::', 1727230921, '__ci_last_regenerate|i:1727230921;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2km55fg8302pflbk4oul2acllven211s', '2a12:d280:100:51::', 1727281921, '__ci_last_regenerate|i:1727281921;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2kmgnkk6obndd8h77d0amp2kreccmiq0', '2a12:d280:100:51::', 1727050862, '__ci_last_regenerate|i:1727050862;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2krbds9h0a56k17n15a5p6uleil4voa2', '2a12:d280:100:51::', 1727205122, '__ci_last_regenerate|i:1727205122;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2l8uvcmadskhf2f0mf3sud890feit3b5', '2a12:d280:100:51::', 1727085121, '__ci_last_regenerate|i:1727085121;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2m2r804qameadhc4op9p9jmachlqtatf', '2a12:d280:100:51::', 1727159942, '__ci_last_regenerate|i:1727159942;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2m5hlj34h2s1k7m7hpedlm4i499uglsl', '2a12:d280:100:51::', 1727290742, '__ci_last_regenerate|i:1727290742;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2mestljg5q37lpgte07c04527vf5cn3m', '2a12:d280:100:51::', 1727071142, '__ci_last_regenerate|i:1727071142;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2mgme4bo1lk7qmrsga8jfcta2v9mj8b7', '2a12:d280:100:51::', 1727074802, '__ci_last_regenerate|i:1727074802;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2mug9nh7v9cierv27sjk4rkbh1t3rdpo', '2a12:d280:100:51::', 1727052482, '__ci_last_regenerate|i:1727052482;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2ndvmfuitt902r7iuqh00qd4h21q8uoo', '2a12:d280:100:51::', 1727122921, '__ci_last_regenerate|i:1727122921;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2o3c2udor4h7akapfqsd89ku51v1pstv', '2a12:d280:100:51::', 1727149381, '__ci_last_regenerate|i:1727149381;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2odbf37i4i4324ea7bq8b2qu5fae94v5', '2a12:d280:100:51::', 1727135762, '__ci_last_regenerate|i:1727135762;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2ogm54oupc0odj0sqgcgb3cjn97s5j8g', '2a12:d280:100:51::', 1727131081, '__ci_last_regenerate|i:1727131081;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2ouatfpjhmsbjdv8ln503l95an8kkre4', '2a12:d280:100:51::', 1727095801, '__ci_last_regenerate|i:1727095801;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2p6r9s6det72grpj9bb5o9dhg81tmu6s', '2a12:d280:100:51::', 1727202721, '__ci_last_regenerate|i:1727202721;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2p6vs7la9rnk1hsm5rnnmb1jeoqqkrpv', '2a12:d280:100:51::', 1727113442, '__ci_last_regenerate|i:1727113442;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2pba23laq18kn3mi0u7rn4avtscgsl59', '2a12:d280:100:51::', 1727133841, '__ci_last_regenerate|i:1727133841;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2pl5jh9n2lv1aascsgg39f53ji9cuave', '2a12:d280:100:51::', 1727064421, '__ci_last_regenerate|i:1727064421;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2pm1e55b1ptagek4lllo96ot36f9v2dj', '2a12:d280:100:51::', 1727067361, '__ci_last_regenerate|i:1727067361;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2pna8m1ibv92nss4n4loegsab2do5uo1', '2a12:d280:100:51::', 1727083202, '__ci_last_regenerate|i:1727083201;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2psl38apjskvecrnc7h4ldpklss23rjl', '2a12:d280:100:51::', 1727202422, '__ci_last_regenerate|i:1727202422;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2q48audmcpgfdsa6b1fe1rk5o0o5rvdb', '2a12:d280:100:51::', 1727179441, '__ci_last_regenerate|i:1727179441;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2q4v6kq0fg8f8c80gr0eub96g1h049tf', '2a12:d280:100:51::', 1727099161, '__ci_last_regenerate|i:1727099161;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2qfnk12up56nreqn1f5hl9n0q1a8iqpa', '2a12:d280:100:51::', 1727227802, '__ci_last_regenerate|i:1727227802;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2qla908q5lac96lp38ttvl2k9gt0370t', '2a12:d280:100:51::', 1727288881, '__ci_last_regenerate|i:1727288881;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2qn732btoioeq2p2hor7ljgtoh7f4qta', '2a12:d280:100:51::', 1727053801, '__ci_last_regenerate|i:1727053801;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2qop97ub61f4nnlva8hnhmdtsvf7ep0m', '2a12:d280:100:51::', 1727140502, '__ci_last_regenerate|i:1727140502;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2qr0ddsb792pcrb825i6jifulkd1onc8', '2a12:d280:100:51::', 1727181482, '__ci_last_regenerate|i:1727181482;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2rl0nmi64m0pvh1o9ikk68rg0b86ut3a', '2a12:d280:100:51::', 1727197681, '__ci_last_regenerate|i:1727197681;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2rrue8iikcnfi98o5fniq7eo0sjjkth3', '2a12:d280:100:51::', 1727123402, '__ci_last_regenerate|i:1727123402;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2rsgp3nnuao85adgir9mlqi9nea80vps', '2a12:d280:100:51::', 1727197021, '__ci_last_regenerate|i:1727197021;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2s5db999diilrn1f5i38hr6p2ln01f42', '2a12:d280:100:51::', 1727161082, '__ci_last_regenerate|i:1727161082;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2s5e7hh86v4ouan5fvnbp8t69pljiklk', '2a12:d280:100:51::', 1727266322, '__ci_last_regenerate|i:1727266322;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2s62m0hl3msue5ne2j2r8blbifqikjhg', '2a12:d280:100:51::', 1727105701, '__ci_last_regenerate|i:1727105701;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2seft5eh8oee01bvjconfjei189u6bkv', '2a12:d280:100:51::', 1727264102, '__ci_last_regenerate|i:1727264102;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2seriijreojl3lviiuvdfbbmsc2snb85', '2a12:d280:100:51::', 1727264161, '__ci_last_regenerate|i:1727264161;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2su023lo6rs3kevr7u7f4124mck56rij', '2a12:d280:100:51::', 1727057642, '__ci_last_regenerate|i:1727057641;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2tjv8cmvdq18u90eue21cii2tdqsc2t3', '2a12:d280:100:51::', 1727063402, '__ci_last_regenerate|i:1727063402;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2tlpcj0l439i6r23njcljccj040od8n0', '2a12:d280:100:51::', 1727063461, '__ci_last_regenerate|i:1727063461;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2u8dpbfrivu2pcn687mcqi00t4o8eo7b', '2a12:d280:100:51::', 1727094901, '__ci_last_regenerate|i:1727094901;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2u98mm8hb78gnpq94mdn877i5nc6k8o8', '2a12:d280:100:51::', 1727200921, '__ci_last_regenerate|i:1727200921;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2ugb2cev7bb8kkos8pe3oejivomqb3sf', '2a12:d280:100:51::', 1727213942, '__ci_last_regenerate|i:1727213942;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2uv1v3aork8ivgnf5neongha6vgh2mi8', '2a12:d280:100:51::', 1727263321, '__ci_last_regenerate|i:1727263321;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2valf81jfvsj9gig3jtm57mq2o3f5c23', '2a12:d280:100:51::', 1727117521, '__ci_last_regenerate|i:1727117521;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2vb934q1s6svo1plbmj8ul8moqlbvdle', '2a12:d280:100:51::', 1727207402, '__ci_last_regenerate|i:1727207402;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2vdmintbk1kmu81f7tcfalpk5265c90n', '2a12:d280:100:51::', 1727229422, '__ci_last_regenerate|i:1727229422;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2vq4482h4som577cdt13mt56j0vjfpjd', '2a12:d280:100:51::', 1727244661, '__ci_last_regenerate|i:1727244661;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('30d724thhbado4sog1uldqq4rmjtd80r', '2a12:d280:100:51::', 1727069581, '__ci_last_regenerate|i:1727069581;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('316drg26q204qh8b14npu67cr06ubg91', '2a12:d280:100:51::', 1727211901, '__ci_last_regenerate|i:1727211901;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('31r9albmn0mu1833u28p9ctolc2labiv', '2a12:d280:100:51::', 1727195641, '__ci_last_regenerate|i:1727195641;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('329sokdammrej59ul6j7luoad626mlvn', '2a12:d280:100:51::', 1727251982, '__ci_last_regenerate|i:1727251982;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('32mohkiv84fkqkvh57cfa2qbd3te6n9o', '2a12:d280:100:51::', 1727152141, '__ci_last_regenerate|i:1727152141;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('32u6k0jbj27idtnvb0764kd1ropl8bo1', '2a12:d280:100:51::', 1727180221, '__ci_last_regenerate|i:1727180221;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('33a7lsm3aqu460kbs9u6lqnf4rcg7jms', '2a12:d280:100:51::', 1727063522, '__ci_last_regenerate|i:1727063522;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('33auc2k43u229edaql9na7rsfa7t5s70', '2a12:d280:100:51::', 1727160062, '__ci_last_regenerate|i:1727160062;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('33e044q3be0rut6rjd7gslnjg116n316', '2a12:d280:100:51::', 1727091241, '__ci_last_regenerate|i:1727091241;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('33rh9cf2f3jg727ebuutbl4r69kqtc3d', '2a12:d280:100:51::', 1727153641, '__ci_last_regenerate|i:1727153641;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3488ibuqk5dfrbrqqi54encb6rrmmuq2', '2a12:d280:100:51::', 1727158022, '__ci_last_regenerate|i:1727158022;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('34aum0485bi5bdsie1velcjoa34oj4dp', '2a12:d280:100:51::', 1727203021, '__ci_last_regenerate|i:1727203021;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('34i4ih8tc1j3fjnpmm92gg9doh3v7ior', '2a12:d280:100:51::', 1727218502, '__ci_last_regenerate|i:1727218502;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('34j6lqem66jp3caahkbf4rs4jt960h08', '2a12:d280:100:51::', 1727065321, '__ci_last_regenerate|i:1727065321;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('34mcgddhigpov0o51duih6nthfbij5d6', '2a12:d280:100:51::', 1727163182, '__ci_last_regenerate|i:1727163182;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('35d0ocvqnr976j8knqfiqsc4e6rkifch', '2a12:d280:100:51::', 1727174162, '__ci_last_regenerate|i:1727174162;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('35glstnpeesn4e3cudscov9vfo2au39t', '2a12:d280:100:51::', 1727110562, '__ci_last_regenerate|i:1727110562;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('35jfiokcq3bgmdaj0dmrlqfuur0b5m3g', '2a12:d280:100:51::', 1727068322, '__ci_last_regenerate|i:1727068321;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('35uimput3rriol77qc5jqonuo1lqokb6', '2a12:d280:100:51::', 1727082362, '__ci_last_regenerate|i:1727082362;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3690sq6olfsrjs6453eioem85tv562j6', '2a12:d280:100:51::', 1727102221, '__ci_last_regenerate|i:1727102221;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('36kjff6at3q1jagkujj9gkrjk6lo35ga', '2a12:d280:100:51::', 1727128382, '__ci_last_regenerate|i:1727128382;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('36ongdg5tumjjfvrgm74rilqqcg3f2rl', '2a12:d280:100:51::', 1727173322, '__ci_last_regenerate|i:1727173322;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('36s964vqqemqqrhqjmtvevq2r19qhts5', '2a12:d280:100:51::', 1727094241, '__ci_last_regenerate|i:1727094241;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('36tb77co1p19dohtmda9aci6nt2kgpkr', '2a12:d280:100:51::', 1727197442, '__ci_last_regenerate|i:1727197442;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('36vnjc2p2r3p1q0stuh0agpkdddrj6ub', '2a12:d280:100:51::', 1727295241, '__ci_last_regenerate|i:1727295241;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('37bov2km57slm0938bh23ccpcmi81d4i', '2a12:d280:100:51::', 1727145002, '__ci_last_regenerate|i:1727145001;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('37dd3t1oq41or6c6nagpjbmuspke1r60', '2a12:d280:100:51::', 1727139841, '__ci_last_regenerate|i:1727139841;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('37egt39h2dson8sn4mufkl4kuepett27', '2a12:d280:100:51::', 1727047562, '__ci_last_regenerate|i:1727047562;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('37jqjm1kgeugbaaqc4spfac5makcdom3', '2a12:d280:100:51::', 1727132042, '__ci_last_regenerate|i:1727132042;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('37v1s2oo5litcoi8tos45g6lgmpfjfje', '2a12:d280:100:51::', 1727242021, '__ci_last_regenerate|i:1727242021;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3841hj06n3v49cqfeih84noil6rk7nbs', '2a12:d280:100:51::', 1727170441, '__ci_last_regenerate|i:1727170441;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('38c0l5h88g4ujkufhufii5mt407pde8l', '2a12:d280:100:51::', 1727133301, '__ci_last_regenerate|i:1727133301;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('38fc63jv47kae7o6o6afuph7bico0lqc', '2a12:d280:100:51::', 1727051341, '__ci_last_regenerate|i:1727051341;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('38iop5f0r5bnbc13aicq52e4klrc2oh4', '2a12:d280:100:51::', 1727201822, '__ci_last_regenerate|i:1727201822;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('38pvh021grsjqhof9gcnvh4f1j9ucf6f', '2a12:d280:100:51::', 1727181302, '__ci_last_regenerate|i:1727181302;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('38tc8dd7aolcanmmlg26cgquv8430qcs', '2a12:d280:100:51::', 1727135821, '__ci_last_regenerate|i:1727135821;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('393kshouf6abnvuutarj10quetfhe1s8', '2a12:d280:100:51::', 1727191021, '__ci_last_regenerate|i:1727191021;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('395bsglpnodkneir20ksr8gvs9vucjqn', '2a12:d280:100:51::', 1727101982, '__ci_last_regenerate|i:1727101982;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('39fn8isj6sn5edd16ol6jt45hv441ndk', '2a12:d280:100:51::', 1727090222, '__ci_last_regenerate|i:1727090221;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('39rbjs7thsgujo9n3smlj6h7nllkikla', '2a12:d280:100:51::', 1727218496, '__ci_last_regenerate|i:1727218494;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('39rm2eatraoctejt7l5vmbm8dfitlk47', '2a12:d280:100:51::', 1727164802, '__ci_last_regenerate|i:1727164802;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3aon1kg8vm0dehv0l26teltlt900kjug', '2a12:d280:100:51::', 1727221382, '__ci_last_regenerate|i:1727221382;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3b9rs09ed45p9b2v9liovjoskk1n3au9', '2a12:d280:100:51::', 1727206742, '__ci_last_regenerate|i:1727206742;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3bglo6j48cvssqhjc2c3c0momf9vp3pc', '2a12:d280:100:51::', 1727088542, '__ci_last_regenerate|i:1727088542;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3bmqae358oh2oavbvkrjo8hu5vodanpa', '2a12:d280:100:51::', 1727087702, '__ci_last_regenerate|i:1727087702;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3bto59pad5543fpfvolv79scbg944f0f', '2a12:d280:100:51::', 1727088301, '__ci_last_regenerate|i:1727088301;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3c3r19evokh55fl2i1pqnj8sq9e4tuc8', '2a12:d280:100:51::', 1727223422, '__ci_last_regenerate|i:1727223422;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3c9hsr3rqd23iqut9979931urnhcds6s', '2a12:d280:100:51::', 1727240462, '__ci_last_regenerate|i:1727240462;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3cf0qvj3luu72balnlgqho580450dgmi', '2a12:d280:100:51::', 1727095501, '__ci_last_regenerate|i:1727095501;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3cns77oe3a784t47hmq1qudr4klrgf38', '2a12:d280:100:51::', 1727074501, '__ci_last_regenerate|i:1727074501;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3cp9bhrucbhkp8hp456siqhj5vm52n22', '2a12:d280:100:51::', 1727206261, '__ci_last_regenerate|i:1727206261;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3d1u63p7ejh8gbq2hc82plhticeivet5', '2a12:d280:100:51::', 1727120222, '__ci_last_regenerate|i:1727120221;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3dmtejcchidph0h5j0bavd42lrhjigvn', '2a12:d280:100:51::', 1727059202, '__ci_last_regenerate|i:1727059202;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3eiocenv294o2f2b0g5c2j9892qkruqf', '2a12:d280:100:51::', 1727148661, '__ci_last_regenerate|i:1727148661;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3ejjq22n2ffduu1u392opl1ekp8m8qpl', '2a12:d280:100:51::', 1727171041, '__ci_last_regenerate|i:1727171041;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3eutn3gcte746o7dt856fpjugnlp1v5p', '2a12:d280:100:51::', 1727050562, '__ci_last_regenerate|i:1727050562;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3ev28m4s98gj9nsftgkjgs41rk4lpdg0', '2a12:d280:100:51::', 1727135701, '__ci_last_regenerate|i:1727135701;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3f11iq29sa3v15192goraoticqeic98i', '2a12:d280:100:51::', 1727195342, '__ci_last_regenerate|i:1727195342;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3f9gcaglv4sjlsn4le1hhfeptdps2v8o', '2a12:d280:100:51::', 1727130061, '__ci_last_regenerate|i:1727130061;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3fbilt3fhndmbpgduhs9dj8lgp40eb7u', '2a12:d280:100:51::', 1727068082, '__ci_last_regenerate|i:1727068082;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3fvc5g6rqi2cm4us590ftop3pv5vij21', '2a12:d280:100:51::', 1727267101, '__ci_last_regenerate|i:1727267101;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3gvb4pn5offrl7bsrcq1ev67cith4fci', '2a12:d280:100:51::', 1727130422, '__ci_last_regenerate|i:1727130422;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3h5ooe5ou4jis4vncpqie6ahq95mu3mp', '2a12:d280:100:51::', 1727166662, '__ci_last_regenerate|i:1727166662;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3h5td6mv1mq4luni6rhebiee89mojbb3', '2a12:d280:100:51::', 1727129402, '__ci_last_regenerate|i:1727129401;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3hlqk2lm4ij67kdnggbd4se1omqbl58t', '2a12:d280:100:51::', 1727202181, '__ci_last_regenerate|i:1727202181;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3hutm7anou39rfr562sp18542pvolmdd', '2a12:d280:100:51::', 1727144161, '__ci_last_regenerate|i:1727144161;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3hvuol3dm3bv6rnf6bgthrusjhl1jmn8', '2a12:d280:100:51::', 1727130962, '__ci_last_regenerate|i:1727130961;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3i1qcgqcph95n5df0nulb33iifph7u49', '2a12:d280:100:51::', 1727242202, '__ci_last_regenerate|i:1727242202;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3i311i44bvalk2qbsp1vmvmft7df9ito', '2a12:d280:100:51::', 1727217961, '__ci_last_regenerate|i:1727217961;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3il0cuar8m0kk3roiuof82lvhphtsens', '2a12:d280:100:51::', 1727209021, '__ci_last_regenerate|i:1727209021;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3iniag58hmnso0s1h4s9m6mfedgfnumj', '2a12:d280:100:51::', 1727076482, '__ci_last_regenerate|i:1727076482;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3iv59agd48r9c42rooprs81degmnc62h', '2a12:d280:100:51::', 1727089142, '__ci_last_regenerate|i:1727089142;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3j1uhir05e00r7ikck0rk13lm96ulis3', '2a12:d280:100:51::', 1727270522, '__ci_last_regenerate|i:1727270522;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3jhvv4frtu1nmnnqv1pejpnlrsfid07u', '2a12:d280:100:51::', 1727164201, '__ci_last_regenerate|i:1727164201;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3jq8fc295bmt8se4pkl2vi1e641dncm1', '2a12:d280:100:51::', 1727087761, '__ci_last_regenerate|i:1727087761;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3junqvogrg11c5sj04uhkvc1drb9pvkq', '2a12:d280:100:51::', 1727059862, '__ci_last_regenerate|i:1727059861;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3khon7ueq7ekam4n3tmg311nfkskf51j', '2a12:d280:100:51::', 1727061242, '__ci_last_regenerate|i:1727061242;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3krulc4neai17ngci5tirbqlj92nr5sg', '2a12:d280:100:51::', 1727138041, '__ci_last_regenerate|i:1727138041;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3ll2sh0gh6l4rqjo5f4pcbjuq8smpijm', '2a12:d280:100:51::', 1727143982, '__ci_last_regenerate|i:1727143982;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3lqq0mftjkom3thb076bks8phtmcj5vh', '2a12:d280:100:51::', 1727243702, '__ci_last_regenerate|i:1727243701;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3lsstuv6mpr138vipbumj5ood05iv51n', '2a12:d280:100:51::', 1727157961, '__ci_last_regenerate|i:1727157961;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3lujrmdqshp0jm0fiamsocpj6q01likk', '2a12:d280:100:51::', 1727077562, '__ci_last_regenerate|i:1727077562;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3m003huatoma9i5uup587rm5i4buc6dc', '2a12:d280:100:51::', 1727151541, '__ci_last_regenerate|i:1727151541;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3m35ld4dkfpn8d7sj12fjhpqiofqt7pk', '2a12:d280:100:51::', 1727165342, '__ci_last_regenerate|i:1727165342;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3m5me5ajkcpp2s5ft0fdjeim6f9tl146', '2a12:d280:100:51::', 1727059621, '__ci_last_regenerate|i:1727059621;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3me09djkcd2kjiimgnstsj72qgiheg66', '2a12:d280:100:51::', 1727225881, '__ci_last_regenerate|i:1727225881;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3mnkrfvu9rv81ebpsbrc17edtnsfuvt3', '2a12:d280:100:51::', 1727261402, '__ci_last_regenerate|i:1727261402;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3n7bj40bvo1sb2fn4e83c6sid1dl7og3', '2a12:d280:100:51::', 1727148841, '__ci_last_regenerate|i:1727148841;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3nc761q1diu0ao6mqvbnmn6p2drf7lc1', '2a12:d280:100:51::', 1727234282, '__ci_last_regenerate|i:1727234282;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3nmdjsr1s1r4nef8ln86dj7d1735g1oj', '2a12:d280:100:51::', 1727060461, '__ci_last_regenerate|i:1727060461;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3nt427gmacmr681p2kr6vc3jbrecqghm', '2a12:d280:100:51::', 1727048402, '__ci_last_regenerate|i:1727048402;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3on3ado58ah2p9524t3peqojj4est6n3', '2a12:d280:100:51::', 1727177822, '__ci_last_regenerate|i:1727177822;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3p29f8nefntj9k7j0793p578h9269rc7', '2a12:d280:100:51::', 1727253721, '__ci_last_regenerate|i:1727253721;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3pg8u88dp6s9qknbrn1vcjcso066ek87', '2a12:d280:100:51::', 1727204641, '__ci_last_regenerate|i:1727204641;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3pjekl3gt4bqm5mh973g0hl9152rqug4', '2a12:d280:100:51::', 1727212802, '__ci_last_regenerate|i:1727212802;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3pl7pfeuncvr358t2v53hj3op10vh78k', '2a12:d280:100:51::', 1727202781, '__ci_last_regenerate|i:1727202781;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3pn44pgkkit0ccpr8r28t842tcrur6fc', '2a12:d280:100:51::', 1727067302, '__ci_last_regenerate|i:1727067302;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3pncsmrs4af3t372eams06cl2j6unsdk', '192.145.39.249', 1727111882, '__ci_last_regenerate|i:1727111882;_prev_url|s:60:\"https://panel.blitconcept.es/admin/resourcebooking/booking/1\";staff_user_id|s:1:\"1\";staff_logged_in|b:1;setup-menu-open|s:0:\"\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3popc2bjiefcb4jqm2ph999srvb8pf69', '2a12:d280:100:51::', 1727093462, '__ci_last_regenerate|i:1727093462;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3q77kdqus06s9qd2mfuopipjr3bavuno', '2a12:d280:100:51::', 1727083022, '__ci_last_regenerate|i:1727083022;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3qj64c3k7quvsvdi33517710c21dijlg', '2a12:d280:100:51::', 1727266621, '__ci_last_regenerate|i:1727266621;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3r4o7d7i3chk5f1hiq5fpue4lmlfihfp', '2a12:d280:100:51::', 1727247962, '__ci_last_regenerate|i:1727247962;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3r7uii0pdo6ge8d81vvli9jmmdllj34f', '2a12:d280:100:51::', 1727243822, '__ci_last_regenerate|i:1727243822;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3sf7dtvhf6v45ml6ak09pl1t2d7t114e', '2a12:d280:100:51::', 1727282881, '__ci_last_regenerate|i:1727282881;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3sh1s18mgoj8n3q28qebvqq44nn6uapn', '2a12:d280:100:51::', 1727121602, '__ci_last_regenerate|i:1727121602;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3sro1r6ckdq84ftiqtpr2qusfdnl5ec5', '2a12:d280:100:51::', 1727095381, '__ci_last_regenerate|i:1727095381;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3t4rh1a5je9e08ev1tgqj4gduqtmp5bh', '2a12:d280:100:51::', 1727104921, '__ci_last_regenerate|i:1727104921;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3tu9kpalbqev1dk7v44s7amgmvqgh3js', '2a12:d280:100:51::', 1727123281, '__ci_last_regenerate|i:1727123281;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3u9fein2031qus7dqg7ofdnme680u8ae', '2a12:d280:100:51::', 1727121722, '__ci_last_regenerate|i:1727121722;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3uboa6jtoolt9e3am0oc26s8b8c1i3ge', '2a12:d280:100:51::', 1727155922, '__ci_last_regenerate|i:1727155922;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3uh4flnfvu78vioi03q2j211qu7q0psb', '2a12:d280:100:51::', 1727173441, '__ci_last_regenerate|i:1727173441;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3uo1l8urkqm80gc4vvhg178df2ofkrlh', '2a12:d280:100:51::', 1727097782, '__ci_last_regenerate|i:1727097781;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3urmbgnqsup51bq4g19p7n4vejvvmm64', '2a12:d280:100:51::', 1727139602, '__ci_last_regenerate|i:1727139601;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3v34hjqg7i7c7uqtd1fg321p6sd71ve3', '2a12:d280:100:51::', 1727252102, '__ci_last_regenerate|i:1727252102;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3v4l0el5rguub7a54mq3ge6dgcpb74b5', '2a12:d280:100:51::', 1727186102, '__ci_last_regenerate|i:1727186102;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3v988657mb1p9cv19odkbro9f3a52ovd', '2a12:d280:100:51::', 1727052541, '__ci_last_regenerate|i:1727052541;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3v9c11cgiter0vnbl3p4mvq8d380ld42', '2a12:d280:100:51::', 1727106422, '__ci_last_regenerate|i:1727106422;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3vjtjbvk606lac2ul48tns8220tjio53', '2a12:d280:100:51::', 1727208242, '__ci_last_regenerate|i:1727208242;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('40bmim83t3n6neadm1hcm79tvnrfcdfh', '2a12:d280:100:51::', 1727091842, '__ci_last_regenerate|i:1727091842;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('40e7bunn25d4098rag218mibc4aa69db', '2a12:d280:100:51::', 1727111041, '__ci_last_regenerate|i:1727111041;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('40enpr1hgstq4vke9e16brepiii03fia', '2a12:d280:100:51::', 1727197082, '__ci_last_regenerate|i:1727197082;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('41036dbd3109u2kf43ekg5ouk3ljnlgu', '2a12:d280:100:51::', 1727192162, '__ci_last_regenerate|i:1727192161;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('41avahtur20k26hdrdjfv1o17uivt5vf', '2a12:d280:100:51::', 1727162222, '__ci_last_regenerate|i:1727162222;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('41e0r262jc46qsla94d2vojv01f20ta7', '2a12:d280:100:51::', 1727175662, '__ci_last_regenerate|i:1727175662;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('41lvea721hmv44kejf2agbg1kmlknrjm', '2a12:d280:100:51::', 1727281982, '__ci_last_regenerate|i:1727281982;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('41r0fup9llplc60j87jebgt4gtpnjhlv', '2a12:d280:100:51::', 1727259362, '__ci_last_regenerate|i:1727259362;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('41saklr3sh7cgtrfgsi9ulrrtfihpek9', '2a12:d280:100:51::', 1727230801, '__ci_last_regenerate|i:1727230801;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('424edpev8n96uk0ufgec5hotd4ihts8c', '2a12:d280:100:51::', 1727150461, '__ci_last_regenerate|i:1727150461;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4271flvg9nu9qtqlb256m938j7onb1re', '2a12:d280:100:51::', 1727124121, '__ci_last_regenerate|i:1727124121;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4280gkmgeljuu3cdd2hd5bhvaqi51196', '2a12:d280:100:51::', 1727073361, '__ci_last_regenerate|i:1727073361;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('42l28lde28pa9r2r7qnudogeq1mpr7m7', '2a12:d280:100:51::', 1727270581, '__ci_last_regenerate|i:1727270581;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('42sh0k1029jjpha1qp8jn38mdgqk3cu2', '2a12:d280:100:51::', 1727276402, '__ci_last_regenerate|i:1727276402;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('431fno6hom4i4b4hv5edahrtpcbcucnu', '2a12:d280:100:51::', 1727248201, '__ci_last_regenerate|i:1727248201;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('433n7si0146216kavrqtfhkg6m8uhrj8', '2a12:d280:100:51::', 1727263382, '__ci_last_regenerate|i:1727263382;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('43grq22s49mao9m7hri4rsp6p9b1684r', '2a12:d280:100:51::', 1727068261, '__ci_last_regenerate|i:1727068261;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('43ijam6flo1ct4qbghnhdn4idm44uf1p', '2a12:d280:100:51::', 1727060821, '__ci_last_regenerate|i:1727060821;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('43jlf5b8gta2e7eiehagbk1f2svni4tk', '2a12:d280:100:51::', 1727194862, '__ci_last_regenerate|i:1727194862;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('43jsej0lsfg05sd6cg172o33hco8t0nf', '2a12:d280:100:51::', 1727244001, '__ci_last_regenerate|i:1727244001;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('43t81dijrqh15v3sbuhrh9u90lntruc0', '2a12:d280:100:51::', 1727228941, '__ci_last_regenerate|i:1727228941;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('43vdfk2kbktvu21c4c9otjjq7p5siig7', '31.223.103.75', 1727294778, '__ci_last_regenerate|i:1727294778;red_url|s:34:\"https://panel.blitconcept.es/admin\";_prev_url|s:49:\"https://panel.blitconcept.es/admin/authentication\";message-danger|s:31:\"Email o contraseña no válidos\";__ci_vars|a:1:{s:14:\"message-danger\";s:3:\"old\";}');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('44cglmjj06doq7gc00s6hr1fc7g1ssb4', '2a12:d280:100:51::', 1727264822, '__ci_last_regenerate|i:1727264821;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('44f3au9t05hjop0buekeh2cngemv9g9p', '2a12:d280:100:51::', 1727260082, '__ci_last_regenerate|i:1727260082;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('44fe1aofggcc8krhti9qntqjckd2gapr', '2a12:d280:100:51::', 1727248922, '__ci_last_regenerate|i:1727248922;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('44gurncn9iquoktjlmvpfig2f93srl5i', '2a12:d280:100:51::', 1727113682, '__ci_last_regenerate|i:1727113682;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('44ho434plfibl36gg17nbtjm3662kvqa', '2a12:d280:100:51::', 1727155981, '__ci_last_regenerate|i:1727155981;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('44k0vb9p33fdgg6krj3pl57valb8buni', '2a12:d280:100:51::', 1727189222, '__ci_last_regenerate|i:1727189222;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('44ln1pqqttoo2tu483nusk177l66j6qh', '2a12:d280:100:51::', 1727124602, '__ci_last_regenerate|i:1727124602;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4556apfovsgdd2kat7or39ehg015ojn1', '2a12:d280:100:51::', 1727067721, '__ci_last_regenerate|i:1727067721;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4569lapc24rv50bpk2suhop96o1upm1u', '2a12:d280:100:51::', 1727123822, '__ci_last_regenerate|i:1727123822;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('45dlf2u23svlq6n16f61bv996arhtogb', '2a12:d280:100:51::', 1727172362, '__ci_last_regenerate|i:1727172362;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('45i004pam1uuv5emfdr5o02vn4pufoup', '2a12:d280:100:51::', 1727186161, '__ci_last_regenerate|i:1727186161;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('45ne4cuh7qem355ori5jthsnol0cc5ah', '2a12:d280:100:51::', 1727123042, '__ci_last_regenerate|i:1727123042;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('46e23jo2gpn1rd8p80kamah6tijm7fle', '2a12:d280:100:51::', 1727062501, '__ci_last_regenerate|i:1727062501;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('46ieost24pp5enbgs40v8lo4jmceu2ah', '2a12:d280:100:51::', 1727146802, '__ci_last_regenerate|i:1727146802;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('46j70k7t9tt1dtvqf1n6mu828nkfn25s', '2a12:d280:100:51::', 1727147641, '__ci_last_regenerate|i:1727147641;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('46l1nvvef88jh9h57stfvue49jvj53cm', '2a12:d280:100:51::', 1727272621, '__ci_last_regenerate|i:1727272621;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('46ufrvr8t13lf0u80c3vke8malrjuhc9', '2a12:d280:100:51::', 1727275261, '__ci_last_regenerate|i:1727275261;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('47j61pnquku6k0j9ldju9vi3dnmmie5t', '2a12:d280:100:51::', 1727267702, '__ci_last_regenerate|i:1727267702;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('47mh010u8nrksg56fkckit4oum9b1kfo', '2a12:d280:100:51::', 1727110922, '__ci_last_regenerate|i:1727110922;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('47sjo7jc3gkso9akjq9ctpd31079kc4m', '2a12:d280:100:51::', 1727215621, '__ci_last_regenerate|i:1727215621;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('48fom885im44r2asasim56ibgdp20l8j', '2a12:d280:100:51::', 1727085481, '__ci_last_regenerate|i:1727085481;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('48vccu4joflchodumo9inbce0omqqjmj', '2a12:d280:100:51::', 1727187482, '__ci_last_regenerate|i:1727187482;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('490v5crrn8cvnj3j1afq6begn9f0tg0e', '2a12:d280:100:51::', 1727264641, '__ci_last_regenerate|i:1727264641;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4amp43oglj4s7ffh5tcu2c28ii8aaru3', '2a12:d280:100:51::', 1727291581, '__ci_last_regenerate|i:1727291581;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4aqu7dcqt4d7rtsug4nqtkoekfoslsf9', '2a12:d280:100:51::', 1727292182, '__ci_last_regenerate|i:1727292182;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4b4l4sl57pge1ck6nibhai8nfe3veodo', '2a12:d280:100:51::', 1727214961, '__ci_last_regenerate|i:1727214961;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4bule41i0nvj3r3hlc4v1bopsbah8rbe', '2a12:d280:100:51::', 1727254861, '__ci_last_regenerate|i:1727254861;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4c1f6ajejvvscklc4dlbco7klrvnkp4o', '2a12:d280:100:51::', 1727182381, '__ci_last_regenerate|i:1727182381;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4c3vs2b2fnf9rs3kut1i0ltgduvgchc7', '2a12:d280:100:51::', 1727161382, '__ci_last_regenerate|i:1727161382;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4d76k7vq5u6cdukua6g4dcpccdvg0vu0', '2a12:d280:100:51::', 1727236021, '__ci_last_regenerate|i:1727236021;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4dcoj5rnbkqvimrcgokoodoi6i785k11', '2a12:d280:100:51::', 1727263141, '__ci_last_regenerate|i:1727263141;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4degvuilhg54pm9lle40ineu091gnb0e', '2a12:d280:100:51::', 1727262422, '__ci_last_regenerate|i:1727262422;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4dgr653ql4ioqqe3kos810v3dvkr12tf', '2a12:d280:100:51::', 1727118122, '__ci_last_regenerate|i:1727118122;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4dov8609cq5ks0rftkfv52np9u4urndc', '2a12:d280:100:51::', 1727294042, '__ci_last_regenerate|i:1727294042;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4dsfcbbbtuo7aqvv00s40s4cjm63t7uj', '2a12:d280:100:51::', 1727271661, '__ci_last_regenerate|i:1727271661;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4e39r0gclsup98noikb2bmgfi4coqbsg', '2a12:d280:100:51::', 1727091181, '__ci_last_regenerate|i:1727091181;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4efq6q0n0bv82t3fj6radqs3qbpl56tu', '2a12:d280:100:51::', 1727285342, '__ci_last_regenerate|i:1727285341;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4epacnkkoj8ced7o8ta0pef2ekko1ltl', '2a12:d280:100:51::', 1727225521, '__ci_last_regenerate|i:1727225521;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4fdmh56amnliuf4qmk2s6cvkopgdha7b', '2a12:d280:100:51::', 1727127301, '__ci_last_regenerate|i:1727127301;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4fubfs4l86uul9tgfa8r30e5p0663rgb', '2a12:d280:100:51::', 1727239862, '__ci_last_regenerate|i:1727239862;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4gaa5mv1ckvl30h5lhq59kc7ivctk7gn', '2a12:d280:100:51::', 1727122801, '__ci_last_regenerate|i:1727122801;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4gkt8tp2agbegr1lob8o6kpus081sg18', '2a12:d280:100:51::', 1727081702, '__ci_last_regenerate|i:1727081702;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4grsu5upgd8lem22l03k66lmdmodu2dh', '2a12:d280:100:51::', 1727079841, '__ci_last_regenerate|i:1727079841;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4gtoh50veovppftfu394u6ck8qhvgn43', '2a12:d280:100:51::', 1727156402, '__ci_last_regenerate|i:1727156402;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4h278h0a0k1kgc63dohvjcd7q36avahh', '2a12:d280:100:51::', 1727160242, '__ci_last_regenerate|i:1727160242;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4h7bl2o1c5rtspcc7709ibm7u09sfkon', '2a12:d280:100:51::', 1727207102, '__ci_last_regenerate|i:1727207102;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4h88ftc23sgonjoqjmcg0gj7tejt151p', '2a12:d280:100:51::', 1727223241, '__ci_last_regenerate|i:1727223241;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4h8nrifpncqv7mh5bcs2fveid2j19d9b', '2a12:d280:100:51::', 1727153041, '__ci_last_regenerate|i:1727153041;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4ha0jqufmvrujelkf47r5fnvmt25hbra', '2a12:d280:100:51::', 1727120822, '__ci_last_regenerate|i:1727120822;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4hcavod5b608fm4e1ovd3tuji0dlhi1s', '2a12:d280:100:51::', 1727206862, '__ci_last_regenerate|i:1727206861;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4hcnvrjtuc8uhrevrtvtlj0u8brq9ubl', '2a12:d280:100:51::', 1727240402, '__ci_last_regenerate|i:1727240401;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4hdk69hg05mbr5003uoldhg4k3hdqi6n', '2a12:d280:100:51::', 1727148002, '__ci_last_regenerate|i:1727148002;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4i4mnmhkuq2u5kh6l1mbht6v8ejnae84', '2a12:d280:100:51::', 1727149981, '__ci_last_regenerate|i:1727149981;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4i4nl4imvlpupf60h0ndp396di745vce', '2a12:d280:100:51::', 1727046181, '__ci_last_regenerate|i:1727046181;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4it2sa3vqvi8u6feucq6543mn4ahere1', '2a12:d280:100:51::', 1727243641, '__ci_last_regenerate|i:1727243641;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4j568e7a93glj817112fprks225ngirh', '2a12:d280:100:51::', 1727220481, '__ci_last_regenerate|i:1727220481;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4jb5o1nvgbkt581uk18gnuf50o7vpogq', '2a12:d280:100:51::', 1727273282, '__ci_last_regenerate|i:1727273281;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4jdeohnn9vs6hqt3lvckvgjdf7t8uob0', '2a12:d280:100:51::', 1727117641, '__ci_last_regenerate|i:1727117641;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4jek3lacfvfsvortp7skl89b4vr8o68j', '2a12:d280:100:51::', 1727077681, '__ci_last_regenerate|i:1727077681;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4jinvil5faq7lr803nb5c9bs34l8t40f', '2a12:d280:100:51::', 1727092141, '__ci_last_regenerate|i:1727092141;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4jk74vfga3ti0cm0bn099psfenjrquvk', '2a12:d280:100:51::', 1727178481, '__ci_last_regenerate|i:1727178481;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4k5ob12jj61a2jqk8crlrrrhb0t4ifug', '2a12:d280:100:51::', 1727058902, '__ci_last_regenerate|i:1727058902;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4ke1dljgl9vrth2s3npbukp142dcv58h', '2a12:d280:100:51::', 1727087881, '__ci_last_regenerate|i:1727087881;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4krb9fctuo95q3g5rfuau5gg24pkb78s', '2a12:d280:100:51::', 1727076962, '__ci_last_regenerate|i:1727076962;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4kths2isfvt46qbaodgvmuu4ffdim25d', '2a12:d280:100:51::', 1727225401, '__ci_last_regenerate|i:1727225401;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4l75f2srbk8lhot8ug8mmt9kju2cul82', '2a12:d280:100:51::', 1727116981, '__ci_last_regenerate|i:1727116981;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4lfnll5r8o43m4npkll92cs0ljrcqp3i', '2a12:d280:100:51::', 1727119981, '__ci_last_regenerate|i:1727119981;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4mdi4dmhmnlr9ato9apvhifqmltjs6c6', '2a12:d280:100:51::', 1727070062, '__ci_last_regenerate|i:1727070061;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4mfksmfuc448r1i4v2qlcmbjsq9b52sg', '2a12:d280:100:51::', 1727099522, '__ci_last_regenerate|i:1727099522;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4mg58pns2v6ed0lg5qhg1vqilvkm7tn8', '2a12:d280:100:51::', 1727253781, '__ci_last_regenerate|i:1727253781;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4mg9o1aoftj8828ocoirjp1cb8ms2p89', '2a12:d280:100:51::', 1727137081, '__ci_last_regenerate|i:1727137081;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4mialg4g4dmhc6mvi6p742mg4e9218gt', '2a12:d280:100:51::', 1727152921, '__ci_last_regenerate|i:1727152921;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4mliemp7h7b2mgo04bap3mcgdnr0kjhm', '2a12:d280:100:51::', 1727155501, '__ci_last_regenerate|i:1727155501;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4mtb2g15ln2nseus2vrjb543js1dsd1d', '2a12:d280:100:51::', 1727055541, '__ci_last_regenerate|i:1727055541;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4nkmpetk2ham2k92jkseh40c4fkj1sc0', '2a12:d280:100:51::', 1727048642, '__ci_last_regenerate|i:1727048642;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4nlknvf95kf6dq2t3gr24459491m12jf', '2a12:d280:100:51::', 1727290442, '__ci_last_regenerate|i:1727290442;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4nlsdgorfd1jfe7u78rudvd0da7lovp9', '2a12:d280:100:51::', 1727115841, '__ci_last_regenerate|i:1727115841;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4o3g42lrdqma2icgjf2ec6a4hbcrou85', '2a12:d280:100:51::', 1727056261, '__ci_last_regenerate|i:1727056261;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4o9ageeicmo2v2tk8820r8hqa9j736to', '2a12:d280:100:51::', 1727212981, '__ci_last_regenerate|i:1727212981;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4o9t0f0urs2rhqt3dtqh3ob6copf15es', '2a12:d280:100:51::', 1727255882, '__ci_last_regenerate|i:1727255882;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4ocr3qdgkl0pu265tmve0gqkmp067s7b', '2a12:d280:100:51::', 1727268901, '__ci_last_regenerate|i:1727268901;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4oqkff4atiurridb13teudp8oadlj828', '2a12:d280:100:51::', 1727187602, '__ci_last_regenerate|i:1727187602;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4otj4i3r6t11l6q0rjbath9u0506ajhc', '2a12:d280:100:51::', 1727191681, '__ci_last_regenerate|i:1727191681;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4pna8t9lbjd7v010of76121nl3t3bl05', '2a12:d280:100:51::', 1727106782, '__ci_last_regenerate|i:1727106782;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4qj0t8utsev5io3defn9hsivvhntua4b', '2a12:d280:100:51::', 1727097961, '__ci_last_regenerate|i:1727097961;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4r1vbmlf62ni635ejogehr3iqkdesf8n', '2a12:d280:100:51::', 1727162342, '__ci_last_regenerate|i:1727162342;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4r5s6lsc5k5jsaal26ctsuh0evci7ho2', '2a12:d280:100:51::', 1727151841, '__ci_last_regenerate|i:1727151841;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4r682qbo79v1rouhf2clr3i1ma0rg9uv', '2a12:d280:100:51::', 1727294882, '__ci_last_regenerate|i:1727294882;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4rg6nrrecum2bms34nu34i04pv3v6v64', '2a12:d280:100:51::', 1727200321, '__ci_last_regenerate|i:1727200321;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4rh00akdgq5qlqe4eaik9fjuaaeb3obc', '2a12:d280:100:51::', 1727134742, '__ci_last_regenerate|i:1727134742;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4rjn1h143qa5lu6pmaco43pbt7alomcb', '2a12:d280:100:51::', 1727106301, '__ci_last_regenerate|i:1727106301;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4roqbpc56evoq56l7j9qkejb74ls9cfh', '2a12:d280:100:51::', 1727077982, '__ci_last_regenerate|i:1727077982;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4sj74ah4g6m5a6srpe4qof6u9rjrpop7', '2a12:d280:100:51::', 1727274541, '__ci_last_regenerate|i:1727274541;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4soia90ensthqg20h54vvbrmk9qid9fs', '2a12:d280:100:51::', 1727247122, '__ci_last_regenerate|i:1727247122;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4ss4q22j4396q17skbs04aqeipevp2om', '2a12:d280:100:51::', 1727208602, '__ci_last_regenerate|i:1727208602;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4sui8jb7mg5dtfj6kecj1id9l22l8tui', '2a12:d280:100:51::', 1727277842, '__ci_last_regenerate|i:1727277842;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4t1m21qjr2it3q8brifb6tka1ch9qnq2', '2a12:d280:100:51::', 1727165281, '__ci_last_regenerate|i:1727165281;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4t22l816ik3bft7mqabfh1sa71fe699c', '2a12:d280:100:51::', 1727047201, '__ci_last_regenerate|i:1727047201;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4tiickpgdthctfpni4ph2530budcq2j0', '2a12:d280:100:51::', 1727142181, '__ci_last_regenerate|i:1727142181;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4ts7mpsgg4m6qgtmqedd5le4hc68rrc6', '2a12:d280:100:51::', 1727095742, '__ci_last_regenerate|i:1727095742;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4u88piiis58p8f74huolavl9fjup32km', '2a12:d280:100:51::', 1727193182, '__ci_last_regenerate|i:1727193182;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4u8qb3q9nvuaqa6037brmd9phtc8r2um', '2a12:d280:100:51::', 1727268241, '__ci_last_regenerate|i:1727268241;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4ua8r0t2c57jko2rjruamhlhp3g4dcqm', '2a12:d280:100:51::', 1727206621, '__ci_last_regenerate|i:1727206621;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4udju82jjq8dqphiabevdcu5d12kksof', '192.145.39.249', 1727098154, '__ci_last_regenerate|i:1727098154;_prev_url|s:60:\"https://panel.blitconcept.es/admin/resourcebooking/booking/1\";staff_user_id|s:1:\"1\";staff_logged_in|b:1;setup-menu-open|s:0:\"\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4vkcqmj2op32uh7u5idrqgl16eevbn38', '2a12:d280:100:51::', 1727067481, '__ci_last_regenerate|i:1727067481;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('50a27o4tv9puhh7bskj4tu5f5cnjt3og', '2a12:d280:100:51::', 1727291282, '__ci_last_regenerate|i:1727291282;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('50htsovhtcacftsh9el5hih8jjceus7q', '2a12:d280:100:51::', 1727079961, '__ci_last_regenerate|i:1727079961;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('50mmghmiavekma03u25kdh7114tm9gar', '2a12:d280:100:51::', 1727280061, '__ci_last_regenerate|i:1727280061;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5152vb4t25gs2cgfla6r6cjsad9k4cdh', '2a12:d280:100:51::', 1727295062, '__ci_last_regenerate|i:1727295062;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('516ose6r85qnl8jsc0ifivgjmbhs7pa3', '2a12:d280:100:51::', 1727146442, '__ci_last_regenerate|i:1727146442;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('51el2i318fcq6rufh37pp5fek8r25mbo', '2a12:d280:100:51::', 1727193902, '__ci_last_regenerate|i:1727193902;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('51ep210f1c3c66dq71k9m9micrnp2kj8', '2a12:d280:100:51::', 1727136062, '__ci_last_regenerate|i:1727136062;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('51jgbblf4combjrg2s54ahaevh0p2er0', '2a12:d280:100:51::', 1727058962, '__ci_last_regenerate|i:1727058961;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('51lhg2pptssbbnfrkbvhdiq6gt46a2rf', '2a12:d280:100:51::', 1727245382, '__ci_last_regenerate|i:1727245382;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('51ml65ufv29e0ud4ljnjeqposcu4l41a', '2a12:d280:100:51::', 1727260561, '__ci_last_regenerate|i:1727260561;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('51mqt8lhpg6sc7hb2petlqvvc4u8mskc', '192.145.39.244', 1727115109, '__ci_last_regenerate|i:1727115109;_prev_url|s:49:\"https://panel.blitconcept.es/admin/authentication\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('51pnsc1uq7r3doeh3ics2rr6nj17n7t5', '2a12:d280:100:51::', 1727193542, '__ci_last_regenerate|i:1727193542;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('529rncabbvht43dntocvk94um9iitk7j', '2a12:d280:100:51::', 1727231041, '__ci_last_regenerate|i:1727231041;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('52q8fnls14q8ihebojojeq9oj60n48pr', '2a12:d280:100:51::', 1727278982, '__ci_last_regenerate|i:1727278982;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('537tp374m19bs3lkpt0vap8p1vks4fqo', '2a12:d280:100:51::', 1727118842, '__ci_last_regenerate|i:1727118842;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('53agbe5nj14codd2mufg3jeu67g1o353', '2a12:d280:100:51::', 1727226362, '__ci_last_regenerate|i:1727226362;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('53bl23n5lbuee5d88dk8kk16i1md6e8e', '2a12:d280:100:51::', 1727142481, '__ci_last_regenerate|i:1727142481;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('53bqm39fgc3dlhgajd61or1avmvpctbt', '2a12:d280:100:51::', 1727084881, '__ci_last_regenerate|i:1727084881;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('53fn3j044qgr9kj40rhpme50rvgjjhh3', '2a12:d280:100:51::', 1727157721, '__ci_last_regenerate|i:1727157721;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('53l74c2anf37mud97hcft4cmo2st811c', '2a12:d280:100:51::', 1727180762, '__ci_last_regenerate|i:1727180762;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('53s4taqehhfiln25mit80bs974jji3hf', '2a12:d280:100:51::', 1727159881, '__ci_last_regenerate|i:1727159881;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5411cb6gadltoih0t6tf4u4k8arna9qt', '2a12:d280:100:51::', 1727075221, '__ci_last_regenerate|i:1727075221;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('547hlqc8rj4dkf6sd84kpqucn87e2k2n', '2a12:d280:100:51::', 1727083741, '__ci_last_regenerate|i:1727083741;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('548git6umeusbsvdvlpkd34qls3ajfkd', '2a12:d280:100:51::', 1727071862, '__ci_last_regenerate|i:1727071862;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('54csp7ob4f42fj6p9fp53dticj5e9u7d', '2a12:d280:100:51::', 1727281621, '__ci_last_regenerate|i:1727281621;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('54epcfv6cc19ira703l1a0rn5nva27c8', '2a12:d280:100:51::', 1727194442, '__ci_last_regenerate|i:1727194441;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('54r0etg4vkdegasounh5pspejs7rh6up', '2a12:d280:100:51::', 1727078642, '__ci_last_regenerate|i:1727078641;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('54v48g7e9hejktg5biehhe6c4f60kb16', '2a12:d280:100:51::', 1727227262, '__ci_last_regenerate|i:1727227262;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('54vpjdpeq73uvtijgnges5vg3ur59tqd', '2a12:d280:100:51::', 1727211002, '__ci_last_regenerate|i:1727211002;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5519r4sm6sohsfbuo3ph7jja8c7v2lsb', '2a12:d280:100:51::', 1727225221, '__ci_last_regenerate|i:1727225221;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('558nkg9k6rvpov3ljr7kdf18bj815m4a', '2a12:d280:100:51::', 1727291522, '__ci_last_regenerate|i:1727291522;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('55e5qasrpu4dnbmgttdik9fgqsq4f19a', '2a12:d280:100:51::', 1727087522, '__ci_last_regenerate|i:1727087522;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('55ou2g1k02iin7k8sclbm7dvcse7r33i', '2a12:d280:100:51::', 1727049121, '__ci_last_regenerate|i:1727049121;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('55pdje1ot7764bj56ilp6niranlb63nc', '2a12:d280:100:51::', 1727098381, '__ci_last_regenerate|i:1727098381;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5650dileim4ffaiu3aqchvohfak6ns59', '2a12:d280:100:51::', 1727219041, '__ci_last_regenerate|i:1727219041;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('56a5uldu79o4oga0kl8cdont8mtll296', '2a12:d280:100:51::', 1727118303, '__ci_last_regenerate|i:1727118301;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('56i7rhhnj4tjlcrdm11j7klm9j09e7en', '2a12:d280:100:51::', 1727120102, '__ci_last_regenerate|i:1727120102;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('576g0gsuo2j79cmvcunnjpsresnmupi8', '2a12:d280:100:51::', 1727122562, '__ci_last_regenerate|i:1727122562;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('57v6tc1ou5k5msdvobmpum29gjqpdnc0', '2a12:d280:100:51::', 1727087582, '__ci_last_regenerate|i:1727087581;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('581a74ujml2a7pnvnssnurqn62eoccm5', '2a12:d280:100:51::', 1727119802, '__ci_last_regenerate|i:1727119802;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5821jee027ba9uf53h79njde2pjdksot', '2a12:d280:100:51::', 1727065621, '__ci_last_regenerate|i:1727065621;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('583q558d6deh6n0sg09dlnisrf1udn62', '2a12:d280:100:51::', 1727080201, '__ci_last_regenerate|i:1727080201;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('58cabm9tdo3cv3b437u9korqoek9ki0d', '2a12:d280:100:51::', 1727231701, '__ci_last_regenerate|i:1727231701;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('58jj2c8rjv281tdcqi8vnlcenfc648h4', '2a12:d280:100:51::', 1727233501, '__ci_last_regenerate|i:1727233501;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('58tes2asq9faf2l305ko9covl40rikco', '2a12:d280:100:51::', 1727185681, '__ci_last_regenerate|i:1727185681;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('591vob65an7kn5h7ivgg9vu9kitcdqra', '2a12:d280:100:51::', 1727235302, '__ci_last_regenerate|i:1727235302;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('592ppit1undeujkfvc4flas2kiup5687', '2a12:d280:100:51::', 1727165762, '__ci_last_regenerate|i:1727165761;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('595muu0b0r8mnfg3rd5im7srqcd7hs3g', '2a12:d280:100:51::', 1727248562, '__ci_last_regenerate|i:1727248562;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('59o8sdknvf2hmb5t05cs8t783dirgv56', '2a12:d280:100:51::', 1727125322, '__ci_last_regenerate|i:1727125322;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('59oeadk8vlr0v7offmglh0ohr1pnpa1u', '2a12:d280:100:51::', 1727192462, '__ci_last_regenerate|i:1727192462;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('59qfr38dvnf4pq1oifhehu4btrrthtfi', '2a12:d280:100:51::', 1727232242, '__ci_last_regenerate|i:1727232242;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('59rdh1ei18liu3gafvqv4pkkkg3223pk', '2a12:d280:100:51::', 1727045042, '__ci_last_regenerate|i:1727045041;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5a9jpsinfluj6n59tcrcm5ae7uks3png', '2a12:d280:100:51::', 1727131621, '__ci_last_regenerate|i:1727131621;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5agh8gs017u63vst6q8aqdhrud2q6u3t', '2a12:d280:100:51::', 1727153402, '__ci_last_regenerate|i:1727153402;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5ahtgeg57veif0jaj93s7edbu859jelq', '2a12:d280:100:51::', 1727126882, '__ci_last_regenerate|i:1727126882;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5aik0lme0vn7s5q0btffmeu93o0f1jld', '2a12:d280:100:51::', 1727171461, '__ci_last_regenerate|i:1727171461;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5anfiud42mu54lf5ip8h4v2kc7irkv99', '2a12:d280:100:51::', 1727094301, '__ci_last_regenerate|i:1727094301;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5b87nffpk32ngn3var2sfpc42dj640q5', '2a12:d280:100:51::', 1727071502, '__ci_last_regenerate|i:1727071502;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5bi1gcrn1chjdu9nlthm7u8qg63ug8if', '2a12:d280:100:51::', 1727148602, '__ci_last_regenerate|i:1727148602;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5bnj5nmmukem1cs6mvkfsjqlp8efjs33', '2a12:d280:100:51::', 1727260141, '__ci_last_regenerate|i:1727260141;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5bs5ctfsiqeknk4snavk8i0cdj3ilk7d', '2a12:d280:100:51::', 1727121842, '__ci_last_regenerate|i:1727121842;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5btst215jd2167c3bn9ctt3e4inkm240', '2a12:d280:100:51::', 1727155321, '__ci_last_regenerate|i:1727155321;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5cg3j3r0jcokbujq0j2051pneed35ufh', '2a12:d280:100:51::', 1727247301, '__ci_last_regenerate|i:1727247301;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5ckvsdspudnbd1t6n5pja93fjuqcf7tj', '2a12:d280:100:51::', 1727289661, '__ci_last_regenerate|i:1727289661;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5cq15ois30vsog90oisq8lkhbuh0jthp', '2a12:d280:100:51::', 1727259962, '__ci_last_regenerate|i:1727259962;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5cvpgl58k3g807beuj17qca1h0gf8ab9', '2a12:d280:100:51::', 1727082841, '__ci_last_regenerate|i:1727082841;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5d396c6ka07j8i92chqgjkbug9cc6k87', '2a12:d280:100:51::', 1727240281, '__ci_last_regenerate|i:1727240281;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5dajrr7pk9p4d8q85cjuu6fr8k99116s', '2a12:d280:100:51::', 1727254981, '__ci_last_regenerate|i:1727254981;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5dee7haau24hs39slregpg4ke99qcc00', '2a12:d280:100:51::', 1727143021, '__ci_last_regenerate|i:1727143021;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5dl919g15nhkfqmh8ec4sd65e88g4i99', '2a12:d280:100:51::', 1727217422, '__ci_last_regenerate|i:1727217422;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5dnl75glur82hp7oi6i31ar8qu9qt5l5', '2a12:d280:100:51::', 1727086861, '__ci_last_regenerate|i:1727086861;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5e86vr9csmlu9k2stct7pcmfg4us3g7f', '2a12:d280:100:51::', 1727103362, '__ci_last_regenerate|i:1727103362;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5f0qpie1eg9l5jrpelmptl5be4tim5vm', '2a12:d280:100:51::', 1727113921, '__ci_last_regenerate|i:1727113921;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5f737fjj3jjgg4v8pnk8luo9594a3n7j', '2a12:d280:100:51::', 1727253361, '__ci_last_regenerate|i:1727253361;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5fdsjif6c54c019h24vdarqv68qf4ta9', '2a12:d280:100:51::', 1727174882, '__ci_last_regenerate|i:1727174882;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5fn0r34bu47m6vdsrghklb12kkhk5pp0', '2a12:d280:100:51::', 1727260202, '__ci_last_regenerate|i:1727260202;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5fpsac6uh30jfg2i7gugolvul50ddog5', '2a12:d280:100:51::', 1727088362, '__ci_last_regenerate|i:1727088362;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5fqf9qqd9oe66ij8lmc97tksq6g2lnoq', '2a12:d280:100:51::', 1727238422, '__ci_last_regenerate|i:1727238422;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5fvlih0kg6fabfkjobu6o4qk6ajeoh15', '2a12:d280:100:51::', 1727132161, '__ci_last_regenerate|i:1727132161;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5g5pmjb6037ujpd3gsgm5ed7rtma2q2r', '2a12:d280:100:51::', 1727073241, '__ci_last_regenerate|i:1727073241;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5g68hh48t4bt4ogmdnegm94nrf2vpldi', '2a12:d280:100:51::', 1727281142, '__ci_last_regenerate|i:1727281142;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5ggav1ahd06un6j0qh8i2iarlot43b7k', '2a12:d280:100:51::', 1727100182, '__ci_last_regenerate|i:1727100182;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5glje374a1ood0f7edhom9vtqe1qu3sg', '2a12:d280:100:51::', 1727172482, '__ci_last_regenerate|i:1727172482;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5gmd8fh7j383iu8n3a2c717vh5rcajcc', '2a12:d280:100:51::', 1727163962, '__ci_last_regenerate|i:1727163962;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5gs23v7id1lmkmu0kbnb8ja9d2u2h307', '2a12:d280:100:51::', 1727130002, '__ci_last_regenerate|i:1727130002;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5h3081934hefoqjftnp01dqncqop6mt5', '2a12:d280:100:51::', 1727045582, '__ci_last_regenerate|i:1727045582;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5hmc44gksafcvnjacekdca2gjcfe0bpr', '2a12:d280:100:51::', 1727067001, '__ci_last_regenerate|i:1727067001;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5hqfiiast22l6vv5493frt54baqd6295', '2a12:d280:100:51::', 1727193002, '__ci_last_regenerate|i:1727193002;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5i321ru1o82a2mnuues270g9v552gpb6', '2a12:d280:100:51::', 1727097361, '__ci_last_regenerate|i:1727097361;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5icpl3s579hk3bmmn072hdb7uu3uv9t2', '2a12:d280:100:51::', 1727294942, '__ci_last_regenerate|i:1727294942;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5imb5butsm57tj0k7lb87r5qp45rs0mj', '2a12:d280:100:51::', 1727104261, '__ci_last_regenerate|i:1727104261;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5j096e65hrll4a3jtkgbf1h75as4kg10', '2a12:d280:100:51::', 1727115242, '__ci_last_regenerate|i:1727115242;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5j8kv34artpeanoiudero9bvm3772l1m', '2a12:d280:100:51::', 1727189821, '__ci_last_regenerate|i:1727189821;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5j97lbu0s92gus4ikalf4froe591ton1', '2a12:d280:100:51::', 1727279701, '__ci_last_regenerate|i:1727279701;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5jd9j9vbnte5dgpr47fudh23qtom9s3k', '2a12:d280:100:51::', 1727249702, '__ci_last_regenerate|i:1727249702;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5je9oai09sc7qr928evkk95da043j3ae', '2a12:d280:100:51::', 1727281562, '__ci_last_regenerate|i:1727281562;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5jf7ch74crbi0sqka82pt2n3vp6e3ss3', '2a12:d280:100:51::', 1727205781, '__ci_last_regenerate|i:1727205781;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5k04hvob5bobhpn3ntrgqch3mesdveq7', '2a12:d280:100:51::', 1727093042, '__ci_last_regenerate|i:1727093042;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5ko0id0gb163jv8632bqspdccvrcq6m8', '2a12:d280:100:51::', 1727269142, '__ci_last_regenerate|i:1727269142;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5kuminvfcq1a6o9gla8p0n73mjhn3bkv', '2a12:d280:100:51::', 1727139301, '__ci_last_regenerate|i:1727139301;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5l4sa9rmj5ar0d85d949bhs2delbq1d2', '2a12:d280:100:51::', 1727230561, '__ci_last_regenerate|i:1727230561;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5l5m4qmrq1eoq1psk0no44nt6n1hhec0', '2a12:d280:100:51::', 1727196662, '__ci_last_regenerate|i:1727196662;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5l71sbusocsepd1fen3st7h7iikb5mh5', '2a12:d280:100:51::', 1727205842, '__ci_last_regenerate|i:1727205842;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5lbra0m1ghppff9rk25tp494r7kn49mg', '2a12:d280:100:51::', 1727284742, '__ci_last_regenerate|i:1727284742;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5ldqounuk3b40nkgcmq4glru8jou2gc5', '2a12:d280:100:51::', 1727237882, '__ci_last_regenerate|i:1727237882;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5m4vtnst1t3cdma4uv9qta2nk49up78p', '2a12:d280:100:51::', 1727274841, '__ci_last_regenerate|i:1727274841;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5mdrhmu14g9oj0ls949shhicdp35s2tn', '2a12:d280:100:51::', 1727189521, '__ci_last_regenerate|i:1727189521;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5mfrtq3r26pbenbkcmvm8ead8urpk10u', '2a12:d280:100:51::', 1727273162, '__ci_last_regenerate|i:1727273162;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5mi1nbhnthiu7h5otpj44mnb8vel1idk', '2a12:d280:100:51::', 1727048521, '__ci_last_regenerate|i:1727048521;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5mihl3muuo7tm1g100ujh3bfrt0l4vcf', '192.145.39.244', 1727114195, '__ci_last_regenerate|i:1727114194;_prev_url|s:49:\"https://panel.blitconcept.es/admin/authentication\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5mqrhoehn0rnualb4s768k9sh3cjqo9j', '2a12:d280:100:51::', 1727163421, '__ci_last_regenerate|i:1727163421;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5n1otc75lps0346na0e9iephfeomqo0i', '2a12:d280:100:51::', 1727270341, '__ci_last_regenerate|i:1727270341;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5n3djirnglf0tmf6d0vt0fsu9h9ll8j1', '2a12:d280:100:51::', 1727222281, '__ci_last_regenerate|i:1727222281;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5n4hunfs1dgrefm4ja8emgctenfd39ge', '2a12:d280:100:51::', 1727095982, '__ci_last_regenerate|i:1727095982;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5nec6jn5m393vaol87r4c6q2np171n1c', '2a12:d280:100:51::', 1727113862, '__ci_last_regenerate|i:1727113862;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5nh49pdmi3kl8b2qd8mmc2hcls93dpv3', '2a12:d280:100:51::', 1727178122, '__ci_last_regenerate|i:1727178122;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5nja7s1cu3136dvokjgfdj2sfmsurl4m', '2a12:d280:100:51::', 1727048041, '__ci_last_regenerate|i:1727048041;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5njt3e82qvq03lohbjmoes9una0fa97t', '2a12:d280:100:51::', 1727248741, '__ci_last_regenerate|i:1727248741;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5nn6gnkdie9grlfhdvv4vq65tdaip6n8', '2a12:d280:100:51::', 1727168941, '__ci_last_regenerate|i:1727168941;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5npce7b3hu5t6b5noeohv22om63oki1b', '2a12:d280:100:51::', 1727065142, '__ci_last_regenerate|i:1727065141;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5npvmgu6cnjr8uijf23eqibfl41su5se', '2a12:d280:100:51::', 1727179922, '__ci_last_regenerate|i:1727179922;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5nrt5168d84cpbms4fc3fkuhui54k2e0', '2a12:d280:100:51::', 1727134081, '__ci_last_regenerate|i:1727134081;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5ns52m63a4hkj2jt08mhcg9itin2cbln', '2a12:d280:100:51::', 1727192282, '__ci_last_regenerate|i:1727192282;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5o9sobtkokk2mtmi6eqf81vbqbgrd0je', '2a12:d280:100:51::', 1727278141, '__ci_last_regenerate|i:1727278141;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5oc5c0oiqcni64fc6ulaqj9jtv6qh8ef', '2a12:d280:100:51::', 1727267522, '__ci_last_regenerate|i:1727267522;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5p67f1pecoq2to587kkv9thnth1k2f4o', '2a12:d280:100:51::', 1727107441, '__ci_last_regenerate|i:1727107441;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5p6j6flccd4unqbm6hm93cpfrpvvgnbm', '2a12:d280:100:51::', 1727162762, '__ci_last_regenerate|i:1727162761;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5p7qflhbturuee219353s3sj383epu7a', '2a12:d280:100:51::', 1727179562, '__ci_last_regenerate|i:1727179562;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5pcj60acekokb6k0a0dh7rgk44hantrg', '192.145.39.244', 1727116696, '__ci_last_regenerate|i:1727116654;_prev_url|s:47:\"https://panel.blitconcept.es/admin/staff/member\";staff_user_id|s:1:\"1\";staff_logged_in|b:1;setup-menu-open|b:1;');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5pcsgiou0beeka5hqscm36d2phbq2c5c', '2a12:d280:100:51::', 1727175902, '__ci_last_regenerate|i:1727175902;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5pejc7tcfn9lsbsj2tmfafm47td6f6ea', '2a12:d280:100:51::', 1727233681, '__ci_last_regenerate|i:1727233681;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5pm7kcdrms5gap10p1mvf5q7ik53qd5q', '2a12:d280:100:51::', 1727276642, '__ci_last_regenerate|i:1727276642;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5ppc8dv9eom10f4m66gv0v11rv1ikb2r', '2a12:d280:100:51::', 1727250781, '__ci_last_regenerate|i:1727250781;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5ptrpv4gfkv2gqnctb9gobji4pbvhava', '2a12:d280:100:51::', 1727113562, '__ci_last_regenerate|i:1727113562;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5puomskfindq856haed878isdbqd2ho2', '2a12:d280:100:51::', 1727161141, '__ci_last_regenerate|i:1727161141;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5qb7cris81um6sdmog6ol8oq4l99etso', '2a12:d280:100:51::', 1727239442, '__ci_last_regenerate|i:1727239442;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5qii8qou0b0rftr8t9m57jfbbm5c47so', '2a12:d280:100:51::', 1727195882, '__ci_last_regenerate|i:1727195882;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5qpclqkmk4tg8e6juca1p1cqhjhjj2fr', '2a12:d280:100:51::', 1727217061, '__ci_last_regenerate|i:1727217061;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5qqi3m95otq5l6o1mlk0ta526fcvjerm', '2a12:d280:100:51::', 1727096221, '__ci_last_regenerate|i:1727096221;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5quc60h834p82pki7r99dvpkikt3g15l', '2a12:d280:100:51::', 1727208841, '__ci_last_regenerate|i:1727208841;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5s4mui09m992ttaabn2i0699ppd785a2', '2a12:d280:100:51::', 1727099762, '__ci_last_regenerate|i:1727099761;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5srjc04febckuuced7ab3sj1mn4cts51', '2a12:d280:100:51::', 1727121421, '__ci_last_regenerate|i:1727121421;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5t0tepf9o7tb96vdjokjikp25qkhjm7u', '2a12:d280:100:51::', 1727234941, '__ci_last_regenerate|i:1727234941;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5t4f9h7jqfrbv8bf9dtivhs9uj452ro2', '2a12:d280:100:51::', 1727190002, '__ci_last_regenerate|i:1727190002;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5u49nk2mrnsct7vsj9jfh2qfa4ek49ue', '2a12:d280:100:51::', 1727157181, '__ci_last_regenerate|i:1727157181;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5um07h01isu38ihdb9jkaa2djh7243ob', '2a12:d280:100:51::', 1727118002, '__ci_last_regenerate|i:1727118002;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5uo7hq2ojb0vtu3obvqf8tmfbkm613mt', '2a12:d280:100:51::', 1727087041, '__ci_last_regenerate|i:1727087041;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5v6p8pqbdrb2nccrbartgh9c81abg8dd', '2a12:d280:100:51::', 1727223481, '__ci_last_regenerate|i:1727223481;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5vba3h6rer3fft3db0pc4bjvd99u5ohh', '2a12:d280:100:51::', 1727287502, '__ci_last_regenerate|i:1727287501;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5vf3b4p7nl9bupds5o7jma339vaj5sss', '2a12:d280:100:51::', 1727135281, '__ci_last_regenerate|i:1727135281;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5vgarf5n8g5q8matdafsr6slhsvrcs4o', '2a12:d280:100:51::', 1727264341, '__ci_last_regenerate|i:1727264341;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5vlrsamni05ussgr16fqn9q0r1077l67', '2a12:d280:100:51::', 1727045521, '__ci_last_regenerate|i:1727045521;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5vrr4qfuenk5ieufh9eji7ruf73jt3n6', '2a12:d280:100:51::', 1727110621, '__ci_last_regenerate|i:1727110621;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('602nccpkjm9o0cjs64e7c6a678a60ke0', '2a12:d280:100:51::', 1727051522, '__ci_last_regenerate|i:1727051522;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('605qsrqhlquff8j23e75b0vpp3fqarq7', '2a12:d280:100:51::', 1727172842, '__ci_last_regenerate|i:1727172842;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('609an2bncf6i7hubi9g53il4k1b3909e', '2a12:d280:100:51::', 1727155081, '__ci_last_regenerate|i:1727155081;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('609od234gk2bcns44flha7n1h2pjs357', '2a12:d280:100:51::', 1727235781, '__ci_last_regenerate|i:1727235781;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('60eo2ea9s9ng81fli8ng29gsqc7h3vai', '2a12:d280:100:51::', 1727067541, '__ci_last_regenerate|i:1727067541;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('60jvg2a9hcervva49pdq7928irfg86kg', '2a12:d280:100:51::', 1727118662, '__ci_last_regenerate|i:1727118662;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('60pkt958nkfh4mrmgcdqcnmpdg615hc8', '2a12:d280:100:51::', 1727078821, '__ci_last_regenerate|i:1727078821;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('60qeoe4s5qrvhambjq97s9mv3hoskugo', '2a12:d280:100:51::', 1727105762, '__ci_last_regenerate|i:1727105762;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('617vd8cu31qgf9amrpsbd0f9lhurulsk', '2a12:d280:100:51::', 1727181121, '__ci_last_regenerate|i:1727181121;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('61aecaarejfs7h3b9mvq1nocs8mstfrs', '2a12:d280:100:51::', 1727283542, '__ci_last_regenerate|i:1727283542;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('61g1sp87guetu3isbb2is96hrt40imfu', '2a12:d280:100:51::', 1727270041, '__ci_last_regenerate|i:1727270041;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('61j8ivecfkur454mvocbd44jii84olf0', '2a12:d280:100:51::', 1727044981, '__ci_last_regenerate|i:1727044981;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('61lk4rkjmhmibmku714u13rtgjplrtvu', '2a12:d280:100:51::', 1727069642, '__ci_last_regenerate|i:1727069642;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('61makt4ro6hieebtts0tdcnd6heuofpt', '2a12:d280:100:51::', 1727294762, '__ci_last_regenerate|i:1727294762;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('61o1k7tjiuigqqbmfdkjnsrlkncjsn21', '2a12:d280:100:51::', 1727086202, '__ci_last_regenerate|i:1727086202;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('61qliuhk3q9815dhl5tsen1991oh9a0m', '2a12:d280:100:51::', 1727232061, '__ci_last_regenerate|i:1727232061;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('62435ka8jn1eur3q8jsd63aekjdcsqog', '2a12:d280:100:51::', 1727237042, '__ci_last_regenerate|i:1727237042;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('626gnorj3kcd4cpacbj7o7hmknj0e08a', '2a12:d280:100:51::', 1727191862, '__ci_last_regenerate|i:1727191862;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('62bpinhvq3lv54b60llkh254dar2bjl6', '2a12:d280:100:51::', 1727165882, '__ci_last_regenerate|i:1727165882;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('62daerffl5kavg07phm9q30dfgkj9i9t', '2a12:d280:100:51::', 1727093941, '__ci_last_regenerate|i:1727093941;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('62eqo19vck6kn2c3o78dp9e6p82pr5du', '2a12:d280:100:51::', 1727127661, '__ci_last_regenerate|i:1727127661;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('62ha45jvbpjd1s0rm5al22lhn05cmue9', '2a12:d280:100:51::', 1727290142, '__ci_last_regenerate|i:1727290142;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('63dttnjnu1q8t1siqkqr1d6o1vo13lv1', '2a12:d280:100:51::', 1727288641, '__ci_last_regenerate|i:1727288641;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('63jlpn8c14pjekf2kr9tuqq2cpjkm786', '2a12:d280:100:51::', 1727254562, '__ci_last_regenerate|i:1727254562;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('63mh9nkprqc7kcsmga5nv88uhpgko3bp', '2a12:d280:100:51::', 1727186941, '__ci_last_regenerate|i:1727186941;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('63tolvsgh4j17799uboerm55t290ier9', '2a12:d280:100:51::', 1727149621, '__ci_last_regenerate|i:1727149621;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('63vt5bbeepm99m9m2quqli04svqc5486', '2a12:d280:100:51::', 1727179502, '__ci_last_regenerate|i:1727179502;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('64594623fm82c0ec1nmh6al9f02973ka', '2a12:d280:100:51::', 1727156641, '__ci_last_regenerate|i:1727156641;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('647si3ou9o80o5ftt8llrjlnt0kcnu2k', '2a12:d280:100:51::', 1727089021, '__ci_last_regenerate|i:1727089021;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('64e06dsbbdrh920a4fau757ul8fb63o5', '2a12:d280:100:51::', 1727230862, '__ci_last_regenerate|i:1727230862;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('64kkep43s4sjpcbq1umtevrsuji214de', '2a12:d280:100:51::', 1727199242, '__ci_last_regenerate|i:1727199242;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('650gvjns9tm2n15o9t8kkmfthag0bqv7', '2a12:d280:100:51::', 1727185381, '__ci_last_regenerate|i:1727185381;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('65391m70q2vvd5q0m51gk02219po2j8o', '2a12:d280:100:51::', 1727114822, '__ci_last_regenerate|i:1727114822;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('658b4t5rh907ju15g6fhtko47dnsrush', '2a12:d280:100:51::', 1727190542, '__ci_last_regenerate|i:1727190542;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('65alu1k3kr7coctb3am1ntslhjo6onpu', '2a12:d280:100:51::', 1727124842, '__ci_last_regenerate|i:1727124842;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('65s6qdsu5t20334mdc272e1e3vbtetqc', '2a12:d280:100:51::', 1727218622, '__ci_last_regenerate|i:1727218622;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('662462c471mt236ebgocdeojjqvus690', '2a12:d280:100:51::', 1727217482, '__ci_last_regenerate|i:1727217481;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('662r03uit2d5q6b63n6iccr9kftcv2g0', '2a12:d280:100:51::', 1727262002, '__ci_last_regenerate|i:1727262002;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('66cerbb6sul042nvqrs6spcsg40hher3', '2a12:d280:100:51::', 1727045462, '__ci_last_regenerate|i:1727045462;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('66gg135j0hnrj747mes4bismc52s3rft', '2a12:d280:100:51::', 1727106181, '__ci_last_regenerate|i:1727106181;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('66hl6dsa94eu165iicctssk269qs7tpn', '2a12:d280:100:51::', 1727075461, '__ci_last_regenerate|i:1727075461;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('66jmdbrs2eem3ja7eoo8cgkcaehvd6f2', '2a12:d280:100:51::', 1727264282, '__ci_last_regenerate|i:1727264282;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('66k1mj6gf331gjt7bnli2uefe09q8g2l', '2a12:d280:100:51::', 1727095442, '__ci_last_regenerate|i:1727095442;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('66rq858uoi8e3v0tikek8neaen1ptsn7', '2a12:d280:100:51::', 1727213821, '__ci_last_regenerate|i:1727213821;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('677em7lrgisdpoutug78eg1rjp83s2s4', '2a12:d280:100:51::', 1727055962, '__ci_last_regenerate|i:1727055961;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('678k2433s29d303f9qho7jofq5ls37hf', '2a12:d280:100:51::', 1727175122, '__ci_last_regenerate|i:1727175122;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('679tvir9r5keg4ssq0fdjc8u1othg87b', '2a12:d280:100:51::', 1727053202, '__ci_last_regenerate|i:1727053202;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('67dblgj4akqoalmbi8qmhophumfvou9i', '2a12:d280:100:51::', 1727174821, '__ci_last_regenerate|i:1727174821;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('67i9lhobrff62dap16l3s44tklh8dtt3', '2a12:d280:100:51::', 1727175301, '__ci_last_regenerate|i:1727175301;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('67mpusphpqmch1ikiomcca7qvu3vn9f0', '2a12:d280:100:51::', 1727167802, '__ci_last_regenerate|i:1727167802;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('67rrmd228248hrrftf429jrn229ff6hg', '2a12:d280:100:51::', 1727107681, '__ci_last_regenerate|i:1727107681;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6832808ts19v6ppm3ledcmovcjk1651h', '2a12:d280:100:51::', 1727100841, '__ci_last_regenerate|i:1727100841;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('683ph7kg1ikhai78eq9d6k58iqpqrt4s', '2a12:d280:100:51::', 1727228881, '__ci_last_regenerate|i:1727228881;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('68evqsl5i6u4rhd0uvei6vueqo8br8tm', '2a12:d280:100:51::', 1727163722, '__ci_last_regenerate|i:1727163722;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('68fll2nq54s6m8o8lhcmctipokk3h97b', '2a12:d280:100:51::', 1727151001, '__ci_last_regenerate|i:1727151001;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('68jjnrakfj7816b6qid0k5oqjbj8rpc4', '2a12:d280:100:51::', 1727127242, '__ci_last_regenerate|i:1727127242;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('69206fo6ic268k79u58m39ovnumpeap5', '2a12:d280:100:51::', 1727291821, '__ci_last_regenerate|i:1727291821;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('69iagu1gt9096ur1p1ovs9qntu9fio2l', '2a12:d280:100:51::', 1727215321, '__ci_last_regenerate|i:1727215321;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('69nhotrd607pig1sljv04ubo5pefls9e', '2a12:d280:100:51::', 1727204821, '__ci_last_regenerate|i:1727204821;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('69ttf7mqqdnp6id5bmmvljn9nsprnjrc', '2a12:d280:100:51::', 1727199721, '__ci_last_regenerate|i:1727199721;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6a0av4cb7ovmedvv5273nuidf68o2ac3', '2a12:d280:100:51::', 1727223541, '__ci_last_regenerate|i:1727223541;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6a86cn9v0g13qvurhc7el0ou2p5fe88f', '2a12:d280:100:51::', 1727198102, '__ci_last_regenerate|i:1727198102;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6alt7hdpo0q4c70o596j4k35barnr09s', '2a12:d280:100:51::', 1727162642, '__ci_last_regenerate|i:1727162642;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6ao5p3mfkd9os8k5aeecslto1gjsh5n6', '2a12:d280:100:51::', 1727171101, '__ci_last_regenerate|i:1727171101;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6arkhc3oni01gkv96m848oj1sqpq26d8', '2a12:d280:100:51::', 1727141341, '__ci_last_regenerate|i:1727141341;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6asn7366mavvlr5v9p33bmdoebjhdqfb', '2a12:d280:100:51::', 1727163061, '__ci_last_regenerate|i:1727163061;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6b0r9bfsmmaotuk7tg9qineuocv43lhf', '2a12:d280:100:51::', 1727271122, '__ci_last_regenerate|i:1727271122;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6b21btqdp08mq83cai4c397fjdo89uu0', '2a12:d280:100:51::', 1727139962, '__ci_last_regenerate|i:1727139962;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6b87ire7ajli3loe795ei2o4ilttd2ro', '2a12:d280:100:51::', 1727198821, '__ci_last_regenerate|i:1727198821;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6b95sk6giggshpje9ma6amj6b5cqikfk', '2a12:d280:100:51::', 1727264521, '__ci_last_regenerate|i:1727264521;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6c8bcionbcjqtnu29soph5jcee666elh', '2a12:d280:100:51::', 1727149022, '__ci_last_regenerate|i:1727149022;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6d10pbccd8703lb89lvujc0ptisqt5os', '2a12:d280:100:51::', 1727192042, '__ci_last_regenerate|i:1727192042;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6d2mok6tirffpfn9onaifa6co9hur4ed', '2a12:d280:100:51::', 1727251921, '__ci_last_regenerate|i:1727251921;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6daredso7io76l9b04tfkdccjdndsbr8', '2a12:d280:100:51::', 1727106001, '__ci_last_regenerate|i:1727106001;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6dsrs7f7grnf4fjb80bl2lafg1jgusat', '2a12:d280:100:51::', 1727277361, '__ci_last_regenerate|i:1727277361;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6e5co8ers7fo27d1cs0cd0i62037ojp2', '2a12:d280:100:51::', 1727278321, '__ci_last_regenerate|i:1727278321;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6ejslkgn04ur58fhhcstd4ukjfnrlprp', '2a12:d280:100:51::', 1727281021, '__ci_last_regenerate|i:1727281021;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6espgj00qktboe2ec9a394ajlhdr3962', '2a12:d280:100:51::', 1727204762, '__ci_last_regenerate|i:1727204761;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6f37116is6od0qrqnsvesvs3le700fq1', '2a12:d280:100:51::', 1727268661, '__ci_last_regenerate|i:1727268661;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6f55mj6vlgnfkigr8q3v0rougi71c4bj', '2a12:d280:100:51::', 1727069222, '__ci_last_regenerate|i:1727069222;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6fad9747pc7m209rvokh2m0evonff1hi', '2a12:d280:100:51::', 1727217781, '__ci_last_regenerate|i:1727217781;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6fapisac70vdg1rfbej84gugmofa5l1l', '2a12:d280:100:51::', 1727292601, '__ci_last_regenerate|i:1727292601;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6fjspgbd64nlh8hhhi54cifeasud662p', '2a12:d280:100:51::', 1727277541, '__ci_last_regenerate|i:1727277541;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6fot3nlc2vc4s16knjeegbqbbabun5v7', '2a12:d280:100:51::', 1727258341, '__ci_last_regenerate|i:1727258341;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6fp198b5147geiugovf62druoe9k6pmc', '2a12:d280:100:51::', 1727174521, '__ci_last_regenerate|i:1727174521;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6g0l7e7imct7a8ejmnsmjgunvl3v5bss', '2a12:d280:100:51::', 1727263022, '__ci_last_regenerate|i:1727263022;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6g309bluvb9ru14n70ds5filpe4kk7tk', '2a12:d280:100:51::', 1727271302, '__ci_last_regenerate|i:1727271302;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6gh6fjnt8tavl0ptias6r4l84q1s61va', '2a12:d280:100:51::', 1727170082, '__ci_last_regenerate|i:1727170082;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6gruum47toc39rlu6o1gpopl4ct2m1q1', '2a12:d280:100:51::', 1727169422, '__ci_last_regenerate|i:1727169422;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6i3dn7cr4h3141bgk7bt18ukj7uqe7eo', '2a12:d280:100:51::', 1727293321, '__ci_last_regenerate|i:1727293321;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6i7hciglk0ja4fbholrshrv7semeaht9', '2a12:d280:100:51::', 1727106481, '__ci_last_regenerate|i:1727106481;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6ia83p0fs6v3kemnvugff7t89t1vkto6', '2a12:d280:100:51::', 1727234641, '__ci_last_regenerate|i:1727234641;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6ifpaof6pouj7q5b5cj2r6sreej3n6au', '2a12:d280:100:51::', 1727169302, '__ci_last_regenerate|i:1727169302;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6ioci313fmii1htiu6hr5vp4f6iraodb', '2a12:d280:100:51::', 1727094781, '__ci_last_regenerate|i:1727094781;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6iop3r86bad517st03b1ut7ka6s8cmk0', '2a12:d280:100:51::', 1727049482, '__ci_last_regenerate|i:1727049482;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6ipkd74b8qkq36tafj7l546kru9tsfp7', '2a12:d280:100:51::', 1727279221, '__ci_last_regenerate|i:1727279221;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6irentbifmpkpbl5n9t5qadol76sj6ns', '2a12:d280:100:51::', 1727177342, '__ci_last_regenerate|i:1727177342;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6j9v1g1d10vgfdpl9tmm65k4mdae89d7', '2a12:d280:100:51::', 1727079541, '__ci_last_regenerate|i:1727079541;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6jt3s4sd2ef7uekhrj4lsi0cs7ckac76', '2a12:d280:100:51::', 1727292841, '__ci_last_regenerate|i:1727292841;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6jv0dt8rc625ft5ev3gdi0pi9me0ilnf', '2a12:d280:100:51::', 1727245261, '__ci_last_regenerate|i:1727245261;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6k6dad1rkgh2du2d0c1ivpv0d5073plc', '2a12:d280:100:51::', 1727288702, '__ci_last_regenerate|i:1727288701;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6k6u444m7me3ipb0tpvg7b18rifhlohh', '2a12:d280:100:51::', 1727285642, '__ci_last_regenerate|i:1727285642;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6kd8c601l9vn616ml94nh8teduqrpbvs', '2a12:d280:100:51::', 1727104622, '__ci_last_regenerate|i:1727104622;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6kr2p2e9pq1sq4jpg9l6g8s39m4i8u96', '2a12:d280:100:51::', 1727272502, '__ci_last_regenerate|i:1727272502;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6l6f2en4sta3iekvs062neqg5u5rhjq4', '2a12:d280:100:51::', 1727132762, '__ci_last_regenerate|i:1727132762;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6leco87dv30a2kphgsqqfksd0okcnnmb', '2a12:d280:100:51::', 1727214061, '__ci_last_regenerate|i:1727214061;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6lhjqve8momnkrmkc5r81qani2ce9kvs', '2a12:d280:100:51::', 1727241421, '__ci_last_regenerate|i:1727241421;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6lqdh7dhu8k2r710sc2bl8khr4g1rc3g', '2a12:d280:100:51::', 1727266021, '__ci_last_regenerate|i:1727266021;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6lqmbotin521o9hnkkadqc7a8rr9doak', '2a12:d280:100:51::', 1727092021, '__ci_last_regenerate|i:1727092021;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6lsq81cd8aggi6flbnm975geg97idadc', '2a12:d280:100:51::', 1727054881, '__ci_last_regenerate|i:1727054881;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6mh1l1ovqbatj2gkfir95kfauglrpn5d', '2a12:d280:100:51::', 1727270461, '__ci_last_regenerate|i:1727270461;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6mhsqjnjok10pme6vm27qi18mdoqf15k', '2a12:d280:100:51::', 1727054641, '__ci_last_regenerate|i:1727054641;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6mj6k9sie0eveq90l8833vkvqklt3dpa', '2a12:d280:100:51::', 1727128082, '__ci_last_regenerate|i:1727128082;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6mqb8q9r59ofglu6f16b72f4mdur1fmn', '2a12:d280:100:51::', 1727090402, '__ci_last_regenerate|i:1727090401;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6mv4pd5jffq35pm3mevqimp3bmghs2ia', '2a12:d280:100:51::', 1727265602, '__ci_last_regenerate|i:1727265602;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6mvg155f6mmerdm5tqg2phpju83s6bp2', '2a12:d280:100:51::', 1727286961, '__ci_last_regenerate|i:1727286961;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6mvpcohvessgju553985as991fhgd57t', '2a12:d280:100:51::', 1727293022, '__ci_last_regenerate|i:1727293022;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6n4us465ei5d0u4sta0o0uak0rsnraof', '2a12:d280:100:51::', 1727075941, '__ci_last_regenerate|i:1727075941;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6n6cq0auf1v9p3btn965b9ana6drta9v', '2a12:d280:100:51::', 1727214721, '__ci_last_regenerate|i:1727214721;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6n7gkkkj7i732lrm1q987st2f3e3n5di', '2a12:d280:100:51::', 1727194021, '__ci_last_regenerate|i:1727194021;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6nf74srmnscqna7eeh2n76b1pp4fm4r0', '2a12:d280:100:51::', 1727060941, '__ci_last_regenerate|i:1727060941;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6nfqpsd3s559d9a3t38vv4mt9v8aimet', '2a12:d280:100:51::', 1727243101, '__ci_last_regenerate|i:1727243101;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6o7ibv76qtm500051afudmpfouscl96h', '2a12:d280:100:51::', 1727068861, '__ci_last_regenerate|i:1727068861;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6od10buvcig1grt86g8hkjaj88rmijj6', '2a12:d280:100:51::', 1727092261, '__ci_last_regenerate|i:1727092261;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6okvts8qkso51dppf09o34fqrbe1ttm2', '2a12:d280:100:51::', 1727282761, '__ci_last_regenerate|i:1727282761;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6p2euania2t5ua95ls6udjbfh5rf19di', '2a12:d280:100:51::', 1727129702, '__ci_last_regenerate|i:1727129702;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6p76pcgopctkhj5s1tfgbghbbska4m6q', '2a12:d280:100:51::', 1727231102, '__ci_last_regenerate|i:1727231102;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6pkrn0099b8r1asovq66i9d5g08n1sqo', '2a12:d280:100:51::', 1727066281, '__ci_last_regenerate|i:1727066281;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6poftp8vovfmkif4jui9573pnc5l8cho', '2a12:d280:100:51::', 1727129882, '__ci_last_regenerate|i:1727129882;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6q6fg83tm0urf4oka3m2u3qjkjr027ee', '2a12:d280:100:51::', 1727275022, '__ci_last_regenerate|i:1727275022;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6q7mppu8f8cm6odlffp3o91248eksd28', '2a12:d280:100:51::', 1727273762, '__ci_last_regenerate|i:1727273762;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6qc1uj1mppalvvgviiqa8pjalblg6k36', '2a12:d280:100:51::', 1727235062, '__ci_last_regenerate|i:1727235062;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6qcici0eai34jsb71g0b1qve0a966abh', '2a12:d280:100:51::', 1727082602, '__ci_last_regenerate|i:1727082601;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6qjsf5rv65b97gjoa4dujra2nbd4i84h', '2a12:d280:100:51::', 1727049361, '__ci_last_regenerate|i:1727049361;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6ql15n4nucoq07jimnt19n9et13q50i5', '2a12:d280:100:51::', 1727169841, '__ci_last_regenerate|i:1727169841;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6r3ie27lr3gti75kr719oh5kgkbdbmhq', '2a12:d280:100:51::', 1727240581, '__ci_last_regenerate|i:1727240581;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6rj4l10ujjtd7te80l9fl7q5ne5ilu4e', '2a12:d280:100:51::', 1727280602, '__ci_last_regenerate|i:1727280602;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6rts0v56b25stacks380ipi0cdnjrqj5', '2a12:d280:100:51::', 1727111881, '__ci_last_regenerate|i:1727111881;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6sc6k53fv43oumv9rsbp3k3jpjrndm1v', '2a12:d280:100:51::', 1727114162, '__ci_last_regenerate|i:1727114162;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6sfh4r3f92mei6ipqphucmparmuq9oqp', '2a12:d280:100:51::', 1727294462, '__ci_last_regenerate|i:1727294462;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6sj4quq3ip61mbtfm10ihgfmde05i0lp', '2a12:d280:100:51::', 1727187541, '__ci_last_regenerate|i:1727187541;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6snlibsuejiofulb3b12vlehpjc4i1im', '2a12:d280:100:51::', 1727274782, '__ci_last_regenerate|i:1727274782;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6snsg7bmve7ch7thua4pgv5mr617vbsu', '2a12:d280:100:51::', 1727184902, '__ci_last_regenerate|i:1727184902;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6sog0nen2dl38gvaacjkdagi2058rfn7', '2a12:d280:100:51::', 1727063102, '__ci_last_regenerate|i:1727063102;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6sq0c242o88evatuu4hfjnial5bl05of', '2a12:d280:100:51::', 1727071261, '__ci_last_regenerate|i:1727071261;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6stf7fl725c8ihjjk7qv3dpehk80t9n6', '2a12:d280:100:51::', 1727105522, '__ci_last_regenerate|i:1727105522;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6te8iprt3qckamtqvltgfgp9rtbo3h80', '2a12:d280:100:51::', 1727181842, '__ci_last_regenerate|i:1727181842;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6tfvj06j1nncmme400a451bqai6o4o3t', '2a12:d280:100:51::', 1727240222, '__ci_last_regenerate|i:1727240222;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6tlhh7nn8gl29p7a541gfk4s50dls9dv', '2a12:d280:100:51::', 1727124421, '__ci_last_regenerate|i:1727124421;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6tnifsqfjb3leobtf855bfppoqtktr3k', '2a12:d280:100:51::', 1727089381, '__ci_last_regenerate|i:1727089381;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6u1ds9jb81fv97bpq7vvj254ihifgvnv', '2a12:d280:100:51::', 1727244241, '__ci_last_regenerate|i:1727244241;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6ub6psuaqbcnq2j40dqj5753g8jrmg0c', '2a12:d280:100:51::', 1727136421, '__ci_last_regenerate|i:1727136421;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6ub86eblt1suun2a7mc3022ck1fksdqq', '2a12:d280:100:51::', 1727226061, '__ci_last_regenerate|i:1727226061;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6ujun48dij77069apnrrcrvn60mcqo1d', '2a12:d280:100:51::', 1727168642, '__ci_last_regenerate|i:1727168642;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6vjvm79vna3pscg3ml6bh5569kakroti', '2a12:d280:100:51::', 1727192642, '__ci_last_regenerate|i:1727192642;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6vqml9kptaj7q6nj3fjr2ik23jr3gik3', '2a12:d280:100:51::', 1727097481, '__ci_last_regenerate|i:1727097481;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7092oa5q8pn0j7eutcinqdd1mpa9dfs6', '2a12:d280:100:51::', 1727180582, '__ci_last_regenerate|i:1727180582;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('70dup0kcp90cke1hri012fduh9lu9lkh', '2a12:d280:100:51::', 1727049182, '__ci_last_regenerate|i:1727049182;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('70rnjcgmkqo6dlv1m5glmu3bqi28o6lm', '2a12:d280:100:51::', 1727262902, '__ci_last_regenerate|i:1727262901;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('713prq2rg8u8hl3q204vl53l6m8olv8f', '2a12:d280:100:51::', 1727217722, '__ci_last_regenerate|i:1727217722;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('72c26mo949l7mm31ujc0msjm3ihbas9e', '2a12:d280:100:51::', 1727151481, '__ci_last_regenerate|i:1727151481;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('72dmja6v2f5162vsffu26q6dk2edape2', '2a12:d280:100:51::', 1727169542, '__ci_last_regenerate|i:1727169542;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('72fao3ok0t14k3pl1ce9n99f8ea9jskn', '2a12:d280:100:51::', 1727223302, '__ci_last_regenerate|i:1727223302;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('72l5vvgq54tbjbo8k6035b60d9tsf10v', '2a12:d280:100:51::', 1727216282, '__ci_last_regenerate|i:1727216282;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('73842k215p3jv2gdv6584ctiu3hkadr0', '2a12:d280:100:51::', 1727170681, '__ci_last_regenerate|i:1727170681;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('73859rpst5q6o1mnfgoa2ir527bgjqdp', '2a12:d280:100:51::', 1727133181, '__ci_last_regenerate|i:1727133181;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('73kdug9ioopr6spmoofi0ph0ufqghjhu', '2a12:d280:100:51::', 1727097721, '__ci_last_regenerate|i:1727097721;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('73kkfp0e235ufr0kr4mv9gh6fnjmu8qj', '2a12:d280:100:51::', 1727109181, '__ci_last_regenerate|i:1727109181;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('73rd6ogps9tt1sqc50aktpkvmqtr7g9j', '2a12:d280:100:51::', 1727168101, '__ci_last_regenerate|i:1727168101;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('74buk1711mnvg2aiok0ee8h8ra2pspqn', '2a12:d280:100:51::', 1727252402, '__ci_last_regenerate|i:1727252402;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('752a73tjuk01upu0u523o6v3s61349vb', '2a12:d280:100:51::', 1727140681, '__ci_last_regenerate|i:1727140681;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('756a7cjq4ie6e6039kmv9l9js70975r4', '2a12:d280:100:51::', 1727223721, '__ci_last_regenerate|i:1727223721;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('756ofto10427it5mgjilksc5t66jscbj', '2a12:d280:100:51::', 1727144402, '__ci_last_regenerate|i:1727144402;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('75c95kjpfgap3jr2n0j7h1d6h9kcn42j', '2a12:d280:100:51::', 1727139421, '__ci_last_regenerate|i:1727139421;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('75divjlht3iibp2rhgimp3h6k17lcs6l', '2a12:d280:100:51::', 1727231161, '__ci_last_regenerate|i:1727231161;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('75khl26n06mt6ib9l46klkijao80iu3l', '2a12:d280:100:51::', 1727239921, '__ci_last_regenerate|i:1727239921;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('75pbknksm02b8idmpt6525old6h5dntq', '2a12:d280:100:51::', 1727172122, '__ci_last_regenerate|i:1727172122;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('75sq52aok8dndf4vkhdcnovesf7hm0os', '2a12:d280:100:51::', 1727112002, '__ci_last_regenerate|i:1727112001;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('76r5rlc93qs1gqgejiains02sr05mio5', '2a12:d280:100:51::', 1727081641, '__ci_last_regenerate|i:1727081641;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('76sgf0i3svaf07fu4u9fpq926p3njuod', '2a12:d280:100:51::', 1727135522, '__ci_last_regenerate|i:1727135522;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('771ai48hdrm86bkgkpgi7qf7nt8q995h', '2a12:d280:100:51::', 1727157062, '__ci_last_regenerate|i:1727157062;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('777odpov68mc2o7t14b2945e82bkbuc7', '184.72.121.156', 1727249631, '__ci_last_regenerate|i:1727249630;red_url|s:34:\"https://panel.blitconcept.es/admin\";_prev_url|s:49:\"https://panel.blitconcept.es/admin/authentication\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('77dg7vlef58n69vt0r2rjve5l4os2gnb', '2a12:d280:100:51::', 1727267221, '__ci_last_regenerate|i:1727267221;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('77lih4vekee8k2agvgi8se6gvctotup6', '2a12:d280:100:51::', 1727219521, '__ci_last_regenerate|i:1727219521;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7830do0rk4amlscnaj0hffltkbh4cc3j', '2a12:d280:100:51::', 1727196242, '__ci_last_regenerate|i:1727196241;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7830q046hc8u3vc98e77n0j5cbd17075', '2a12:d280:100:51::', 1727061901, '__ci_last_regenerate|i:1727061901;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('785hjb6fi8hg6849kprhnv2plkt2bdr3', '2a12:d280:100:51::', 1727169602, '__ci_last_regenerate|i:1727169602;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('78786d88tus7ctk2j8bqqaj1k0lue32k', '2a12:d280:100:51::', 1727050801, '__ci_last_regenerate|i:1727050801;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('78e6j4spra80df094h6ffh69fqhuu9r5', '2a12:d280:100:51::', 1727067062, '__ci_last_regenerate|i:1727067062;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('78m6e83c0diun6nl96a2ks47dhgjl9r7', '2a12:d280:100:51::', 1727069402, '__ci_last_regenerate|i:1727069401;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('78srrt4ed01ee5can4lcpfgm8jerb3k7', '2a12:d280:100:51::', 1727079002, '__ci_last_regenerate|i:1727079002;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('78tga9ektj0m89238v5cd9i9sftsaq62', '2a12:d280:100:51::', 1727110801, '__ci_last_regenerate|i:1727110801;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('78ti0j8635tjscq3rrkvg3t9bqnk3ep5', '2a12:d280:100:51::', 1727236321, '__ci_last_regenerate|i:1727236321;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('78uhqrpimn36a3ccg5msaslbqv8is97q', '2a12:d280:100:51::', 1727191742, '__ci_last_regenerate|i:1727191742;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('791ll675vqji5uph5ut1rdkji1an3j4k', '2a12:d280:100:51::', 1727176741, '__ci_last_regenerate|i:1727176741;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('795jpn27fh67uvt5oo4u2p318lgck7sl', '2a12:d280:100:51::', 1727195401, '__ci_last_regenerate|i:1727195401;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('79ata1m7lk71amnk8evdpdbp42t7rhdu', '2a12:d280:100:51::', 1727137261, '__ci_last_regenerate|i:1727137261;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('79markheihhbv50aa9rcqbfqsf6hfrph', '2a12:d280:100:51::', 1727235842, '__ci_last_regenerate|i:1727235842;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('79pca845pa4rrcfccsfmvv8mgf7rjglk', '2a12:d280:100:51::', 1727209322, '__ci_last_regenerate|i:1727209321;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('79rssats82nfd053o70f8liosit35tl2', '2a12:d280:100:51::', 1727265961, '__ci_last_regenerate|i:1727265961;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7a4tnv48c3j0d7rn7nd3srpn2fnvpoju', '2a12:d280:100:51::', 1727281442, '__ci_last_regenerate|i:1727281442;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7a6sg78prgmad3lth7cr058c4c1kfskn', '2a12:d280:100:51::', 1727190421, '__ci_last_regenerate|i:1727190421;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7a7riu9kts0hajfnidprcp7jstv7laug', '2a12:d280:100:51::', 1727237821, '__ci_last_regenerate|i:1727237821;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7a9611otsdpajkd7uaisoqd5o3uj2401', '2a12:d280:100:51::', 1727244361, '__ci_last_regenerate|i:1727244361;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7ainmctilih2gcuub4l0dahh8fhb39j8', '2a12:d280:100:51::', 1727134202, '__ci_last_regenerate|i:1727134201;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7am6l03tterlmm1pm3b4qav5kodmavod', '2a12:d280:100:51::', 1727081881, '__ci_last_regenerate|i:1727081881;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7b8cggrnq2cag9336tenbmslc4dl2udp', '2a12:d280:100:51::', 1727119202, '__ci_last_regenerate|i:1727119202;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7bj940alohptlsg4cun5ma3vjtoaato7', '2a12:d280:100:51::', 1727194921, '__ci_last_regenerate|i:1727194921;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7bl8bj8f36m35img4adpfjbe7jrgri1d', '2a12:d280:100:51::', 1727217361, '__ci_last_regenerate|i:1727217361;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7c4mj9qplrsig3lf38m2kdrvtavm9q8g', '2a12:d280:100:51::', 1727228761, '__ci_last_regenerate|i:1727228761;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7cqesd6da6m45qlh17r4l2ous4qbf6gm', '2a12:d280:100:51::', 1727091422, '__ci_last_regenerate|i:1727091422;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7d0gss3r2oqk39aokm69bt54kf2tu40d', '2a12:d280:100:51::', 1727281862, '__ci_last_regenerate|i:1727281862;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7d1g9ssrsnu0u68bsrok55lesl9ne89l', '2a12:d280:100:51::', 1727142122, '__ci_last_regenerate|i:1727142122;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7dj8fesrli5hr5sc2hd2t02oljhrr81p', '2a12:d280:100:51::', 1727290261, '__ci_last_regenerate|i:1727290261;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7dls5o0vn2ogr8u6klqa7rdmkd9vhc37', '2a12:d280:100:51::', 1727128561, '__ci_last_regenerate|i:1727128561;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7drl8mlrj0dfvs5mgehodlq239441k4v', '2a12:d280:100:51::', 1727090881, '__ci_last_regenerate|i:1727090881;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7e6sr4pc7hudkcn5k6faa2ok1l0krsgt', '2a12:d280:100:51::', 1727172901, '__ci_last_regenerate|i:1727172901;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7ec85pha9s01akatos9005oq1romtb4t', '2a12:d280:100:51::', 1727047262, '__ci_last_regenerate|i:1727047262;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7em2ptpjui16qer6iceaj9dcdh3sq9ca', '2a12:d280:100:51::', 1727146981, '__ci_last_regenerate|i:1727146981;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7errrcrnf3d50m2v1nbh4nof0m40hs26', '2a12:d280:100:51::', 1727140741, '__ci_last_regenerate|i:1727140741;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7fech5001caodi2re6or3e8o3toqv4po', '2a12:d280:100:51::', 1727216402, '__ci_last_regenerate|i:1727216402;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7fn5um86ua876p73t1ia5p2026qfcvnp', '2a12:d280:100:51::', 1727121661, '__ci_last_regenerate|i:1727121661;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7fo9eqeuoeub3kujuheracipa331jhk9', '2a12:d280:100:51::', 1727091061, '__ci_last_regenerate|i:1727091061;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7fvs2euja0cq14c73spp39rbnqr56jns', '2a12:d280:100:51::', 1727128861, '__ci_last_regenerate|i:1727128861;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7gdc7j6fb368eq6n7afn4jiqml0rqrla', '2a12:d280:100:51::', 1727154901, '__ci_last_regenerate|i:1727154901;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7h3v1aacca1sk6a2n9t4j0thg0f4u7bl', '2a12:d280:100:51::', 1727250122, '__ci_last_regenerate|i:1727250122;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7h6d55hgirid261jdrq0njsgr2gfth4q', '2a12:d280:100:51::', 1727269802, '__ci_last_regenerate|i:1727269802;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7hd5j850cf1bq9g7vucmd3lo1rs8fp20', '2a12:d280:100:51::', 1727128202, '__ci_last_regenerate|i:1727128201;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7hsd9slc7h7ld8soq4mvq04qbve5gplu', '2a12:d280:100:51::', 1727186222, '__ci_last_regenerate|i:1727186222;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7i6ad57e6np9kq5lvuig0dqkrflai87j', '2a12:d280:100:51::', 1727047021, '__ci_last_regenerate|i:1727047021;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7i99a70bkrs04m57ocrqia5uop5h7dpn', '2a12:d280:100:51::', 1727131801, '__ci_last_regenerate|i:1727131801;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7iaobqen10fdnd26caqt0b9es93ek4u4', '2a12:d280:100:51::', 1727160961, '__ci_last_regenerate|i:1727160961;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7ill020fq4m5m3hmnsvvlpv4o2livu0p', '2a12:d280:100:51::', 1727064602, '__ci_last_regenerate|i:1727064602;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7inodlgh4lvmor6cukdftd57jgq6b9si', '2a12:d280:100:51::', 1727254381, '__ci_last_regenerate|i:1727254381;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7j0bs7c4au5cdu0p7sd1s2nolsg3k95k', '2a12:d280:100:51::', 1727152742, '__ci_last_regenerate|i:1727152742;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7j63jjhrr24id0uu3p24pb0o19idq0bs', '2a12:d280:100:51::', 1727230202, '__ci_last_regenerate|i:1727230202;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7jcheau5fg94rff15v6g8a1aj849e8gq', '2a12:d280:100:51::', 1727074862, '__ci_last_regenerate|i:1727074862;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7jf2duirqbr9g0afvtnmbg7hurclu45d', '2a12:d280:100:51::', 1727152622, '__ci_last_regenerate|i:1727152621;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7jk70tir3h29moge68v8fu81c6759he0', '2a12:d280:100:51::', 1727203682, '__ci_last_regenerate|i:1727203682;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7k3u4q2jbiirth7mdoh70ft6dusajji0', '2a12:d280:100:51::', 1727284921, '__ci_last_regenerate|i:1727284921;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7k4jtqoi3t9qc743hrp7qg6dtb63k2ud', '2a12:d280:100:51::', 1727108942, '__ci_last_regenerate|i:1727108942;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7k7omdq6s6m8tkd0c3761272ufi6lgti', '2a12:d280:100:51::', 1727064361, '__ci_last_regenerate|i:1727064361;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7kmv3v0u7jd418f2p5t1q1sler4903hs', '2a12:d280:100:51::', 1727062562, '__ci_last_regenerate|i:1727062562;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7ks4klteo63mgej238fv94kloit74sst', '2a12:d280:100:51::', 1727194621, '__ci_last_regenerate|i:1727194621;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7kv4pg9phh5ms6gjdlfc60mv5fbpu48l', '2a12:d280:100:51::', 1727225942, '__ci_last_regenerate|i:1727225942;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7lectuskh14cfhp46hda22ig7c6lq76n', '2a12:d280:100:51::', 1727130302, '__ci_last_regenerate|i:1727130302;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7lg656sdhpfc4s4bd2rqp93l6toc7ejb', '2a12:d280:100:51::', 1727112542, '__ci_last_regenerate|i:1727112542;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7lqhqs55gcebp8id61m2383g6l1g6u1l', '2a12:d280:100:51::', 1727107801, '__ci_last_regenerate|i:1727107801;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7m1etsk6jhseojojqccf5j5gbkuth6t1', '2a12:d280:100:51::', 1727260621, '__ci_last_regenerate|i:1727260621;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7m44khr2cb1h2ed36cta2guba6vuclpc', '2a12:d280:100:51::', 1727157362, '__ci_last_regenerate|i:1727157362;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7m84qb4ga60sprknoaidui2h2o1m2e00', '2a12:d280:100:51::', 1727153221, '__ci_last_regenerate|i:1727153221;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7mdi7cu1190dnachcvk3k0nl0teb6fbm', '2a12:d280:100:51::', 1727117401, '__ci_last_regenerate|i:1727117401;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7nhgg8pvqgtff34pihtedtf2l3f68ejh', '2a12:d280:100:51::', 1727111222, '__ci_last_regenerate|i:1727111222;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7ni4emie2es1an61g82opi9tfnveojlb', '2a12:d280:100:51::', 1727250241, '__ci_last_regenerate|i:1727250241;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7nrpqsk2qqjdiqdmped74afkllde1slo', '2a12:d280:100:51::', 1727119861, '__ci_last_regenerate|i:1727119861;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7o43ih1gphbu8tbhr79v9d4d75sqrn7f', '2a12:d280:100:51::', 1727137202, '__ci_last_regenerate|i:1727137202;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7obujtfioqc4r4dg0us4etaejqntg8p6', '2a12:d280:100:51::', 1727241961, '__ci_last_regenerate|i:1727241961;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7ovdka2t373a3v57omdslbpgvdcr658t', '2a12:d280:100:51::', 1727227981, '__ci_last_regenerate|i:1727227981;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7pc11thtg2npskkfe4nd88ve5cjh0ml4', '2a12:d280:100:51::', 1727141101, '__ci_last_regenerate|i:1727141101;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7q07nnp45o89s65j1hvdio7dgho38qao', '2a12:d280:100:51::', 1727121482, '__ci_last_regenerate|i:1727121482;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7q4vb2ta8qug1otn7i3nseilctvso3gp', '2a12:d280:100:51::', 1727286302, '__ci_last_regenerate|i:1727286302;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7q6hpaps5qt7gu38b2frbogv4al3juln', '2a12:d280:100:51::', 1727123761, '__ci_last_regenerate|i:1727123761;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7qhubm4q70b0vhktdik22q75so7kb35r', '2a12:d280:100:51::', 1727139902, '__ci_last_regenerate|i:1727139902;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7qjcv6n7gmstk5n65u1t7bjt2rk6hvll', '2a12:d280:100:51::', 1727135881, '__ci_last_regenerate|i:1727135881;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7qsd5bpo6jifhp4fqiqnjlom7rdgfcap', '2a12:d280:100:51::', 1727264042, '__ci_last_regenerate|i:1727264042;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7qukbm040bc02u03fevge8n6lpoep79t', '2a12:d280:100:51::', 1727276461, '__ci_last_regenerate|i:1727276461;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7qv9nrqohola0jd7krufmi5cspojr60m', '54.175.74.27', 1727256126, '__ci_last_regenerate|i:1727256125;red_url|s:65:\"https://panel.blitconcept.es/admin/resourcebooking/resource_group\";_prev_url|s:49:\"https://panel.blitconcept.es/admin/authentication\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7r4n78rmnu5s15v9k0ah37jiegabrf34', '2a12:d280:100:51::', 1727158622, '__ci_last_regenerate|i:1727158622;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7rbn4dh9gdjk134vrfch4l1qfottkehm', '2a12:d280:100:51::', 1727204942, '__ci_last_regenerate|i:1727204942;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7rsomql3kcer1o9nnikk6qi72el34qnv', '2a12:d280:100:51::', 1727136602, '__ci_last_regenerate|i:1727136602;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7s0bard1nc16el5i36r0c2m7vuduammv', '2a12:d280:100:51::', 1727135401, '__ci_last_regenerate|i:1727135401;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7s0jsqk798sslu3jihessj2c847rio4f', '2a12:d280:100:51::', 1727112662, '__ci_last_regenerate|i:1727112662;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7s27lsli4hdklsihof73r87n3o9pngs3', '2a12:d280:100:51::', 1727221922, '__ci_last_regenerate|i:1727221922;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7s7i1rfgidrej6jen91rqv9ruhnuq2e1', '2a12:d280:100:51::', 1727057942, '__ci_last_regenerate|i:1727057942;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7sfssj12h44epgk7jkhureojplh0dp75', '2a12:d280:100:51::', 1727094721, '__ci_last_regenerate|i:1727094721;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7slf13bffanfo84tcp6704ea39fe0l4d', '2a12:d280:100:51::', 1727121061, '__ci_last_regenerate|i:1727121061;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7t49d3n5fcteeevsa1ttjkiqm1bmodv6', '2a12:d280:100:51::', 1727259901, '__ci_last_regenerate|i:1727259901;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7t5guu8pc520a7d8cm67rgr8t4lf14ci', '2a12:d280:100:51::', 1727175002, '__ci_last_regenerate|i:1727175002;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7tkj256u2rlel2bdo5053f4r71e4jsis', '2a12:d280:100:51::', 1727187781, '__ci_last_regenerate|i:1727187781;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7tmov65oq59r4jhqaragr34i4gpb60ti', '2a12:d280:100:51::', 1727202242, '__ci_last_regenerate|i:1727202242;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7tn1q23autvqbmne209kenc0vpojekf0', '2a12:d280:100:51::', 1727182802, '__ci_last_regenerate|i:1727182801;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7tqpud88u816ubros6rt7h69j0u4ngd1', '2a12:d280:100:51::', 1727178722, '__ci_last_regenerate|i:1727178722;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7u57jtdtrnc99gndlo3op7143lops90s', '2a12:d280:100:51::', 1727093641, '__ci_last_regenerate|i:1727093641;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7ud4nnje900cuqkkkol7dieob5d7lmne', '2a12:d280:100:51::', 1727247722, '__ci_last_regenerate|i:1727247722;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7ugrrt0n9l5lnm6b08qs8jk3oks1vcs4', '184.72.121.156', 1727251226, '__ci_last_regenerate|i:1727251225;red_url|s:42:\"https://panel.blitconcept.es/admin/modules\";_prev_url|s:49:\"https://panel.blitconcept.es/admin/authentication\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7urmlaqvudhthq9r831avpu6q5t8ql8f', '2a12:d280:100:51::', 1727197382, '__ci_last_regenerate|i:1727197382;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7utg2tj31jq7ce0lsq7c0shhs96sr40v', '2a12:d280:100:51::', 1727205722, '__ci_last_regenerate|i:1727205722;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7v1d0selqp6eg8kv28h4014luf50egam', '2a12:d280:100:51::', 1727113201, '__ci_last_regenerate|i:1727113201;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7v20qhmifhojf4smd91r639ludanrnrp', '2a12:d280:100:51::', 1727131562, '__ci_last_regenerate|i:1727131562;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('80gt50p053lig7gmddprcl9tqaegrl9n', '2a12:d280:100:51::', 1727083142, '__ci_last_regenerate|i:1727083142;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('80i6albom3i6vfto44jvk2iuehnnqbep', '2a12:d280:100:51::', 1727136182, '__ci_last_regenerate|i:1727136182;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('80vk6s2ii0nnrd0sibe4otmjaglv6fr6', '2a12:d280:100:51::', 1727165462, '__ci_last_regenerate|i:1727165462;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('811l5s2u003b2o6bk2119jt3jscbvt5n', '2a12:d280:100:51::', 1727277002, '__ci_last_regenerate|i:1727277002;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('81335h32cpnr8g1u5t2c5pck6upsc7sm', '2a12:d280:100:51::', 1727191622, '__ci_last_regenerate|i:1727191622;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('815q25ajki342d0e497551q0s3e9n0aa', '2a12:d280:100:51::', 1727205182, '__ci_last_regenerate|i:1727205182;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('818bgqo00np92us3evr4r14ga81ad8oc', '2a12:d280:100:51::', 1727202361, '__ci_last_regenerate|i:1727202361;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('81ir4j2q3drglohidn161clhsoft35pn', '2a12:d280:100:51::', 1727206322, '__ci_last_regenerate|i:1727206322;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('81r3m7di642bl58qcdbb01d8n4doo1hl', '2a12:d280:100:51::', 1727054462, '__ci_last_regenerate|i:1727054462;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('81sbped0keuardqevml6idi0a487lqcb', '2a12:d280:100:51::', 1727246762, '__ci_last_regenerate|i:1727246762;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('82akd326ngei46gpjv2copu7bpftbq44', '2a12:d280:100:51::', 1727173202, '__ci_last_regenerate|i:1727173202;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('82ca69u0n4ckjpsh6i3oag7unatvbsik', '2a12:d280:100:51::', 1727163242, '__ci_last_regenerate|i:1727163242;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('82pg53fgh531oubrga3p6pgifkd856i3', '2a12:d280:100:51::', 1727164442, '__ci_last_regenerate|i:1727164442;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('831a9kk9pq8vchqm04m3tfi6tdrl12h4', '2a12:d280:100:51::', 1727067182, '__ci_last_regenerate|i:1727067182;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('83204d1b5q5esgual0m55oup4jjrovui', '2a12:d280:100:51::', 1727114402, '__ci_last_regenerate|i:1727114402;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('83556o7ogv09cjsqos42djes6vktk0pt', '2a12:d280:100:51::', 1727090281, '__ci_last_regenerate|i:1727090281;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('837al6bmfev2eptoei1k8hpcsspet4ha', '2a12:d280:100:51::', 1727247361, '__ci_last_regenerate|i:1727247361;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('83hcubul04rj3a3qhccnr02onnti7vkp', '2a12:d280:100:51::', 1727169781, '__ci_last_regenerate|i:1727169781;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('83ombg0qvj5qinquivotjhuee0bfj5qs', '2a12:d280:100:51::', 1727078882, '__ci_last_regenerate|i:1727078882;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('83rfc1egbei58phouj2o7nh038ttv4fb', '2a12:d280:100:51::', 1727174642, '__ci_last_regenerate|i:1727174642;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('83uupk95agdhst36m7d45qsqlui23kvd', '2a12:d280:100:51::', 1727262182, '__ci_last_regenerate|i:1727262182;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('844ff0qc3ghmv3s4r9u466salvevru8l', '2a12:d280:100:51::', 1727193302, '__ci_last_regenerate|i:1727193301;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('846r4g24f7slg8kocgm1g6cc2664dp7t', '2a12:d280:100:51::', 1727087822, '__ci_last_regenerate|i:1727087822;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('84cq56ikgpd4kbfqhmjo9386mu4kqfgh', '2a12:d280:100:51::', 1727121181, '__ci_last_regenerate|i:1727121181;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('84lr0grhj07mlj9k3khg7tcvnbvbhhao', '2a12:d280:100:51::', 1727065081, '__ci_last_regenerate|i:1727065081;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('855i374v0p1ecnre7ucfjio8nsodsu5v', '2a12:d280:100:51::', 1727159402, '__ci_last_regenerate|i:1727159402;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('85f67f64khldj4a8gr9vil5d3j84u0sk', '2a12:d280:100:51::', 1727167382, '__ci_last_regenerate|i:1727167382;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('85sb8d1tsmkegjqulsjlvalajijt44fe', '2a12:d280:100:51::', 1727211122, '__ci_last_regenerate|i:1727211122;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('86bm0ooqbru15oo7e7tvv1du7qc6pup0', '2a12:d280:100:51::', 1727163661, '__ci_last_regenerate|i:1727163661;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('86enr1p72o5dav1eacmku15vj4b8ciu6', '2a12:d280:100:51::', 1727127781, '__ci_last_regenerate|i:1727127781;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('86l3jiiq1k9jt23orq94psbd1cfdds44', '2a12:d280:100:51::', 1727212861, '__ci_last_regenerate|i:1727212861;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('86tt3uht1qa39giiss5nlbns2v42r2q2', '2a12:d280:100:51::', 1727127122, '__ci_last_regenerate|i:1727127122;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('86ufb09v7vif4kjt8lomsg1nsmr840st', '2a12:d280:100:51::', 1727199301, '__ci_last_regenerate|i:1727199301;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('870i0ptpaomh6u9f5oe07p9ensrh5r5g', '2a12:d280:100:51::', 1727233082, '__ci_last_regenerate|i:1727233082;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8787cfm6992mqdmgr9jbiold9b2rhrd9', '2a12:d280:100:51::', 1727101262, '__ci_last_regenerate|i:1727101262;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('87ibdmdau5s2kf0q4v9khcu7vt3jsj7m', '2a12:d280:100:51::', 1727188981, '__ci_last_regenerate|i:1727188981;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('880bst8shahep6ag06kc4c16s8s97qs9', '2a12:d280:100:51::', 1727283901, '__ci_last_regenerate|i:1727283901;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('88ubopklsbtumt89g4av14qgjeie4tqn', '2a12:d280:100:51::', 1727175481, '__ci_last_regenerate|i:1727175481;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('894jvrf73meh2k9865ks9gub311orvgi', '2a12:d280:100:51::', 1727227561, '__ci_last_regenerate|i:1727227561;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('89b325e4s87u4d4i7j2t9kmib7c1470c', '2a12:d280:100:51::', 1727102761, '__ci_last_regenerate|i:1727102761;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('89d0a1sbpq4dj88l0484nd6mogkfgead', '2a12:d280:100:51::', 1727124181, '__ci_last_regenerate|i:1727124181;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('89jme3bn0thp3aophd572fa5jfj9amgo', '2a12:d280:100:51::', 1727211962, '__ci_last_regenerate|i:1727211962;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('89l2vrce2gapn0lirbb198td28hsv7e4', '2a12:d280:100:51::', 1727142362, '__ci_last_regenerate|i:1727142361;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('89p7rlkhadirltc1fff0s302ceaa94n0', '2a12:d280:100:51::', 1727189282, '__ci_last_regenerate|i:1727189282;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('89u33b3c6rfkarnodvq2sd08c9rfq320', '2a12:d280:100:51::', 1727057341, '__ci_last_regenerate|i:1727057341;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8a1lp5k4sepmtecr3s5tmpbhse1d046l', '2a12:d280:100:51::', 1727126041, '__ci_last_regenerate|i:1727126041;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8a97sqhr121v55lat9kqb22k4bo8dpgh', '2a12:d280:100:51::', 1727217181, '__ci_last_regenerate|i:1727217181;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8afsnh4alu19ascf2liq2gu9gs4gsnd8', '2a12:d280:100:51::', 1727123461, '__ci_last_regenerate|i:1727123461;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8ak5b6mti2ok8l0tt40it6tddcbo965o', '2a12:d280:100:51::', 1727058061, '__ci_last_regenerate|i:1727058061;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8am4107n5gf7ppe49drrh7fpgm71gf8e', '2a12:d280:100:51::', 1727137741, '__ci_last_regenerate|i:1727137741;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8b1anainndjueal7vkpkhkclo73ls362', '2a12:d280:100:51::', 1727171281, '__ci_last_regenerate|i:1727171281;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8bdsmvn6n5cum9p6stiq1gim9e567e3i', '2a12:d280:100:51::', 1727166002, '__ci_last_regenerate|i:1727166002;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8bqmnas0up5fn9o71d233i9l1ogls6f6', '2a12:d280:100:51::', 1727089082, '__ci_last_regenerate|i:1727089082;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8cigaflojtr1cvs5q5r6iapv841nd0tl', '2a12:d280:100:51::', 1727189941, '__ci_last_regenerate|i:1727189941;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8cs0q0qrhhke4f8s10tjim0tahudstj6', '2a12:d280:100:51::', 1727117161, '__ci_last_regenerate|i:1727117161;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8d54fvu44ufq70f8s58ohltm5upi6mf7', '2a12:d280:100:51::', 1727174761, '__ci_last_regenerate|i:1727174761;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8dclv7a650pfdfirvjq97gk6jhmiiie6', '2a12:d280:100:51::', 1727154602, '__ci_last_regenerate|i:1727154602;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8de2i1atrd701be3h1rr2mjl08m5lg1p', '2a12:d280:100:51::', 1727062322, '__ci_last_regenerate|i:1727062322;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8dtsq1ne7govcbibbd5vffj4pkonnphi', '2a12:d280:100:51::', 1727184541, '__ci_last_regenerate|i:1727184541;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8e3b1opddq1t884lvets4vkvmnaftian', '2a12:d280:100:51::', 1727175721, '__ci_last_regenerate|i:1727175721;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8e71c1tf0dd0bo0u2187obffgp28g4d5', '2a12:d280:100:51::', 1727095681, '__ci_last_regenerate|i:1727095681;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8eauftj651umu0rmdfvuvhkt0m8btnti', '2a12:d280:100:51::', 1727253122, '__ci_last_regenerate|i:1727253122;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8ebqav1omcqamfc8345tmcn5fi2a0l9h', '2a12:d280:100:51::', 1727279402, '__ci_last_regenerate|i:1727279402;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8ehacbfvc9bq0s2u7qokqn9pghu37rnv', '2a12:d280:100:51::', 1727055121, '__ci_last_regenerate|i:1727055121;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8enirsd7b18cs656pllmc4jhn3m5oq6j', '2a12:d280:100:51::', 1727254322, '__ci_last_regenerate|i:1727254322;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8f1c631vn10r0iihos91kv2cjta4bn88', '2a12:d280:100:51::', 1727107981, '__ci_last_regenerate|i:1727107981;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8f4beb4ecpsdogncu1om5ibir5omphj1', '2a12:d280:100:51::', 1727245681, '__ci_last_regenerate|i:1727245681;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8fn03m2ao3rs189ug0t8i2qvda0r90av', '2a12:d280:100:51::', 1727273101, '__ci_last_regenerate|i:1727273101;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8frlvcpf4en12m7pscq4ms1qrkhn4843', '2a12:d280:100:51::', 1727238122, '__ci_last_regenerate|i:1727238121;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8g0i1aog41slqh37v7jeoh0a566jubju', '2a12:d280:100:51::', 1727044741, '__ci_last_regenerate|i:1727044741;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8g27obtb801497olcc7ofv869c2gcvm7', '2a12:d280:100:51::', 1727074741, '__ci_last_regenerate|i:1727074741;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8gfh1c0uk4c7a6a9d3sn6bq3ecsf7k06', '2a12:d280:100:51::', 1727108821, '__ci_last_regenerate|i:1727108821;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8gktc0bmskidcm0eippvthokf08evno8', '2a12:d280:100:51::', 1727224082, '__ci_last_regenerate|i:1727224082;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8gn1bfgh4mci3hber6b4kg8mkqecoihl', '2a12:d280:100:51::', 1727203861, '__ci_last_regenerate|i:1727203861;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8gvcbmjie37ilu3i12dgs5uu7igdcruc', '2a12:d280:100:51::', 1727176621, '__ci_last_regenerate|i:1727176621;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8h207jubll4u3k2bntkaes810kkivjbq', '2a12:d280:100:51::', 1727140382, '__ci_last_regenerate|i:1727140382;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8h68uv8gf8013g76pf2biufap10str0s', '2a12:d280:100:51::', 1727222221, '__ci_last_regenerate|i:1727222221;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8h7gjk5n7887v534be12ovako03o3jgn', '2a12:d280:100:51::', 1727208362, '__ci_last_regenerate|i:1727208362;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8h7ioo4innu97j4htbjortup5fepijpc', '2a12:d280:100:51::', 1727184242, '__ci_last_regenerate|i:1727184242;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8hev8kv27n7eqn6i8r9f7vqi02h26kcu', '2a12:d280:100:51::', 1727061602, '__ci_last_regenerate|i:1727061602;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8hfmhhhai49gjpdb5r60aat2l0g9p4tb', '2a12:d280:100:51::', 1727207162, '__ci_last_regenerate|i:1727207162;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8hma8ng3odvrkm49ss0eedbqrv62t403', '2a12:d280:100:51::', 1727147761, '__ci_last_regenerate|i:1727147761;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8hmb12tfs74dbgkle8eoekat031qhkpd', '2a12:d280:100:51::', 1727193721, '__ci_last_regenerate|i:1727193721;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8i9s2ogo7vtas984sn1f88vtvjtsfnfo', '2a12:d280:100:51::', 1727212442, '__ci_last_regenerate|i:1727212441;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8iglmqnlq6e3hgcsaici996oiav49v35', '2a12:d280:100:51::', 1727155142, '__ci_last_regenerate|i:1727155142;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8ip91hddbtbv3gp27l1svvud8dimlmcv', '2a12:d280:100:51::', 1727116501, '__ci_last_regenerate|i:1727116501;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8je78f1ntb1inf998spsv73sja8mfs70', '2a12:d280:100:51::', 1727104381, '__ci_last_regenerate|i:1727104381;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8jem7v5rtgt0m6gmf2ed194sguhpk8g7', '2a12:d280:100:51::', 1727267762, '__ci_last_regenerate|i:1727267762;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8jo1v9bga092tu5ma9u0v4adp2v7rvtg', '2a12:d280:100:51::', 1727211361, '__ci_last_regenerate|i:1727211361;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8js696efnl1udvs8ds9fmh1n7pdbrid0', '2a12:d280:100:51::', 1727277061, '__ci_last_regenerate|i:1727277061;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8ju5l0rcef0fgo82har68o6o6r0t7uub', '2a12:d280:100:51::', 1727262601, '__ci_last_regenerate|i:1727262601;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8jvrbhncvlocgqjdm0aeid4ho2bgi9q3', '2a12:d280:100:51::', 1727207221, '__ci_last_regenerate|i:1727207221;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8l2rkalfp1boj6ed3nkgera6con5ihqa', '2a12:d280:100:51::', 1727295422, '__ci_last_regenerate|i:1727295422;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8lqpkbvj5gld0l79rf7caclsvd1k5qac', '2a12:d280:100:51::', 1727182141, '__ci_last_regenerate|i:1727182141;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8luki125fl71sdvcuir7nv3vsafbu016', '2a12:d280:100:51::', 1727266442, '__ci_last_regenerate|i:1727266442;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8m3hku9lcmtv7985ak89l2en8coirki5', '2a12:d280:100:51::', 1727199781, '__ci_last_regenerate|i:1727199781;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8mp41qfj4b7ooh04aph7ul7mi1j6eo25', '2a12:d280:100:51::', 1727149681, '__ci_last_regenerate|i:1727149681;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8mp8m8jqijlthea07ol1s6t6e8csgogn', '2a12:d280:100:51::', 1727095921, '__ci_last_regenerate|i:1727095921;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8n24s5hvbbck8e65jo8i6ahuu6qhtqdo', '2a12:d280:100:51::', 1727163841, '__ci_last_regenerate|i:1727163841;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8nd98n12572qcj7u3sjhvpn5bekcrmai', '2a12:d280:100:51::', 1727234762, '__ci_last_regenerate|i:1727234762;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8nqnh035ub08l4lc36a8baivsoja8j4a', '2a12:d280:100:51::', 1727237221, '__ci_last_regenerate|i:1727237221;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8nsb1ffkj2o2nug9isuackt74uts6959', '2a12:d280:100:51::', 1727113742, '__ci_last_regenerate|i:1727113742;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8ntluar8mt0b94mkqjmg7t1k20kpqmbh', '2a12:d280:100:51::', 1727121901, '__ci_last_regenerate|i:1727121901;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8oc0fdnkvt7932o6gntru45i4ni9a4jj', '2a12:d280:100:51::', 1727264761, '__ci_last_regenerate|i:1727264761;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8ok1654h0jpulk1fh3k916sjthrffccj', '2a12:d280:100:51::', 1727122862, '__ci_last_regenerate|i:1727122862;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8oqed7moh9ovcr0p0gqnp2j5v3sedqme', '2a12:d280:100:51::', 1727180461, '__ci_last_regenerate|i:1727180461;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8oso4ksrug2mjs7e9urrs128utn7om12', '2a12:d280:100:51::', 1727272681, '__ci_last_regenerate|i:1727272681;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8p8odsnubvqvfb61ibbm6t6p5vnu2kdk', '2a12:d280:100:51::', 1727124721, '__ci_last_regenerate|i:1727124721;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8p94pr69nsmp7vptua8hnkhes5i7220p', '2a12:d280:100:51::', 1727085722, '__ci_last_regenerate|i:1727085721;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8pjt7a8h1i0m20nhfeu1ah1l5gg26avb', '2a12:d280:100:51::', 1727114642, '__ci_last_regenerate|i:1727114642;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8pmm8b93t5900d64jd9aq6ho3694l1s4', '2a12:d280:100:51::', 1727214902, '__ci_last_regenerate|i:1727214902;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8pogujbl0t2fjg5rj23u552f7jbda7m3', '2a12:d280:100:51::', 1727287921, '__ci_last_regenerate|i:1727287921;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8ppcc47cu74kff3jvdb49iud9u4bblf4', '2a12:d280:100:51::', 1727138641, '__ci_last_regenerate|i:1727138641;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8pqb20sbh9bab81oi7652fdmkt0limnf', '2a12:d280:100:51::', 1727170742, '__ci_last_regenerate|i:1727170742;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8qariqv3srtllc3k2cdjfhn7juc031jr', '2a12:d280:100:51::', 1727067842, '__ci_last_regenerate|i:1727067842;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8qlq6ldtberg4qo3t94g67nue35pie36', '2a12:d280:100:51::', 1727059021, '__ci_last_regenerate|i:1727059021;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8qlqcci5c6gd6np904i95fp6ancjuv6t', '2a12:d280:100:51::', 1727156762, '__ci_last_regenerate|i:1727156761;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8qo1ml2utjh1qp80lpfcm434n71tu6a9', '2a12:d280:100:51::', 1727139541, '__ci_last_regenerate|i:1727139541;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8r5msp0edfnle6vgkbm1kji99evemsvu', '2a12:d280:100:51::', 1727144521, '__ci_last_regenerate|i:1727144521;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8rrmbbmo4ip3nfo2smte8hkuu9qba3bi', '2a12:d280:100:51::', 1727058722, '__ci_last_regenerate|i:1727058721;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8s3ees28vu8pagaen05f2sdcc4fbl867', '2a12:d280:100:51::', 1727180881, '__ci_last_regenerate|i:1727180881;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8sbb8r8ch9dvf93tq7dk5iost9bg2da5', '2a12:d280:100:51::', 1727087341, '__ci_last_regenerate|i:1727087341;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8shg91gv8l0912epifr3hcsd436gpluh', '2a12:d280:100:51::', 1727093582, '__ci_last_regenerate|i:1727093582;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8t6f7tv3cc2jtg73gr623r256p077rag', '2a12:d280:100:51::', 1727110201, '__ci_last_regenerate|i:1727110201;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8tbu0errddbbtifvb2i4qf9urkgciit3', '2a12:d280:100:51::', 1727046782, '__ci_last_regenerate|i:1727046782;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8u3ba0rj4pahe0o5fmq7a8g20hqgq1tb', '2a12:d280:100:51::', 1727068621, '__ci_last_regenerate|i:1727068621;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8u4r4hg8u95bclgb3fvogbtruk6gbi4i', '2a12:d280:100:51::', 1727105042, '__ci_last_regenerate|i:1727105042;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8u7f4unr68n6cef52mn9gi7571ebpnl4', '2a12:d280:100:51::', 1727246941, '__ci_last_regenerate|i:1727246941;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8ucrj5v204elio7gp8alq9co7aaardhm', '2a12:d280:100:51::', 1727077141, '__ci_last_regenerate|i:1727077141;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8ufsh5s06k99c4eemsahml72qu68j6qp', '2a12:d280:100:51::', 1727087941, '__ci_last_regenerate|i:1727087941;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8upje0fehb34tr7c8lmbikhdp6n428au', '2a12:d280:100:51::', 1727062742, '__ci_last_regenerate|i:1727062742;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8v0iv5oqf5d4gbccsbv752fi0t7c11r3', '2a12:d280:100:51::', 1727200261, '__ci_last_regenerate|i:1727200261;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8v2ubn979auka47f1q1lep43n8vfehv4', '2a12:d280:100:51::', 1727196781, '__ci_last_regenerate|i:1727196781;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8vcmise7cvntcoq208vrvhis2uf3bnma', '2a12:d280:100:51::', 1727248501, '__ci_last_regenerate|i:1727248501;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8vcrmfjnv9beos5d4hrmk0odp3lgmqmm', '2a12:d280:100:51::', 1727232122, '__ci_last_regenerate|i:1727232122;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8vfcpe0gdtvr952rho69j2ic4largt97', '2a12:d280:100:51::', 1727056321, '__ci_last_regenerate|i:1727056321;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8vj6pkhok22opni6qa1jjcf451f2p6q5', '2a12:d280:100:51::', 1727044682, '__ci_last_regenerate|i:1727044682;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9013jeejnqlh6nii421rjce4cdrshtga', '2a12:d280:100:51::', 1727108581, '__ci_last_regenerate|i:1727108581;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9047jgo2pbajktku6vlokg5l53f9jp11', '2a12:d280:100:51::', 1727213162, '__ci_last_regenerate|i:1727213162;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('904i4523f124o3oda57gvl46uh9c71eb', '2a12:d280:100:51::', 1727113021, '__ci_last_regenerate|i:1727113021;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('90ql4kdkpohognupbek0kcbdvh5uqmtp', '2a12:d280:100:51::', 1727196122, '__ci_last_regenerate|i:1727196122;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9176erkqvlilh19pvhdj120vlf22qv9e', '2a12:d280:100:51::', 1727109242, '__ci_last_regenerate|i:1727109242;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('91etfset9mn3uoekfnporkuqh295vk31', '2a12:d280:100:51::', 1727286001, '__ci_last_regenerate|i:1727286001;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('91fb71j92bpevne5v8f9311dek9094k9', '2a12:d280:100:51::', 1727155262, '__ci_last_regenerate|i:1727155262;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('91fu7e9m4774i7e92jvduiogaptq74jh', '2a12:d280:100:51::', 1727166541, '__ci_last_regenerate|i:1727166541;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('91qj2tvj40t9jem46hhmv07vgderl3k9', '2a12:d280:100:51::', 1727192821, '__ci_last_regenerate|i:1727192821;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('92hgevssu8cb0dn78fbjg336hjkb5d6r', '2a12:d280:100:51::', 1727093522, '__ci_last_regenerate|i:1727093522;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('92l50ipb7db9rel7dtvepj6asahqa6hi', '2a12:d280:100:51::', 1727218681, '__ci_last_regenerate|i:1727218681;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('92s9m6nl03chb9a1lvu94qtr1mtbtfb1', '2a12:d280:100:51::', 1727278921, '__ci_last_regenerate|i:1727278921;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('92sii9d2s42shrsekh1ah9eh3ialikbn', '2a12:d280:100:51::', 1727062982, '__ci_last_regenerate|i:1727062982;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('92sj2ea8traghfinujbasot830db7jrf', '2a12:d280:100:51::', 1727225821, '__ci_last_regenerate|i:1727225821;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('93qmasp7lfb17rakfut41lpkv1t8v3i5', '2a12:d280:100:51::', 1727130781, '__ci_last_regenerate|i:1727130781;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('94g2gu9r8amc6pnqi733elv8953e4bpl', '2a12:d280:100:51::', 1727191082, '__ci_last_regenerate|i:1727191082;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('951e62895r1vqgt3oh1qqtecmfsh2mus', '2a12:d280:100:51::', 1727282641, '__ci_last_regenerate|i:1727282641;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('95qehs9c7i1ojqhoucmepc6tfd4ucer4', '2a12:d280:100:51::', 1727286781, '__ci_last_regenerate|i:1727286781;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('965gavtav7dg51bjm6qcabgcu8ml2lhf', '2a12:d280:100:51::', 1727122081, '__ci_last_regenerate|i:1727122081;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('96e9dda3iock0v59etiek5mfohel6hbi', '2a12:d280:100:51::', 1727126162, '__ci_last_regenerate|i:1727126161;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('96tut599nh1lkrbbnijac8b4tj82k7nj', '2a12:d280:100:51::', 1727064242, '__ci_last_regenerate|i:1727064242;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('97jqdsvg0d4q1fg0eunnf5kjtlc96i84', '2a12:d280:100:51::', 1727265542, '__ci_last_regenerate|i:1727265542;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('97k3l2mj155449bu53megvnf7ulrvf2l', '2a12:d280:100:51::', 1727154361, '__ci_last_regenerate|i:1727154361;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('98cl8ma8qo1d0a9maajhjr39vv8hs16a', '2a12:d280:100:51::', 1727115901, '__ci_last_regenerate|i:1727115901;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('98dom253vqvskfhu4kjvlp5t901ll4u0', '2a12:d280:100:51::', 1727089322, '__ci_last_regenerate|i:1727089322;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('98f29ojfnp2pqb4k6hv849457bu84vnl', '2a12:d280:100:51::', 1727164321, '__ci_last_regenerate|i:1727164321;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('98jj3ef8otjhj46sdlo168724ldea176', '2a12:d280:100:51::', 1727254142, '__ci_last_regenerate|i:1727254142;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('98mmgsdvdsi61voisvdmgnus1ebmnlbk', '2a12:d280:100:51::', 1727256901, '__ci_last_regenerate|i:1727256901;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('990t1b5qn7qkh2ses7ue61v4f94eud2m', '2a12:d280:100:51::', 1727216881, '__ci_last_regenerate|i:1727216881;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('99p51vu5cll6etef4ulv6omne5uje5l6', '2a12:d280:100:51::', 1727258281, '__ci_last_regenerate|i:1727258281;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('99tlqlam8mudgh2queee5qpas1pbhht1', '2a12:d280:100:51::', 1727138521, '__ci_last_regenerate|i:1727138521;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('99upvvi7n7ios7gv67c0vk8jqs0ff777', '2a12:d280:100:51::', 1727070961, '__ci_last_regenerate|i:1727070961;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9ah4d4jc61l0hhtgbnvmqnasg1me4a4o', '2a12:d280:100:51::', 1727273942, '__ci_last_regenerate|i:1727273941;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9ap4dn1s5hd5fs154ll5t3ldo0cd30lp', '2a12:d280:100:51::', 1727114581, '__ci_last_regenerate|i:1727114581;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9asuf1n3th3mevtfk74hub0oa6g6n2bt', '2a12:d280:100:51::', 1727159581, '__ci_last_regenerate|i:1727159581;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9b3nqsp5jdfjv02f7hphlr1ug5jvbii6', '2a12:d280:100:51::', 1727200742, '__ci_last_regenerate|i:1727200742;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9bj19ap6kduhnbgc0nt7aebvte5bveus', '2a12:d280:100:51::', 1727073661, '__ci_last_regenerate|i:1727073661;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9bk5k8uvrk2j1l0q9meribnsgiqsdibf', '2a12:d280:100:51::', 1727195162, '__ci_last_regenerate|i:1727195162;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9bl2hmem33ndn2fjqies3oj4o6k4dn1n', '2a12:d280:100:51::', 1727210461, '__ci_last_regenerate|i:1727210461;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9boo8crhkmgh570rho3kma1cj2jv6l83', '2a12:d280:100:51::', 1727236562, '__ci_last_regenerate|i:1727236562;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9bvmbmbvocg1o4dimlf41kdvhke9kadv', '2a12:d280:100:51::', 1727050682, '__ci_last_regenerate|i:1727050682;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9c7rmibb87f9k0k85nusflucv0o6lgro', '2a12:d280:100:51::', 1727280661, '__ci_last_regenerate|i:1727280661;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9cgmp9bvpf4hni63d6u8mj17p82r793m', '2a12:d280:100:51::', 1727284141, '__ci_last_regenerate|i:1727284141;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9cjq2l39mi54d05lpjul4fqngsiousc4', '2a12:d280:100:51::', 1727153942, '__ci_last_regenerate|i:1727153942;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9d4k13osob562h42m1gue7oq2jdfnfo0', '2a12:d280:100:51::', 1727090462, '__ci_last_regenerate|i:1727090462;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9dtdok1e0kqb9usbah0oiosqnk3betrf', '2a12:d280:100:51::', 1727156342, '__ci_last_regenerate|i:1727156342;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9e5kr4cbj53ibhec8upjuok54tp9mit3', '2a12:d280:100:51::', 1727202002, '__ci_last_regenerate|i:1727202002;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9ec7q871c2ak3vslg65f76tjgi1d9jd2', '2a12:d280:100:51::', 1727046421, '__ci_last_regenerate|i:1727046421;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9edaeq6i6r5s7omihvqg4qahkoalecio', '2a12:d280:100:51::', 1727237162, '__ci_last_regenerate|i:1727237162;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9eg1m9hu3o9apscq4umtffv0me1uq7sb', '2a12:d280:100:51::', 1727137561, '__ci_last_regenerate|i:1727137561;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9egj6r7e4vvfdvckaddra1qpjmbv67sm', '2a12:d280:100:51::', 1727109062, '__ci_last_regenerate|i:1727109062;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9eo6h8cudbb9600m68jb0uo338hrb5cv', '2a12:d280:100:51::', 1727116261, '__ci_last_regenerate|i:1727116261;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9eutmt1vicjvjjvcakpr637s1r2bggkq', '2a12:d280:100:51::', 1727079482, '__ci_last_regenerate|i:1727079482;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9f17aj6bq135nbhom6prsvn2m558fpgi', '2a12:d280:100:51::', 1727148181, '__ci_last_regenerate|i:1727148181;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9fpp2es0f6q3muhml6lj4es341hcuo48', '2a12:d280:100:51::', 1727292002, '__ci_last_regenerate|i:1727292002;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9fv2ccp1h85n6kvnevbv3skv6vu0rn0j', '2a12:d280:100:51::', 1727289301, '__ci_last_regenerate|i:1727289301;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9gu5voaohu8r6k8v2hocg9aoqhhara3p', '2a12:d280:100:51::', 1727176082, '__ci_last_regenerate|i:1727176082;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9h0fg4r52ifevpfbb5j7il1aec6toksc', '2a12:d280:100:51::', 1727111342, '__ci_last_regenerate|i:1727111342;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9h40j36gi7lmb6cqmj510neefprqo9ob', '2a12:d280:100:51::', 1727150402, '__ci_last_regenerate|i:1727150402;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9h4brl7tfsu6qu6jboc39168oe5rjuav', '2a12:d280:100:51::', 1727152382, '__ci_last_regenerate|i:1727152382;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9h9tu4eulg4n5p7gm1j5fe8274ohhirn', '2a12:d280:100:51::', 1727134621, '__ci_last_regenerate|i:1727134621;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9hdshtk54293oo1p3fq5d2dbi1rh921c', '2a12:d280:100:51::', 1727124062, '__ci_last_regenerate|i:1727124062;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9i2au02djbmut64ber5qbmdku399gplo', '2a12:d280:100:51::', 1727181781, '__ci_last_regenerate|i:1727181781;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9i9aamgqs6g9e97b7mcg61crdulc95d6', '2a12:d280:100:51::', 1727110862, '__ci_last_regenerate|i:1727110862;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9iio3blavf6cffan00qfmki1krjobdc5', '2a12:d280:100:51::', 1727283001, '__ci_last_regenerate|i:1727283001;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9ikb623u1cu5vv0jikqhov23m2blq0fv', '2a12:d280:100:51::', 1727289722, '__ci_last_regenerate|i:1727289722;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9inla48fdkbcrmf2rv8ojc4htviqfr74', '2a12:d280:100:51::', 1727076242, '__ci_last_regenerate|i:1727076242;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9iojr6a1khjvgbqhc1pgb43s6n35ojpt', '2a12:d280:100:51::', 1727145781, '__ci_last_regenerate|i:1727145781;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9iq08c2ge789vuvjbvv4bbanrt2v75mh', '2a12:d280:100:51::', 1727279641, '__ci_last_regenerate|i:1727279641;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9iupapgv875ptvci8gli53t1i5i2o30i', '2a12:d280:100:51::', 1727185502, '__ci_last_regenerate|i:1727185502;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9ja13htng9ggpvmb2hba0gs3i7bjheds', '2a12:d280:100:51::', 1727080922, '__ci_last_regenerate|i:1727080922;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9jvfnk0vm9onpbid5ksch60vutn3gkb0', '2a12:d280:100:51::', 1727137141, '__ci_last_regenerate|i:1727137141;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9k95iu34qdn11ml0lbr3ou4timjqbuvd', '2a12:d280:100:51::', 1727139361, '__ci_last_regenerate|i:1727139361;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9kfc1h4t00k0adu5lv448vrbn0vgd14r', '2a12:d280:100:51::', 1727257021, '__ci_last_regenerate|i:1727257021;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9kh5d3kf4fa84k6r4hliftgrsl9d43p0', '2a12:d280:100:51::', 1727142962, '__ci_last_regenerate|i:1727142962;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9kmg35g7vmfj47ajp2qomt8pv1v1lark', '2a12:d280:100:51::', 1727272322, '__ci_last_regenerate|i:1727272322;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9kuc6f3j21e409lj7u03a8mt38v89up5', '2a12:d280:100:51::', 1727111161, '__ci_last_regenerate|i:1727111161;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9l42ve61oqnh7d9ppfnit39j6drmolnh', '2a12:d280:100:51::', 1727119322, '__ci_last_regenerate|i:1727119322;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9l4nrue2rftn8uklmr1hqfm6pgu9dddm', '2a12:d280:100:51::', 1727133782, '__ci_last_regenerate|i:1727133782;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9l4q2nbb9jqdurtn69ck278fq65l8bi5', '2a12:d280:100:51::', 1727250302, '__ci_last_regenerate|i:1727250302;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9l53c7cudp0h237q4789p1s38uf995pv', '2a12:d280:100:51::', 1727072642, '__ci_last_regenerate|i:1727072642;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9l86va0qmrfl6m67erb8mkb3ndtdtol7', '2a12:d280:100:51::', 1727050141, '__ci_last_regenerate|i:1727050141;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9lmj4v6h5rffbtshmlo0qab6vgtg5i5n', '2a12:d280:100:51::', 1727214541, '__ci_last_regenerate|i:1727214541;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9lulllmag6d64iebo3kcraujobdieinc', '2a12:d280:100:51::', 1727088722, '__ci_last_regenerate|i:1727088722;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9m3t3lle45466sfff4pptsk5lfobpd2r', '2a12:d280:100:51::', 1727215381, '__ci_last_regenerate|i:1727215381;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9m4kr9gfumu1j3k1h6t032s7272svknh', '2a12:d280:100:51::', 1727274121, '__ci_last_regenerate|i:1727274121;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9mc7sn2ejdd4v9lt7sucrmiqbl598rv6', '2a12:d280:100:51::', 1727061722, '__ci_last_regenerate|i:1727061722;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9mdh8d86i3df9v3st8psfjmgi9ms8mi6', '2a12:d280:100:51::', 1727118961, '__ci_last_regenerate|i:1727118961;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9mejvvaf89uuk7220cdb3qvcf6fhpb1k', '2a12:d280:100:51::', 1727176202, '__ci_last_regenerate|i:1727176202;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9mfa3vt9puq44sroahtcutred7jagv9b', '2a12:d280:100:51::', 1727186281, '__ci_last_regenerate|i:1727186281;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9mflgcsa4v4cos708jbmtm74fgp22saf', '2a12:d280:100:51::', 1727200862, '__ci_last_regenerate|i:1727200862;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9mun8n2qvlds3dh5j6biejffasnmtumt', '2a12:d280:100:51::', 1727266261, '__ci_last_regenerate|i:1727266261;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9n6limlo33e4lfip3bg35sgt7q9qam9t', '2a12:d280:100:51::', 1727120281, '__ci_last_regenerate|i:1727120281;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9ngnqfbbr08i39uqkgelmb5qdoa1f9gn', '2a12:d280:100:51::', 1727127722, '__ci_last_regenerate|i:1727127722;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9nltq7tj4a627fa97a5j93i2s5km39n6', '2a12:d280:100:51::', 1727258942, '__ci_last_regenerate|i:1727258942;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9nt0ii201rs2t67cnc7rpjn2o2le592m', '2a12:d280:100:51::', 1727215741, '__ci_last_regenerate|i:1727215741;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9ob8v4feeeoqok46u50mgo8gs16ikjh8', '2a12:d280:100:51::', 1727277602, '__ci_last_regenerate|i:1727277602;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9oj1v8jfi09m9i1tdo56t8bj1p4msgsn', '2a12:d280:100:51::', 1727198702, '__ci_last_regenerate|i:1727198702;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9ojout4lt1iombab3t9avnqtq81rr80m', '2a12:d280:100:51::', 1727259842, '__ci_last_regenerate|i:1727259842;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9okphm247cpm75ppvgbe2v79bdjijac4', '2a12:d280:100:51::', 1727244602, '__ci_last_regenerate|i:1727244601;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9p727m5ti4g5o9u5hc91v719gdusrdif', '2a12:d280:100:51::', 1727062141, '__ci_last_regenerate|i:1727062141;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9p8jlku19eps7bqcfndp3nbh616t31o2', '2a12:d280:100:51::', 1727156881, '__ci_last_regenerate|i:1727156881;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9pj627v2qvfl60hv1ea8i14s4cujqqvt', '2a12:d280:100:51::', 1727102582, '__ci_last_regenerate|i:1727102581;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9pva4kji0u1vbo4rafuof98r83ae73bh', '2a12:d280:100:51::', 1727209622, '__ci_last_regenerate|i:1727209622;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9ql8hc71t8sb27jh3lg8bkqcgtafkdsq', '2a12:d280:100:51::', 1727174582, '__ci_last_regenerate|i:1727174582;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9qs4i04jq3qgmor347vqnplo2kve9jv7', '2a12:d280:100:51::', 1727205961, '__ci_last_regenerate|i:1727205961;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9rrhepe27vo46sevjh1i8pag36jc7n35', '2a12:d280:100:51::', 1727227622, '__ci_last_regenerate|i:1727227622;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9rstrukqogak9d8iq27tfluf12jt0to5', '2a12:d280:100:51::', 1727141281, '__ci_last_regenerate|i:1727141281;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9s0l1h93prgh3l6cjnivfip6a8brqu1h', '2a12:d280:100:51::', 1727063281, '__ci_last_regenerate|i:1727063281;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9st90j047kk86ft2alpsgn4hn559839d', '2a12:d280:100:51::', 1727096101, '__ci_last_regenerate|i:1727096101;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9t4dgqsnmadd1ku61f0aphtbudilv9hs', '2a12:d280:100:51::', 1727277302, '__ci_last_regenerate|i:1727277302;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9tb57ugf6jcsqs50mhieclejc7423l2u', '2a12:d280:100:51::', 1727154541, '__ci_last_regenerate|i:1727154541;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9trrvjokvfn4upvvbrrnhtjhgjg4fpid', '2a12:d280:100:51::', 1727144582, '__ci_last_regenerate|i:1727144582;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9u03r3e59ijsumbep6k9ibkmrulaqkf5', '2a12:d280:100:51::', 1727051882, '__ci_last_regenerate|i:1727051882;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9umvi5hmu3rrpcmc2ohdoqnuavqar4gq', '2a12:d280:100:51::', 1727098802, '__ci_last_regenerate|i:1727098801;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9uu3f3hab4qiicphflgghhhks6p0fh97', '2a12:d280:100:51::', 1727265482, '__ci_last_regenerate|i:1727265482;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9v1m4s18s4u2a5mv54n2bvmocl5260rt', '2a12:d280:100:51::', 1727075821, '__ci_last_regenerate|i:1727075821;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9v2fsik9uqu9dq4fskbfeukhclocomuf', '2a12:d280:100:51::', 1727070602, '__ci_last_regenerate|i:1727070602;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9v75qvgfmuiooo1vh8nor778mbvdsvpo', '2a12:d280:100:51::', 1727060402, '__ci_last_regenerate|i:1727060402;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9vj53p7g7k79sp6ej60703hi1lrkubcg', '2a12:d280:100:51::', 1727276042, '__ci_last_regenerate|i:1727276042;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9vrhchna5k3ajarloa8m745s692r9uie', '2a12:d280:100:51::', 1727224562, '__ci_last_regenerate|i:1727224561;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9vtp527ojbdoa20ee6iepc83rqe3o2n2', '2a12:d280:100:51::', 1727103181, '__ci_last_regenerate|i:1727103181;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9vvolo445esadgp2ldpbmusrneo52dgq', '2a12:d280:100:51::', 1727108221, '__ci_last_regenerate|i:1727108221;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a03qgiuee3pgq3ua1mfohmoq8m3m0ksp', '2a12:d280:100:51::', 1727279581, '__ci_last_regenerate|i:1727279581;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a04gb922rjtt8p7ojjinjt3rsae2pagb', '2a12:d280:100:51::', 1727197922, '__ci_last_regenerate|i:1727197922;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a0h35un4ia887dqe0j00s60ahrk0djob', '2a12:d280:100:51::', 1727070901, '__ci_last_regenerate|i:1727070901;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a24qt31nfq5o8k8lsabnrgru6sqpbpsb', '2a12:d280:100:51::', 1727108162, '__ci_last_regenerate|i:1727108162;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a2elor5l2pk8uqhf9bcbm4kcmv175227', '2a12:d280:100:51::', 1727154181, '__ci_last_regenerate|i:1727154181;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a2he5nj7mkh7snp0b7khnsttoq0qth3l', '2a12:d280:100:51::', 1727238002, '__ci_last_regenerate|i:1727238001;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a3184bobq7k3f4ln24pcqqqgn3elhlaq', '2a12:d280:100:51::', 1727116022, '__ci_last_regenerate|i:1727116021;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a38ilcrgdofror8968m0kjrb55mbor6i', '2a12:d280:100:51::', 1727086382, '__ci_last_regenerate|i:1727086382;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a3rgohegmkr73c03k4e5953deqtg4dvg', '2a12:d280:100:51::', 1727224621, '__ci_last_regenerate|i:1727224621;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a3sbhgcc862sdpvlq9ideq0fb9hlhtvi', '2a12:d280:100:51::', 1727219642, '__ci_last_regenerate|i:1727219642;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a3ujamdh0ejqfcplg2kfn1po6107n14l', '2a12:d280:100:51::', 1727118362, '__ci_last_regenerate|i:1727118362;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a4eec9j33hptrgisjmm0lmtaladi3dbc', '2a12:d280:100:51::', 1727094542, '__ci_last_regenerate|i:1727094542;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a4rtvq3mure2h1tvofkr0p8fou35f4oo', '2a12:d280:100:51::', 1727221861, '__ci_last_regenerate|i:1727221861;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a548i7mjpjror0sohs1kpqr51oprr3fk', '2a12:d280:100:51::', 1727167322, '__ci_last_regenerate|i:1727167321;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a570ndmk8l0foogkgejgfql2mkqedabi', '2a12:d280:100:51::', 1727068382, '__ci_last_regenerate|i:1727068381;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a58vmafrh8rtdbm57e756gm9trjfr67m', '2a12:d280:100:51::', 1727288221, '__ci_last_regenerate|i:1727288221;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a5l0mjaeodpdbji1nacmp71s9uvtg3qd', '2a12:d280:100:51::', 1727161441, '__ci_last_regenerate|i:1727161441;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a62ovqrqm5dg69skg6qcsaqk1tputgvo', '2a12:d280:100:51::', 1727080382, '__ci_last_regenerate|i:1727080382;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a63t37v3lh4295s97oevak2o097oib2c', '2a12:d280:100:51::', 1727258162, '__ci_last_regenerate|i:1727258162;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a67auuh8evidvbhkqod34kqfbh8s9s22', '2a12:d280:100:51::', 1727053922, '__ci_last_regenerate|i:1727053922;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a73cahvfuv2h8t9fo60p9oe26t36l3pj', '2a12:d280:100:51::', 1727171702, '__ci_last_regenerate|i:1727171702;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a7bk2gr2o580confld0o4t1rcf05rfi8', '184.72.121.156', 1727237448, '__ci_last_regenerate|i:1727237448;red_url|s:49:\"https://panel.blitconcept.es/admin/modules/upload\";_prev_url|s:49:\"https://panel.blitconcept.es/admin/authentication\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a7e7puav93nk00m5sdsji42jhh9if86p', '2a12:d280:100:51::', 1727260682, '__ci_last_regenerate|i:1727260682;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a8ciss8bv7p3ildpupg8bucv0e6l8n4r', '2a12:d280:100:51::', 1727134381, '__ci_last_regenerate|i:1727134381;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a8g4avndojqsnlgk21m2fd845bhv7p96', '2a12:d280:100:51::', 1727289362, '__ci_last_regenerate|i:1727289362;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a8i41gmh82a2qtgboa3dnfpfo9m490bm', '2a12:d280:100:51::', 1727062202, '__ci_last_regenerate|i:1727062202;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a8jfsp59ig36ccrlj3qk3l1gkga15hr9', '2a12:d280:100:51::', 1727072522, '__ci_last_regenerate|i:1727072522;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a94668gsad0qvls05vbgg71ioiahds0n', '2a12:d280:100:51::', 1727087101, '__ci_last_regenerate|i:1727087101;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a998ihm9krk0ddek86qh62oheueomhmf', '2a12:d280:100:51::', 1727276821, '__ci_last_regenerate|i:1727276821;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a9elmcu08o223g2k38saf5p9sbcrq2uj', '2a12:d280:100:51::', 1727253302, '__ci_last_regenerate|i:1727253302;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a9s9rgc0n97oacl5rbnuc6rjtdfh2d5q', '2a12:d280:100:51::', 1727129342, '__ci_last_regenerate|i:1727129342;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('aa6m74983ast968ncto7rqnbjso48va1', '2a12:d280:100:51::', 1727054342, '__ci_last_regenerate|i:1727054342;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('aaaemg52bpa1nq59fl7aeka1f4bj0g61', '2a12:d280:100:51::', 1727261822, '__ci_last_regenerate|i:1727261821;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('aaovjk7hmgrqudm8guec4p4847nc92n9', '2a12:d280:100:51::', 1727046961, '__ci_last_regenerate|i:1727046961;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('aarms7kenole16fq39mr5rn7f1nu00st', '2a12:d280:100:51::', 1727207882, '__ci_last_regenerate|i:1727207882;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('aav34rojne5a7mjf89jhk0f88oe4n2rh', '2a12:d280:100:51::', 1727166602, '__ci_last_regenerate|i:1727166602;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ab0g6kt25k8f2a25t9e53hbmsb37ikbp', '2a12:d280:100:51::', 1727145602, '__ci_last_regenerate|i:1727145602;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('abbog109e44s582ib6fgv029c66vip6m', '2a12:d280:100:51::', 1727168701, '__ci_last_regenerate|i:1727168701;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('abc0rnhu5bui80rb970nu5fl4c7aomm5', '2a12:d280:100:51::', 1727067961, '__ci_last_regenerate|i:1727067961;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('abjrugj657al2egttprn2pfjs1iqmfi2', '2a12:d280:100:51::', 1727064301, '__ci_last_regenerate|i:1727064301;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('abpk2n76cgj5ubfbmahr80rneiavklrq', '2a12:d280:100:51::', 1727097542, '__ci_last_regenerate|i:1727097541;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ac7uohk84dde67k27nbanhm4igabeot6', '2a12:d280:100:51::', 1727084941, '__ci_last_regenerate|i:1727084941;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('acdq97numedi5g7kdu07frf3ea5m7kln', '2a12:d280:100:51::', 1727088241, '__ci_last_regenerate|i:1727088241;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('acg0ksf7vd4nfsron7eki4dd57roe69e', '2a12:d280:100:51::', 1727180521, '__ci_last_regenerate|i:1727180521;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ach3vdmrl9fg78hd1u8977c66aqnem97', '2a12:d280:100:51::', 1727144881, '__ci_last_regenerate|i:1727144881;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('acibqvvejo3os47fl2985c9iuq5a2935', '2a12:d280:100:51::', 1727076542, '__ci_last_regenerate|i:1727076542;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('acmievpc9cmseulk1ljo62diku4ui1eh', '2a12:d280:100:51::', 1727249881, '__ci_last_regenerate|i:1727249881;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('acoih0c9csgor0u7crps11vfui3s7i5p', '2a12:d280:100:51::', 1727268722, '__ci_last_regenerate|i:1727268722;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ad0vd9s2fv538v3t27keusgp06pkj6os', '2a12:d280:100:51::', 1727103902, '__ci_last_regenerate|i:1727103902;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ad5kdfr4hc609i4j0ephg0gfdohf0f05', '2a12:d280:100:51::', 1727068681, '__ci_last_regenerate|i:1727068681;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('adct4liepus0mteal31rra3q4ddvqg89', '2a12:d280:100:51::', 1727047741, '__ci_last_regenerate|i:1727047741;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ade6sphl9esijd3muu2c3j81fbclh8ld', '2a12:d280:100:51::', 1727287862, '__ci_last_regenerate|i:1727287862;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('adm9sohrk6pkm3imqr8e98pbaun344na', '2a12:d280:100:51::', 1727248802, '__ci_last_regenerate|i:1727248802;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('adnkisfv93205abjket3n6ooio1pb21h', '2a12:d280:100:51::', 1727151721, '__ci_last_regenerate|i:1727151721;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ae0sbm9v5of8j5o3e5ct6458s8q8k3cv', '2a12:d280:100:51::', 1727218201, '__ci_last_regenerate|i:1727218201;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ael58ukdkqe9r11aqqiu6r8kr4qd570e', '2a12:d280:100:51::', 1727053742, '__ci_last_regenerate|i:1727053742;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('afhuf1esc5fdpfiarhlaujinem4kn9fe', '2a12:d280:100:51::', 1727217002, '__ci_last_regenerate|i:1727217002;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('afoj86l486bri786t7jnmgvu0vsj9uji', '2a12:d280:100:51::', 1727261761, '__ci_last_regenerate|i:1727261761;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('afr6h2d25eii5mk22n1ha5g9m8btup6g', '2a12:d280:100:51::', 1727181002, '__ci_last_regenerate|i:1727181001;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('afse5ops54frn78av1snle7cfor4hg0b', '2a12:d280:100:51::', 1727254621, '__ci_last_regenerate|i:1727254621;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('afstgopchmgvr0maeb5tutht3r3vsfud', '2a12:d280:100:51::', 1727160782, '__ci_last_regenerate|i:1727160782;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ag70l14lhp909njnm8r5u48ovpf7i2c6', '2a12:d280:100:51::', 1727054521, '__ci_last_regenerate|i:1727054521;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ai2kij93g3co5s5ic3qcvft5lbj0ves7', '2a12:d280:100:51::', 1727210161, '__ci_last_regenerate|i:1727210161;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ai35al2msb26orflo6iplb4vcq5upjq4', '2a12:d280:100:51::', 1727056981, '__ci_last_regenerate|i:1727056981;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ai3vq94b8balrafcti9agcirp7u4o4de', '2a12:d280:100:51::', 1727199122, '__ci_last_regenerate|i:1727199122;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ai4cai0582mmghaf850ff6kv2tct795k', '192.145.39.244', 1727116654, '__ci_last_regenerate|i:1727116654;_prev_url|s:60:\"https://panel.blitconcept.es/admin/resourcebooking/booking/1\";staff_user_id|s:1:\"1\";staff_logged_in|b:1;setup-menu-open|b:1;');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('aj6dlp3ab2rk3vd4cmh9bpe4shevb6v9', '2a12:d280:100:51::', 1727232002, '__ci_last_regenerate|i:1727232002;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ajdsr0tdfs9j6icn18kushue9q2r66am', '2a12:d280:100:51::', 1727294402, '__ci_last_regenerate|i:1727294402;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ajhsbahv27mucah2c2kb3fumukfr5ft8', '2a12:d280:100:51::', 1727166301, '__ci_last_regenerate|i:1727166301;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ajo9ppjs9thrc5dc5pcvsv8a5mrchf4j', '2a12:d280:100:51::', 1727097182, '__ci_last_regenerate|i:1727097182;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ak68a4qvigafhv4tan7qd6nk09r1pmec', '2a12:d280:100:51::', 1727147882, '__ci_last_regenerate|i:1727147882;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('aks04qebuted8pu4v6n4jkl65ogjb1qq', '2a12:d280:100:51::', 1727197262, '__ci_last_regenerate|i:1727197262;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('al5u994f2up3sp5rq2gp4ovgc4a8408p', '2a12:d280:100:51::', 1727200802, '__ci_last_regenerate|i:1727200802;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('aldag0lqton5f6pen9autakvc4ks900m', '2a12:d280:100:51::', 1727085662, '__ci_last_regenerate|i:1727085662;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('alp5d84kh9b3ugjj6pio2lru75bd2o0s', '2a12:d280:100:51::', 1727118902, '__ci_last_regenerate|i:1727118901;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('alv756o8blh86hu2jjlms165ncjb1ia7', '2a12:d280:100:51::', 1727221142, '__ci_last_regenerate|i:1727221142;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('am1bcgi3gumr3jbo7hfrbig2vikvad5a', '2a12:d280:100:51::', 1727121541, '__ci_last_regenerate|i:1727121541;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('am6q23k6ej9o2es02u6p7og402jk97ks', '2a12:d280:100:51::', 1727157541, '__ci_last_regenerate|i:1727157541;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('amgig3u0d8tdsb3at4gak86e7nol9366', '2a12:d280:100:51::', 1727275742, '__ci_last_regenerate|i:1727275741;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('amgo9s89l04fh6uelb1iu0f608bl7309', '192.145.39.244', 1727112335, '__ci_last_regenerate|i:1727112335;_prev_url|s:67:\"https://panel.blitconcept.es/admin/resourcebooking/add_edit_booking\";staff_user_id|s:1:\"1\";staff_logged_in|b:1;setup-menu-open|s:0:\"\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('amloqc1g17ip1mu9svnlvl4evml0bob7', '2a12:d280:100:51::', 1727269922, '__ci_last_regenerate|i:1727269921;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ano623ckek6di3lbdblsh8sjq3u4vap4', '2a12:d280:100:51::', 1727190062, '__ci_last_regenerate|i:1727190061;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ao144cgtgeqd7rp4ofs545ur90qpnna2', '2a12:d280:100:51::', 1727286661, '__ci_last_regenerate|i:1727286661;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('aofc54dv9nvqevpi7hb73qe7d61751i7', '2a12:d280:100:51::', 1727082482, '__ci_last_regenerate|i:1727082482;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('aojdojms7kjjj3389kud69i5i09rtm4a', '2a12:d280:100:51::', 1727155381, '__ci_last_regenerate|i:1727155381;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('aopk9ko8o2guodd81i4hfvjvcl4qbf4b', '2a12:d280:100:51::', 1727178002, '__ci_last_regenerate|i:1727178002;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('aorg03sqkhrd6o6u9gmbl4n3ubfuacth', '2a12:d280:100:51::', 1727155621, '__ci_last_regenerate|i:1727155621;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('aoslcthcleeqqc73a63m1dvofm71bv74', '2a12:d280:100:51::', 1727187242, '__ci_last_regenerate|i:1727187242;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('aoup12m01l4k42ga5c5nij2drf7ukag7', '2a12:d280:100:51::', 1727266501, '__ci_last_regenerate|i:1727266501;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ap07ii2nllc1q193ceeeff3or83f1gkq', '2a12:d280:100:51::', 1727092622, '__ci_last_regenerate|i:1727092622;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ap4993bkrqt2fibmce3q029mr1n7ucrf', '2a12:d280:100:51::', 1727227861, '__ci_last_regenerate|i:1727227861;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ap9mvg67q9oki6sb2c5ktgf008ra1q5r', '2a12:d280:100:51::', 1727154661, '__ci_last_regenerate|i:1727154661;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('apaa4a6fa2lc14lsaciqiitinqtvef6i', '2a12:d280:100:51::', 1727188142, '__ci_last_regenerate|i:1727188142;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('apbfeec2ak063j62vje09j4jbbhdl4s8', '2a12:d280:100:51::', 1727053382, '__ci_last_regenerate|i:1727053382;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('apcfaad7hqpasqhln0tos9onui5n6g2k', '2a12:d280:100:51::', 1727270162, '__ci_last_regenerate|i:1727270162;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('apdc0hlsbpobo7p5hhnhg6h5u8dojr71', '2a12:d280:100:51::', 1727161682, '__ci_last_regenerate|i:1727161682;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('apusa1l5nlnekjrce2n11taag824il5r', '2a12:d280:100:51::', 1727115122, '__ci_last_regenerate|i:1727115122;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('aqa79qmp13n1i2fonatkncq0na5rp28n', '2a12:d280:100:51::', 1727074081, '__ci_last_regenerate|i:1727074081;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('aqanssc3osrulgt5lup0q2op4breai81', '2a12:d280:100:51::', 1727105461, '__ci_last_regenerate|i:1727105461;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('aqdmjlnotbquki3ujb50juprvaouuu0l', '2a12:d280:100:51::', 1727066761, '__ci_last_regenerate|i:1727066761;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('aqj37darqennseqnso859r7vil0cjoa1', '2a12:d280:100:51::', 1727251741, '__ci_last_regenerate|i:1727251741;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('aqko6geqamibkp3nper3oqfj8umhd3tl', '2a12:d280:100:51::', 1727142241, '__ci_last_regenerate|i:1727142241;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('aqt8mrldkg8ad8vbe0ev6glgojcraogq', '2a12:d280:100:51::', 1727277661, '__ci_last_regenerate|i:1727277661;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ar8ba5enn0a2gu7jocbv8oec5bdc76o3', '2a12:d280:100:51::', 1727265662, '__ci_last_regenerate|i:1727265661;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ar9puisa7snsd1bbbn4juj6e04kk5umd', '2a12:d280:100:51::', 1727070361, '__ci_last_regenerate|i:1727070361;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('arf4i828trglu4kvsaehl9l47detff3n', '2a12:d280:100:51::', 1727237702, '__ci_last_regenerate|i:1727237701;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('arklibukvh8nkfvcfjc6lepnfc1023dn', '2a12:d280:100:51::', 1727201941, '__ci_last_regenerate|i:1727201941;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('arr0cjjmb85gt4b8osmk82d3u26534vl', '2a12:d280:100:51::', 1727268481, '__ci_last_regenerate|i:1727268481;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('asf9pa5d6gi0k80kapvjq6hfdg7sm16n', '167.172.247.125', 1727059343, '__ci_last_regenerate|i:1727059343;red_url|s:29:\"https://panel.blitconcept.es/\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('atbdll2lnqh1rd2pjr2pqs0lbb4hnj7i', '2a12:d280:100:51::', 1727160001, '__ci_last_regenerate|i:1727160001;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ato48sesp1ctilqj0keq7l25uib8cbuo', '2a12:d280:100:51::', 1727200441, '__ci_last_regenerate|i:1727200441;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('atqrfdpooeth849fgi359d5gunhmcm9t', '54.86.66.252', 1727261453, '__ci_last_regenerate|i:1727261453;red_url|s:60:\"https://panel.blitconcept.es/admin/resourcebooking/booking/1\";_prev_url|s:49:\"https://panel.blitconcept.es/admin/authentication\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('au2hk8ic09uts14963rav7tv5lcnn2db', '2a12:d280:100:51::', 1727137622, '__ci_last_regenerate|i:1727137622;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('auas30c453pbve3qhgqagk9vfn0ldd02', '2a12:d280:100:51::', 1727267282, '__ci_last_regenerate|i:1727267282;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('aud36gn6vmqt30pb7j6vh1gr21mta4hr', '2a12:d280:100:51::', 1727126701, '__ci_last_regenerate|i:1727126701;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('auikod7lu0e48c2gdiovo367k30386gm', '2a12:d280:100:51::', 1727066162, '__ci_last_regenerate|i:1727066161;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('auofmlok6e79vvdlpq5dj0our1ppm2hp', '2a12:d280:100:51::', 1727236081, '__ci_last_regenerate|i:1727236081;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('auoono2ruog03iq49mkticnrsud85p7q', '2a12:d280:100:51::', 1727139121, '__ci_last_regenerate|i:1727139121;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('auufp4v5hojl2mm479arm4d23p46f25i', '2a12:d280:100:51::', 1727175421, '__ci_last_regenerate|i:1727175421;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('av33i68j2lvnfnnpjgi2tbdalqddbspb', '2a12:d280:100:51::', 1727133362, '__ci_last_regenerate|i:1727133362;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('av608sd97364jjq75cpfu9trhrnenb1v', '2a12:d280:100:51::', 1727165401, '__ci_last_regenerate|i:1727165401;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('av73d22otccp0arrvs9tcg0dvsf729c7', '2a12:d280:100:51::', 1727261221, '__ci_last_regenerate|i:1727261221;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('avfi2imel4eq2cqua21o47upn2ijhnv7', '2a12:d280:100:51::', 1727201461, '__ci_last_regenerate|i:1727201461;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('avie7j4ii89u9bdli6o2bvar3t5ueprv', '2a12:d280:100:51::', 1727243881, '__ci_last_regenerate|i:1727243881;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b04qrdncjuucq67plqkhoha6n768fr31', '2a12:d280:100:51::', 1727221621, '__ci_last_regenerate|i:1727221621;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b0tvcnca8559iec4o80m4sapjp94bk8u', '2a12:d280:100:51::', 1727138462, '__ci_last_regenerate|i:1727138462;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b171kbghcim6rj0n9kghjpfaccbutpcb', '2a12:d280:100:51::', 1727097061, '__ci_last_regenerate|i:1727097061;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b17q3tfn46p3b3d3c4qghbd9fkfqa64s', '2a12:d280:100:51::', 1727272202, '__ci_last_regenerate|i:1727272202;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b1ivftgk3nrbhduog3n9btpnctobcdel', '2a12:d280:100:51::', 1727221682, '__ci_last_regenerate|i:1727221682;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b1lf01jvbc6ucak2tobofan1f6218qpa', '2a12:d280:100:51::', 1727197501, '__ci_last_regenerate|i:1727197501;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b21p28n8s3ld9ut44tt1m9g059bc159t', '2a12:d280:100:51::', 1727094842, '__ci_last_regenerate|i:1727094841;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b24urbj5pet1tndpn3g016o787gvh4hr', '2a12:d280:100:51::', 1727246522, '__ci_last_regenerate|i:1727246522;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b2dreo9b6o38ram02ur1pb7j1fkgfhc7', '2a12:d280:100:51::', 1727257621, '__ci_last_regenerate|i:1727257621;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b2s0b4h15kgdvch9lv8ivfmu3o8hjekg', '2a12:d280:100:51::', 1727053561, '__ci_last_regenerate|i:1727053561;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b3avbtvtugbpn3ir57kphaj92mo253e4', '2a12:d280:100:51::', 1727167502, '__ci_last_regenerate|i:1727167502;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b3nuct793ar9rn14aa8efesf4mthu6j3', '2a12:d280:100:51::', 1727131021, '__ci_last_regenerate|i:1727131021;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b4gcqmi3ubtbndc1rv65ineafd7ba5l0', '2a12:d280:100:51::', 1727266862, '__ci_last_regenerate|i:1727266862;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b4kpotfmhik5aml27btit40ghb9dc9bp', '2a12:d280:100:51::', 1727193841, '__ci_last_regenerate|i:1727193841;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b4m6iqeu7fbttdiubrveaaalttu5hjn4', '2a12:d280:100:51::', 1727060162, '__ci_last_regenerate|i:1727060162;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b4onp4bcqlchvgp264aru03uhhe7049r', '2a12:d280:100:51::', 1727160902, '__ci_last_regenerate|i:1727160902;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b55ki3kvigu6fb3u3rmgvqnkeqktm6e1', '2a12:d280:100:51::', 1727232301, '__ci_last_regenerate|i:1727232301;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b5qifk6aqfq317rmli5phee6pk2heirt', '2a12:d280:100:51::', 1727183101, '__ci_last_regenerate|i:1727183101;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b604piqka4qhpo1iupin5ib8ueucui2n', '2a12:d280:100:51::', 1727263681, '__ci_last_regenerate|i:1727263681;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b60kdsk3f4hj4mlsmpsg9ginchmlo4gi', '2a12:d280:100:51::', 1727063821, '__ci_last_regenerate|i:1727063821;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b6gfdt923j1kcd3ctoo58ahsrvbdf6vc', '2a12:d280:100:51::', 1727078041, '__ci_last_regenerate|i:1727078041;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b6n0n7294khp60v5l6la1rk424d8r1de', '2a12:d280:100:51::', 1727274241, '__ci_last_regenerate|i:1727274241;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b6o92om4jvuedp85g71dn7to40qr76eb', '2a12:d280:100:51::', 1727140081, '__ci_last_regenerate|i:1727140081;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b6vfnhjsf05m9dr9392g7dqkd4qati96', '2a12:d280:100:51::', 1727144821, '__ci_last_regenerate|i:1727144821;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b706q17k5s1abouhcenlkrsc8trks92u', '2a12:d280:100:51::', 1727130841, '__ci_last_regenerate|i:1727130841;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b73k9rc0l6av8neik0pid4qdfemlbvau', '2a12:d280:100:51::', 1727223002, '__ci_last_regenerate|i:1727223002;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b7crfsvgfnt0g6pii215purtgfr7td16', '2a12:d280:100:51::', 1727078701, '__ci_last_regenerate|i:1727078701;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b81gp5f4nchmct4kobkivunlpoqlu73a', '2a12:d280:100:51::', 1727078762, '__ci_last_regenerate|i:1727078762;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b88mdu7v414hsdp4o7vvieqt3dkmdni6', '2a12:d280:100:51::', 1727087402, '__ci_last_regenerate|i:1727087402;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b8ebvahqejakqqphpbe1b26t4j7lp3dl', '2a12:d280:100:51::', 1727262061, '__ci_last_regenerate|i:1727262061;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b8f5m26915250l8rvp3lb9r52qfh63im', '2a12:d280:100:51::', 1727114042, '__ci_last_regenerate|i:1727114042;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b941glpuo6d7ql9ltaqb2nl7rtnhf627', '2a12:d280:100:51::', 1727131322, '__ci_last_regenerate|i:1727131322;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b94fld229mtn73e3fi57hivau6deacqp', '2a12:d280:100:51::', 1727211842, '__ci_last_regenerate|i:1727211842;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b9837f1src5nebef6muqb4orbijd7qa9', '2a12:d280:100:51::', 1727258222, '__ci_last_regenerate|i:1727258222;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b9gkutvqjbe40rfaldbjqqckpon6jgas', '2a12:d280:100:51::', 1727176982, '__ci_last_regenerate|i:1727176982;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ba98lhkgv9mq8176kmck8tttosnuomqh', '2a12:d280:100:51::', 1727074261, '__ci_last_regenerate|i:1727074261;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('babk8un7p13gvfv4vq85sholfdcg7lv1', '2a12:d280:100:51::', 1727284202, '__ci_last_regenerate|i:1727284201;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bacf1hqcrc9nc65v6o4gikt5bgabg6be', '2a12:d280:100:51::', 1727198221, '__ci_last_regenerate|i:1727198221;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('basiu0u1jj7uib8t1qip8jlmfids9pdj', '2a12:d280:100:51::', 1727263441, '__ci_last_regenerate|i:1727263441;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bbf5sh1fkf2oeo8j68sej33lfjgfro9h', '2a12:d280:100:51::', 1727231521, '__ci_last_regenerate|i:1727231521;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bbr2afn9pih8vo5glpab9hcbcerehnec', '2a12:d280:100:51::', 1727213341, '__ci_last_regenerate|i:1727213341;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bc8fmu7i8qnbifg65t5hvmi8ov8dhov3', '2a12:d280:100:51::', 1727205362, '__ci_last_regenerate|i:1727205362;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bcl6d42davmu129pe7hvu369hm3k2tgo', '2a12:d280:100:51::', 1727223901, '__ci_last_regenerate|i:1727223901;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bd1i7gseo420t9610s0hl1nqs00h6cc8', '2a12:d280:100:51::', 1727229602, '__ci_last_regenerate|i:1727229601;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bd86goko4k1an66je7ug9v9qqrq15p9d', '2a12:d280:100:51::', 1727227321, '__ci_last_regenerate|i:1727227321;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bdcmou0hc3ipq1j51hbcno9fv14jjrrs', '2a12:d280:100:51::', 1727208661, '__ci_last_regenerate|i:1727208661;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bdigjgpukeu72bqk7nbmnhtj92v200td', '2a12:d280:100:51::', 1727076361, '__ci_last_regenerate|i:1727076361;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('be192d98vf5hd3is50bg85rvlm8jk7js', '2a12:d280:100:51::', 1727076721, '__ci_last_regenerate|i:1727076721;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('be25a58718k8m3fi934o2fk2i3aagoip', '2a12:d280:100:51::', 1727132581, '__ci_last_regenerate|i:1727132581;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('be34ja5ojpe74err12dteqehel65m0q5', '2a12:d280:100:51::', 1727171221, '__ci_last_regenerate|i:1727171221;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('beka2j6rb4dnc9kspokn0islc6enur3c', '2a12:d280:100:51::', 1727092322, '__ci_last_regenerate|i:1727092322;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('beskukv0f7kjh15ahac36hils0nsdq7l', '2a12:d280:100:51::', 1727244062, '__ci_last_regenerate|i:1727244061;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bf77qnoltcmbum6sjlhmou82es6o1ucj', '2a12:d280:100:51::', 1727280181, '__ci_last_regenerate|i:1727280181;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bf9vam59pb26rkbc4dbej2fri7b8rsnn', '2a12:d280:100:51::', 1727198341, '__ci_last_regenerate|i:1727198341;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bfcom7snna594frq54sl401tsi37mavu', '2a12:d280:100:51::', 1727060701, '__ci_last_regenerate|i:1727060701;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bfi2pjn25mgm9rmirseb9k2i1ukqev76', '2a12:d280:100:51::', 1727194081, '__ci_last_regenerate|i:1727194081;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bfv2r8s48caavdro8bl3r42eoaq7grbg', '2a12:d280:100:51::', 1727047621, '__ci_last_regenerate|i:1727047621;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bg1n575ehdj8bf6hvimff9o1e00p37u5', '2a12:d280:100:51::', 1727069162, '__ci_last_regenerate|i:1727069162;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bg2gq2lcsp6991pulr4pkdv1m62j4672', '2a12:d280:100:51::', 1727278082, '__ci_last_regenerate|i:1727278082;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bg81edeojmag9nbv6vkk2fbvhsfvm4a2', '2a12:d280:100:51::', 1727071621, '__ci_last_regenerate|i:1727071621;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bgamohp8qeqqgpngq9tqk7qe730p7veg', '2a12:d280:100:51::', 1727237281, '__ci_last_regenerate|i:1727237281;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bgllto1vpj33u5638e40st2vcc80fn2f', '2a12:d280:100:51::', 1727211181, '__ci_last_regenerate|i:1727211181;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bgo0vei1sfq84943apo8ohkfjjekek9r', '2a12:d280:100:51::', 1727059142, '__ci_last_regenerate|i:1727059141;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bgr0ivg87sbkm7k8uoq72bpotp2gv2vf', '2a12:d280:100:51::', 1727165521, '__ci_last_regenerate|i:1727165521;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bgt2nmt7sn215rrq96rqnncggqg8doev', '54.175.74.27', 1727259334, '__ci_last_regenerate|i:1727259333;red_url|s:68:\"https://panel.blitconcept.es/admin/modules/activate/account_balances\";_prev_url|s:49:\"https://panel.blitconcept.es/admin/authentication\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bhc0t5glhh7punkfplmmqtais9dsv96j', '2a12:d280:100:51::', 1727147341, '__ci_last_regenerate|i:1727147341;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bhfd58tkbgci1bhvb6me2g85bfa9vkl5', '2a12:d280:100:51::', 1727068561, '__ci_last_regenerate|i:1727068561;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bhl2u73k8g36g14ra9rtpnghvott4tet', '2a12:d280:100:51::', 1727156221, '__ci_last_regenerate|i:1727156221;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bhnigp6jbhqol7cs2tsa7klsrp6fdlng', '2a12:d280:100:51::', 1727072161, '__ci_last_regenerate|i:1727072161;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bhp4moiumd49bbpu296vi2ocq5cq6oiq', '2a12:d280:100:51::', 1727072102, '__ci_last_regenerate|i:1727072102;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bijunvijk8qa80nr0k6ftdpqc3tka524', '2a12:d280:100:51::', 1727255042, '__ci_last_regenerate|i:1727255041;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('biqljpfcjdhli1nud9n1hjmjk7rm1bga', '2a12:d280:100:51::', 1727188081, '__ci_last_regenerate|i:1727188081;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bj0n29ju2h8imffe6mf22tqtcjfuc7tc', '2a12:d280:100:51::', 1727226842, '__ci_last_regenerate|i:1727226842;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bj74d46sha7qce2gdqs4900hq7fdcnm7', '2a12:d280:100:51::', 1727116921, '__ci_last_regenerate|i:1727116921;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bjef372d4mjeohmfeo0npkl2ru7e1msr', '2a12:d280:100:51::', 1727116442, '__ci_last_regenerate|i:1727116441;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bjgspnbe68t8kvhmpvgh2q8lgrsk5qfk', '2a12:d280:100:51::', 1727167981, '__ci_last_regenerate|i:1727167981;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bjngt6kcop7d5rjgq9u9s9jov7gq64hg', '2a12:d280:100:51::', 1727080262, '__ci_last_regenerate|i:1727080262;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bjrg1fghsmnceov2mcco2c505a5022f1', '2a12:d280:100:51::', 1727045881, '__ci_last_regenerate|i:1727045881;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bjtrjd4972vdc0ol3strj59hvjnpsj8l', '2a12:d280:100:51::', 1727172421, '__ci_last_regenerate|i:1727172421;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bk2m6ll1nbmk7rt9365a4ktvvvljtp7s', '2a12:d280:100:51::', 1727176022, '__ci_last_regenerate|i:1727176022;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bk3eh0334mm38jr1qvo508n4obfipi39', '2a12:d280:100:51::', 1727139181, '__ci_last_regenerate|i:1727139181;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bkimejm57ak30cmds1p4p7jtdqken7on', '2a12:d280:100:51::', 1727243282, '__ci_last_regenerate|i:1727243282;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bko43r819n935me3o29l20g7o294qbjs', '2a12:d280:100:51::', 1727158442, '__ci_last_regenerate|i:1727158442;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bkrocf0go3l1aagrmb09gke0uuif8t50', '2a12:d280:100:51::', 1727241841, '__ci_last_regenerate|i:1727241841;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bldjtd90ienmrpsg9hnhu5k4b7oj6fl4', '2a12:d280:100:51::', 1727167261, '__ci_last_regenerate|i:1727167261;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('blgcjmdab9gj2v8gl2q3md5tg4lv23l3', '2a12:d280:100:51::', 1727200021, '__ci_last_regenerate|i:1727200021;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('blrk1bepihdf1fo6bqtpgar42ehpa1gd', '2a12:d280:100:51::', 1727050022, '__ci_last_regenerate|i:1727050022;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bm9e4mi9nloln5vo05k6ppqt2sobo2de', '2a12:d280:100:51::', 1727282041, '__ci_last_regenerate|i:1727282041;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bmguj6ideh67h0dhjsc4qf8fp91cve31', '192.145.39.244', 1727112708, '__ci_last_regenerate|i:1727112708;_prev_url|s:60:\"https://panel.blitconcept.es/admin/resourcebooking/booking/2\";staff_user_id|s:1:\"1\";staff_logged_in|b:1;setup-menu-open|s:0:\"\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bmkm8710j5fh2qnspnoskbl23fjvu2ah', '2a12:d280:100:51::', 1727181541, '__ci_last_regenerate|i:1727181541;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bmsj6bs1pakr249algkh19la657f5176', '2a12:d280:100:51::', 1727268002, '__ci_last_regenerate|i:1727268001;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bmuubg8oi395feupef51pnq2r9rp8d4l', '2a12:d280:100:51::', 1727190182, '__ci_last_regenerate|i:1727190181;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bmvdmkvu2igoe24q3rhiov2cm6r8er01', '2a12:d280:100:51::', 1727170862, '__ci_last_regenerate|i:1727170862;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bnh5j8adrocalcf0as04l4icmvagq8nq', '2a12:d280:100:51::', 1727058302, '__ci_last_regenerate|i:1727058302;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bobfs3uhu0eq4sg1i2hu6jipb40tlasv', '2a12:d280:100:51::', 1727259422, '__ci_last_regenerate|i:1727259422;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bogsm5l6vouer04hbjf354v7db0jribg', '2a12:d280:100:51::', 1727275622, '__ci_last_regenerate|i:1727275622;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bopoqa0su3jpg1cuni8rpcgb3cscbh68', '2a12:d280:100:51::', 1727127422, '__ci_last_regenerate|i:1727127422;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bpktkr8blu7di9shbu634irrctnb1n1m', '184.72.121.156', 1727248028, '__ci_last_regenerate|i:1727248027;red_url|s:67:\"https://panel.blitconcept.es/admin/resourcebooking/add_edit_booking\";_prev_url|s:49:\"https://panel.blitconcept.es/admin/authentication\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bpv4a24u3v1er1n2p3kdbq2tgjg2jv0q', '2a12:d280:100:51::', 1727102523, '__ci_last_regenerate|i:1727102523;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bq45mn9e2nktaln7lds0mebpi6i7t012', '2a12:d280:100:51::', 1727145241, '__ci_last_regenerate|i:1727145241;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bq8pb7ni7o37p34hfnlu4f88hn3u2hdq', '2a12:d280:100:51::', 1727233202, '__ci_last_regenerate|i:1727233202;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bqiekqph50r5rhbuf9a3b6qp4pr9uhfj', '2a12:d280:100:51::', 1727071981, '__ci_last_regenerate|i:1727071981;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bqqei018bgmdj0kquklmmp50n2jchlvo', '2a12:d280:100:51::', 1727068021, '__ci_last_regenerate|i:1727068021;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bqvrfkviltrir10jurnj2tvaca16olpv', '2a12:d280:100:51::', 1727293141, '__ci_last_regenerate|i:1727293141;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('br1qos37055qu28efk0ikdesogcmtdfr', '2a12:d280:100:51::', 1727244542, '__ci_last_regenerate|i:1727244542;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('br432cehm50gq2524ju6jgb7akq1fh28', '2a12:d280:100:51::', 1727121781, '__ci_last_regenerate|i:1727121781;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('br93fav0nn869srmsoatfguag67t75as', '2a12:d280:100:51::', 1727198881, '__ci_last_regenerate|i:1727198881;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('brda1gmlardt8q0es2db9ca4sce8aq86', '2a12:d280:100:51::', 1727244481, '__ci_last_regenerate|i:1727244481;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('brev0eam0fk8j4q1b1ahhaom4kp9r48f', '2a12:d280:100:51::', 1727182021, '__ci_last_regenerate|i:1727182021;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('brfs9vi68vv91n8f5im9893dp78tfao7', '2a12:d280:100:51::', 1727188382, '__ci_last_regenerate|i:1727188382;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('brooap7jlu4ufklsp3f6pmnoohdph9tt', '2a12:d280:100:51::', 1727236681, '__ci_last_regenerate|i:1727236681;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('brti0uugc5v7gm7cko51bf8uflnce9gb', '2a12:d280:100:51::', 1727290202, '__ci_last_regenerate|i:1727290201;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bsu1bn95h0ljb27ni6n9dmqi7t3dq99a', '2a12:d280:100:51::', 1727050202, '__ci_last_regenerate|i:1727050202;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bsuctuj0654uhlnvdlnqc8nh439piujk', '2a12:d280:100:51::', 1727109661, '__ci_last_regenerate|i:1727109661;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bt8h6f0uq1khkr47sg41hbbtv8d6jrqk', '2a12:d280:100:51::', 1727116861, '__ci_last_regenerate|i:1727116861;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('btjgj2ght5n2ee1u11k64o146pcv99ja', '2a12:d280:100:51::', 1727252882, '__ci_last_regenerate|i:1727252882;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('btqoh5pj02soib0l8r43pikduhc859a0', '2a12:d280:100:51::', 1727051761, '__ci_last_regenerate|i:1727051761;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bu9mb8uq3jh0g1sc28v2bgk9k2vmhrj5', '2a12:d280:100:51::', 1727155801, '__ci_last_regenerate|i:1727155801;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('buluc8fb3ics4gq34c1dd6hf2emalokb', '2a12:d280:100:51::', 1727189701, '__ci_last_regenerate|i:1727189701;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bv08jrjt57snuo24vjkholmugrli06k5', '2a12:d280:100:51::', 1727061842, '__ci_last_regenerate|i:1727061842;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bvetp74amsqnuirl4vnm6gd0iv11n6vq', '2a12:d280:100:51::', 1727053441, '__ci_last_regenerate|i:1727053441;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bvfja2nrf3k97n45smqe3hgku9iaqki8', '2a12:d280:100:51::', 1727139001, '__ci_last_regenerate|i:1727139001;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bvpacbg3umvmgjta9g09uag1bk82qnlm', '2a12:d280:100:51::', 1727251502, '__ci_last_regenerate|i:1727251502;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bvr25onh1prldbk5hp8h856vefql4q8t', '2a12:d280:100:51::', 1727292662, '__ci_last_regenerate|i:1727292662;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c02el6tsa1tdo2q1c1pursa3gp6v12pn', '2a12:d280:100:51::', 1727096521, '__ci_last_regenerate|i:1727096521;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c0lfcfpnihl06hgr7kb3kki98h9mro39', '2a12:d280:100:51::', 1727096942, '__ci_last_regenerate|i:1727096941;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c0uij1mtcl8vsor06fe55rotfm0l8vld', '2a12:d280:100:51::', 1727076301, '__ci_last_regenerate|i:1727076301;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c1p43qucv7op36rn295nj88morf4o66p', '2a12:d280:100:51::', 1727289841, '__ci_last_regenerate|i:1727289841;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c1q6rpkg3hdv8tcafddonb4ahg0tf5tf', '2a12:d280:100:51::', 1727098202, '__ci_last_regenerate|i:1727098202;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c1sfluntrp683had3ll3l2n6aavvitrf', '2a12:d280:100:51::', 1727112422, '__ci_last_regenerate|i:1727112422;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c1tshru8rc0tpn947sjbutkr8u19fosk', '2a12:d280:100:51::', 1727278561, '__ci_last_regenerate|i:1727278561;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c20o8p3409rs404ftns19618qonuunp2', '2a12:d280:100:51::', 1727110682, '__ci_last_regenerate|i:1727110681;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c21k5ffqunq41jn85ramfu1vh81njmko', '2a12:d280:100:51::', 1727197982, '__ci_last_regenerate|i:1727197982;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c21uho89nqovu2pbkt5i5g0671o44lpb', '2a12:d280:100:51::', 1727164682, '__ci_last_regenerate|i:1727164682;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c22lmrmsoccvn53tdts9g4o1898n7rn6', '2a12:d280:100:51::', 1727151782, '__ci_last_regenerate|i:1727151782;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c2b8m13kgq62sp5ohjh5j61dpk6ott64', '2a12:d280:100:51::', 1727100062, '__ci_last_regenerate|i:1727100062;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c2ft5n0tsao50ste13iulptjvjbmrc9a', '2a12:d280:100:51::', 1727283962, '__ci_last_regenerate|i:1727283962;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c2nedr0j3dcne7ct68kkobk2jueht880', '2a12:d280:100:51::', 1727236741, '__ci_last_regenerate|i:1727236741;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c3bdc9i44eivllntlps26je8pvrv40nd', '2a12:d280:100:51::', 1727186882, '__ci_last_regenerate|i:1727186882;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c3bffp2f77f6a84jv50tvhk364qecgo7', '2a12:d280:100:51::', 1727056861, '__ci_last_regenerate|i:1727056861;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c3h0godf99uovjfklof874virqqk6o0i', '2a12:d280:100:51::', 1727250661, '__ci_last_regenerate|i:1727250661;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c3k16ipa7dm6v5rh9anqilmhu0fmnaho', '2a12:d280:100:51::', 1727238782, '__ci_last_regenerate|i:1727238782;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c3mj9bsvjf2chjvhfcjnhd8rq5jhfijf', '2a12:d280:100:51::', 1727251621, '__ci_last_regenerate|i:1727251621;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c3qlmld4f9n1bim37317r2jh7oiapjfb', '2a12:d280:100:51::', 1727259482, '__ci_last_regenerate|i:1727259482;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c45520jp3lqvd7anp7c734bgoecmsg3j', '2a12:d280:100:51::', 1727272082, '__ci_last_regenerate|i:1727272082;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c4558u2tr6pn3jiq5ldsphpdfivhdhga', '2a12:d280:100:51::', 1727079122, '__ci_last_regenerate|i:1727079122;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c45u642kkb2m9fmstojd5pgugvpr60kr', '2a12:d280:100:51::', 1727210582, '__ci_last_regenerate|i:1727210582;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c4lh1ddorn5np5cqulg2po3s9r5cga4s', '2a12:d280:100:51::', 1727084101, '__ci_last_regenerate|i:1727084101;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c4muoj93rn5qcep2d92lpb3hmhb1jjt4', '2a12:d280:100:51::', 1727065562, '__ci_last_regenerate|i:1727065562;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c50ttu7k2hojkru4v87dcqo1i3u7fqvs', '2a12:d280:100:51::', 1727054221, '__ci_last_regenerate|i:1727054221;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c571s5o0n5m437gtnts70s0og3c9qiq9', '2a12:d280:100:51::', 1727216461, '__ci_last_regenerate|i:1727216461;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c5f6ttbln4luel0ufr2t4atti1vnuk51', '2a12:d280:100:51::', 1727184061, '__ci_last_regenerate|i:1727184061;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c5muki4jvgqd63bdhgjkok61c1qmn2i3', '2a12:d280:100:51::', 1727069042, '__ci_last_regenerate|i:1727069042;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c627lqqdln3mfe52n0tj78p5dr46gacp', '2a12:d280:100:51::', 1727210702, '__ci_last_regenerate|i:1727210702;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c6psj2eci46kirtr5s75cgbjcjs2m4kk', '2a12:d280:100:51::', 1727260261, '__ci_last_regenerate|i:1727260261;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c6rucunkimc8vdqaufaks5tj08lmjo99', '2a12:d280:100:51::', 1727182682, '__ci_last_regenerate|i:1727182682;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c6vlb5j4bks01l76sp3vke3igamgu1gk', '2a12:d280:100:51::', 1727055241, '__ci_last_regenerate|i:1727055241;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c6vvrt90bl08u0mctkjhs5fi3og5idoa', '2a12:d280:100:51::', 1727287081, '__ci_last_regenerate|i:1727287081;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c73u3dukt8sctvrhi6bnae94mhmcrjv8', '2a12:d280:100:51::', 1727284562, '__ci_last_regenerate|i:1727284562;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c7ok6ma4aeda9ajqbn7j63l0q7rube8o', '2a12:d280:100:51::', 1727188561, '__ci_last_regenerate|i:1727188561;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c7vcj4f43enle2iq6pkduc0rkedj4r3c', '2a12:d280:100:51::', 1727249341, '__ci_last_regenerate|i:1727249341;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c8b7u1poc84jdqhcfmgf1d96hdiuo2mf', '2a12:d280:100:51::', 1727271361, '__ci_last_regenerate|i:1727271361;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c8csnklts2blk55k8ted85efpbsbre41', '2a12:d280:100:51::', 1727274302, '__ci_last_regenerate|i:1727274302;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c99phppvk65142ioh5qt16919aeahnkv', '2a12:d280:100:51::', 1727059562, '__ci_last_regenerate|i:1727059561;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c9c4al0eb3b6qgdn6hbb56mjm1fta64j', '2a12:d280:100:51::', 1727259781, '__ci_last_regenerate|i:1727259781;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c9nco8ok5ip2fhatgpejh9vkp6nf39i3', '2a12:d280:100:51::', 1727275982, '__ci_last_regenerate|i:1727275982;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c9occr08itugju6gr9jpb105n7fn7u04', '2a12:d280:100:51::', 1727080742, '__ci_last_regenerate|i:1727080742;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c9v161gmtht7non5nef4at16vjs4e5k1', '2a12:d280:100:51::', 1727073602, '__ci_last_regenerate|i:1727073602;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ca474ofmkac4ms7d9ta56la7vg64hq07', '2a12:d280:100:51::', 1727253241, '__ci_last_regenerate|i:1727253241;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ca4lfnljveshpc7kd2n05kai5t5u87ar', '2a12:d280:100:51::', 1727103603, '__ci_last_regenerate|i:1727103602;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cablf6r6cp6oi6utkuuo21uhhpcmp0lu', '2a12:d280:100:51::', 1727286541, '__ci_last_regenerate|i:1727286541;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('capp0hh2h8t7k53dpl9tcg03mu7vucjc', '2a12:d280:100:51::', 1727244782, '__ci_last_regenerate|i:1727244782;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('carjt4i6uhe56rthec9qd01td0214rvl', '2a12:d280:100:51::', 1727242681, '__ci_last_regenerate|i:1727242681;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cb0880435fqm2bbk6lnc5ut4m6jmvqja', '2a12:d280:100:51::', 1727137322, '__ci_last_regenerate|i:1727137322;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cb1ee9guelq5ictpjq8edatg3baecj23', '2a12:d280:100:51::', 1727075162, '__ci_last_regenerate|i:1727075162;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cb71f40egf8cggablb5hc3vi10ejnko3', '2a12:d280:100:51::', 1727294521, '__ci_last_regenerate|i:1727294521;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cbdgdp8ab9vnje2k2pb7qqet48ediebg', '2a12:d280:100:51::', 1727098443, '__ci_last_regenerate|i:1727098441;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cbi0rf6jlehj38kg53fqm7crdac9ml7u', '2a12:d280:100:51::', 1727148541, '__ci_last_regenerate|i:1727148541;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ccgpftt5ngmsrauisjt78q1amhngbcai', '2a12:d280:100:51::', 1727072881, '__ci_last_regenerate|i:1727072881;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cclo57ti27h9p2t6a687p85u83532ppm', '2a12:d280:100:51::', 1727073902, '__ci_last_regenerate|i:1727073901;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ccoiqksihisd75l59en7h2h1618hot6j', '2a12:d280:100:51::', 1727153881, '__ci_last_regenerate|i:1727153881;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ccri3l3mjkemep94aek2oka3s27lcsk4', '2a12:d280:100:51::', 1727276701, '__ci_last_regenerate|i:1727276701;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cd6otdo1fl6g643mot35l3nbm8t9qlgq', '2a12:d280:100:51::', 1727257261, '__ci_last_regenerate|i:1727257261;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cdb88vlvogmmnt465mbg7767cqrtjtpv', '2a12:d280:100:51::', 1727209742, '__ci_last_regenerate|i:1727209742;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cdes5h6ug2prkbp2nvr7thmv7s7l85of', '2a12:d280:100:51::', 1727143741, '__ci_last_regenerate|i:1727143741;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cds7g5jivkgpduvb3g0cs0lb28u0h3k6', '2a12:d280:100:51::', 1727169002, '__ci_last_regenerate|i:1727169002;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ce438af862oltlrbpijn9mh6sreglge2', '2a12:d280:100:51::', 1727276102, '__ci_last_regenerate|i:1727276101;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ceempbacrvrvam6u5rpo58kgbht77mr0', '2a12:d280:100:51::', 1727244961, '__ci_last_regenerate|i:1727244961;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ceqoe5qn24kkeq7rfptdecnvf7fcj50s', '2a12:d280:100:51::', 1727101862, '__ci_last_regenerate|i:1727101861;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cf0e4as4v06no51elnbqsqt0v9rka1b4', '2a12:d280:100:51::', 1727182562, '__ci_last_regenerate|i:1727182562;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cf36emc959fhugkml9m02uno6braiku0', '2a12:d280:100:51::', 1727047981, '__ci_last_regenerate|i:1727047981;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cf4rqf13mqe7ti39sdgr1upr67nb3p8f', '2a12:d280:100:51::', 1727295481, '__ci_last_regenerate|i:1727295481;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cfefto3l4ipgo2r1gj08edfupe8a4ak5', '2a12:d280:100:51::', 1727220662, '__ci_last_regenerate|i:1727220662;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cfm8p1et2beoj79cqt417rt7cid6p6id', '2a12:d280:100:51::', 1727086022, '__ci_last_regenerate|i:1727086022;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cfpienan6v1ckr15iuv1pquem12hokgp', '2a12:d280:100:51::', 1727146381, '__ci_last_regenerate|i:1727146381;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cg1g16398kmpl8ngqidc6va4em6nsjk2', '2a12:d280:100:51::', 1727151422, '__ci_last_regenerate|i:1727151422;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cg6hfg71e6slmjrg43s3udf7bi4opb00', '2a12:d280:100:51::', 1727218982, '__ci_last_regenerate|i:1727218982;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cgbcat51ublsfbho5ojq3av4i9gfs7fu', '2a12:d280:100:51::', 1727268842, '__ci_last_regenerate|i:1727268842;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cgenoppbue61q7ga6punmb0o12ij1f7h', '2a12:d280:100:51::', 1727212022, '__ci_last_regenerate|i:1727212022;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cgqhcogqovkqf1pm04qmandb4m9fmhsi', '2a12:d280:100:51::', 1727188741, '__ci_last_regenerate|i:1727188741;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ch9ohb1qfpv31hsun7e7keoc74gj2f37', '2a12:d280:100:51::', 1727239501, '__ci_last_regenerate|i:1727239501;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cha1dt4pr65psg6skpvkii46clvmghvb', '2a12:d280:100:51::', 1727211601, '__ci_last_regenerate|i:1727211601;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('chg65tvr94lar1hsvcbjapvaohnsgv6v', '2a12:d280:100:51::', 1727211781, '__ci_last_regenerate|i:1727211781;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('chms425609mekp37teadeaugn42knb4k', '2a12:d280:100:51::', 1727227381, '__ci_last_regenerate|i:1727227381;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ci298i6e1alvdcur8trt0q3n4ioh5r27', '2a12:d280:100:51::', 1727280421, '__ci_last_regenerate|i:1727280421;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ci8lja3rvhbuba78hdr4d0shn0buu2pe', '2a12:d280:100:51::', 1727267041, '__ci_last_regenerate|i:1727267041;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cim6mkmf18otrs1daf57rbcv5j80e6vk', '2a12:d280:100:51::', 1727196841, '__ci_last_regenerate|i:1727196841;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cj0lclhj041l92abmgre2kcdsq3g9ph2', '2a12:d280:100:51::', 1727173622, '__ci_last_regenerate|i:1727173622;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cj78nsu71e9k60bt1i7jdce56unih5qq', '2a12:d280:100:51::', 1727065381, '__ci_last_regenerate|i:1727065381;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cjcfbt4n8lj921vm23tg8kb60dl9tfjv', '2a12:d280:100:51::', 1727241721, '__ci_last_regenerate|i:1727241721;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ck5vpds0qt4s1el3e1iqub6e2k0hcboa', '2a12:d280:100:51::', 1727216642, '__ci_last_regenerate|i:1727216642;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ck872q815ttj0qpf6pgrq7nc8bo9ofvq', '2a12:d280:100:51::', 1727106541, '__ci_last_regenerate|i:1727106541;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ckp1i294v8pfvb03q0sdhpp74ovhu0ta', '2a12:d280:100:51::', 1727198461, '__ci_last_regenerate|i:1727198461;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ckti4gcs8gk1hf936klp4eq2tp1r9155', '2a12:d280:100:51::', 1727160721, '__ci_last_regenerate|i:1727160721;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cl24grphsuo57833mesu2scl4kttl4r2', '2a12:d280:100:51::', 1727166902, '__ci_last_regenerate|i:1727166902;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cl4hk8g2soak06t2j9t9p9k8s88dal6b', '2a12:d280:100:51::', 1727122262, '__ci_last_regenerate|i:1727122262;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cl6mokv4h290stuer2r0si90se5oqvgv', '2a12:d280:100:51::', 1727275921, '__ci_last_regenerate|i:1727275921;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cl76829jfh2k473946b0322rhphpdurn', '2a12:d280:100:51::', 1727231401, '__ci_last_regenerate|i:1727231401;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('clh5hju21flt57k5o68ma3j68v5bgm8r', '2a12:d280:100:51::', 1727059321, '__ci_last_regenerate|i:1727059321;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('clhoo2em5erilkkpmlqqf2aahivb4da1', '2a12:d280:100:51::', 1727100662, '__ci_last_regenerate|i:1727100662;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cm00bc25kh5tcjqts8rm6atsk55am96g', '2a12:d280:100:51::', 1727130542, '__ci_last_regenerate|i:1727130542;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cm40o307b81i5ntc1mb09f40o4bc6epb', '2a12:d280:100:51::', 1727138942, '__ci_last_regenerate|i:1727138942;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cm9o6kakdektohoelfl4ne2in0t6lumc', '2a12:d280:100:51::', 1727089982, '__ci_last_regenerate|i:1727089982;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cmpmt690mriatepqd66gnes9gor8jcdo', '2a12:d280:100:51::', 1727129761, '__ci_last_regenerate|i:1727129761;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cms6k20ckscbsep254lgatg28h7v5pi6', '2a12:d280:100:51::', 1727126762, '__ci_last_regenerate|i:1727126762;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cn7o7rg1nc6s7mdd982ed833fr1ft3ld', '2a12:d280:100:51::', 1727131381, '__ci_last_regenerate|i:1727131381;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cndd988paksn7kf3pvjpvvnh679jb3ld', '2a12:d280:100:51::', 1727084702, '__ci_last_regenerate|i:1727084702;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cnndisme6i8ujo4hib0kkceuoftrl50k', '2a12:d280:100:51::', 1727258101, '__ci_last_regenerate|i:1727258101;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cnutok4jbi8cl1djo0rmrvmbo7ikor5v', '2a12:d280:100:51::', 1727206802, '__ci_last_regenerate|i:1727206802;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('co269loimj6u9aq4bfr0infpurg9hp09', '2a12:d280:100:51::', 1727238721, '__ci_last_regenerate|i:1727238721;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('coki4cmg2v7t8duoebhaesj3hh6gjl55', '2a12:d280:100:51::', 1727049842, '__ci_last_regenerate|i:1727049842;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('conu15p7m0fvdagj9vnr4p4jjsucqtv1', '2a12:d280:100:51::', 1727061121, '__ci_last_regenerate|i:1727061121;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cosauthmcvmt3icsss7gi24klbkoeef5', '2a12:d280:100:51::', 1727134321, '__ci_last_regenerate|i:1727134321;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cp2sqe95rvjogmga8pju2rc31593obbh', '2a12:d280:100:51::', 1727077441, '__ci_last_regenerate|i:1727077441;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cp950pen7b751a8066ohh6f6ukn6kuaj', '2a12:d280:100:51::', 1727119682, '__ci_last_regenerate|i:1727119681;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cpbnilf2totsqedijt6c9e9fc54bl4hh', '2a12:d280:100:51::', 1727058181, '__ci_last_regenerate|i:1727058181;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cpcqovvr4n481pq9082ts4ia740k149r', '2a12:d280:100:51::', 1727100302, '__ci_last_regenerate|i:1727100302;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cq2mk5bcpp804q4avd2biicllt1enfss', '2a12:d280:100:51::', 1727219701, '__ci_last_regenerate|i:1727219701;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cq7h3o78ij5s9v8u46doe66m0o1mdg4u', '2a12:d280:100:51::', 1727288461, '__ci_last_regenerate|i:1727288461;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cqd894ivfpdjlhsp1342osp2f9jsn79m', '2a12:d280:100:51::', 1727112961, '__ci_last_regenerate|i:1727112961;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cqfg3ve8oj2v67c27sooe5nqmgcdhusd', '2a12:d280:100:51::', 1727172541, '__ci_last_regenerate|i:1727172541;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cqlvnefbjaggvmssigjjprr5sin46gr7', '2a12:d280:100:51::', 1727234401, '__ci_last_regenerate|i:1727234401;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cqo70od3ksv3n5nbs46pc6evmjbnbkb4', '2a12:d280:100:51::', 1727070302, '__ci_last_regenerate|i:1727070302;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cqq1j3viudqlhujf7nksl381icif083l', '2a12:d280:100:51::', 1727046542, '__ci_last_regenerate|i:1727046542;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cqr76mhr2802tcjvhaf13isieftsn0dv', '2a12:d280:100:51::', 1727289541, '__ci_last_regenerate|i:1727289541;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cr1gvjt72k8o3dtls7g2bnoe9k9bec0p', '2a12:d280:100:51::', 1727237521, '__ci_last_regenerate|i:1727237521;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cr3v8r3drpa2uagke4gdqbgj0bp3m4jo', '2a12:d280:100:51::', 1727098022, '__ci_last_regenerate|i:1727098022;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('crb6pbr04vceahepse2pq85c7cf17lr3', '2a12:d280:100:51::', 1727045161, '__ci_last_regenerate|i:1727045161;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('crvivcrpgkl26i1qp6r2ilu2th7v4mdd', '2a12:d280:100:51::', 1727292421, '__ci_last_regenerate|i:1727292421;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cs5d8gnmcqvo4i2lpsoapuuf0v471ggp', '2a12:d280:100:51::', 1727085901, '__ci_last_regenerate|i:1727085901;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('csesvh1l5stf42d8c3tmbcniahpkrs9t', '2a12:d280:100:51::', 1727246581, '__ci_last_regenerate|i:1727246581;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('csjtcv9j407rogg7shnrjpj3n1232o5f', '2a12:d280:100:51::', 1727083981, '__ci_last_regenerate|i:1727083981;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('csq67va443damm33fv3dvvas9rchfrsa', '2a12:d280:100:51::', 1727262541, '__ci_last_regenerate|i:1727262541;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('csr2hivcp6s6ghi88gj2lnh9uca2pnqg', '2a12:d280:100:51::', 1727193422, '__ci_last_regenerate|i:1727193422;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('csr5satffo19ee080l55e0d8p84r011n', '2a12:d280:100:51::', 1727291402, '__ci_last_regenerate|i:1727291402;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cstmqf0rcmps3jl7ngqrl10im9e1gl59', '2a12:d280:100:51::', 1727227682, '__ci_last_regenerate|i:1727227682;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('csuvcmoo9jl18rij2u511mgvq4pa7ju2', '2a12:d280:100:51::', 1727246642, '__ci_last_regenerate|i:1727246642;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ct7u9thqqlcraag62s63unr7r8fs270q', '2a12:d280:100:51::', 1727162702, '__ci_last_regenerate|i:1727162702;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ctgr731b10hkvfhfqa037qr13vb0ghlg', '2a12:d280:100:51::', 1727167921, '__ci_last_regenerate|i:1727167921;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cu7b64k6u54fc5kb6ll364nnvvi7l9tf', '2a12:d280:100:51::', 1727280542, '__ci_last_regenerate|i:1727280542;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cu7oe1p0g8tt2s59rl4iimohk77itv27', '2a12:d280:100:51::', 1727192221, '__ci_last_regenerate|i:1727192221;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cuefmvr1spppcrvmsirmr9tncb0eqlkk', '2a12:d280:100:51::', 1727185201, '__ci_last_regenerate|i:1727185201;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cupbjn8g1ek61ti79oo2kdf6a1vongdk', '2a12:d280:100:51::', 1727219221, '__ci_last_regenerate|i:1727219221;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cuqanvucc2irbul295cemmu5akjjl791', '2a12:d280:100:51::', 1727253422, '__ci_last_regenerate|i:1727253422;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cuuq285jrde5lug1sgikt7987eq6ak6p', '2a12:d280:100:51::', 1727054761, '__ci_last_regenerate|i:1727054761;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cv7el0cmd01u3532qtco2lldm4bn1j2b', '192.145.39.244', 1727115159, '__ci_last_regenerate|i:1727115159;_prev_url|s:49:\"https://panel.blitconcept.es/admin/authentication\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cvcrjjfp74eev06lpvl5pr5smkc31hfv', '2a12:d280:100:51::', 1727230622, '__ci_last_regenerate|i:1727230622;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d019cisej91engji6vj0kmc6u218ksof', '2a12:d280:100:51::', 1727172301, '__ci_last_regenerate|i:1727172301;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d0ojr4p2nft0edekr2e0uqnmld4kmuak', '2a12:d280:100:51::', 1727147581, '__ci_last_regenerate|i:1727147581;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d119bqv4m8l4fvhnl8b0sad7ufsrk28o', '2a12:d280:100:51::', 1727111582, '__ci_last_regenerate|i:1727111582;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d1a3p21pk2rshp3si2fmgeqd5sqqa52m', '2a12:d280:100:51::', 1727130121, '__ci_last_regenerate|i:1727130121;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d1bk58jg1gct6b5sdh7lg2530bhno8v3', '2a12:d280:100:51::', 1727177462, '__ci_last_regenerate|i:1727177462;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d1hj1cp48ke3m2ktjkn10rupbohh5sv6', '2a12:d280:100:51::', 1727206021, '__ci_last_regenerate|i:1727206021;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d1iegcfl32lr57a9ro0gn9b25lv2b9s9', '2a12:d280:100:51::', 1727168882, '__ci_last_regenerate|i:1727168882;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d1pj2khatka451nm80us1dfn7a7igvgh', '2a12:d280:100:51::', 1727215861, '__ci_last_regenerate|i:1727215861;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d20i6sfie36b67pdmb1p88elcdkps9pm', '2a12:d280:100:51::', 1727208301, '__ci_last_regenerate|i:1727208301;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d29o1ibbosoqovv4itakollrst0ks1tj', '2a12:d280:100:51::', 1727223061, '__ci_last_regenerate|i:1727223061;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d2loulsph0a4k2imtmr7622jcbu9o9n7', '2a12:d280:100:51::', 1727153702, '__ci_last_regenerate|i:1727153702;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d382nupcktfg0fb29skjrngnmesqu092', '2a12:d280:100:51::', 1727210522, '__ci_last_regenerate|i:1727210522;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d3jr7155ei61f8kctd77jlc9e1384bav', '2a12:d280:100:51::', 1727219401, '__ci_last_regenerate|i:1727219401;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d3tr86e83m2836spd9ra0uofrgte376f', '2a12:d280:100:51::', 1727251322, '__ci_last_regenerate|i:1727251322;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d45kac49gcvqgtq6t3b4j2q9d53bro8o', '2a12:d280:100:51::', 1727285281, '__ci_last_regenerate|i:1727285281;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d4aq7cjkgk2kfphtd68eaagscu2pu14m', '2a12:d280:100:51::', 1727052721, '__ci_last_regenerate|i:1727052721;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d4c3c4g3eq73k1328nq58fr69b4vsecg', '2a12:d280:100:51::', 1727052002, '__ci_last_regenerate|i:1727052002;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d4gcsk8rq0t0jq4pn3o43n1mro3u2lm8', '2a12:d280:100:51::', 1727251082, '__ci_last_regenerate|i:1727251081;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d4l5ddmfhi57i5lkt6ee95dr8hatcs89', '2a12:d280:100:51::', 1727238602, '__ci_last_regenerate|i:1727238602;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d4odnff0ojsev5vrfb76a8jbippgpl0l', '2a12:d280:100:51::', 1727126642, '__ci_last_regenerate|i:1727126641;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d4p9fojlr3t5aj5jgt8co964d77eoggo', '2a12:d280:100:51::', 1727233141, '__ci_last_regenerate|i:1727233141;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d59h2ihr19192qgt981mp32inm3cm79e', '2a12:d280:100:51::', 1727070182, '__ci_last_regenerate|i:1727070182;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d5kt9tiob61tholergppii9ju0pld8g0', '2a12:d280:100:51::', 1727193241, '__ci_last_regenerate|i:1727193241;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d6cfh07jrilr1pkqp0bt1918qgaiocsj', '2a12:d280:100:51::', 1727229662, '__ci_last_regenerate|i:1727229662;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d6ohvl1lk1vbdkb194t1bhonrpefa7cn', '2a12:d280:100:51::', 1727203621, '__ci_last_regenerate|i:1727203621;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d6shrvua3uhpa8umep62hs8p1cgoruvd', '2a12:d280:100:51::', 1727181661, '__ci_last_regenerate|i:1727181661;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d6u6kthpli4um8ot0rtsjrsle311s2o0', '2a12:d280:100:51::', 1727249222, '__ci_last_regenerate|i:1727249222;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d6u72cq8d4np15mt2mav178bugfel108', '2a12:d280:100:51::', 1727272981, '__ci_last_regenerate|i:1727272981;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d7409l41lci2frrjpng3t11cufhggtf3', '2a12:d280:100:51::', 1727053321, '__ci_last_regenerate|i:1727053321;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d7ev5msr6qvtkli7tfhevvkr75ddroof', '2a12:d280:100:51::', 1727257742, '__ci_last_regenerate|i:1727257742;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d7j1mbp6kcv5anjftqhnvnq456k592bj', '2a12:d280:100:51::', 1727093281, '__ci_last_regenerate|i:1727093281;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d7oe6qm26oj836sdo570gj54igq166tc', '2a12:d280:100:51::', 1727288761, '__ci_last_regenerate|i:1727288761;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d7ognjqq0lcsm4g4dltk75g7hekl1nt3', '2a12:d280:100:51::', 1727200561, '__ci_last_regenerate|i:1727200561;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d7tl0pnk1ihbd1454namg8c290kfu87b', '2a12:d280:100:51::', 1727257081, '__ci_last_regenerate|i:1727257081;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d7vq3makmmc7kt3ako47a6g7gpuuqe31', '2a12:d280:100:51::', 1727184722, '__ci_last_regenerate|i:1727184722;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d8h3rdqd1pdv1ai48v2jt44j9v3r5a9v', '2a12:d280:100:51::', 1727136961, '__ci_last_regenerate|i:1727136961;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d8l1mt284r7611qubnleah9f3j9lbgbt', '2a12:d280:100:51::', 1727046241, '__ci_last_regenerate|i:1727046241;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d8sl15fqbnc11rcsti8iq72lkija3l1g', '2a12:d280:100:51::', 1727223841, '__ci_last_regenerate|i:1727223841;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d8vl2i4v8h7s5g0k5lithr89kdh62ve8', '2a12:d280:100:51::', 1727146201, '__ci_last_regenerate|i:1727146201;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d96vkdloagfb2l9ffpr2qh1ibh18r861', '2a12:d280:100:51::', 1727174221, '__ci_last_regenerate|i:1727174221;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d985acjr5t6v3587flca9h80m4vhsqqr', '2a12:d280:100:51::', 1727125261, '__ci_last_regenerate|i:1727125261;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d9g4snd2a86sl7k1n2gvootkh2a20ib3', '2a12:d280:100:51::', 1727190661, '__ci_last_regenerate|i:1727190661;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d9ng196nfnr4sd96nlpv9dpkc71h8h1i', '2a12:d280:100:51::', 1727123101, '__ci_last_regenerate|i:1727123101;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d9rqd2jlfenin12ir1lt6nop1qbicg26', '31.223.103.75', 1727294427, '__ci_last_regenerate|i:1727294427;red_url|s:34:\"https://panel.blitconcept.es/admin\";_prev_url|s:49:\"https://panel.blitconcept.es/admin/authentication\";message-danger|s:31:\"Email o contraseña no válidos\";__ci_vars|a:1:{s:14:\"message-danger\";s:3:\"old\";}');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d9tao5ptblmn7to0d44b0gopnkil99dd', '2a12:d280:100:51::', 1727241902, '__ci_last_regenerate|i:1727241901;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('da786beb1m6j8io69ckq9stfmikepvgp', '2a12:d280:100:51::', 1727117222, '__ci_last_regenerate|i:1727117221;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dad09n6snjrnorekmjlr7k406358ai6r', '2a12:d280:100:51::', 1727291042, '__ci_last_regenerate|i:1727291042;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dafq0316chlpdv7s9e3ca72bda7m0v00', '2a12:d280:100:51::', 1727053261, '__ci_last_regenerate|i:1727053261;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('das9tlpcpc3prrq82ttkf9qaiq7qkt3h', '2a12:d280:100:51::', 1727206381, '__ci_last_regenerate|i:1727206381;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dasrcbbl2vuu5iumbgb11nr5hvr2rpi3', '2a12:d280:100:51::', 1727269081, '__ci_last_regenerate|i:1727269081;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dc19jci8qosnmp5vmogfefgsfmu2fq65', '2a12:d280:100:51::', 1727254442, '__ci_last_regenerate|i:1727254442;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dcouollg1ij7rjd0nlrlb9f4enj4av6i', '2a12:d280:100:51::', 1727245502, '__ci_last_regenerate|i:1727245502;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dcvkon06lt5b9jjvuq961rdjpehen9vq', '2a12:d280:100:51::', 1727247241, '__ci_last_regenerate|i:1727247241;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dd0q5h6jcvbedo9iur22eb1p6r89ll8a', '2a12:d280:100:51::', 1727292362, '__ci_last_regenerate|i:1727292362;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ddj94fvj6e16rs8bqhr9lndiegb63b56', '2a12:d280:100:51::', 1727269262, '__ci_last_regenerate|i:1727269262;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ddp4uleqpr212oatadume23h19kpqkil', '2a12:d280:100:51::', 1727177282, '__ci_last_regenerate|i:1727177282;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('de0jb0li2ob2c1ldu4h0mkhiqlq382nt', '2a12:d280:100:51::', 1727133421, '__ci_last_regenerate|i:1727133421;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('del5le08kffkm7ev1s352rfesm0evs4q', '2a12:d280:100:51::', 1727170621, '__ci_last_regenerate|i:1727170621;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('deo6da59hj0cq3e2t6l3g5c8sdvsfrt4', '2a12:d280:100:51::', 1727070842, '__ci_last_regenerate|i:1727070842;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dep9aj1kqnsvfjnqn6nonfpto2f5upk7', '2a12:d280:100:51::', 1727217901, '__ci_last_regenerate|i:1727217901;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('devdaoe2o7a5lhd9sv8f7abktthn92nq', '2a12:d280:100:51::', 1727080621, '__ci_last_regenerate|i:1727080621;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('df3uegkovlct6c2bb5l73hcdbl80g2o7', '2a12:d280:100:51::', 1727080321, '__ci_last_regenerate|i:1727080321;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('df8qt291amv39ffo0uph46sef37p26s6', '2a12:d280:100:51::', 1727259061, '__ci_last_regenerate|i:1727259061;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dfj5njm70o74nj4fiapto1kk5okc7qep', '2a12:d280:100:51::', 1727260502, '__ci_last_regenerate|i:1727260502;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dfoh6v2s4pjon4purdeiscvo89n3qu37', '2a12:d280:100:51::', 1727234582, '__ci_last_regenerate|i:1727234582;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dfq53iot6qn0oadt2val2r9jhj99bph2', '31.223.103.75', 1727296276, '__ci_last_regenerate|i:1727296276;_prev_url|s:60:\"https://panel.blitconcept.es/admin/resourcebooking/booking/2\";staff_user_id|s:1:\"6\";staff_logged_in|b:1;setup-menu-open|b:1;');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dfs17mk6ughju1hm473lu52mofp40f43', '2a12:d280:100:51::', 1727133661, '__ci_last_regenerate|i:1727133661;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dg04bttenetcmaa7qkraa4qub5vfrs08', '2a12:d280:100:51::', 1727221081, '__ci_last_regenerate|i:1727221081;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dg0h6ul5fkrjdhnic9ef74ku7jp4lg3p', '2a12:d280:100:51::', 1727216761, '__ci_last_regenerate|i:1727216761;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dgapef44ure0cdkgfcm813ett3d88qkk', '2a12:d280:100:51::', 1727051221, '__ci_last_regenerate|i:1727051221;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dhopcj7ql865vs0ql5rq76ha5cne6071', '2a12:d280:100:51::', 1727199002, '__ci_last_regenerate|i:1727199002;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('didocu3275li8gsgfj87c77ji322s3u6', '2a12:d280:100:51::', 1727095262, '__ci_last_regenerate|i:1727095262;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('diicbjsivrp97v36up8vu9hebo9ueekr', '2a12:d280:100:51::', 1727203501, '__ci_last_regenerate|i:1727203501;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dikpl74hot93uhm9e0ngskjgc9vuvfnn', '2a12:d280:100:51::', 1727171342, '__ci_last_regenerate|i:1727171342;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dipi62m3384g7235qamla22nc8bbcprs', '2a12:d280:100:51::', 1727286842, '__ci_last_regenerate|i:1727286841;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dj07jlp7i6a2921f2nrcqjk3ijkmg2dt', '2a12:d280:100:51::', 1727198521, '__ci_last_regenerate|i:1727198521;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dj8o700obqok9k8m1funacluceoo937s', '2a12:d280:100:51::', 1727245142, '__ci_last_regenerate|i:1727245142;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('djkde5m5q9s9gf04a3ck51cl0m08nvbq', '2a12:d280:100:51::', 1727079241, '__ci_last_regenerate|i:1727079241;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('djvg1rhgvs3v8da060qqg5dq451jbu0b', '2a12:d280:100:51::', 1727261282, '__ci_last_regenerate|i:1727261282;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('djvjfe230f1vv9ep7h0e0juorqasn9k7', '2a12:d280:100:51::', 1727277481, '__ci_last_regenerate|i:1727277481;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dk2d10ftvc6rgl6hmqksdhfqtk154obt', '2a12:d280:100:51::', 1727262781, '__ci_last_regenerate|i:1727262781;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dke8tsm39kslojup1p66vifphtjti2an', '2a12:d280:100:51::', 1727083622, '__ci_last_regenerate|i:1727083622;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dl4u7tqfl7o1gna2b2ffkh96msetv2hf', '2a12:d280:100:51::', 1727105942, '__ci_last_regenerate|i:1727105942;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dl8dccqn4mv1378990ree68e4a6gcsvk', '2a12:d280:100:51::', 1727165161, '__ci_last_regenerate|i:1727165161;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dld6lapmpgolhthq19ic91tq516b042a', '2a12:d280:100:51::', 1727262122, '__ci_last_regenerate|i:1727262122;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dll5urbhf1965knbs9dkcpuu7p8motn5', '2a12:d280:100:51::', 1727290382, '__ci_last_regenerate|i:1727290382;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dlqkp811034q9r0lgkq8mliqg4660na0', '2a12:d280:100:51::', 1727191142, '__ci_last_regenerate|i:1727191142;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dmdfhfa9c806i76gvcl8vfauflj4g61k', '2a12:d280:100:51::', 1727282161, '__ci_last_regenerate|i:1727282161;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dmtvu832i8af5t5gm1tspqqmfa4jusjt', '2a12:d280:100:51::', 1727091721, '__ci_last_regenerate|i:1727091721;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dmvi4sto1vlglf3avuj0pb2hbj0okdge', '2a12:d280:100:51::', 1727120942, '__ci_last_regenerate|i:1727120942;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dn2gtq80t5oesj4l5cjlv6b7k9e6khrh', '2a12:d280:100:51::', 1727167741, '__ci_last_regenerate|i:1727167741;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dn78kiudq282jk76s546k3gn87i6av34', '2a12:d280:100:51::', 1727254802, '__ci_last_regenerate|i:1727254802;_prev_url|s:39:\"https://panel.blitconcept.es/cron/index\";');
INSERT INTO `tblsessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dnj9pujgviu1rapsqsdg8gv3s4qc7g98', '2a12:d280:100:51::', 1727112602, '_