<?php
defined('BASEPATH') or exit('No direct script access allowed');

/**
 * Get staff id by email
 * @param string $email
 * @return string staff id
 */

function handle_booking_attachments_array($booking, $index_name = 'attachments')
{
    $uploaded_files = [];
    $path = RESOURCEBOOKING_MODULE_UPLOAD_FOLDER . '/' . $booking . '/';
    $CI = &get_instance();

    if (isset($_FILES[$index_name]['name'])
        && ($_FILES[$index_name]['name'] != '' || is_array($_FILES[$index_name]['name']) && count($_FILES[$index_name]['name']) > 0)) {
        if (!is_array($_FILES[$index_name]['name'])) {
            $_FILES[$index_name]['name'] = [$_FILES[$index_name]['name']];
            $_FILES[$index_name]['type'] = [$_FILES[$index_name]['type']];
            $_FILES[$index_name]['tmp_name'] = [$_FILES[$index_name]['tmp_name']];
            $_FILES[$index_name]['error'] = [$_FILES[$index_name]['error']];
            $_FILES[$index_name]['size'] = [$_FILES[$index_name]['size']];
        }

        _file_attachments_index_fix($index_name);
        for ($i = 0; $i < count($_FILES[$index_name]['name']); $i++) {
            // Get the temp file path
            $tmpFilePath = $_FILES[$index_name]['tmp_name'][$i];

            // Make sure we have a filepath
            if (!empty($tmpFilePath) && $tmpFilePath != '') {
                if (_perfex_upload_error($_FILES[$index_name]['error'][$i])
                    || !_upload_extension_allowed($_FILES[$index_name]['name'][$i])) {
                    continue;
                }

                _maybe_create_upload_path($path);
                $filename = unique_filename($path, $_FILES[$index_name]['name'][$i]);
                $newFilePath = $path . $filename;

                // Upload the file into the temp dir
                if (move_uploaded_file($tmpFilePath, $newFilePath)) {
                    array_push($uploaded_files, [
                        'file_name' => $filename,
                        'filetype' => $_FILES[$index_name]['type'][$i],
                    ]);
                    if (is_image($newFilePath)) {
                        create_img_thumb($path, $filename);
                    }
                }
            }
        }
    }

    if (count($uploaded_files) > 0) {
        return $uploaded_files;
    }

    return false;
}


/**
 *
 * @date 2024-03-29 Halil
 *
 */
function handle_booking_payment_attachments_array($payment_id, $index_name = 'attachments')
{
    $uploaded_files = [];

    $path = RESOURCEBOOKING_MODULE_UPLOAD_FOLDER . '/payment_' . $payment_id . '/';

    $CI = &get_instance();

    if (isset($_FILES[$index_name]['name'])
        && ($_FILES[$index_name]['name'] != '' || is_array($_FILES[$index_name]['name']) && count($_FILES[$index_name]['name']) > 0)) {
        if (!is_array($_FILES[$index_name]['name'])) {
            $_FILES[$index_name]['name'] = [$_FILES[$index_name]['name']];
            $_FILES[$index_name]['type'] = [$_FILES[$index_name]['type']];
            $_FILES[$index_name]['tmp_name'] = [$_FILES[$index_name]['tmp_name']];
            $_FILES[$index_name]['error'] = [$_FILES[$index_name]['error']];
            $_FILES[$index_name]['size'] = [$_FILES[$index_name]['size']];
        }

        _file_attachments_index_fix($index_name);

        for ($i = 0; $i < count($_FILES[$index_name]['name']); $i++)
        {
            // Get the temp file path
            $tmpFilePath = $_FILES[$index_name]['tmp_name'][$i];

            // Make sure we have a filepath
            if (!empty($tmpFilePath) && $tmpFilePath != '')
            {

                if (_perfex_upload_error($_FILES[$index_name]['error'][$i])
                    || !_upload_extension_allowed($_FILES[$index_name]['name'][$i])) {
                    continue;
                }

                _maybe_create_upload_path($path);

                $filename = unique_filename($path, $_FILES[$index_name]['name'][$i]);
                $newFilePath = $path . $filename;

                // Upload the file into the temp dir
                if (move_uploaded_file($tmpFilePath, $newFilePath))
                {
                    $uploaded_files[] = [
                        'file_name' => $filename,
                        'filetype' => $_FILES[$index_name]['type'][$i],
                    ];

                    if (is_image($newFilePath))
                    {
                        create_img_thumb($path, $filename);
                    }

                }

            }

        }

    }


    if (count($uploaded_files) > 0)
    {
        return $uploaded_files;
    }

    return false;
}
