<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">


            <div class="col-md-11 col-md-offset-1">
                <div>

                    <?php

                    $options = icon_btn('resourcebooking/add_edit_booking/' . $booking->id, 'fa fa-pencil-square', 'btn-default');
                    $options .= icon_btn('resourcebooking/copy_booking/' . $booking->id, 'fa fa-copy', 'btn-default');
                    $options .= icon_btn('resourcebooking/delete_booking/' . $booking->id, 'fa fa-remove', 'btn-danger _delete');

                    echo $options;
                    ?>

                </div>
            </div>

            <div class="col-md-6 col-md-offset-1">




                <div class="panel_s">
                    <div class="panel-body">
                        <?php
                        $this->load->model('resourcebooking/resourcebooking_model');
                        $time = $this->resourcebooking_model->get_time_booking($booking->start_time, $booking->end_time);
                        $group = $this->resourcebooking_model->get_resource_group_by_id($booking->resource_group);
                        ?>

                        <div class="col-md-3">
                            <h4 class="no-margin font-bold"><?php echo htmlspecialchars($title); ?></h4>
                            <hr>
                        </div>
                        <div class="col-md-9">
                            <h4 class="no-margin font-bold"><?php echo htmlspecialchars($booking->purpose); ?></h4>
                            <hr>
                        </div>

                        <div class="col-md-12">

                            <table class="table no-margin project-overview-table">
                                <tbody>
                                <tr class="project-overview paddedbooking">
                                    <td class="bold"><?php echo _l('resource_name'); ?></td>
                                    <td style="color:<?php echo htmlspecialchars($resource->color); ?>;"><?php echo htmlspecialchars($resource->resource_name); ?></td>
                                </tr>
                                <tr class="project-overview paddedbooking">
                                    <td class="bold"><?php echo _l('resource_group'); ?></td>
                                    <td><?php echo '<i class="fa ' . $group->icon . '"></i> ' . $group->group_name; ?></td>
                                </tr>
                                <tr class="project-overview paddedbooking">
                                    <td class="bold"><?php echo _l('orderer'); ?></td>
                                    <td>
                                        <a href="<?php echo admin_url('staff/profile/' . $booking->orderer); ?>"> <?php echo staff_profile_image($booking->orderer, ['staff-profile-image-small',]); ?> </a><a
                                                href=" <?php echo admin_url('staff/profile/' . $booking->orderer); ?>"><?php echo get_staff_full_name($booking->orderer); ?></a>
                                    </td>
                                </tr>
                                <tr class="project-overview paddedbooking">
                                    <td class="bold"><?php echo _l('manager'); ?></td>
                                    <td>
                                        <a href="<?php echo admin_url('staff/profile/' . $resource->manager); ?>"> <?php echo staff_profile_image($resource->manager, ['staff-profile-image-small',]); ?> </a><a
                                                href=" <?php echo admin_url('staff/profile/' . $resource->manager); ?>"><?php echo get_staff_full_name($resource->manager); ?></a>
                                    </td>
                                </tr>
                                <tr class="project-overview paddedbooking">
                                    <td class="bold"><?php echo _l('description'); ?></td>
                                    <td>
                                        <?php // ($booking->description); ?>
                                    </td>
                                </tr>
                                <tr >
                                    <td colspan="2" class="halil_description_css" >
                                        <?php echo ($booking->description); ?>
                                    </td>
                                </tr>
                                <tr class="project-overview paddedbooking">
                                    <td class="bold"><?php echo _l('booktime'); ?></td>
                                    <td><?php echo '' . $time; ?></td>
                                </tr>
                                </tbody>
                            </table>
                            <hr>
                            <?php if (($resource->approved != 0) && ($resource->manager != 0) && ($resource->manager == get_staff_user_id()) && ($booking->status == 1)) { ?>
                                <a href="<?php echo admin_url('resourcebooking/approve_booking/' . '3' . '/' . $booking->id); ?>"
                                   class="btn btn-warning pull-right mleft10 display-block">
                                    <?php echo _l('reject'); ?>
                                </a>
                                <a href="Javascript:void(0);" data-loading-text="<?php echo _l('wait_text'); ?>"
                                   onclick="approve_booking(<?php echo htmlspecialchars($booking->id); ?>); return false;"
                                   class="btn btn-success pull-right display-block">
                                    <?php echo _l('approve'); ?>
                                </a>
                            <?php } ?>
                        </div>


                    </div>

                </div>



                <div class="panel_s">
                    <div class="panel-body">


                        <!-- @date 2024-03-11 Halil Checklist -->
                        <div class="clearfix"></div>

                        <div class="col-md-12">

                            <div class="form-group">

                                <div class="input-group">

                                    <input class="form-control" id="booking_checklist_value_0" placeholder="Add checklist" autocomplete="off" >

                                    <div class="input-group-addon">

                                        <i class="fa fa-save"></i>
                                        <a style="cursor: pointer" onclick="booking_save_checklist( 0 )">Save Check List</a>

                                    </div>

                                </div>

                            </div>

                            <?php if( !empty( $checklists_templates ) ) { ?>

                                <div class="form-group">
                                    <select data-live-search="true" id="booking_checklist_template_id" onchange="booking_checklist_add_template()" class="selectpicker" data-actions-box="true" data-width="100%" data-none-selected-text="Checklist templates">
                                        <option></option>
                                        <?php foreach ( $checklists_templates as $checklists_template ) {
                                            echo "<option value='$checklists_template->id'>$checklists_template->checklist_text</option>";
                                        } ?>
                                    </select>
                                </div>

                            <?php } ?>


                            <table class="table table-hover table-striped" id="table_booking_checklist">
                                <thead>
                                    <tr>
                                        <th> Check List</th>
                                        <th>Options</th>
                                    </tr>
                                </thead>
                                <tbody>

                                    <?php if ( !empty( $checklists ) ):

                                        foreach ( $checklists as $checklist ) :

                                            $this->load->view('v_booking_checklist_inc' , [ 'checklist' => $checklist] );

                                        endforeach;

                                    endif; ?>

                                </tbody>
                            </table>

                        </div>

                    </div>
                </div>



                <div class="panel_s">
                    <div class="panel-body">
                        <div class="col-md-12">
                            <h4 class="no-margin font-bold"><?php echo _l('comments_activity'); ?></h4>
                            <hr>
                        </div>
                        <div class="data task-modal-single" id="view_booking_comment">
                            <?php include_once('booking_comment.php') ?>
                        </div>
                    </div>
                </div>


            </div>


            <div class="col-md-4">
                <div class="panel_s">
                    <div class="panel-body">
                        <div class="col-md-12">
                            <h4 class="no-margin font-bold"><?php echo _l('follower'); ?></h4>
                            <hr>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <?php foreach ($follower as $fol) { ?>
                                    <a href="<?php echo admin_url('staff/profile/' . $fol['follower']); ?>"><?php echo staff_profile_image($fol['follower'], [
                                            'staff-profile-image-small'], 'small', [
                                            'data-toggle' => 'tooltip',
                                            'data-title' => get_staff_full_name($fol['follower']),
                                        ]); ?> </a>&nbsp;

                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>


                <div class="panel_s">
                    <div class="panel-body">
                        <div class="col-md-12">
                            <h4 class="no-margin font-bold"><?php echo _l('resource_detail'); ?></h4>
                            <hr>

                        </div>
                        <div class="col-md-12">
                            <table class="table no-margin project-overview-table">
                                <tbody>
                                <tr class="project-overview paddedbooking">
                                    <td class="bold"><?php echo _l('resource_name'); ?></td>
                                    <td><?php echo htmlspecialchars($resource->resource_name); ?></td>
                                </tr>
                                <tr class="project-overview paddedbooking">
                                    <td class="bold"><?php echo _l('resource_group'); ?></td>
                                    <td><?php echo '<i class="fa ' . $group->icon . '"></i> ' . $group->group_name; ?></td>
                                </tr>
                                <tr class="project-overview paddedbooking">
                                    <td class="bold"><?php echo _l('manager'); ?></td>
                                    <td>
                                        <a href="<?php echo admin_url('staff/profile/' . $resource->manager); ?>"> <?php echo staff_profile_image($resource->manager, ['staff-profile-image-small',]); ?> </a><a
                                                href=" <?php echo admin_url('staff/profile/' . $resource->manager); ?>"><?php echo get_staff_full_name($resource->manager); ?></a>
                                    </td>
                                </tr>
                                <tr class="project-overview paddedbooking hide">
                                    <td class="bold"><?php echo _l('color'); ?></td>
                                    <td><span class="label label-tag tag-id-1"
                                              style="background-color: <?php echo htmlspecialchars($resource->color); ?>;">&nbsp;&nbsp;&nbsp;</span>
                                    </td>
                                </tr>


                                <!--
                                 @date 2024-03-09 Halil
                                 -->
                                <tr class="project-overview paddedbooking">
                                    <td class="bold"><?php echo _l('statement_heading_amount')?> (€)</td>
                                    <td><?php echo app_format_money($booking->amount, 'EUR') ?></td>
                                </tr>
                                <tr class="project-overview paddedbooking">
                                    <td class="bold"><?php echo _l('booking_due')?> (€)</td>
                                    <td>
                                        <?php

                                        $total_payment = $this->db->select('SUM(amount) as amount', false)->from(db_prefix() . 'booking_payments')->where('booking_id', $booking->id)->where('status', 1)->get()->row();

                                        $total_debt = $this->db->select('SUM( amount - paid ) as amount', false)->from(db_prefix() . 'booking_debt')->where('booking_id', $booking->id)->get()->row();

                                        $due_amount = $booking->amount
                                                    - ( !empty( $total_payment->amount ) ? $total_payment->amount : 0 )
                                                    + ( !empty( $total_debt->amount ) ? $total_debt->amount : 0 );

                                        echo app_format_money($due_amount, 'EUR');

                                        ?>
                                    </td>
                                </tr>

                                <tr class="project-overview paddedbooking">
                                    <td class="bold"><?php echo _l('booking_people')?></td>
                                    <td><?php echo $booking->person_number ?></td>
                                </tr>

                                <tr class="project-overview paddedbooking">
                                    <td class="bold"><?php echo _l('booking_confirmed')?></td>
                                    <td>
                                        <?php
                                        if ($booking->confirmed == 1)
                                            echo "<spam class='text-success'>" . _l('filter_boolean_yes') . "</spam>";
                                        elseif ($booking->confirmed == 2)
                                            echo "<spam class='text-danger'>" . _l('filter_boolean_no') . "</spam>";
                                        ?>
                                    </td>
                                </tr>

                                </tbody>

                            </table>
                        </div>
                    </div>
                </div>


                <!--
                @date 2024-03-06 Halil
                -->
                <div class="panel_s">

                    <div class="panel-body">

                        <div class="col-md-12">
                            <h4 class="no-margin font-bold">
                                <?php echo _l('booking_payment_made')?>

                                <a class="btn btn-primary" onclick="booking_payment_detail( 0 )" style="float: right;"> <i class="fa fa-plus"></i>
                                    <?php echo _l('booking_payment')?></a>
                            </h4>
                            <hr>
                        </div>

                        <div class="col-md-12">

                            <div class="panel-table-full">

                                <table class="table halil-payment-table">

                                    <thead>
                                    <tr>
                                        <th class="not_visible">#</th>
                                        <th><?php echo _l('invoice_payments_table_mode_heading') ?></th>
                                        <th><?php echo _l('statement_heading_amount') ?></th>
                                        <th><?php echo _l('invoice_payments_table_date_heading') ?></th>
                                        <th><?php echo _l('estimate_request_dt_status') ?></th>
                                    </tr>
                                    </thead>

                                    <tbody></tbody>

                                </table>

                            </div>

                        </div>

                    </div>

                </div>


                <!--
                @date 2024-03-31 Halil
                -->
                <div class="panel_s">

                    <div class="panel-body">

                        <div class="col-md-12">

                            <h4 class="no-margin font-bold">

                                <?php echo _l('booking_debt')?>

                                <a class="btn btn-primary" onclick="booking_debt_detail( 0 )" style="float: right;"> <i class="fa fa-plus"></i> <?php echo _l('booking_debt')?></a>

                                <a href="#" data-toggle="modal" data-target="#booking_debt_modal"  class="btn btn-primary pull-right display-block mright5">
                                    <?php echo _l('import')?>
                                </a>

                            </h4>
                            <hr>

                        </div>

                        <div class="col-md-12">

                            <div class="panel-table-full">

                                <table class="table halil-debt-table">

                                    <thead>
                                    <tr>
                                        <th class="not_visible">#</th>
                                        <th><?php echo _l('name') ?></th>
                                        <th><?php echo _l('statement_heading_amount') ?></th>
                                        <th><?php echo _l('amount_paid') ?></th>
                                        <th><?php echo _l('booking_due')?></th>
                                        <th class="not_visible"><?php echo _l('estimate_request_dt_status') ?></th>
                                    </tr>
                                    </thead>

                                    <tbody></tbody>
                                    <tfoot>
                                        <td></td>
                                        <td></td>
                                        <td class="total_amount"></td>
                                        <td class="total_paid"></td>
                                        <td class="total_due"></td>
                                        <td></td>
                                    </tfoot>
                                </table>

                            </div>

                        </div>

                    </div>

                </div>


            </div>


        </div>
    </div>
</div>

<div class="modal fade" id="list_sending" tabindex="-1" role="dialog">
    <div class="modal-dialog">
        <?php echo form_open(admin_url('resourcebooking/reject_list_booking/' . $booking->id), array('id' => 'list_sending-form')); ?>
        <div class="modal-content rbfullwidth">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <span class="add-title"><?php echo _l('list_sending'); ?></span>
                </h4>
            </div>
            <div class="modal-body">
                <div class="notification bold"><?php echo _l('notification_approve_booking'); ?></div>
                <div id="list">

                </div>
                <div id="input">

                </div>
            </div>
            <div class="modal-footer">
                <button type="
                    " class="btn btn-default" data-dismiss="modal"><?php echo _l('close'); ?></button>

                <button id="sm_btn" type="submit" class="btn btn-info"><?php echo _l('continue'); ?></button>
            </div>
        </div><!-- /.modal-content -->
        <?php echo form_close(); ?>
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<div class="modal fade" id="list_approve" tabindex="-1" role="dialog">
    <div class="modal-dialog">

        <div class="modal-content rbfullwidth">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <span class="add-title"><?php echo _l('list_approve'); ?></span>
                </h4>
            </div>
            <div class="modal-body">
                <div class="notification2 bold"><?php echo _l('notification_approve_booking2'); ?></div>
                <div id="approved">

                </div>
                <div id="list_id">

                </div>
            </div>
            <div class="modal-footer">
                <button type="
                    " class="btn btn-default" data-dismiss="modal"><?php echo _l('close'); ?></button>
            </div>
        </div><!-- /.modal-content -->

    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->


<div class="modal fade" id="booking_payment_modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">


</div>


<div class="modal fade" id="booking_debt_modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" data-backdrop="static">

    <div class="modal-dialog" role="document">

        <div class="modal-content">

            <div class="modal-header">

                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>

                <h4 class="modal-title" id="myModalLabel">

                    <span class="add-title"><?php echo _l('import')?></span>

                </h4>

            </div>

            <?php echo form_open_multipart('admin/resourcebooking/debt_import/'.$booking->id, ['id' => 'project_upload_excel' ]); ?>

            <div class="modal-body">

                <div class="row">

                    <div class="col-md-12">

                        <p class="text-info"><?php echo _l('booking_debt_upload_message')?></p>

                        <div class="form-group">

                            <label for="placement" class="control-label clearfix"><?php echo _l('File'); ?></label>

                            <div class="form-control">

                                <input type="file" name="file" value="" id="file" required>

                            </div>

                        </div>

                    </div>

                </div>

                <hr />

                <div class="row">

                    <div class="col-md-12">

                        <button type="button" class="btn btn-default mleft15" data-dismiss="modal"><?php echo _l('close'); ?></button>

                        <a href="<?php echo base_url('uploads/sample_debt.xlsx')?>" target="_blank" class="btn btn-info mleft15">Download Sample</a>

                        <button type="submit" class="btn btn-primary mleft15"><?php echo _l('submit'); ?></button>

                    </div>

                </div>

                <!-- Result -->

                <div class="row" id="upload_result" style="display: none">

                    <div class="col-md-12">
                        <hr />
                    </div>

                    <div class="col-md-12">
                        Do not close it until you see the "completed" text.
                    </div>

                    <div class="col-md-12 iframe-loading">

                    </div>

                    <div class="col-md-12">

                        <button id="btn_reload_project" onclick="reload_booking_debt_table()" type="button" class="btn btn-success"><?php echo _l('dt_button_reload'); ?></button>

                    </div>

                </div>

            </div>

            <?php echo form_close(); ?>

        </div>

    </div>

</div>



<?php init_tail(); ?>

</body>

</html>

<script type="text/javascript" src="<?php echo module_dir_url('resourcebooking', 'assets/js/booking.js'); ?>"></script>

<script>

    function init_new_booking_comment(manual) {

        if (tinymce.editors.booking_comment) {
            tinymce.remove('#booking_comment');
        }

        if (typeof (bookingCommentAttachmentDropzone) != 'undefined') {
            bookingCommentAttachmentDropzone.destroy();
        }

        $('#dropzoneBookingComment').removeClass('hide');
        $('#addBookingCommentBtn').removeClass('hide');
        var $booking = $('#view_booking_comment');

        bookingCommentAttachmentDropzone = new Dropzone("#booking-comment-form", appCreateDropzoneOptions({
            uploadMultiple: true,
            clickable: '#dropzoneBookingComment',
            previewsContainer: '.dropzone-booking-comment-previews',
            autoProcessQueue: false,
            addRemoveLinks: true,
            parallelUploads: 20,
            maxFiles: 20,
            paramName: 'file',
            sending: function (file, xhr, formData) {
                formData.append("booking", $('#addBookingCommentBtn').attr('data-comment-booking-id'));
                if (tinyMCE.activeEditor) {
                    formData.append("content", tinyMCE.activeEditor.getContent());
                } else {
                    formData.append("content", $('#booking_comment').val());
                }
            },
            success: function (files, response) {
                response = JSON.parse(response);
                if (this.getUploadingFiles().length === 0 && this.getQueuedFiles().length === 0) {
                    $booking.html(response.taskHtml);
                    tinymce.remove('#booking_comment');
                }
            }
        }));
        var editorConfig = _simple_editor_config();
        if (typeof (manual) == 'undefined' || manual === false) {
            editorConfig.auto_focus = true;
        }
        var iOS = is_ios();
        // Not working fine on iOs
        if (!iOS) {
            init_editor('#booking_comment', editorConfig);
        }
    }


    $(document).ready(function () {

        initDataTable('.halil-payment-table', admin_url + 'resourcebooking/payment_lists/<?php echo $booking->id?>', [], [], [], [0, 'desc']);

        initDataTable('.halil-debt-table', admin_url + 'resourcebooking/debt_lists/<?php echo $booking->id?>', [], [], [], [0, 'desc']);


        $('#booking_comment_frame').on('load', function () {

            var iframeBody = $(this).contents().find('body');
            $(this).height(parseInt(iframeBody.height()) + 50);

        });

        $('#booking_checklist_value_0').keydown(function(event) {

            if (event.keyCode === 13)
            {

                booking_save_checklist( 0 );

            }

        });




        // Upload booking debt
        // upload xml

        $('#booking_debt_modal').on('show.bs.modal', function(event) {

            $('#upload_result').hide();
            $('#btn_reload_project').hide();

        } );


        $("#project_upload_excel").submit(function(){

            if( $('#upload_frame').attr("name") == null) {
                // create iframe

                $('#upload_result').show();

                setTimeout(function (){

                    $('#btn_reload_project').show();

                },1000)


                $('#upload_frame').html("");

                $('.iframe-loading').append('<iframe id="upload_frame" name="upload_frame" frameborder="0" width="100%" style="min-height: 300px"></iframe>');
                $('#upload_frame').on('load',function(){
                    //matrix_iframe_loading();
                    if($(this).contents()[0].location.href.match($(this).parent('form').attr('action'))){

                        $('#server_response').html($(this).contents().find('html').html());

                    }
                });

                $(this).attr('method','post');
                $(this).attr('enctype','multipart/form-data');
                $(this).attr('target','upload_frame').submit();

            }

        });



        $('.halil-debt-table').on('draw.dt', function() {

            var paymentReceivedReportsTable = $(this).DataTable();

            var sums = paymentReceivedReportsTable.ajax.json().sums;

            $(this).find('tfoot').addClass('bold');

            $(this).find('tfoot td').eq(0).html("<?php echo _l('invoice_total'); ?> (<?php echo _l('per_page'); ?>)");

            $(this).find('tfoot td.total_amount').html(sums.total_amount);
            $(this).find('tfoot td.total_paid').html(sums.total_paid);
            $(this).find('tfoot td.total_due').html(sums.total_due);

        });



    })



    function reload_booking_debt_table()
    {

        $('#booking_debt_modal').modal('hide');

        $(".halil-debt-table").DataTable().ajax.reload();

    }



    function booking_payment_detail(record_id) {

        $('#booking_payment_modal').modal({

            show: true,

            backdrop: "static",

            keyboard: false,

        });

        $.post(admin_url + "resourcebooking/payment_detail/<?php echo $booking->id?>", {record_id: record_id})
            .done(function (response) {

                response = JSON.parse(response);

                $('#booking_payment_modal').html(response.content).promise().done(function () {

                    init_datepicker();

                    init_selectpicker();

                });

            });

    }

    function booking_debt_detail(record_id) {

        $('#booking_payment_modal').modal({

            show: true,

            backdrop: "static",

            keyboard: false,

        });

        $.post(admin_url + "resourcebooking/debt_detail/<?php echo $booking->id?>", {record_id: record_id})
            .done(function (response) {

                response = JSON.parse(response);

                $('#booking_payment_modal').html(response.content).promise().done(function () {


                });

            });

    }


    function booking_debt_delete(record_id) {

        $.post(admin_url + "resourcebooking/debt_delete/<?php echo $booking->id?>", {record_id: record_id})
            .done(function (response) {

                $(".halil-debt-table").DataTable().ajax.reload();

            });

    }


    function booking_save_checklist( record_id )
    {

        $input_obj = $('#booking_checklist_value_'+record_id);

        if ( $input_obj.val() )
        {

            $.post(admin_url + "resourcebooking/booking_checklist_save/<?php echo $booking->id?>", { record_id: 0 , value : $input_obj.val() } )
                .done(function (response) {

                    response = JSON.parse(response);

                    if( response.success )
                    {

                        $input_obj.val('');

                        if ( response.content )
                        {
                            $('#table_booking_checklist').append( response.content );
                        }

                        $input_obj.focus();

                    }

                });

        }
        else
            $input_obj.focus();


    }

    function booking_checklist_status_change( record_id )
    {

        $.post(admin_url + "resourcebooking/booking_checklist_status_change/<?php echo $booking->id?>", { record_id: record_id , status : $('#booking_checklist_value_'+record_id).prop('checked') } )
            .done(function (response) {

                response = JSON.parse(response);

                if( response.success )
                {
                    alert_float( 'success' , 'Successful' );
                }
                else
                    alert_float( 'danger' , response.message );

            });


    }

    function booking_checklist_save_template( record_id )
    {

        $.post(admin_url + "resourcebooking/booking_checklist_save_template/<?php echo $booking->id?>", { record_id: record_id } )
            .done(function (response) {

                response = JSON.parse(response);

                if( response.success )
                {
                    alert_float( 'success' , 'Successful' );
                }

            });

    }

    function booking_checklist_remove( record_id )
    {

        if( confirm_delete() )
        {

            $.post(admin_url + "resourcebooking/booking_checklist_remove/<?php echo $booking->id?>", { record_id: record_id } )
                .done(function (response) {

                    response = JSON.parse(response);

                    if( response.success )
                    {

                        alert_float( 'success' , 'Successful' );

                        $('.checklist_tr_'+record_id).remove();

                    }

                });

        }

    }

    function booking_checklist_add_template()
    {

        $template_obj = $('#booking_checklist_template_id');

        if ( $template_obj.val() )
        {

            $.post(admin_url + "resourcebooking/booking_checklist_add_template/<?php echo $booking->id?>", { template_id : $template_obj.val() } )
                .done(function (response) {

                    response = JSON.parse(response);

                    if( response.success )
                    {

                        if ( response.content )
                        {

                            $('#table_booking_checklist').append( response.content );

                        }

                        $template_obj.selectpicker('val','');

                        $template_obj.selectpicker('refresh');

                    }
                    else
                        alert_float( 'danger' , response.message );


                });

        }


    }

    function add_payment_to_debt( record_id )
    {

        if ( $('#paid_amount').val() > 0 )
        {
            $.post(admin_url + "resourcebooking/add_payment_to_debt/<?php echo $booking->id?>", { record_id: record_id , paid_amount : $('#paid_amount').val() } )
                .done(function (response) {

                    response = JSON.parse(response);

                    if( response.success )
                    {
                        alert_float( 'success' , 'Successful' );
                    }
                    else
                        alert_float( 'danger' , response.message );


                    booking_debt_detail( record_id );

                });
        }
        else
            $('#paid_amount').focus();



    }
</script>


<style>

    .halil_description_css ul,
    .halil_description_css ol{
        list-style: initial;
    }


</style>
