<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">

                        <div class="row">
                            <div class="col-md-12">
                                <h4 class="no-margin font-bold"><i class="fa fa-edit" aria-hidden="true"></i> <?php echo _l($title); ?> </h4>
                                <hr/>
                            </div>
                        </div>

                        <div class="row">
                            <div class="_buttons col-md-3">
                                <a href="<?php echo admin_url('resourcebooking/add_edit_booking'); ?>"
                                   class="btn btn-info pull-left mright10 display-block">
                                    <?php echo _l('new_booking'); ?>
                                </a>
                                <a href="<?php echo admin_url('resourcebooking/calendar_booking'); ?>"
                                   class="btn btn-default pull-left display-block">
                                    <?php echo _l('calendar_view'); ?>
                                </a>
                            </div>

                        </div>

                        <br>
                        <div class="row">

                            <div class="col-md-3">

                                <input type="hidden" name="from_date" id="from_date" value="">

                                <input type="hidden" name="to_date" id="to_date" value="">

                                <?php $this->load->view('account_balances/_statement_period_select', ['onChange' => 'booking_reload_the_table()']); ?>

                            </div>


                            <div class="col-md-3">

                                <?php echo render_select( 'resource_group' , $resource_group , [ 'id' , [ 'group_name'] ] ,  '' , '' , ['onchange' => 'booking_table_load()' , 'data-none-selected-text' => _l('resource_group') ] ); ?>

                            </div>

                            <div class="col-md-3">

                                <?php echo render_select( 'resource' , $resources , [ 'id' , [ 'resource_name'] ] ,  '' , '' , ['onchange' => 'booking_table_load()' , 'data-none-selected-text' => _l('resource') ] ); ?>

                            </div>

                            <div class="col-md-3">

                                <?php
                                $confirmed_data = [];
                                $confirmed_data[] = [ 'id' => 1 , 'text' => _l('filter_boolean_yes') ];
                                $confirmed_data[] = [ 'id' => 2 , 'text' => _l('filter_boolean_no') ];

                                echo render_select( 'confirmed' , $confirmed_data , [ 'id' , [ 'text' ] ] , '', '', ['onchange' => 'booking_table_load()', 'data-none-selected-text' => 'Confirmed (Yes/No)' ] );
                                ?>

                            </div>

                            <div class="col-md-3">

                                <?php
                                $status_data = [];
                                $status_data[] = [ 'id' => 1 , 'text' => _l('scheduled') ];
                                $status_data[] = [ 'id' => 2 , 'text' => _l('ended') ];
                                $status_data[] = [ 'id' => 3 , 'text' => _l('currentlyactive') ];

                                echo render_select( 'status' , $status_data , [ 'id' , [ 'text' ] ] , '', 1 , ['onchange' => 'booking_table_load()', 'data-none-selected-text' => _l('status') ] );
                                ?>

                            </div>

                            <div class="col-md-3">

                                <?php
                                $debt_data  = [];
                                $debt_data[] = [ 'id' => 1 , 'text' => 'has debt' ];
                                $debt_data[] = [ 'id' => 2 , 'text' => 'has not debt' ];

                                echo render_select( 'debt' , $debt_data , [ 'id' , [ 'text' ] ] , '', '', ['onchange' => 'booking_table_load()', 'data-none-selected-text' => 'Debt' ] );
                                ?>

                            </div>

                        </div>
                        <br><br>

                        <?php

                        $footer_html = '<tfoot>
                                            <td colspan="2"></td> 
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td class="total"></td>
                                            <td></td>
                                            <td></td>
                                         </tfoot>';


                        render_datatable(array(

                            _l('start_time'),
                            _l('resource'),

                            _l('purpose'),
                            _l('orderer'),
                            _l('follower'),
                            _l('resource_group'),
                            _l('end_time'),

                            _l('booking_confirmed'),
                            _l('booking_debt'),

                            _l('status'),
                            _l('options')
                        ), 'table_booking' , [] , [] , $footer_html ); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php init_tail(); ?>

</body>
</html>

<script language="JavaScript" type="text/javascript"
        src="<?php echo module_dir_url('resourcebooking', 'assets/js/manage_booking.js?v=5'); ?>"></script>


<script>

    $(document).ready(function (){


        $('.table-table_booking').on('draw.dt', function() {

            var paymentReceivedReportsTable = $(this).DataTable();

            var sums = paymentReceivedReportsTable.ajax.json().sums;

            $(this).find('tfoot').addClass('bold');

            $(this).find('tfoot td').eq(0).html("<?php echo _l('invoice_total'); ?> (<?php echo _l('per_page'); ?>)");

            $(this).find('tfoot td.total').html(sums.total_amount);

        });

    })

</script>


<style>
    .table.dataTable > thead:first-child > tr:first-child > th:last-child {
        padding: 13px;
    }

    th.sorting_disabled.sorting_asc:after {
        display: none !important;
    }
</style>
