<div class="modal-dialog" role="document">

    <div class="modal-content">

        <div class="modal-header">

            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>

            <h4 class="modal-title" id="myModalLabel">

                <span><?php echo _l('booking_debt')?></span>

            </h4>

        </div>



        <?php echo form_open('resourcebooking/debt_save' ,  ['id' => 'debt_form'] ); ?>

            <input type="hidden" name="booking_id" id="booking_id" value="<?php echo $booking_id?>" />

            <input type="hidden" name="id" id="id" value="<?php echo $detail->id?>" />

            <div class="modal-body">

                <div class="row">

                    <div class="col-md-12">

                        <?php

                        echo render_input('name', _l("name") , $detail->name );

                        echo render_input('amount', _l("invoice_payments_table_amount_heading") , $detail->amount , 'number' );


                        if ( !empty( $detail->id ) )
                        {

                            echo render_input('paid', _l("invoice_total_paid") , $detail->paid , 'number' , [ 'disabled' => true ] );

                        }

                        ?>

                    </div>


                    <?php if ( !empty( $detail->id ) ) { ?>

                        <div class="clearfix"></div>

                        <div class="col-md-12">
                            <hr />
                        </div>

                        <div class="col-md-8">
                            <?php echo render_input('paid_amount', '' , '' , 'number' ); ?>
                        </div>

                        <div class="col-md-4">
                            <a class="btn btn-primary" onclick="add_payment_to_debt( <?php echo $detail->id ?> )"><?php echo _l('add_batch_payments')?></a>
                        </div>


                        <div class="col-md-12">

                            <table class="table dt-table">

                                <thead>
                                    <tr>
                                        <th><?php echo _l('invoice_table_amount_heading')?></th>
                                        <th><?php echo _l('invoice_payments_table_date_heading')?></th>
                                        <th><?php echo _l('status')?></th>
                                    </tr>
                                </thead>

                                <tbody>
                                <?php foreach ( $payments as $payment ) { ?>

                                    <tr>
                                        <td><?php echo app_format_money($payment->payment_amount , 'EUR')?></td>
                                        <td><?php echo _d($payment->date)?></td>
                                        <td><?php echo $this->resourcebooking_model->payment_status( $payment->status )?></td>
                                    </tr>

                                <?php } ?>
                                </tbody>

                            </table>

                        </div>


                    <?php } ?>

                </div>


                <div class="row">

                    <div class="col-md-12">
                        <?php $this->load->view('v_payment_attachment') ?>
                    </div>

                </div>


            </div>

            <div class="modal-footer">

                <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo _l('close'); ?></button>

                <button type="submit" class="btn btn-primary"><?php echo _l('submit'); ?></button>

            </div>


        <?php echo form_close(); ?>


    </div>

</div>


<script>


    $(document).ready(function (){


        appValidateForm($('#debt_form'), {

            name: 'required',

            amount: 'required',

        }, manage_debt );


    })


    function manage_debt(form) {

        var data = $(form).serialize();

        var url = form.action;

        $.post(url, data).done(function(response) {

            response = JSON.parse(response);

            if (response.success == true) {

                $('.halil-debt-table').DataTable().ajax.reload();

                alert_float('success', response.message);

            }

            $('#booking_payment_modal').modal('hide');

        });

        return false;

    }


</script>
