<div class="modal-dialog" role="document">

    <div class="modal-content">

        <div class="modal-header">

            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>

            <h4 class="modal-title" id="myModalLabel">

                <span><?php echo _l('statement_heading_payments')?></span>

            </h4>

        </div>



        <?php echo form_open_multipart('resourcebooking/payment_save' ,  ['id' => 'payment_form'] ); ?>

            <input type="hidden" name="booking_id" id="booking_id" value="<?php echo $booking_id?>" />

            <input type="hidden" name="id" id="id" value="<?php echo $detail->id?>" />

            <div class="modal-body">

                <div class="row">

                    <div class="col-md-12">

                        <?php echo render_select('payment_id', $payment_modes , [ 'id' , [ 'name'] ] , _l("invoice_payments_table_mode_heading") , $detail->payment_id  ); ?>

                        <?php echo render_input('amount', _l("invoice_payments_table_amount_heading") , $detail->amount , 'number' , [ 'step' => 'any' ] ); ?>

                        <?php echo render_datetime_input('date' , _l("invoice_payments_table_date_heading") , _dt($detail->date) ); ?>

                        <?php echo render_textarea('description', _l("task_view_description"), $detail->description , [ 'rows' => 5]); ?>

                    </div>


                    <!--Attachment-->

                    <div class="col-sm-12">
                        <div class="row attachments">
                            <div class="attachment">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="attachment" class="control-label"><?php echo _l('add_task_attachments'); ?></label>
                                        <div class="input-group">
                                            <input type="file" extension="<?php echo str_replace('.','',get_option('allowed_files')); ?>" filesize="<?php echo file_upload_max_size(); ?>" class="form-control" name="attachments[0]">
                                            <span class="input-group-btn">
												<button class="btn btn-success add_more_attachments p8" type="button"><i class="fa fa-plus"></i></button>
											</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>


                <div class="row">

                    <div class="col-md-12">
                        <?php $this->load->view('v_payment_attachment') ?>
                    </div>

                </div>


            </div>

            <div class="modal-footer">

                <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo _l('close'); ?></button>

                <button type="submit" class="btn btn-primary"><?php echo _l('submit'); ?></button>

            </div>


        <?php echo form_close(); ?>


    </div>

</div>


<script>


    function delete_booking_payment_attachment(id) {

        if (confirm_delete()) {

            requestGet("resourcebooking/delete_payment_attachment/" + id)

                .done(function (success) {

                    if (success == 1) {

                        $("body")

                            .find('[data-attachment-id="' + id + '"]')

                            .remove();

                        init_credit_note(

                            $("body").find('input[name="_attachment_sale_id"]').val()

                        );

                    }

                })

                .fail(function (error) {

                    alert_float("danger", error.responseText);

                });

        }

    }


    /*
    $(document).ready(function (){


        appValidateForm($('#payment_form'), {

            payment_id: 'required',

            amount: 'required',

            date: 'required',

        }, manage_payment );


    })


    function manage_payment(form) {

        var data = $(form).serialize();

        var url = form.action;

        $.post(url, data).done(function(response) {

            response = JSON.parse(response);

            if (response.success == true) {

                $('.halil-payment-table').DataTable().ajax.reload();

                alert_float('success', response.message);

            }

            $('#booking_payment_modal').modal('hide');

        });

        return false;

    }

    */

</script>
