<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Preview\TrustedComms;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceContext;
use Twilio\Options;
use Twilio\Values;
use Twilio\Version;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 */
class CurrentCallContext extends InstanceContext {
    /**
     * Initialize the CurrentCallContext
     *
     * @param Version $version Version that contains the resource
     */
    public function __construct(Version $version) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [];

        $this->uri = '/CurrentCall';
    }

    /**
     * Fetch the CurrentCallInstance
     *
     * @param array|Options $options Optional Arguments
     * @return CurrentCallInstance Fetched CurrentCallInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(array $options = []): CurrentCallInstance {
        $options = new Values($options);

        $headers = Values::of([
            'X-Xcnam-Sensitive-Phone-Number-From' => $options['xXcnamSensitivePhoneNumberFrom'],
            'X-Xcnam-Sensitive-Phone-Number-To' => $options['xXcnamSensitivePhoneNumberTo'],
        ]);

        $payload = $this->version->fetch('GET', $this->uri, [], [], $headers);

        return new CurrentCallInstance($this->version, $payload);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Preview.TrustedComms.CurrentCallContext ' . \implode(' ', $context) . ']';
    }
}