<?php

namespace app\services\messages;

defined('BASEPATH') or exit('No direct script access allowed');

use app\services\messages\AbstractPopupMessage;

class StartTimersWithNoTasks extends AbstractPopupMessage
{
    public function isVisible(...$params)
    {
        $task_id  = $params[0]['task_id'];
        $timer_id = $params[0]['timer_id'];

        return $task_id != '0' && $timer_id == 1;
    }

    public function getMessage(...$params)
    {
        return 'First Timer Started!<br />
            <span style="font-size:26px;">Did you know that you can start a timer without task and assign the timer to task afterward?</span><br /><br /><img alt="timer-start" class="img-responsive center-block" src="data:image/png;base64,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">';
    }
}
