<?php

/**
 *
 * @property Resourcebooking_model $resourcebooking_model;
 *
 * @property Case_model $case_model
 *
 */


class Booking extends AdminController

{



    public function __construct()

    {

        parent::__construct();


        $this->load->model("resourcebooking/resourcebooking_model");

        $this->load->model('case_model');

        $this->resourcebooking_model->check_the_database();

    }



    public function payment_menu()
    {

        $data['title'] = 'Aprobacion de Ingresos';

        $data['payment_modes'] = $this->case_model->get_transaction();

        $this->load->view( 'v_payment_menu' , $data );

    }


    public function booking_lists( $show_pending_approval = 0 )
    {

        if ( $this->input->is_ajax_request() )
        {


            $sTable     = db_prefix().'booking_payments';
            $booking    = db_prefix().'booking';

            $aColumns = [

                $sTable.'.id as id',

                'purpose',

                'payment_id',

                $sTable.'.amount as amount',

                $sTable.'.date as date',

                $sTable.'.status as status',

                $sTable.'.description as description',

            ];

            $where = [];


            if ( $show_pending_approval == 1 )
                $where[] = "AND $sTable.status = 0 ";

            if( $this->input->post('from_payment_mode') )

                $where[] = "AND $sTable.payment_id = ".$this->input->post('from_payment_mode');




            $hidden_payment_modes = $this->case_model->get_hidden_payment_modes_for_staff();

            if ( !empty( $hidden_payment_modes ) )
            {

                foreach ( $hidden_payment_modes as $hidden_payment_mode )
                {

                    $where[] = "AND $sTable.payment_id != '$hidden_payment_mode' ";

                }

            }

            $sIndexColumn = 'id';

            $join = [

                'LEFT JOIN ' . $booking . ' ON ' . $booking . '.id = ' . $sTable . '.booking_id',

            ];

            $result = data_tables_init( $aColumns , $sIndexColumn , $sTable , $join , $where , [ 'booking_id' ] );

            $output  = $result['output'];

            $rResult = $result['rResult'];

            $payment_modes = [];

            $modes = $this->case_model->get_transaction();


            foreach ( $modes as $mode )
            {

                $mode_id = $mode['id'];

                $payment_modes["$mode_id"] = $mode ;

            }


            foreach( $rResult as $aRow )
            {

                $row = [];

                $source_mode = $this->case_model->get_payment_mode_info( $payment_modes , $aRow["payment_id"] );

                $record_id = $aRow['id'];
                $booking_id = $aRow['booking_id'];

                $numberOutput = "# $record_id" ;

                $numberOutput .= '<div class="row-options">';

                $numberOutput .= "<a class='text-info' href='#' onclick='booking_payment_detail( $record_id ); return false;'>" . _l('view') . "</a>";

                if ( is_admin() && $aRow['status'] == 0 )

                    $numberOutput .= " | <a class='text-danger _delete' href='#' onclick='booking_payment_delete( $record_id )'>" . _l('delete') . "</a>";


                $numberOutput .= '</div>';

                $row[] =  $numberOutput;

                $link   = admin_url('resourcebooking/booking/'.$booking_id );

                $row[] =  "<a target='_blank' href='$link'> ".$aRow['purpose']." </a>";

                $row[] = $source_mode->name ;


                $row[] =  app_format_money( $aRow['amount'] , $source_mode->payment_currency );

                $row[] =  _d($aRow['date']);

                $status = $this->resourcebooking_model->payment_status( $aRow["status"] );

                $row[] =  $status;

                // $row[] = nl2br( $aRow['description'] ) ;

                $output['aaData'][] = $row;

            }

            echo json_encode($output);

            die();

        }

    }

    public function payment_status( $status = 0 )
    {

        return $this->resourcebooking_model->payment_status( $status );

    }

    public function payment_detail( $record_id = 0 )
    {

        $data = [];


        $data['record_id']    = $record_id;

        $data['detail']   = $this->db->where('id',$record_id)->get(db_prefix() . 'booking_payments')->row();

        if ( !empty( $data['detail'] ) )
        {

            $data['payment_mode'] = $this->case_model->get_transaction( $data['detail']->payment_id );

            $data['status_text'] = $this->payment_status( $data['detail']->status );

            $data['booking'] = $this->db->select('purpose')->from(db_prefix().'booking')->where('id',$data['detail']->booking_id)->get()->row();

            $data['attachments'] = $this->resourcebooking_model->get_attachments( $record_id );

            $this->load->view('v_payment_detail',$data);

        }

    }


    public function payment_status_change()
    {

        $record_id  = $this->input->post('record_id');
        $status     = $this->input->post('status');

        $detail   = $this->db->select('*')->where('id',$record_id)->get(db_prefix() . 'booking_payments')->row();

        if ( !empty( $detail ) )
        {


            if ( $status == 2 ) // cancel
            {

                $added_staff_id     = $detail->added_staff_id;
                $reject_description = $this->input->post('reject_description');

                $this->db->set('status',2)
                        ->set('reject_description',$reject_description)
                        ->where('id',$record_id)
                        ->update(db_prefix().'booking_payments');


                if ( !empty( $reject_description ) && !empty( $added_staff_id ) )
                {

                    /**
                     * Send notification to added staff
                     */
                    $this->db->insert(db_prefix() . 'notifications', [

                        'description' => _l('booking_payment_request_rejected' , $reject_description ),

                        'touserid' => $added_staff_id,

                        'fromcompany' => 1,

                        'fromuserid' => get_staff_user_id(),

                        'link' => 'resourcebooking/booking/' . $detail->booking_id,

                        'additional_data' => '',

                        'date' => date('Y-m-d H:i:s')

                    ]);
                }

            }

            elseif( $status == 1 ) // approve
            {

                $db_data = [

                    'source_mode' => $detail->payment_id,

                    'client_id' => 0,

                    'staff_id' => 0 ,

                    'amount' =>  $detail->amount ,

                    'description' => $detail->description ,

                    'date' => $detail->date,

                    'added_from' => get_staff_user_id()

                ];


                $db_data['added_date'] = date('Y-m-d H:i:s');

                $this->db->insert(db_prefix().'payment_modes_income',$db_data);

                $bank_case_payment_record_id = $this->db->insert_id();

                $this->db->set('status',1)
                        ->set('bank_case_payment_record_id',$bank_case_payment_record_id)
                        ->where('id',$record_id)
                        ->update(db_prefix().'booking_payments');

            }

        }

        echo json_encode( [ true ] );

    }

    public function payment_status_undo()
    {

        $record_id  = $this->input->post('record_id');

        $detail   = $this->db->select('bank_case_payment_record_id,booking_id,status')->where('id',$record_id)->get(db_prefix() . 'booking_payments')->row();

        if ( !empty( $detail ) && is_admin() )
        {


            if( $detail->status == 1 ) // approve
            {

                $this->db->where('id',$detail->bank_case_payment_record_id)->delete(db_prefix().'payment_modes_income');
                log_activity('Deleted payment income payment. Booking payment id : '.$record_id);

            }

            $this->db->set('status',0)->where('id',$record_id)->update(db_prefix().'booking_payments');

            log_activity('Event payment status undo [ Event ID '.$detail->booking_id.' : Payment ID : '.$record_id.' ] ');

        }

        echo json_encode( [ true ] );

    }

    public function payment_delete( $record_id = 0 )
    {

        if ( $this->input->is_ajax_request() )
        {

            $this->db->where('id',$record_id)->delete(db_prefix().'booking_payments');


            log_activity( "Event payment deleted [ id : $record_id ]" );


            echo json_encode([ true ]);

        }

    }


    public function debt_menu()
    {

        $data['title'] = _l('booking_debt_approval');

        $this->load->view( 'v_debt_menu' , $data );

    }

    public function debt_lists( $dont_show_zero_record = 0 , $show_pending_approval = 0 )
    {

        if ( $this->input->is_ajax_request() )
        {


            $sTable     = db_prefix().'booking_debt';
            $booking    = db_prefix().'booking';

            $aColumns = [

                $sTable.'.id as id',

                'purpose',

                $sTable.'.name as name',

                $sTable.'.amount as amount',

                $sTable.'.paid as paid',

                '( '.$sTable.'.amount -  '.$sTable.'.paid  ) as debt',

                $sTable.'.added_date as date',

              //  $sTable.'.status as status',

            ];

            $where = [];

            if ( $dont_show_zero_record == 1 )
                $where[] = 'AND ( '.$sTable.'.amount -  '.$sTable.'.paid  ) > 0';

            if ( $show_pending_approval == 1 )
                $where[] = "AND $sTable.id IN ( SELECT debt_id FROM ".db_prefix()."booking_debt_payments WHERE status = 0 ) ";

            if( $this->input->post('from_payment_mode') )

                $where[] = "AND $sTable.payment_id = ".$this->input->post('from_payment_mode');


            $sIndexColumn = 'id';

            $join = [

                'LEFT JOIN ' . $booking . ' ON ' . $booking . '.id = ' . $sTable . '.booking_id',

            ];

            $result = data_tables_init( $aColumns , $sIndexColumn , $sTable , $join , $where , [ 'booking_id' ] );

            $output  = $result['output'];

            $rResult = $result['rResult'];

            $base_currency = get_base_currency();

            $footer_data['total_amount']    = 0;
            $footer_data['total_paid']      = 0;
            $footer_data['total_debt']      = 0;


            foreach( $rResult as $aRow )
            {

                $row = [];


                $record_id = $aRow['id'];
                $booking_id = $aRow['booking_id'];


                $footer_data['total_amount']    += $aRow['amount'];
                $footer_data['total_paid']      += $aRow['paid'];
                $footer_data['total_debt']      += $aRow['debt'];



                $numberOutput = "# $record_id" ;

                $numberOutput .= '<div class="row-options">';

                $numberOutput .= "<a class='text-info' href='#' onclick='booking_debt_detail( $record_id ); return false;'>" . _l('view') . "</a>";

                $numberOutput .= '</div>';

                $row[] =  $numberOutput;

                $link   = admin_url('resourcebooking/booking/'.$booking_id );

                $row[] =  "<a target='_blank' href='$link'> ".$aRow['purpose']." </a>";

                $row[] = $aRow['name'] ;


                $row[] =  app_format_money( $aRow['amount'] , $base_currency );

                $row[] =  app_format_money( $aRow['paid'] , $base_currency );

                $debt_row = app_format_money( $aRow['debt'] , $base_currency );
                if ( $aRow['debt'] > 0 )
                    $debt_row = "<span class='text-danger'>$debt_row</span>";

                $row[] =  $debt_row;

                $row[] =  _d($aRow['date']);

                //$status = $this->resourcebooking_model->payment_status( $aRow["status"] );

                //$row[] =  $status;


                $has_pending_payment = $this->db->select('id')->from(db_prefix().'booking_debt_payments')->where('status',0)->where('debt_id',$record_id)->get()->row();


                if ( !empty( $has_pending_payment ) )
                {
                    $row['DT_RowClass'] = 'warning';
                }


                $output['aaData'][] = $row;

            }



            $footer_data['total_amount']    = e(app_format_money($footer_data['total_amount'],$base_currency));
            $footer_data['total_paid']      = e(app_format_money($footer_data['total_paid'],$base_currency));
            $footer_data['total_debt']      = e(app_format_money($footer_data['total_debt'],$base_currency));

            $output['sums']              = $footer_data;


            echo json_encode($output);

            die();

        }

    }

    public function debt_detail( $record_id = 0 )
    {

        $data = [];


        $data['record_id']    = $record_id;

        $data['detail']   = $this->db->where('id',$record_id)->get(db_prefix() . 'booking_debt')->row();

        if ( !empty( $data['detail'] ) )
        {

            $data['status_text'] = $this->payment_status( $data['detail']->status );

            $data['booking'] = $this->db->select('purpose')->from(db_prefix().'booking')->where('id',$data['detail']->booking_id)->get()->row();

            $data['attachments'] = $this->resourcebooking_model->get_attachments( $record_id );

            $data['payments'] = $this->resourcebooking_model->debt_payments( $record_id );

            $this->load->view('v_debt_detail',$data);

        }

    }

    public function debt_status_change()
    {
        $record_id  = $this->input->post('debt_id');
        $payment_id = $this->input->post('payment_id');
        $status     = $this->input->post('status');

        $detail   = $this->db->where('id',$record_id)->get(db_prefix() . 'booking_debt')->row();

        if ( !empty( $detail ) )
        {

            if ( $status == 2 ) // cancel
            {

                $this->db->set('status',2)->where('id',$payment_id)->update(db_prefix().'booking_debt_payments');

                log_activity('debt payment reject event debt id :  '.$record_id.' payment id : '.$payment_id);

            }
            elseif( $status == 1 ) // approve
            {

                $this->db->set('status',1)->where('id',$payment_id)->update(db_prefix().'booking_debt_payments');

                log_activity('debt payment approved event debt id :  '.$record_id.' payment id : '.$payment_id);
            }


            $records = $this->resourcebooking_model->debt_payments( $record_id );

            $total_paid = 0;
            foreach ( $records as $record )
            {

                if ( $record->status == 1 )
                    $total_paid += $record->payment_amount;

            }

            $this->db->set('paid',$total_paid)->where('id',$record_id)->update(db_prefix().'booking_debt');

        }

        echo json_encode( [ true ] );

    }

    /**
     * @date 2024-05-08 Undo status changes
     */
    public function debt_status_undo()
    {
        $record_id  = $this->input->post('debt_id');
        $payment_id = $this->input->post('payment_id');

        $detail   = $this->db->where('id',$record_id)->get(db_prefix() . 'booking_debt')->row();

        if ( !empty( $detail ) && is_admin() )
        {

            $this->db->set('status',0)->where('id',$payment_id)->update(db_prefix().'booking_debt_payments');

            log_activity('debt payment status changes undo event debt id :  '.$record_id.' payment id : '.$payment_id);

            $records = $this->resourcebooking_model->debt_payments( $record_id );

            $total_paid = 0;
            foreach ( $records as $record )
            {

                if ( $record->status == 1 )
                    $total_paid += $record->payment_amount;

            }

            $this->db->set('paid',$total_paid)->where('id',$record_id)->update(db_prefix().'booking_debt');

        }

        echo json_encode( [ true ] );

    }


}

