<div class="modal-dialog" role="document">

    <div class="modal-content">

        <div class="modal-header">

            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>

            <h4 class="modal-title" id="myModalLabel">

                <span>Debt</span>

            </h4>

        </div>


        <input type="hidden" name="id" id="id" value="<?php echo $detail->id?>" />

        <div class="modal-body">

            <div class="row">

                <div class="col-md-12">


                    <table class="table no-margin project-overview-table">

                        <tbody>

                            <tr class="project-overview paddedbooking">
                                <td class="bold"><?php echo _l('booking_detail'); ?></td>
                                <td><?php echo $booking->purpose?></td>
                            </tr>

                            <tr class="project-overview paddedbooking">
                                <td class="bold"><?php echo _l('name'); ?></td>
                                <td><?php echo $detail->name?></td>
                            </tr>

                            <tr class="project-overview paddedbooking">
                                <td class="bold"><?php echo _l('invoice_payments_table_amount_heading'); ?></td>
                                <td><?php echo app_format_money( $detail->amount , get_base_currency() )?></td>
                            </tr>

                            <tr class="project-overview paddedbooking">
                                <td class="bold"><?php echo _l('booking_paid')?></td>
                                <td><?php echo app_format_money( $detail->paid , get_base_currency() )?></td>
                            </tr>

                            <tr class="project-overview paddedbooking">
                                <td class="bold"><?php echo _l('invoice_payments_table_date_heading'); ?></td>
                                <td><?php echo _d($detail->added_date)?></td>
                            </tr>


                            <tr class="project-overview paddedbooking hide">
                                <td class="bold"><?php echo _l('estimate_request_dt_status'); ?></td>
                                <td><?php echo $status_text?></td>
                            </tr>

                        </tbody>

                    </table>

                </div>


                <div class="col-md-12">

                    <table class="table dt-table">

                        <thead>
                        <tr>
                            <th><?php echo _l('invoice_table_amount_heading')?></th>
                            <th><?php echo _l('invoice_payments_table_date_heading')?></th>
                            <th><?php echo _l('status')?></th>
                        </tr>
                        </thead>

                        <tbody>
                        <?php foreach ( $payments as $payment ) { ?>

                            <tr>
                                <td><?php echo app_format_money($payment->payment_amount , 'EUR')?></td>
                                <td><?php echo _d($payment->date)?></td>
                                <td>
                                    <?php if ( $payment->status == 0 ) { ?>

                                        <a class="btn btn-success" onclick="booking_debt_status( <?php echo $record_id?> , <?php echo $payment->id?> , 1 )"> <?php echo _l('booking_approve')?> </a>

                                        <a class="btn btn-danger" onclick="booking_debt_status( <?php echo $record_id?> , <?php echo $payment->id?> , 2 )"> <?php echo _l('booking_reject')?> </a>

                                    <?php
                                    }
                                    else
                                    {
                                        echo $this->resourcebooking_model->payment_status($payment->status);


                                        if ( is_admin() ) { ?>

                                            <a class="mleft5 btn btn-warning" onclick="booking_debt_status_undo( <?php echo $record_id?> , <?php echo $payment->id?> )"> <?php echo _l('undo')?> </a>

                                    <?php }

                                    }

                                    ?>


                                </td>
                            </tr>

                        <?php } ?>
                        </tbody>

                    </table>

                </div>


            </div>

        </div>

        <div class="modal-footer">

            <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo _l('close'); ?></button>

        </div>



    </div>

</div>
