<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>



<?php init_head(); ?>



<div id="wrapper">

    <div class="content">

        <div class="row">

            <div class="col-md-12">

                <div class="panel_s">

                    <div class="panel-body">


                        <div class="col-md-3">

                            <input type="hidden" name="from_date" id="from_date" value="">

                            <input type="hidden" name="to_date" id="to_date" value="">

                            <?php $this->load->view('_statement_period_select', ['onChange' => 'reload_the_table()']); ?>

                        </div>



                        <div class="col-md-3">


                            <div class="checkbox checkbox-info">

                                <input type="checkbox" id="dont_show_none_debt" name="dont_show_none_debt" checked>

                                <label for="dont_show_none_debt"><?php echo _l('booking_dont_show_none_debt') ?></label>

                            </div>

                        </div>

                        <div class="col-md-3">


                            <div class="checkbox checkbox-info">

                                <input type="checkbox" id="show_pending_approval" name="show_pending_approval" >

                                <label for="show_pending_approval"><?php echo _l('booking_show_pending_approval') ?></label>

                            </div>

                        </div>



                        <div class="col-md-12">

                            <div class="panel-table-full">


                                <?php

                                $footer_html = '<tfoot>
                                                    <td colspan="3"></td>   
                                                    <td class="total_amount"></td>
                                                    <td class="total_paid"></td>
                                                    <td class="total_debt"></td>
                                                    <td></td>
                                                 </tfoot>';

                                render_datatable([

                                    _l('transfer_heading_id'),

                                    _l('booking_detail'),

                                    _l('name'),

                                    _l('statement_heading_amount'),

                                    _l('booking_paid'),

                                    _l('booking_debt'),

                                    _l('invoice_payments_table_date_heading'),

                                   // _l('estimate_request_dt_status')

                                ], 'payment-modes-transfer'  , [] , [] , $footer_html ); ?>

                            </div>

                        </div>



                    </div>

                </div>

            </div>

        </div>

    </div>

</div>



<div class="modal fade" id="booking_payment_modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">

</div>

<?php init_tail(); ?>



<script>



    (function($) {

        "use strict";



        $(document).ready(function (){



            transfer_table_load();


            <?php if ( !empty( $this->input->get( 'record_id' ) ) ) : ?>

                booking_debt_detail( <?php echo $this->input->get( 'record_id' )?> );

            <?php endif; ?>


            $('#dont_show_none_debt').on('change',function (){
                transfer_table_load();
            })


            $('#show_pending_approval').on('change',function (){
                transfer_table_load();
            })



            $('.table-payment-modes-transfer').on('draw.dt', function() {

                var paymentReceivedReportsTable = $(this).DataTable();

                var sums = paymentReceivedReportsTable.ajax.json().sums;

                $(this).find('tfoot').addClass('bold');

                $(this).find('tfoot td').eq(0).html("<?php echo _l('invoice_total'); ?> (<?php echo _l('per_page'); ?>)");

                $(this).find('tfoot td.total_amount').html(sums.total_amount);
                $(this).find('tfoot td.total_paid').html(sums.total_paid);
                $(this).find('tfoot td.total_debt').html(sums.total_debt);

            });


        });



    })(jQuery);



    function booking_debt_detail( record_id )
    {

        $('#booking_payment_modal').modal();


        requestGet("account_balances/booking/debt_detail/"+record_id).done(function (response) {

            $("#booking_payment_modal").html(response);

        });



    }


    function reload_the_table()

    {

        var $statementPeriod = $('#range');

        var value = $statementPeriod.selectpicker('val');

        var period = new Array();

        if (value != 'period') {

            period = JSON.parse(value);

        } else {

            period[0] = $('input[name="period-from"]').val();

            period[1] = $('input[name="period-to"]').val();



            if (period[0] == '' || period[1] == '') {

                return false;

            }

        }



        $('#from_date').val(period[0]);

        $('#to_date').val(period[1]);


        transfer_table_load();

    }



    function transfer_table_load()
    {


        if ($.fn.DataTable.isDataTable('.table-payment-modes-transfer'))

        {

            $('.table-payment-modes-transfer').DataTable().destroy();

        }

        var dont_show_debt_zero = $('#dont_show_none_debt').prop('checked') ? 1 : 0 ;
        var show_pending_approval = $('#show_pending_approval').prop('checked') ? 1 : 0 ;

        initDataTable('.table-payment-modes-transfer', admin_url+'account_balances/booking/debt_lists/'+dont_show_debt_zero+'/'+show_pending_approval, [], [],

            {

                "from_date": '#from_date',

                "to_date": '#to_date',

                "payment_mode": '#payment_mode',

            }

            , [0, 'desc']);

    }



    function booking_debt_status( debt_id , payment_id , status )
    {


        $.post(admin_url+"account_balances/booking/debt_status_change", { debt_id:debt_id , payment_id:payment_id , status:status }).done(function() {

            $('#booking_payment_modal').modal('hide');

            //transfer_table_load();

            $('.table-payment-modes-transfer').DataTable().ajax.reload();

        });


    }

    function booking_debt_status_undo( debt_id , payment_id )
    {


        $.post(admin_url+"account_balances/booking/debt_status_undo", { debt_id:debt_id , payment_id:payment_id }).done(function() {

            booking_debt_detail( debt_id );

            $('.table-payment-modes-transfer').DataTable().ajax.reload();

        });


    }



</script>



</body>



</html>

