<div class="modal-dialog" role="document">

    <div class="modal-content">

        <div class="modal-header">

            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>

            <h4 class="modal-title" id="myModalLabel">

                <span>Payment</span>

            </h4>

        </div>


        <input type="hidden" name="id" id="id" value="<?php echo $detail->id?>" />

        <div class="modal-body">

            <div class="row">

                <div class="col-md-12">


                    <table class="table no-margin project-overview-table">

                        <tbody>

                            <tr class="project-overview paddedbooking">
                                <td class="bold"><?php echo _l('booking_detail'); ?></td>
                                <td><?php echo $booking->purpose?></td>
                            </tr>

                            <tr class="project-overview paddedbooking">
                                <td class="bold"><?php echo _l('invoice_payments_table_mode_heading'); ?></td>
                                <td><?php echo $payment_mode->name?></td>
                            </tr>

                            <tr class="project-overview paddedbooking">
                                <td class="bold"><?php echo _l('invoice_payments_table_amount_heading'); ?></td>
                                <td><?php echo app_format_money( $detail->amount , $payment_mode->payment_currency )?></td>
                            </tr>

                            <tr class="project-overview paddedbooking">
                                <td class="bold"><?php echo _l('invoice_payments_table_date_heading'); ?></td>
                                <td><?php echo _d($detail->date)?></td>
                            </tr>

                            <tr class="project-overview paddedbooking">
                                <td class="bold"><?php echo _l('estimate_request_dt_status'); ?></td>
                                <td><?php echo $status_text?></td>
                            </tr>

                            <tr class="project-overview paddedbooking">
                                <td class="bold"><?php echo _l('transfer_heading_description'); ?></td>
                                <td><?php echo nl2br($detail->description)?></td>
                            </tr>



                            <?php if ( !empty( $attachments ) && count( $attachments ) > 0 ) { ?>

                                <tr class="project-overview paddedbooking">

                                    <td class="bold"><?php echo _l('add_task_attachments'); ?></td>

                                    <td>

                                        <?php foreach ( $attachments as $attachment) {

                                            $attachment_url = site_url('download/file/booking_payment/' . $attachment['attachment_key']);

                                            if (!empty($attachment['external'])) {

                                                $attachment_url = $attachment['external_link'];

                                            }
                                            ?>

                                            <div class="pull-left"><i class="<?php echo get_mime_class($attachment['filetype']); ?>"></i></div>

                                            <a href="<?php echo e($attachment_url); ?>"

                                               target="_blank"><?php echo e($attachment['file_name']); ?></a>

                                            <br />

                                            <small class="text-muted"> <?php echo e($attachment['filetype']); ?></small>

                                            <hr />

                                        <?php } ?>

                                    </td>

                                </tr>

                            <?php } ?>



                            <?php if ( !empty( $detail->reject_description ) ) { ?>

                                <tr class="project-overview paddedbooking">
                                    <td class="bold"><?php echo _l('booking_reject_description'); ?></td>
                                    <td><?php echo nl2br($detail->reject_description)?></td>
                                </tr>

                            <?php } elseif ( $detail->status == 0 ) { ?>

                                <tr class="project-overview paddedbooking">
                                    <td class="bold"><?php echo _l('booking_reject_description'); ?></td>
                                    <td>
                                        <?php echo render_textarea('reject_description', '', '' , [ 'rows' => 5]); ?>
                                    </td>
                                </tr>


                            <?php } ?>


                        </tbody>

                    </table>

                </div>

            </div>

        </div>

        <div class="modal-footer">

            <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo _l('close'); ?></button>

            <?php if ( $detail->status == 0 ) { ?>

                <a class="btn btn-success" onclick="booking_payment_status( <?php echo $record_id?> , 1 )"> <?php echo _l('booking_approve')?> </a>

                <a class="btn btn-danger" onclick="booking_payment_status( <?php echo $record_id?> , 2 )"> <?php echo _l('booking_reject')?> </a>

            <?php } elseif( is_admin() ){ ?>

                <a class="btn btn-warning" onclick="booking_payment_status_undo( <?php echo $record_id?> )"> <span class="fa fa-undo"> </span> <?php echo _l('undo')?> </a>

            <?php } ?>


        </div>



    </div>

</div>

