<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>



<?php init_head(); ?>



<div id="wrapper">

    <div class="content">

        <div class="row">

            <div class="col-md-12">

                <div class="panel_s">

                    <div class="panel-body">


                        <div class="col-md-4">

                            <input type="hidden" name="from_date" id="from_date" value="">

                            <input type="hidden" name="to_date" id="to_date" value="">

                            <?php $this->load->view('_statement_period_select', ['onChange' => 'reload_the_table()']); ?>

                        </div>


                        <div class="col-md-4">

                            <?php echo render_select( 'payment_mode' , $payment_modes , [ 'id' , [ 'name'] ] ,  '' , '' , ['onchange' => 'transfer_table_load()' , 'data-none-selected-text' => _l('invoice_payments_table_mode_heading') ] ); ?>

                        </div>



                        <div class="col-md-4">


                            <div class="checkbox checkbox-info">

                                <input type="checkbox" id="show_pending_approval" name="show_pending_approval" >

                                <label for="show_pending_approval"><?php echo _l('booking_show_pending_approval') ?></label>

                            </div>

                        </div>



                        <div class="col-md-12">

                            <div class="panel-table-full">

                                <?php render_datatable([

                                    _l('transfer_heading_id'),

                                    _l('booking_detail'),

                                    _l('invoice_payments_table_mode_heading'),

                                    // _l('team'),

                                    _l('statement_heading_amount'),

                                    _l('invoice_payments_table_date_heading'),

                                    _l('estimate_request_dt_status')

                                ], 'payment-modes-transfer'); ?>

                            </div>

                        </div>



                    </div>

                </div>

            </div>

        </div>

    </div>

</div>



<div class="modal fade" id="booking_payment_modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">

</div>

<?php init_tail(); ?>



<script>



    (function($) {

        "use strict";



        $(document).ready(function (){



            transfer_table_load();


            <?php if ( !empty( $this->input->get( 'record_id' ) ) ) : ?>

                booking_payment_detail( <?php echo $this->input->get( 'record_id' )?> );

            <?php endif; ?>



            $('#show_pending_approval').on('change',function (){
                transfer_table_load();
            })


        });



    })(jQuery);



    function booking_payment_detail( record_id )
    {

        $("#booking_payment_modal").html('');
        $('#booking_payment_modal').modal();


        requestGet("account_balances/booking/payment_detail/"+record_id).done(function (response) {

            $("#booking_payment_modal").html(response);

        });



    }


    function reload_the_table()

    {

        var $statementPeriod = $('#range');

        var value = $statementPeriod.selectpicker('val');

        var period = new Array();

        if (value != 'period') {

            period = JSON.parse(value);

        } else {

            period[0] = $('input[name="period-from"]').val();

            period[1] = $('input[name="period-to"]').val();



            if (period[0] == '' || period[1] == '') {

                return false;

            }

        }



        $('#from_date').val(period[0]);

        $('#to_date').val(period[1]);


        transfer_table_load();

    }



    function transfer_table_load()
    {


        if ($.fn.DataTable.isDataTable('.table-payment-modes-transfer'))

        {

            $('.table-payment-modes-transfer').DataTable().destroy();

        }


        var show_pending_approval = $('#show_pending_approval').prop('checked') ? 1 : 0 ;

        initDataTable('.table-payment-modes-transfer', admin_url+'account_balances/booking/booking_lists/'+show_pending_approval, [], [],

            {

                "from_date": '#from_date',

                "to_date": '#to_date',

                "payment_mode": '#payment_mode',

            }

            , [0, 'desc']);

    }



    function booking_payment_status( record_id , status )
    {

        if( status == 2 )
        {

            if ( $('#reject_description').val() )
            {

                $.post(admin_url+"account_balances/booking/payment_status_change", { record_id:record_id , status:status , reject_description : $('#reject_description').val() }).done(function() {

                    $('#booking_payment_modal').modal('hide');

                    transfer_table_load();

                });

            }
            else
                $('#reject_description').focus();

        }
        else
        {

            $.post(admin_url+"account_balances/booking/payment_status_change", { record_id:record_id , status:status }).done(function() {

                $('#booking_payment_modal').modal('hide');

                transfer_table_load();

            });

        }



    }


    function booking_payment_status_undo( record_id )
    {

        if ( confirm_delete() )
        {

            $.post(admin_url+"account_balances/booking/payment_status_undo", { record_id:record_id }).done(function() {

                booking_payment_detail( record_id );

                $('.table-payment-modes-transfer').DataTable().ajax.reload();

            });


        }

    }





    function booking_payment_delete( record_id )
    {

        requestGet("account_balances/booking/payment_delete/"+record_id).done(function () {

            $('.table-payment-modes-transfer').DataTable().ajax.reload();

        });



    }



</script>



</body>



</html>

