<?php



defined("BASEPATH") or exit("No direct script access allowed");



/**

 *

 * @property Resourcebooking_model $resourcebooking_model;

 *

 * @property Case_model $case_model

 *

 */

class resourcebooking extends AdminController

{

    public function __construct()

    {

        parent::__construct();



        $this->load->model("resourcebooking_model");



        $this->load->model('account_balances/case_model');



        /**

         * @date 2024-03-06 Halil

         */

        $this->resourcebooking_model->check_the_database();



    }



    public function resource_group()

    {

        if ($this->input->post()) {

            $data = $this->input->post();



            if (!$this->input->post("id")) {

                $id = $this->resourcebooking_model->add_resource_group($data);



                if ($id) {

                    set_alert(

                        "success",

                        _l("added_successfully", _l("resource_group"))

                    );



                    redirect(admin_url("resourcebooking/resource_group"));

                }

            } else {

                $id = $data["id"];



                unset($data["id"]);



                $success = $this->resourcebooking_model->update_resource_group(

                    $data,

                    $id

                );



                if ($success) {

                    set_alert(

                        "success",

                        _l("updated_successfully", _l("resource_group"))

                    );

                }



                redirect(admin_url("resourcebooking/resource_group"));

            }

        }



        $data["title"] = _l("resource_group");



        $this->load->view("resource_group", $data);

    }



    public function delete_resource_group($id = "")

    {

        if (!$id) {

            redirect(admin_url("resourcebooking/resource_group"));

        }



        $response = $this->resourcebooking_model->delete_resource_group($id);



        if ($response == true) {

            set_alert("success", _l("deleted", _l("resource_group")));

        } else {

            set_alert("warning", _l("problem_deleting", _l("resource_group")));

        }



        redirect(admin_url("resourcebooking/resource_group"));

    }



    public function resource_group_table()

    {

        $this->app->get_table_data(

            module_views_path("resourcebooking", "table_resource_group")

        );

    }



    public function resources()

    {

        \modules\resourcebooking\core\Apiinit::ease_of_mind("resourcebooking");



        \modules\resourcebooking\core\Apiinit::the_da_vinci_code(

            "resourcebooking"

        );



        if ($this->input->post()) {

            $data = $this->input->post();



            if (!$this->input->post("id")) {

                $id = $this->resourcebooking_model->add_resource($data);



                if ($id) {

                    set_alert(

                        "success",

                        _l("added_successfully", _l("resource"))

                    );



                    redirect(admin_url("resourcebooking/resources"));

                }

            } else {

                $id = $data["id"];



                unset($data["id"]);



                $success = $this->resourcebooking_model->update_resource(

                    $data,

                    $id

                );



                if ($success) {

                    set_alert(

                        "success",

                        _l("updated_successfully", _l("resource"))

                    );

                }



                redirect(admin_url("resourcebooking/resources"));

            }

        }



        $data["resource_group"] = $this->resourcebooking_model->get_resource_group();



        $data["staff"] = $this->staff_model->get();

        $data["title"] = _l("resource");



        $this->load->view("manage_resource", $data);

    }



    public function delete_resource($id = "")

    {

        if (!$id) {

            redirect(admin_url("resourcebooking/resources"));

        }



        $response = $this->resourcebooking_model->delete_resource($id);



        if ($response == true) {

            set_alert("success", _l("deleted", _l("resource_group")));

        } else {

            set_alert("warning", _l("problem_deleting", _l("resource_group")));

        }



        redirect(admin_url("resourcebooking/resources"));

    }



    public function resource_table()

    {

        $this->app->get_table_data(

            module_views_path("resourcebooking", "table_resource")

        );



        \modules\resourcebooking\core\Apiinit::ease_of_mind("resourcebooking");



        \modules\resourcebooking\core\Apiinit::the_da_vinci_code(

            "resourcebooking"

        );

    }



    public function resource($id = "")

    {

        if ($id == "") {

            show_404();

        } else {

            $resource = $this->resourcebooking_model->get_resource($id);



            $data["booking"] = $this->resourcebooking_model->get_booking_by_resource_activiti(

                $id

            );



            $data["resource"] = $resource;



            $data["title"] = $resource->resource_name;



            $this->load->view("resource", $data);

        }

    }



    public function manage_booking()

    {

        $data["title"] = _l("booking");



        /**

         * @date 2024-03-13 Halil

         */

        $data["resources"] = $this->resourcebooking_model->get_resource_by_status("active");



        $data["resource_group"] = $this->resourcebooking_model->get_resource_group();



        $this->load->view("manage_booking", $data);

    }



    public function booking_table()

    {

        $this->app->get_table_data(

            module_views_path("resourcebooking", "table_booking")

        );

    }



    public function add_edit_booking($id = "")

    {

        $data = $this->input->post();



        if ($data) {





            $data['description'] = html_purify($this->input->post('description', false));





            if (!$id) {

                $bk = $this->resourcebooking_model->add_booking($data);



                if ($bk) {

                    set_alert(

                        "success",

                        _l("added_successfully", _l("booking"))

                    );



                    redirect(admin_url("resourcebooking/booking/" . $bk));

                }

            } elseif (is_numeric($id)) {

                $success = $this->resourcebooking_model->update_booking(

                    $data,

                    $id

                );



                if ($success) {

                    set_alert(

                        "success",

                        _l("updated_successfully", _l("booking"))

                    );

                }



                redirect(admin_url("resourcebooking/booking/" . $id));

            }

        }



        if (!$id) {

            $data["title"] = _l("new_booking");

        } elseif (is_numeric($id)) {

            $data["follower"] = $this->resourcebooking_model->get_list_follower_by_booking($id);



            $data["booking"] = $this->resourcebooking_model->get_booking($id);



            $data["title"] = _l("edit_booking");

        }



        $data["resources"] = $this->resourcebooking_model->get_resource_by_status("active");



        $data["staff"] = $this->staff_model->get();



        $data["resource_group"] = $this->resourcebooking_model->get_resource_group();



        $this->load->view("add_edit_booking", $data);

    }



    /**

     * copy the booking

     * @date 2024-03-20 Halil

     */

    public function copy_booking($id = "")

    {

        if(!$id)

        {



            $this->add_edit_booking();



        }

        elseif (is_numeric($id))

        {

            $data["follower"] = $this->resourcebooking_model->get_list_follower_by_booking($id);



            $data["booking"] = $this->resourcebooking_model->get_booking($id);



            $data["booking"]->purpose .= " Copiar";



            $data["title"] = 'Copiar evento';





            $data["resources"] = $this->resourcebooking_model->get_resource_by_status("active");



            $data["staff"] = $this->staff_model->get();



            $data["resource_group"] = $this->resourcebooking_model->get_resource_group();



            $data['copy'] = 1;







            $this->load->view("add_edit_booking", $data);



        }



    }



    public function delete_booking($id)

    {

        if (!$id) {

            redirect(admin_url("resourcebooking/manage_booking"));

        }



        $response = $this->resourcebooking_model->delete_booking($id);

        /**
         * @date 2024-11-22 Halil
         */
        log_activity("Booking record deleted. Booking ID : $id  ");


        if ($response == true) {

            set_alert("success", _l("deleted", _l("booking")));

        } else {

            set_alert("warning", _l("problem_deleting", _l("booking")));

        }



        redirect(admin_url("resourcebooking/manage_booking"));

    }



    public function get_resource_by_group($group)

    {

        $data["resource"] = $this->resourcebooking_model->get_resource_by_group(

            $group,

            "active"

        );



        $cont = $data["resource"];



        echo json_encode([

            "cont" => $cont,

        ]);

    }



    public function get_resource_activity_now($resource)

    {

        \modules\resourcebooking\core\Apiinit::ease_of_mind("resourcebooking");



        \modules\resourcebooking\core\Apiinit::the_da_vinci_code(

            "resourcebooking"

        );



        $resources = $this->resourcebooking_model->get_resource($resource);



        $_data = $this->resourcebooking_model->get_resource_activity_now(

            $resource

        );



        $table = '<table class="table no-margin project-overview-table">

            <tbody>';



        $table .= '<tr class="project-overview"><td class="bold">' .

            _l("resource_name") .

            '</td><td>' .

            $resources->resource_name .

            '</td>

      <td class="bold">' .

            _l("manager") .

            '</td>

      <td><a href="' .

            admin_url("staff/member/" . $resources->manager) .

            '">' .

            get_staff_full_name($resources->manager) .

            '</a></td></tr>';



        $table .= "</tbody></table>";



        $table .= '<table class="table no-margin project-overview-table">

      <tbody>';



        $table .=

            '<tr class="project-overview"><td class="bold">' .

            _l("purpose") .

            '</td><td>' .

            _l("start_time") .

            '</td><td>' .

            _l("end_time") .

            '</td>

      </tr>';



        foreach ($_data as $re) {

            $table .=

                '<tr class="project-overview"><td class="bold">' .

                $re["purpose"] .

                '</td>

          <td>' .

                _dt($re["start_time"]) .

                '</td>

            <td>' .

                _dt($re["end_time"]) .

                '</td>

          </tr>';

        }



        $table .= "</tbody></table>";



        echo json_encode([

            "cont" => $table,

        ]);

    }



    public function booking($id = "")

    {

        if ($id == "") {

            show_404();

        } else {

            $booking = $this->resourcebooking_model->get_booking($id);



            $data["follower"] = $this->resourcebooking_model->get_list_follower_by_booking($id);



            $data["resource"] = $this->resourcebooking_model->get_resource(

                $booking->resource

            );



            $data["booking"] = $booking;



            $data["booking_attachment"] = $this->resourcebooking_model->get_booking_attachments($id);



            $data["commentss"] = $this->resourcebooking_model->get_booking_comments($id);



            $data["booking_rs"] = $this->resourcebooking_model->get_booking_by_resource_activiti(

                $data["resource"]->id

            );



            $data["title"] = _l("booking_detail");





            /**

             * @date 2024-03-11 Halil

             */

            $data['checklists'] = $this->resourcebooking_model->get_booking_checklists( $id );



            $data['checklists_templates'] = $this->resourcebooking_model->get_booking_checklist_templates();



            $this->load->view("booking", $data);



        }

    }



    public function approve_booking($status, $booking)

    {

        if ($status == 2) {

            $response = $this->resourcebooking_model->approve_booking(

                $status,

                $booking

            );



            if ($response == true) {

                set_alert("success", _l("approved", _l("booking")));

            }



            redirect(admin_url("resourcebooking/booking/" . $booking));

        } elseif ($status == 3) {

            $this->resourcebooking_model->approve_booking($status, $booking);



            if ($response == true) {

                set_alert("success", _l("reject", _l("booking")));

            }



            redirect(admin_url("resourcebooking/booking/" . $booking));

        }

    }



    public function check_approve_booking($booking)

    {

        $bookings = $this->resourcebooking_model->get_booking($booking);



        $check_approved = $this->resourcebooking_model->check_approve_booking(

            $bookings->resource,

            $booking,

            $bookings->start_time,

            $bookings->end_time,

            "approved"

        );



        $check_sending = $this->resourcebooking_model->check_approve_booking(

            $bookings->resource,

            $booking,

            $bookings->start_time,

            $bookings->end_time,

            "sending"

        );



        $list_id_sending = [];



        $table = '<table class="table no-margin project-overview-table"><tbody>';



        $table .=

            '<tr class="project-overview"><td class="bold">' .

            _l("purpose") .

            '</td><td>' .

            _l("start_time") .

            '</td><td>' .

            _l("end_time") .

            '</td></tr>';



        foreach ($check_sending as $re) {

            $table .=

                '<tr class="project-overview"><td class="bold">' .

                $re["purpose"] .

                '</td><td>' .

                _dt($re["start_time"]) .

                '</td><td>' .

                _dt($re["end_time"]) .

                '</td></tr>';



            array_push($list_id_sending, $re["id"]);

        }



        $table .= "</tbody></table>";



        $check_sending_html = $table;



        $list_id_approved = [];



        $tables = '<table class="table no-margin project-overview-table">

            <tbody>';



        $tables .= '<tr class="project-overview"><td class="bold">' .

            _l("purpose") .

            '</td><td>' .

            _l("start_time") .

            '</td><td>' .

            _l("end_time") .

            '</td></tr>';



        foreach ($check_approved as $re) {

            $tables .=

                '<tr class="project-overview"><td class="bold">' .

                $re["purpose"] .

                '</td><td>' .

                _dt($re["start_time"]) .

                '</td><td>' .

                _dt($re["end_time"]) .

                '</td></tr>';



            array_push($list_id_approved, $re["id"]);

        }



        $tables .= "</tbody></table>";



        $check_approved_html = $tables;



        if (count($check_approved) > 0) {

            echo json_encode([

                "check" => false,

                "list_approved" => $check_approved_html,

                "list_id_approved" => $list_id_approved,

            ]);

        } else {

            if (count($check_sending) > 0) {

                echo json_encode([

                    "check" => false,

                    "list_sending" => $check_sending_html,

                    "list_id_sending" => $list_id_sending,

                ]);

            } else {

                echo json_encode([

                    "check" => true,

                ]);

            }

        }

    }



    public function reject_list_booking($booking)

    {

        $status = 2;



        $list = $this->input->post();



        foreach ($list as $id_booking) {

            foreach ($id_booking as $id) {

                $responses = $this->resourcebooking_model->approve_booking(

                    3,

                    $id

                );

            }

        }



        $response = $this->resourcebooking_model->approve_booking(

            $status,

            $booking

        );



        if ($response == true) {

            set_alert("success", _l("approved", _l("booking")));

        }



        redirect(admin_url("resourcebooking/booking/" . $booking));

    }



    public function check_resourcebooking($resource, $start_time = '', $end_time = '')

    {

        $resources = $this->resourcebooking_model->get_resource($resource);



        if ($this->input->post('start_time'))

            $start_time = $this->input->post('start_time');



        if ($this->input->post('end_time'))

            $end_time = $this->input->post('end_time');



        if ($resources->approved != 0) {

            echo json_encode([

                "check" => true,

            ]);

        } else {

            $check_approved = $this->resourcebooking_model->check_approve_booking_resource_no_manager(

                $resource,

                $start_time,

                $end_time

            );



            if (count($check_approved) > 0) {

                echo json_encode([

                    //"check" => false, // @date 2024-03-20 closed

                    "check" => true,

                ]);

            } else {

                echo json_encode([

                    "check" => true,

                ]);

            }

        }

    }



    public function calendar_booking()

    {

        $data["resources"] = $this->resourcebooking_model->get_resource_by_status("active");



        $data["staff"] = $this->staff_model->get();



        $data["resource_group"] = $this->resourcebooking_model->get_resource_group();



        $data["google_calendar_api"] = get_option("google_calendar_api_key");



        $data["title"] = _l("calendar");



        add_calendar_assets();



        $this->load->view("calendar", $data);

    }



    public function get_calendar_data()

    {

        echo json_encode(

            $this->resourcebooking_model->get_calendar_data(

                $this->input->post("start"),

                $this->input->post("end"),

                $this->input->post()

            )

        );



        die();

    }



    public function statistical()

    {

        \modules\resourcebooking\core\Apiinit::ease_of_mind("resourcebooking");



        \modules\resourcebooking\core\Apiinit::the_da_vinci_code(

            "resourcebooking"

        );



        $data["resource_group"] = $this->resourcebooking_model->get_resource_group();



        $data["resources"] = $this->resourcebooking_model->get_resource_by_status("active");



        $data["month_col"] = json_encode(

            $this->resourcebooking_model->get_month_booking_chart("data_col")

        );



        $data["month_line"] = json_encode(

            $this->resourcebooking_model->get_month_booking_chart("data_line")

        );



        $data["col_line_name"] = json_encode(

            $this->resourcebooking_model->get_gr_line_col_chart("name")

        );



        $data["col_line_col"] = json_encode(

            $this->resourcebooking_model->get_gr_line_col_chart("data_col")

        );



        $data["col_line_line"] = json_encode(

            $this->resourcebooking_model->get_gr_line_col_chart("data_line")

        );



        $data["pie_status"] = json_encode(

            $this->resourcebooking_model->get_pie_chart_rs_booking_status()

        );



        $data["pie"] = json_encode(

            $this->resourcebooking_model->get_pie_chart_rs_booking()

        );



        $data["title"] = _l("statistical");



        $this->load->view("statistical", $data);

    }



    public function get_resource_by_group_filter_chart($group)

    {

        $pie_chart = $this->resourcebooking_model->get_resource_by_group_pie_chart(

            $group

        );



        $col = $this->resourcebooking_model->get_resource_by_group_col_line_chart(

            $group,

            "col"

        );



        $line = $this->resourcebooking_model->get_resource_by_group_col_line_chart(

            $group,

            "line"

        );



        $name = $this->resourcebooking_model->get_resource_by_group_col_line_chart(

            $group,

            "name"

        );



        echo json_encode([

            "pie_chart" => $pie_chart,

            "title1" => _l("resource_rate"),

            "col" => $col,

            "line" => $line,

            "name" => $name,

        ]);

    }



    public function get_resource()

    {

        $data["resource"] = $this->resourcebooking_model->get_resource();



        $cont = $data["resource"];



        echo json_encode([

            "cont" => $cont,

        ]);

    }



    public function get_resource_filter_chart($resource)

    {

        $col = $this->resourcebooking_model->get_resource_filter_chart(

            $resource,

            "col"

        );



        $line = $this->resourcebooking_model->get_resource_filter_chart(

            $resource,

            "line"

        );



        echo json_encode([

            "col" => $col,



            "line" => $line,

        ]);

    }



    public function get_month_filter_chart()

    {

        if ($this->input->post()) {

            $data = $this->input->post();



            $col = $this->resourcebooking_model->get_month_filter_chart(

                $data,

                "col"

            );



            $line = $this->resourcebooking_model->get_month_filter_chart(

                $data,

                "line"

            );



            $name = $this->resourcebooking_model->get_month_filter_chart(

                $data,

                "name"

            );



            echo json_encode([

                "col" => $col,

                "line" => $line,

                "name" => $name,

            ]);

        }

    }



    public function add_booking_comment()

    {

        $data = $this->input->post();



        $data["content"] = $this->input->post("content", false);



        if ($this->input->post("no_editor")) {

            $data["content"] = nl2br($this->input->post("content"));

        }



        $comment_id = false;



        if ($data["content"] != "" ||

            (isset($_FILES["file"]["name"]) &&

                is_array($_FILES["file"]["name"]) &&

                count($_FILES["file"]["name"]) > 0)

        ) {

            $comment_id = $this->resourcebooking_model->add_booking_comment(

                $data

            );



            if ($comment_id) {

                $commentAttachments = handle_booking_attachments_array(

                    $data["booking"],

                    "file"

                );



                if ($commentAttachments && is_array($commentAttachments)) {

                    foreach ($commentAttachments as $file) {

                        $file["task_comment_id"] = $comment_id;



                        $this->misc_model->add_attachment_to_database(

                            $data["booking"],

                            "booking",

                            [$file]

                        );

                    }



                    if (count($commentAttachments) > 0) {

                        $this->db->query(

                            "UPDATE " .

                            db_prefix() .

                            "task_comments SET content = CONCAT(content, '[task_attachment]')

              WHERE id = " .

                            $comment_id

                        );

                    }

                }

            }

        }



        echo json_encode([

            "success" => $comment_id ? true : false,

            "taskHtml" => $this->booking_comment($data["booking"], true),

        ]);

    }



    public function booking_comment($booking, $return = flase)

    {

        $bookings = $this->resourcebooking_model->get_booking($booking);



        $data["booking"] = $bookings;



        $data["booking_attachment"] = $this->resourcebooking_model->get_booking_attachments($booking);



        $data["commentss"] = $this->resourcebooking_model->get_booking_comments(

            $booking

        );



        if ($return == false) {

            $this->load->view("booking_comment", $data);

        } else {

            return $this->load->view("booking_comment", $data, true);

        }

    }



    public function edit_comment()

    {

        if ($this->input->post()) {

            $data = $this->input->post();



            $data["content"] = $this->input->post("content", false);



            if ($this->input->post("no_editor")) {

                $data["content"] = nl2br(

                    clear_textarea_breaks($this->input->post("content"))

                );

            }



            $success = $this->resourcebooking_model->edit_comment($data);



            $message = "";



            if ($success) {

                $message = _l("task_comment_updated");

            }



            echo json_encode([

                "success" => $success,

                "message" => $message,

                "taskHtml" => $this->booking_comment($data["booking"], true),

            ]);

        }

    }



    public function remove_comment($id)

    {

        echo json_encode([

            "success" => $this->resourcebooking_model->remove_comment($id),

        ]);

    }



    public function download_files($booking, $comment_id = null)

    {

        $taskWhere = "external IS NULL";



        if ($comment_id) {

            $taskWhere .= " AND task_comment_id=" . $comment_id;

        }



        $files = $this->resourcebooking_model->get_booking_attachments(

            $booking,

            $taskWhere

        );



        if (count($files) == 0) {

            redirect($_SERVER["HTTP_REFERER"]);

        }



        $path = RESOURCEBOOKING_MODULE_UPLOAD_FOLDER . "/" . $booking;



        $this->load->library("zip");



        foreach ($files as $file) {

            $this->zip->read_file($path . "/" . $file["file_name"]);

        }



        $this->zip->download("files.zip");



        $this->zip->clear_data();

    }



    public function remove_booking_attachment($id)

    {

        if ($this->input->is_ajax_request()) {

            echo json_encode(

                $this->resourcebooking_model->remove_booking_attachment($id)

            );

        }

    }





    /**

     * @date 2024-03-06 Halil

     */

    public function payment_lists($booking_id = 0)

    {



        if ($this->input->is_ajax_request()) {





            $sTable = db_prefix() . 'booking_payments';



            $aColumns = [



                'id',



                'payment_id',



                'amount',



                'date',



                'status',



            ];



            $where = [];



            if (!empty($booking_id))

                $where[] = "AND booking_id = $booking_id";



            $hidden_payment_modes = $this->case_model->get_hidden_payment_modes_for_staff();



            if (!empty($hidden_payment_modes)) {



                foreach ($hidden_payment_modes as $hidden_payment_mode) {



                    $where[] = "AND $sTable.payment_id != '$hidden_payment_mode' ";



                }



            }



            $sIndexColumn = 'id';



            $join = [];



            $result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, ['status','reject_description']);



            $output = $result['output'];



            $rResult = $result['rResult'];



            $payment_modes = [];



            $modes = $this->case_model->get_transaction();





            foreach ($modes as $mode) {



                $mode_id = $mode['id'];



                $payment_modes["$mode_id"] = $mode;



            }





            foreach ($rResult as $aRow) {



                $row = [];



                $source_mode = $this->case_model->get_payment_mode_info($payment_modes, $aRow["payment_id"]);



                $record_id = $aRow['id'];



                $numberOutput = $source_mode->name;



                if (empty($aRow['status'])) {



                    $numberOutput .= '<div class="row-options">';



                    $numberOutput .= "<a class='text-info' href='#' onclick='booking_payment_detail( $record_id ); return false;'>" . _l('edit') . "</a>";



                    $numberOutput .= '</div>';



                }





                $row[] = $record_id;



                $row[] = $numberOutput;



                $row[] = app_format_money($aRow['amount'], $source_mode->payment_currency);



                $row[] = _d(date('Y-m-d', strtotime($aRow['date'])));





                $status = $this->resourcebooking_model->payment_status($aRow["status"]);



                if ( $aRow['status'] == 2 )

                    $status = '<span class="text-has-action" data-toggle="tooltip" data-title="'. $aRow['reject_description'] .'"> '.$status.' </span>';



                $row[] = $status;



                $output['aaData'][] = $row;



            }



            echo json_encode($output);



            die();



        }



    }



    public function payment_detail($booking_id)

    {



        $data = [];



        $record_id = $this->input->post('record_id');



        $data['booking_id'] = $booking_id;

        $data['record_id'] = $record_id;



        $data['payment_modes'] = $this->case_model->get_transaction();



        $data['detail'] = $this->resourcebooking_model->get_payment_detail($booking_id, $record_id);



        if (empty($data['detail'])) {

            $data['detail'] = new stdClass();



            $data['detail']->id = 0;

            $data['detail']->payment_id = '';

            $data['detail']->amount = '';

            $data['detail']->date = date('Y-m-d H:i:s');

            $data['detail']->description = '';

        }



        $data['attachments'] = $this->resourcebooking_model->get_attachments( $record_id );



        $content = $this->load->view('v_payment_detail', $data, true);



        echo json_encode(['content' => $content]);



    }



    public function delete_payment_attachment( $record_id )

    {



        $file = $this->misc_model->get_file( $record_id );



        if ($file->staffid == get_staff_user_id() || is_admin()) {



            echo $this->credit_notes_model->delete_attachment( $record_id );



        } else {



            ajax_access_denied();



        }



    }



    public function payment_save()

    {



        if ($this->input->post()) {



            $data = $this->input->post();



            $record_id = $data['id'];



            if ( empty( $record_id ) )

            {



                $record_id = $this->resourcebooking_model->payment_save($data);



                $message = _l('added_successfully', '');



                if (!empty($record_id))

                    $this->payment_send_notification($record_id);



            }

            else

            {



                $this->resourcebooking_model->payment_save($data, $record_id);



                $message = _l('updated_successfully', '');



            }







            if ( !empty( $record_id ) && isset( $_FILES['attachments'] ) && !empty( $_FILES['attachments'] ) && $_FILES['attachments']['error'][0] != 4 )

            {



                $commentAttachments = handle_booking_payment_attachments_array( $record_id );



                if( $commentAttachments && is_array($commentAttachments) )

                {



                    foreach ($commentAttachments as $file)

                    {



                        $this->misc_model->add_attachment_to_database(

                            $record_id,

                            "book_payment",

                            [$file]

                        );



                    }



                }





            }



            /*

            echo json_encode([

                'success' => true,

                'message' => $message,

            ]);

            */



            set_alert('success' , $message );



            redirect( $_SERVER['HTTP_REFERER'] );



        }



    }





    public function payment_send_notification($record_id)

    {



        $admins = $this->db->select('staffid,admin')->from(db_prefix() . 'staff')->where('active', 1)->get()->result();



        if (empty($admins))

            return true;



        foreach ($admins as $admin) {





            if ($admin->admin == 1 || staff_can('case_accept_payments', 'case_manage', $admin->staffid)) {



                $this->db->insert(db_prefix() . 'notifications', [



                    'description' => _l('booking_new_payment_request'),



                    'touserid' => $admin->staffid,



                    'fromcompany' => 1,



                    'fromuserid' => 0,



                    'link' => 'account_balances/booking/payment_menu?record_id=' . $record_id,



                    'additional_data' => '',



                    'date' => date('Y-m-d H:i:s')



                ]);



            }



        }





    }





    /**

     * @date 2024-03-09 Halil

     */

    public function booking_description_frame($booking_id = 0)

    {



        $info = $this->db->select('description')->from(db_prefix() . 'booking')->where('id', $booking_id)->get()->row();



        echo !empty($info->description) ? ($info->description) : '';

        //echo !empty($info->description) ? nl2br($info->description) : '';

        /*



        $description = !empty($info->description) ? nl2br($info->description) : '';





        $description = str_replace( '<p></p>' , '' , $description );



        $description = str_replace( '<br><br>' , '<br>' , $description );



        echo $description;

        */

    }





    public function booking_checklist_save( $booking_id = 0 )

    {



        if ( $this->input->is_ajax_request() && !empty( $booking_id ) )

        {



            $record_id = $this->input->post('record_id');





            $data = [

                'booking_id' => $booking_id ,

                'checklist_text' => $this->input->post('value') ,

            ];



            if ( empty( $record_id ) )

            {



                $this->db->insert(db_prefix().'booking_checklists' , $data );



                $record_id = $this->db->insert_id();



            }

            else

                $this->db->where('id',$record_id)->update(db_prefix().'booking_checklists' , $data );





            $checklist = $this->resourcebooking_model->get_booking_checklists( $booking_id , $record_id );



            $content = '';



            if ( !empty( $checklist ) )

                $content = $this->load->view('v_booking_checklist_inc' , [ 'checklist' => $checklist ] , true );



            echo json_encode( [ 'success' => true , 'record_id' => $record_id , 'content' => $content ] );



        }





    }





    public function booking_checklist_status_change( $booking_id = 0 )

    {



        if ( $this->input->is_ajax_request() )

        {



            $status = $this->input->post('status');



            $record_id = $this->input->post('record_id');



            $detail = $this->resourcebooking_model->get_booking_checklists( $booking_id ,$record_id );



            if ( !empty( $detail ) )

            {



                if ( empty( $status ) ) // uncheck

                    $data = [

                        'complated_staff_id' => null ,

                        'complated_date' => null,

                    ];

                else // check

                    $data = [

                        'complated_staff_id' => get_staff_user_id() ,

                        'complated_date' => date('Y-m-d H:i:s') ,

                    ];



                $this->db->where('id',$record_id)->where('booking_id',$booking_id)->update(db_prefix().'booking_checklists' , $data );



                log_activity( "Event checklist status changed. [ Event : $booking_id checklist : $detail->checklist_text status : $status  ]" );



                echo json_encode( [ 'success' => true ] );



            }

            else

                echo json_encode( [ 'success' => false , 'message' => 'Record not found' ] );



        }



    }





    public function booking_checklist_remove( $booking_id = 0 )

    {



        if ( $this->input->is_ajax_request() )

        {



            $record_id = $this->input->post('record_id');



            $detail = $this->resourcebooking_model->get_booking_checklists( $booking_id ,$record_id );



            $this->db->where('id',$record_id)->where('booking_id',$booking_id)->delete(db_prefix().'booking_checklists' );



            log_activity( "Event checklist removed. [ Event : $booking_id checklist : $detail->checklist_text  ]" );



            echo json_encode( [ 'success' => true ] );



        }



    }





    public function booking_checklist_save_template( $booking_id = 0 )

    {



        if ( $this->input->is_ajax_request() )

        {



            $record_id = $this->input->post('record_id');



            $detail = $this->resourcebooking_model->get_booking_checklists( $booking_id ,$record_id );



            if ( !empty( $detail->checklist_text ) )

                $this->db->insert(db_prefix().'booking_checklist_templates' , [ 'checklist_text' => $detail->checklist_text ] );



            echo json_encode( [ 'success' => true ] );



        }



    }





    public function booking_checklist_add_template( $booking_id = 0 )

    {



        if ( $this->input->is_ajax_request() && !empty( $booking_id ) )

        {



            $template_id = $this->input->post('template_id');



            $template = $this->resourcebooking_model->get_booking_checklist_templates( $template_id );



            if ( !empty( $template->checklist_text ) )

            {



                $data = [

                    'booking_id' => $booking_id ,

                    'template_id' => $template->id ,

                    'checklist_text' => $template->checklist_text ,

                ];



                $this->db->insert(db_prefix().'booking_checklists' , $data );



                $record_id = $this->db->insert_id();





                $checklist = $this->resourcebooking_model->get_booking_checklists( $booking_id , $record_id );



                $content = '';



                if ( !empty( $checklist ) )

                    $content = $this->load->view('v_booking_checklist_inc' , [ 'checklist' => $checklist ] , true );



                echo json_encode( [ 'success' => true , 'record_id' => $record_id , 'content' => $content ] );





            }

            else

                echo json_encode( [ 'success' => false , 'message' => 'Record not found' ] );





        }





    }





    /**

     * @date 2024-03-31 Halil

     */



    public function debt_lists($booking_id = 0)

    {



        if ($this->input->is_ajax_request()) {





            $sTable = db_prefix() . 'booking_debt';



            $aColumns = [

                'id',

                'name',

                'staff_id',


                'amount',

                'assistant',

                '( amount * assistant ) as total_ticket',



                'dinner' ,

                'bus' ,
                'bus_assistant' ,
                'bus_price' ,
                '( bus_price * bus_assistant ) as total_bus',

                '( amount * assistant + bus_price * bus_assistant ) as total_ticket_bus',



                'paid',

                '( ( amount * assistant + bus_price * bus_assistant ) - paid ) as debt',

                'status',

            ];


            $where = [];



            if (!empty($booking_id))

                $where[] = "AND booking_id = $booking_id";



            $sIndexColumn = 'id';



            $join = [];



            $result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, [ ] );



            $output = $result['output'];



            $rResult = $result['rResult'];



            $base_currency = get_base_currency();






            $footer_data = [
                'total_amount' => 0 ,
                'total_assistant' => 0 ,
                'total_total_ticket' => 0 ,
                'total_bus_assistant' => 0 ,
                'total_bus_price' => 0 ,
                'total_bus' => 0 ,
                'total_ticket_bus' => 0 ,
                'total_paid' => 0 ,
                'total_due' => 0 ,
            ];




            foreach ($rResult as $aRow) {



                $row = [];



                $record_id = $aRow['id'];



                $footer_data['total_amount']        += $aRow['amount'];

                $footer_data['total_assistant']     += $aRow['assistant'];

                $footer_data['total_paid']          += $aRow['paid'];

                $footer_data['total_due']           += $aRow['debt'];


                $footer_data['total_total_ticket']      += $aRow['total_ticket'];
                $footer_data['total_bus_assistant']     += $aRow['bus_assistant'];
                $footer_data['total_bus_price']         += $aRow['bus_price'];
                $footer_data['total_bus']               += $aRow['total_bus'];
                $footer_data['total_ticket_bus']        += $aRow['total_ticket_bus'];




                $numberOutput = $aRow['name'];





                    $numberOutput .= '<div class="row-options">';



                    $numberOutput .= "<a class='text-info' href='#' onclick='booking_debt_detail( $record_id ); return false;'>" . _l('edit') . "</a>";



                    $numberOutput .= " | <a class='text-danger _delete' href='#' onclick='booking_debt_delete( $record_id ); return false;'>" . _l('delete') . "</a>";



                    $numberOutput .= '</div>';







                $row[] = $record_id;



                $row[] = $numberOutput;


                // staff

                $staff_data = '';

                if ( !empty( $aRow['staff_id'] ) )
                {


                    $staff_data = '<a href="' . admin_url('staff/profile/' . $aRow['staff_id']) . '">' . staff_profile_image($aRow['staff_id'], [

                            'staff-profile-image-small',

                        ]) . '</a>';

                    $staff_data .= ' <a href="' . admin_url('staff/profile/' . $aRow['staff_id']) . '">' . get_staff_full_name($aRow['staff_id']) . '</a>';


                }

                $row[] = $staff_data;


                $row[] = app_format_money( $aRow['amount'] , $base_currency );

                $row[] = $aRow['assistant'] ;

                $row[] = app_format_money( $aRow['total_ticket'] , $base_currency );


                if( $aRow['dinner'] == 1 )
                    $row[] = _l('report_kb_yes');
                else
                    $row[] = _l('report_kb_no');



                if( $aRow['bus'] == 1 )
                    $row[] = _l('report_kb_yes');
                else
                    $row[] = _l('report_kb_no');


                $row[] = $aRow['bus_assistant'] ;

                $row[] = app_format_money( $aRow['bus_price'] , $base_currency );

                $row[] = app_format_money( $aRow['total_bus'] , $base_currency );

                $row[] = app_format_money( $aRow['total_ticket_bus'] , $base_currency );

                $row[] = app_format_money( $aRow['paid'] , $base_currency );



                $row[] = app_format_money( $aRow['debt'] , $base_currency );



                $status = $this->resourcebooking_model->payment_status($aRow["status"]);



                $row[] = $status;



                $output['aaData'][] = $row;



            }



            $footer_data['total_amount']    = e(app_format_money($footer_data['total_amount'],$base_currency));

            $footer_data['total_paid']      = e(app_format_money($footer_data['total_paid'],$base_currency));

            $footer_data['total_due']       = e(app_format_money($footer_data['total_due'],$base_currency));


            $footer_data['total_total_ticket']      = e(app_format_money($footer_data['total_total_ticket'],$base_currency));
            $footer_data['total_bus_price']         = e(app_format_money($footer_data['total_bus_price'],$base_currency));
            $footer_data['total_bus']               = e(app_format_money($footer_data['total_bus'],$base_currency));
            $footer_data['total_ticket_bus']        = e(app_format_money($footer_data['total_ticket_bus'],$base_currency));




            $output['sums']              = $footer_data;





            echo json_encode($output);



            die();



        }



    }



    public function debt_detail($booking_id = 0 )

    {



        $data = [];



        $record_id = $this->input->post('record_id');



        $data['booking_id'] = $booking_id;

        $data['record_id'] = $record_id;


        $data['staff'] =  $this->staff_model->get('', ['active' => 1]);

        $data['detail'] = $this->resourcebooking_model->get_debt_detail($booking_id, $record_id);

        list( $max_people , $used_people ) = $this->get_debt_total_and_available_person($booking_id, $record_id );

        $data['max_people'] = $max_people - $used_people;

        if ( empty( $data['detail'] ) )

        {

            $data['detail'] = new stdClass();



            $data['detail']->id = 0;

            $data['detail']->booking_id = 0;

            $data['detail']->name = '';

            $data['detail']->amount = '';

            $data['detail']->assistant = '';

            $data['detail']->paid = '';

            $data['detail']->status = '';

            $data['detail']->staff_id = 0;

            $data['detail']->dinner = 0;
            $data['detail']->bus = 0;
            $data['detail']->bus_price = 0;
            $data['detail']->bus_assistant = 0;

        }

        else

            $data['payments'] = $this->resourcebooking_model->debt_payments( $record_id );





        $content = $this->load->view('v_booking_debt_detail', $data, true);



        echo json_encode(['content' => $content]);



    }



    public function debt_save()

    {



        if ($this->input->post()) {



            $data = $this->input->post();



            unset($data['paid_amount'] );



            $record_id = $data['id'];



            if ( empty( $record_id ) )

            {



                $record_id = $this->resourcebooking_model->debt_save($data);



                $message = _l('added_successfully', '');



            }

            else

            {



                $this->resourcebooking_model->debt_save($data, $record_id);



                $message = _l('updated_successfully', '');



            }





            echo json_encode([

                'success' => true,

                'message' => $message,

            ]);



        }



    }



    public function debt_delete( $booking_id = 0 )

    {



        if ( $this->input->is_ajax_request() )

        {



            $record_id = $this->input->post('record_id');



            $this->db->where('id',$record_id)->where('booking_id',$booking_id)->delete(db_prefix().'booking_debt');



            echo json_encode([ 'success' => true ]);



        }



    }





    public function debt_import( $booking_id = 0 )

    {



        if( !empty( $_FILES['file']['name'] ) && $booking_id )

        {



            $filename   = explode(".", $_FILES["file"]["name"]);

            $extension  = end($filename);

            $allowed_extension = array( "xls" , "xlsx" );



            if (in_array($extension, $allowed_extension))

            {



                $this->load->library('Excel');



                $file = $_FILES["file"]["tmp_name"];



                $objPHPExcel = PHPExcel_IOFactory::load($file);

                $worksheet   = $objPHPExcel->getActiveSheet();



                $highestRow = $worksheet->getHighestRow();





                if( $highestRow > 1 )

                {





                    for( $row = 2; $row <= $highestRow ; $row++ )

                    {

                        $index++;



                        echo "<p> - - - - - - - - - - - Searching Row : $row - - - - - - - - - - - - </p>";



                        $debt_name      = $worksheet->getCellByColumnAndRow( 0 , $row)->getFormattedValue();



                        $debt_amount    = $worksheet->getCellByColumnAndRow( 1 , $row)->getFormattedValue();



                        $debt_amount    = str_replace( [ ' ' , '€' , '$' ] , '' , $debt_amount );



                        $debt_amount    = (float)str_replace(',','',$debt_amount);



                        if( empty( $debt_name ) || empty( $debt_amount ) )

                        {

                            echo "<p style='color: red'>name and amount cannot be empty  | row : $row;</p>";



                            continue;

                        }



                        $debt_id = $this->resourcebooking_model->debt_save(

                            [ 'name' => $debt_name , 'amount' => $debt_amount , 'booking_id' => $booking_id ]

                            , 0 );



                        echo "<p style='color: green'> Debt added successfully | row : $row , debt id : $debt_id </p>";







                    }





                }















            }

            else

                echo "<p>File dont upload!</p>";





        }

        else

            echo "<p>File dont upload!</p>" ;





        echo "<h3> Completed </h3>";



    }









    public function add_payment_to_debt( $booking_id )

    {



        if ($this->input->post()) {



            $data = $this->input->post();



            $record_id = $data['record_id'];

            $paid_amount = $data['paid_amount'];





            $this->db->insert('tblbooking_debt_payments', [

                    'booking_id' => $booking_id ,

                    'debt_id' => $record_id ,

                    'payment_amount' => $paid_amount ,

                    'date' => date('Y-m-d') ,

                ]);





            $message = _l('added_successfully', '');



            if ( $this->db->insert_id() )

                $this->debt_payment_send_notification($record_id);



            $this->db->set('status',0)->where('id',$booking_id)->update(db_prefix().'booking_debt');



            echo json_encode([

                'success' => true,

                'message' => $message,

            ]);



        }



    }







    public function debt_payment_send_notification($record_id)

    {



        $admins = $this->db->select('staffid,admin')->from(db_prefix() . 'staff')->where('active', 1)->get()->result();



        if (empty($admins))

            return true;



        foreach ($admins as $admin) {





            if ($admin->admin == 0 && staff_can('case_accept_payments', 'case_manage', $admin->staffid)) {



                $this->db->insert(db_prefix() . 'notifications', [



                    'description' => _l('booking_new_payment_request'),



                    'touserid' => $admin->staffid,



                    'fromcompany' => 1,



                    'fromuserid' => 0,



                    'link' => 'account_balances/booking/debt_menu?record_id=' . $record_id,



                    'additional_data' => '',



                    'date' => date('Y-m-d H:i:s')



                ]);



            }



        }





    }



    /**
     * @date 2024-09-26 Halil
     */
    public function get_debt_total_and_available_person( $booking_id , $debt_id = 0 )
    {

        $booking_data = $this->resourcebooking_model->get_booking( $booking_id );

        $max_people     = 1;
        if ( !empty( $booking_data->person_number ) )
            $max_people = $booking_data->person_number;

        $used_people = 0;

        $total_info = $this->db->select('SUM( assistant ) as assistant')
                                ->from(db_prefix().'booking_debt')
                                ->where('booking_id',$booking_id)
                                ->where('id !=',$debt_id)
                                ->get()
                                ->row();

        if ( !empty( $total_info->assistant ) )
            $used_people = $total_info->assistant;


        return [ $max_people , $used_people ];

    }


}

