<?php



defined('BASEPATH') or exit('No direct script access allowed');



$debt_sql = 'IFNULL(tblbooking.amount,0)  

            - IFNULL(( SELECT SUM(py.amount) FROM '.db_prefix() . 'booking_payments as py WHERE py.booking_id = tblbooking.id AND py.status = 1 ),0)  

            + IFNULL(( SELECT SUM(db.amount - db.paid) FROM '.db_prefix() . 'booking_debt as db WHERE db.booking_id = tblbooking.id ),0)

            ';



$debt_sql = ' IFNULL( ( SELECT SUM(db.assistant) FROM '.db_prefix() . 'booking_debt as db WHERE db.booking_id = tblbooking.id ),0)
            ';



$aColumns = [

    'start_time',



    'resource',



    'purpose',



    'orderer',



    'tblbooking.id',



    'tblbooking.resource_group',



    'end_time',



    'confirmed',



    $debt_sql.' as amount',



    'tblbooking.status' ,

];





$sIndexColumn = 'id';

$sTable = 'tblbooking';

$join = ['LEFT JOIN tblresource on tblresource.id = tblbooking.resource',

    'LEFT JOIN tblresource_group on tblresource_group.id = tblbooking.resource_group'

];

$where = [];





/**

 * @date 2024-03-12 Halil

 */





$where = [];





$from_date  = to_sql_date( $this->ci->input->post('from_date') );



$to_date    = to_sql_date( $this->ci->input->post('to_date') );



if( !empty( $from_date ) )

    $where[] = "AND DATE( $sTable.start_time ) >= '$from_date'";



if( !empty( $to_date ) )

    $where[] = "AND DATE( $sTable.start_time ) <= '$to_date'";





$resource_group = $this->ci->input->post('resource_group');

if ( !empty( $resource_group ) )

    $where[] = "AND resource_group = $resource_group";





$resource = $this->ci->input->post('resource');

if ( !empty( $resource ) )

    $where[] = "AND resource = $resource";





$confirmed = $this->ci->input->post('confirmed');

if ( !empty( $confirmed ) )

    $where[] = "AND confirmed = $confirmed";





$status = $this->ci->input->post('status');

if ( !empty( $status ) )

{



    $timenow = date('Y-m-d h:i:s');



    if ( $status == 1 )

        $where[] = "AND start_time >= '$timenow'";

    elseif ( $status == 2 )

        $where[] = "AND end_time <= '$timenow'";

    else

        $where[] = "AND start_time < '$timenow' AND end_time > '$timenow'";



}





$debt = $this->ci->input->post('debt');

if ( !empty( $debt ) )

{



    if ( $debt == 1 ) // has debt

        $where[] = "AND $debt_sql > 0 ";

    else

        $where[] = "AND $debt_sql <= 0 ";



}







$result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, ['tblbooking.status', 'group_name', 'resource_name' , 'person_number']);



$output = $result['output'];

$rResult = $result['rResult'];

$this->ci->load->model('resourcebooking_model');





$footer_data['total_amount'] = 0;





foreach ($rResult as $aRow) {

    $row = [];

    for ($i = 0; $i < count($aColumns); $i++) {

        $_data = $aRow[$aColumns[$i]];

        if ($aColumns[$i] == 'purpose') {

            $_data = '<a href="' . admin_url('resourcebooking/booking/' . $aRow['tblbooking.id']) . '">' . $_data . '</a>';

        } elseif ($aColumns[$i] == 'orderer') {

            $_data = '<a href="' . admin_url('staff/profile/' . $aRow['orderer']) . '">' . staff_profile_image($aRow['orderer'], [

                    'staff-profile-image-small',

                ]) . '</a>';

            $_data .= ' <a href="' . admin_url('staff/profile/' . $aRow['orderer']) . '">' . get_staff_full_name($aRow['orderer']) . '</a>';

        } elseif ($aColumns[$i] == 'tblbooking.resource_group') {

            $_data = $aRow['group_name'];

        } elseif ($aColumns[$i] == 'resource') {

            $_data = '<a href="' . admin_url('resourcebooking/resource/' . $aRow['resource']) . '">' . $aRow['resource_name'] . '</a>';

        } elseif ($aColumns[$i] == 'start_time') {

            $_data = _dt($aRow['start_time']);

        } elseif ($aColumns[$i] == 'end_time') {

            $_data = _dt($aRow['end_time']);

        } elseif ($aColumns[$i] == 'tblbooking.id') {

            $list = $this->ci->resourcebooking_model->get_list_follower_by_booking($aRow['tblbooking.id']);

            $str = '';

            foreach ($list as $lst) {

                $str .= '<a href="' . admin_url('staff/profile/' . $lst['follower']) . '">' . staff_profile_image($lst['follower'], [

                        'staff-profile-image-small'], 'small', [

                        'data-toggle' => 'tooltip',

                        'data-title' => get_staff_full_name($lst['follower']),

                    ]) . '</a>&nbsp';

            }

            $_data = $str;

        } elseif ($aColumns[$i] == 'tblbooking.status') {

            $timenow = date('Y-m-d h:i:s');



            if ($aRow['start_time'] >= $timenow) {

                $_data = '<span class="label label inline-block project-status-color-scheduled">' . _l('scheduled') . '</span>';

            } elseif ($aRow['end_time'] <= $timenow) {

                $_data = '<span class="label label inline-block project-status-color-completed">' . _l('ended') . '</span>';

            } else {

                $_data = '<span class="label label inline-block project-status-color-currentlyactive">' . _l('currentlyactive') . '</span>';

            }

        } elseif ($aColumns[$i] == 'confirmed') {



            if (empty($_data))

                $_data = '';

            elseif ($_data == 1)

                $_data = "<spam class='text-success'>" . _l('filter_boolean_yes') . "</spam>";

            elseif ($_data == 2)

                $_data = "<spam class='text-danger'>" . _l('filter_boolean_no') . "</spam>";



        //} elseif ($aColumns[$i] == 'amount') {

        } elseif ( $i == 8 ) {



            //$payment_amount = 0;



            //$total_payment = $this->ci->db->select('SUM(amount) as amount', false)->from(db_prefix() . 'booking_payments')->where('booking_id', $aRow['tblbooking.id'])->where('status', 1)->get()->row();



            //$due_amount = $aRow['amount'] - (!empty($total_payment->amount) ? $total_payment->amount : 0);

            //$due_amount = $aRow['amount'] ;



            //$footer_data['total_amount'] += $due_amount;



            //$_data = app_format_money($due_amount, 'EUR');
            $_data = $aRow['amount'].' / '.$aRow['person_number'];



        }





        $row[] = $_data;

    }

    if ($aRow['orderer'] == get_staff_user_id() || is_admin()) {

        $options = icon_btn('resourcebooking/add_edit_booking/' . $aRow['tblbooking.id'], 'fa fa-pencil-square', 'btn-default');

        $options .= icon_btn('resourcebooking/copy_booking/' . $aRow['tblbooking.id'], 'fa fa-copy', 'btn-default');

        $options .= icon_btn('resourcebooking/delete_booking/' . $aRow['tblbooking.id'], 'fa fa-remove', 'btn-danger _delete');

    } else {

        $options = '';

    }

    $row[] = $options;



    $output['aaData'][] = $row;

}





$footer_data['total_amount'] = e(app_format_money($footer_data['total_amount'],'EUR'));



$output['sums']              = $footer_data;

