<div class="modal-dialog" role="document">



    <div class="modal-content">



        <div class="modal-header">



            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>



            <h4 class="modal-title" id="myModalLabel">



                <span><?php echo _l('booking_debt')?></span>



            </h4>



        </div>







        <?php echo form_open('resourcebooking/debt_save' ,  ['id' => 'debt_form'] ); ?>



            <input type="hidden" name="booking_id" id="booking_id" value="<?php echo $booking_id?>" />



            <input type="hidden" name="id" id="id" value="<?php echo $detail->id?>" />



            <div class="modal-body">



                <div class="row">



                    <div class="col-md-12">



                        <?php



                        echo render_input('name', _l("name") , $detail->name );



                        if ( empty( $detail->id ) || is_admin() )
                            echo render_input('amount', _l("booking_entrance_price") , $detail->amount , 'number' );
                        else
                            echo render_input('amount', _l("booking_entrance_price") , $detail->amount , 'number' , [ 'readonly' => true ] );


                        echo render_input('assistant', _l("booking_assistant") , $detail->assistant , 'number' , [ 'max' => $max_people ] );


                        $options = [
                            [ 'id' => 1 , 'text' => _l('report_kb_yes') ] ,
                            [ 'id' => 0 , 'text' => _l('report_kb_no') ] ,
                        ];

                        echo render_select( 'dinner' , $options , [ 'id' , 'text' ] , 'booking_dinner' , $detail->dinner , [] , [] , '' , '' , false  );
                        echo render_select( 'bus' , $options , [ 'id' , 'text' ] , 'booking_bus' , $detail->bus  , [] , [] , '' , '' , false  );

                        echo render_input('bus_price', _l("booking_bus_price") , $detail->bus_price , 'number' );
                        echo render_input('bus_assistant', _l("booking_bus_assistant") , $detail->bus_assistant , 'number' );


                        echo render_select( 'staff_id' , $staff , [ 'staffid' , [ 'firstname' , 'lastname' ] ] , 'booking_debt_staff' , $detail->staff_id  );



                        if ( !empty( $detail->id ) )

                        {



                            echo render_input('paid', _l("invoice_total_paid") , $detail->paid , 'number' , [ 'disabled' => true ] );



                        }



                        ?>



                    </div>





                    <?php if ( !empty( $detail->id ) ) { ?>



                        <div class="clearfix"></div>



                        <div class="col-md-12">

                            <hr />

                        </div>



                        <div class="col-md-8">

                            <?php echo render_input('paid_amount', '' , '' , 'number' ); ?>

                        </div>



                        <div class="col-md-4">

                            <a class="btn btn-primary" onclick="add_payment_to_debt( <?php echo $detail->id ?> )"><?php echo _l('add_batch_payments')?></a>

                        </div>





                        <div class="col-md-12">



                            <table class="table dt-table">



                                <thead>

                                    <tr>

                                        <th><?php echo _l('invoice_table_amount_heading')?></th>

                                        <th><?php echo _l('invoice_payments_table_date_heading')?></th>

                                        <th><?php echo _l('status')?></th>

                                    </tr>

                                </thead>



                                <tbody>

                                <?php foreach ( $payments as $payment ) { ?>



                                    <tr>

                                        <td><?php echo app_format_money($payment->payment_amount , 'EUR')?></td>

                                        <td><?php echo _d($payment->date)?></td>

                                        <td><?php echo $this->resourcebooking_model->payment_status( $payment->status )?></td>

                                    </tr>



                                <?php } ?>

                                </tbody>



                            </table>



                        </div>





                    <?php } ?>



                </div>





                <div class="row">



                    <div class="col-md-12">

                        <?php $this->load->view('v_payment_attachment') ?>

                    </div>



                </div>





            </div>



            <div class="modal-footer">



                <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo _l('close'); ?></button>



                <button type="submit" class="btn btn-primary"><?php echo _l('submit'); ?></button>



            </div>





        <?php echo form_close(); ?>





    </div>



</div>





<script>





    $(document).ready(function (){



        init_selectpicker();


        appValidateForm($('#debt_form'), {



            name: 'required',



            amount: 'required',

            assistant: 'required',

            staff_id: 'required',

            bus_price: 'required',
            bus_assistant: 'required',


        }, manage_debt );





    })





    function manage_debt(form) {



        var data = $(form).serialize();



        var url = form.action;



        $.post(url, data).done(function(response) {



            response = JSON.parse(response);



            if (response.success == true) {



                $('.halil-debt-table').DataTable().ajax.reload();



                alert_float('success', response.message);



            }



            $('#booking_payment_modal').modal('hide');



        });



        return false;



    }





</script>

