
<?php if ( !empty( $attachments ) && count( $attachments ) > 0 ) { ?>

    <div class="clearfix"></div>

    <hr />

    <p class="bold text-muted"><?php echo _l('add_task_attachments'); ?></p>

    <?php foreach ( $attachments as $attachment) {

        $attachment_url = site_url('download/file/booking_payment/' . $attachment['attachment_key']);

        if (!empty($attachment['external'])) {

            $attachment_url = $attachment['external_link'];

        } ?>

        <div class="mbot15 row inline-block full-width"

             data-attachment-id="<?php echo e($attachment['id']); ?>">

            <div class="col-md-8">

                <div class="pull-left"><i class="<?php echo get_mime_class($attachment['filetype']); ?>"></i></div>

                <a href="<?php echo e($attachment_url); ?>"

                   target="_blank"><?php echo e($attachment['file_name']); ?></a>

                <br />

                <small class="text-muted"> <?php echo e($attachment['filetype']); ?></small>

            </div>

            <div class="col-md-4 text-right">

                <?php if ($attachment['staffid'] == get_staff_user_id() || is_admin()) { ?>

                    <a href="#" class="text-danger"

                       onclick="delete_booking_payment_attachment(<?php echo $attachment['id']; ?>); return false;"><i class="fa fa-times"></i></a>

                <?php } ?>

            </div>

        </div>

        <?php

    } ?>

<?php } ?>
